/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service.jointplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.helper.multisystemjoint.param.ScMultiCosmicStdParamArgs;
import kd.scm.common.helper.multisystemjoint.param.ScMultiParamArgs;
import kd.scm.common.helper.multisystemjoint.param.plugin.AbstractLinkEntityCustomParamPlugin;
import kd.scm.common.util.BussinessTypeUtils;

public final class PurOrderLogisticsStatusForCosmicStdPlugin
extends AbstractLinkEntityCustomParamPlugin {
    private String uniqueValueOption;

    protected Collection<String> getProperty() {
        HashSet<String> propertys = new HashSet<String>(1);
        propertys.add("materialentry.poentryid poentryid");
        return propertys;
    }

    protected Set<String> getGroupKeys() {
        HashSet<String> groupKey = new HashSet<String>(1);
        groupKey.add("poentryid");
        return groupKey;
    }

    public void initEntityLinkInfoVar(String linkConfigId) {
        super.initEntityLinkInfoVar(linkConfigId);
        this.setLinkProperty("materialentry.poentryid");
    }

    public void initValuePropertyAndOptionVar(Map<String, String> customConfigMap) {
        super.initValuePropertyAndOptionVar(customConfigMap);
        this.setValueProperty("logstatus");
    }

    protected ScMultiParamArgs assembleJointParam(List<DynamicObject> orderList) {
        Set logisticsIds;
        ScMultiCosmicStdParamArgs cosmicStdParamArgs = null;
        HashMap<String, HashSet<Long>> logisticsMaps = new HashMap<String, HashSet<Long>>(8);
        for (DynamicObject bill : orderList) {
            boolean pmOmBussinessType = BussinessTypeUtils.isPmOmBussinessType((String)bill.getString("businesstype"));
            if (pmOmBussinessType) continue;
            String logstatus = bill.getString("logstatus");
            HashSet<Long> logisticsIds2 = (HashSet<Long>)logisticsMaps.get(logstatus);
            if (logisticsIds2 == null) {
                logisticsIds2 = new HashSet<Long>(8);
            }
            logisticsIds2.add(Long.parseLong(bill.getString("pobillid")));
            logisticsMaps.put(logstatus, logisticsIds2);
        }
        Set valueOptions = this.getValueOptions();
        if (valueOptions.size() == 1) {
            this.uniqueValueOption = (String)valueOptions.stream().findFirst().get();
        }
        if (this.uniqueValueOption == null) {
            this.uniqueValueOption = "";
        }
        if (CollectionUtils.isEmpty((Collection)(logisticsIds = (Set)logisticsMaps.get(this.uniqueValueOption)))) {
            return cosmicStdParamArgs;
        }
        cosmicStdParamArgs = new ScMultiCosmicStdParamArgs();
        HashMap<String, Object> logisticsMap = new HashMap<String, Object>(2);
        logisticsMap.put("status", this.uniqueValueOption);
        logisticsMap.put("ids", new ArrayList(logisticsIds));
        cosmicStdParamArgs.setCloudId("scmc");
        cosmicStdParamArgs.setAppId("pm");
        cosmicStdParamArgs.setServiceName("PmSupColService");
        cosmicStdParamArgs.setMethodName("upLogisticsStatus");
        cosmicStdParamArgs.setParamMap(logisticsMap);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ScpOrderConfirmForEasPlugin#cosmicStdParamArgs:{}", (Object)SerializationUtils.toJsonString((Object)cosmicStdParamArgs));
        }
        return cosmicStdParamArgs;
    }

    protected List<DynamicObject> getRefDynamicObjects(List<DynamicObject> originalData) {
        ORM orm = ORM.create();
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(1024);
        HashSet<String> linkValues = new HashSet<String>(1024);
        for (DynamicObject data : originalData) {
            DynamicObjectCollection dys = data.getDynamicObjectCollection("materialentry");
            for (DynamicObject dy : dys) {
                String poEntryId = dy.getString("poentryid");
                if (poEntryId == null || poEntryId.isEmpty() || "0".equalsIgnoreCase(poEntryId)) continue;
                linkValues.add(poEntryId);
            }
        }
        if (!linkValues.isEmpty()) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)this.getSceneEntityNumber(), (String)"logstatus,materialentry.pobillid pobillid,businesstype.number businesstype", (QFilter[])new QFilter[]{new QFilter("materialentry.poentryid", "in", linkValues)}, (String)"id");){
                DataSet groupDataSet = dataSet.groupBy(new String[]{"pobillid", "logstatus", "businesstype"}).finish();
                dynamicObjects.addAll((Collection<DynamicObject>)orm.toPlainDynamicObjectCollection(groupDataSet));
                groupDataSet.close();
            }
        }
        return dynamicObjects;
    }
}

