/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service.kdtx;

import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.invoke.CommonDtxResponse;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ExceptionUtil;

public class OrderCloseService
extends BaseECService {
    private static Log log = LogFactory.getLog(OrderCloseService.class);

    public DtxResponse doExecute(Object o, Object lastParam) throws Exception {
        log.info("pur\u5fae\u670d\u52a1\u63a5\u53e3\u88ab\u8c03\u7528\uff1aOrderCloseService(\u4f9b\u5e94\u94fe\u540c\u6b65\u534f\u540c\u8ba2\u5355\u5173\u95ed\u4fe1\u606f\u63a5\u53e3) begin\uff1a");
        CommonDtxResponse result = new CommonDtxResponse();
        if (!(o instanceof CommonParam)) {
            return this.getErrorInfo(result, ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u5f02\u5e38", (String)"OrderCloseService_3", (String)"scm-pur-mservice", (Object[])new Object[0]));
        }
        Map map = ((CommonParam)o).getAll();
        log.info("\u63a5\u53e3\u53c2\u6570:" + map);
        if (map == null || map.size() < 1) {
            return this.getErrorInfo(result, ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u5f02\u5e38\u4e3a\u7a7a\u3002", (String)"OrderCloseService_4", (String)"scm-pur-mservice", (Object[])new Object[0]));
        }
        CommonDtxResponse response = new CommonDtxResponse();
        CommonParam param1 = (CommonParam)o;
        Map paramMap = param1.getAll();
        log.info("\u4f9b\u5e94\u94fe\u5173\u95ed\u4fe1\u606f\u540c\u6b65\u53c2\u6570\uff1a" + paramMap);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        String message = null;
        resultMap.put("success", Boolean.FALSE);
        if (null == paramMap || 0 == paramMap.size()) {
            resultMap.put("message", ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a", (String)"OrderCloseService_5", (String)"scm-pur-mservice", (Object[])new Object[0]));
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a", (String)"OrderCloseService_5", (String)"scm-pur-mservice", (Object[])new Object[0]));
        }
        QFilter orderQFilter = new QFilter("materialentry.pobillid", "in", paramMap.keySet());
        DynamicObject[] orders = BusinessDataServiceHelper.load((String)"pur_order", (String)"billstatus, closer, closereason, closedate, materialentry.pobillid, materialentry.poentryid, materialentry.entrystatus, materialentry.rowcloser, materialentry.rowclosereason, materialentry.rowclosedate", (QFilter[])new QFilter[]{orderQFilter});
        if (null == orders || 0 == orders.length) {
            resultMap.put("message", ResManager.loadKDString((String)"\u6839\u636e\u5165\u53c2\u6ca1\u6709\u67e5\u8be2\u5230\u534f\u540c\u8ba2\u5355\u6570\u636e\u3002", (String)"OrderCloseService_6", (String)"scm-pur-mservice", (Object[])new Object[0]));
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u5165\u53c2\u6ca1\u6709\u67e5\u8be2\u5230\u534f\u540c\u8ba2\u5355\u6570\u636e\u3002", (String)"OrderCloseService_6", (String)"scm-pur-mservice", (Object[])new Object[0]));
        }
        for (DynamicObject order : orders) {
            DynamicObjectCollection tempMaterialentry = order.getDynamicObjectCollection("materialentry");
            if (null == tempMaterialentry || tempMaterialentry.size() == 0) continue;
            String orderId = ((DynamicObject)tempMaterialentry.get(0)).getString("pobillid");
            Object mapObj = paramMap.get(orderId);
            Map imOrder = null;
            if (null == mapObj) continue;
            if (mapObj instanceof Map) {
                imOrder = (Map)mapObj;
            }
            if (null == imOrder || 0 == imOrder.size()) continue;
            Object closeStatusObj = imOrder.get("closeStatus");
            Object alertDateObj = imOrder.get("alertDate");
            Object closerObj = imOrder.get("closer");
            Date alertDate = null;
            Long closerId = 0L;
            if (null != closerObj) {
                closerId = Long.parseLong(closerObj.toString());
            }
            if (null != alertDateObj) {
                alertDate = DateUtil.string2date((String)alertDateObj.toString(), (String)"yyyy-MM-dd HH:mm:ss");
            }
            String closeStatus = "";
            if (null == closeStatusObj) continue;
            closeStatus = closeStatusObj.toString();
            if ("0".equals(closeStatus)) {
                order.set("billstatus", (Object)"D");
                order.set("closer_id", (Object)closerId);
                order.set("closedate", (Object)alertDate);
            } else if ("1".equals(closeStatus)) {
                order.set("billstatus", (Object)"C");
                order.set("closer_id", (Object)0L);
                order.set("closedate", null);
            }
            DynamicObjectCollection materialentry = order.getDynamicObjectCollection("materialentry");
            if (null == materialentry) continue;
            for (DynamicObject entry : materialentry) {
                String poentryid = entry.getString("poentryid");
                Object entryCloseStatusObj = imOrder.get(poentryid);
                if (StringUtils.isBlank(entryCloseStatusObj)) continue;
                String entryCloseStatus = entryCloseStatusObj.toString();
                if ("0".equals(entryCloseStatus)) {
                    entry.set("entrystatus", (Object)"B");
                    entry.set("rowcloser_id", (Object)closerId);
                    entry.set("rowclosedate", (Object)alertDate);
                    continue;
                }
                if (!"1".equals(entryCloseStatus)) continue;
                entry.set("entrystatus", (Object)"A");
                entry.set("rowcloser_id", null);
                entry.set("rowclosedate", null);
            }
        }
        if (StringUtils.isNotBlank(message)) {
            throw new KDBizException(message);
        }
        try {
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])orders);
        }
        catch (Exception e) {
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("message", e.getMessage());
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u94fe\u5173\u95ed\u4fe1\u606f\u540c\u6b65\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a{0}", (String)"OrderCloseService_2", (String)"scm-pur-mservice", (Object[])new Object[0]), ExceptionUtil.getStackTrace((Throwable)e)));
        }
        resultMap.put("success", Boolean.TRUE);
        resultMap.put("message", ResManager.loadKDString((String)"\u4f9b\u5e94\u94fe\u5173\u95ed\u4fe1\u606f\u540c\u6b65\u6210\u529f\u3002", (String)"OrderCloseService_7", (String)"scm-pur-mservice", (Object[])new Object[0]));
        response.putAll(resultMap);
        return response;
    }

    private CommonDtxResponse getErrorInfo(CommonDtxResponse result, String message) {
        log.info(message);
        result.put((Object)"success", (Object)false);
        result.put((Object)"message", (Object)message);
        return result;
    }
}

