/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service.schandle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.helper.scdatahandle.args.AssembleHandleArgs;
import kd.scm.common.helper.scdatahandle.args.CosmicParamArgs;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleArgs;
import kd.scm.common.helper.scdatahandle.handleplugin.AbstractDataHandlePlugin;
import kd.scm.common.util.DateUtil;

public class ScPurOrderChangeConfirmHandle
extends AbstractDataHandlePlugin {
    public void assembleCosmicHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        DynamicObject[] dynamicObjects = this.getScHandleParamProxy().getMajorDataParamArgs().getDynamicObjects();
        HashSet<String> scpOrderNumberSet = new HashSet<String>(dynamicObjects.length);
        HashMap<String, Date> changedOrderEntryId = new HashMap<String, Date>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            scpOrderNumberSet.add(dynamicObject.getString("pobillno"));
            DynamicObjectCollection materialEntry = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject material : materialEntry) {
                if (!StringUtils.isNotEmpty((CharSequence)material.getString("chgtype"))) continue;
                changedOrderEntryId.put(material.getString("poentryid"), material.getDate("promiseday"));
            }
        }
        HashMap params = new HashMap();
        DynamicObject[] scpOrderArray = BusinessDataServiceHelper.load((String)"pur_order", (String)"id,materialentry.id,materialentry.pobillid,materialentry.poentryid,materialentry.promiseday", (QFilter[])new QFilter[]{new QFilter("billno", "in", scpOrderNumberSet)});
        ArrayList batchBills = new ArrayList(scpOrderArray.length);
        for (DynamicObject dynamicObject : scpOrderArray) {
            HashMap<String, Serializable> batchBillsMap = new HashMap<String, Serializable>();
            DynamicObjectCollection materialEntry = dynamicObject.getDynamicObjectCollection("materialentry");
            ArrayList billEntry = new ArrayList();
            for (DynamicObject material : materialEntry) {
                Date promiseDay = (Date)changedOrderEntryId.get(material.getString("poentryid"));
                if (promiseDay == null) continue;
                batchBillsMap.put("orderBillId", Long.valueOf(material.getString("pobillid")));
                HashMap<String, Object> billEntryMap = new HashMap<String, Object>();
                billEntryMap.put("entryId", Long.valueOf(material.getString("poentryid")));
                billEntryMap.put("promiseDate", DateUtil.date2str((Date)material.getDate("promiseday"), (String)"yyyy-MM-dd"));
                billEntry.add(billEntryMap);
            }
            batchBillsMap.put("billEntry", billEntry);
            batchBills.add(batchBillsMap);
        }
        params.put("batchBills", batchBills);
        CosmicParamArgs cosmicParamArgs = new CosmicParamArgs();
        cosmicParamArgs.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
        cosmicParamArgs.setCloudId("scmc");
        cosmicParamArgs.setAppId("pm");
        cosmicParamArgs.setServiceName("PurOrderService");
        cosmicParamArgs.setMethodName("changeOrderBillPromiseDate");
        cosmicParamArgs.setParamMap(params);
        cosmicParamArgs.setDynamicObjects(dynamicObjects);
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)cosmicParamArgs, "PurOrderChangeConfirmPromiseDay");
    }
}

