/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceHelper;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceSwitch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillEntryStatusEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ReturnStatusEnum;
import kd.scm.common.service.botp.BotpService;
import kd.scm.common.service.botp.BotpServiceFactory;
import kd.scm.common.service.botp.entity.BotpPushArgs;
import kd.scm.common.service.botp.entity.BotpResult;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicFormUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.common.util.MutexUtil;
import kd.scm.pur.common.util.PurBizTypeUtil;

public abstract class AbstractPurReturnMatchPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog((String)AbstractPurReturnMatchPlugin.class.getName());
    private static final String CONFIRMCALLBACK = "ConfirmCallBack";
    protected static final String RECEIVEQTY = "receiveqty";
    protected static final String OPENSOURCE = "opensource";
    protected static final String ACTION_BOTPLIST = "botpList";
    protected static final String ACTION_BOTPLIST_CQ = "botpListcq";
    protected static String poped_flag = "scm_pur_return_match_%S";
    protected static final String SOURCE_ENTITY_KEY = "source";
    protected static final String ACTION_QUERYFILTER = "queryfilter";
    private static final String ISGOODSBIZTYPE = "isGoodsBizType";
    private static final String BUSINESSTYPE = "businesstype";
    protected static final String HEAD_ENTRY_ENTITY = "head_entryentity";
    protected static final String DETAIL_ENTRY_ENTITY = "detail_entryentity";
    protected static final String SUFFIX_DETAIL = "1";
    public static final String PARTITION = "_";
    private static final String[] VALID_PRO = new String[]{"warehouse", "location", "unit", "basicUnit"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        EntryGrid headGrid = (EntryGrid)this.getView().getControl(HEAD_ENTRY_ENTITY);
        headGrid.addRowClickListener((RowClickEventListener)this);
        headGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid detailGrid = (EntryGrid)this.getView().getControl(DETAIL_ENTRY_ENTITY);
        detailGrid.addHyperClickListener((HyperLinkClickListener)this);
        detailGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IPageCache cache = this.getPageCache();
        super.afterCreateNewData(e);
        String cacheKey = String.format(poped_flag, this.getView().getPageId());
        String poped = cache.get(cacheKey);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!SUFFIX_DETAIL.equals(poped)) {
            this.getPageCache().put(cacheKey, SUFFIX_DETAIL);
            if (customParams.containsKey("customfilter")) {
                this.allotDynamicData();
            } else {
                List billIdList = (List)customParams.get("billid");
                Object businessTypeId = customParams.get(BUSINESSTYPE);
                if (businessTypeId != null) {
                    cache.put(BUSINESSTYPE, businessTypeId.toString());
                }
                if (null != billIdList && billIdList.size() > 0) {
                    HashSet mutexIdSet = new HashSet(billIdList);
                    Map batchRequest = MutexUtil.batchRequest(mutexIdSet, (String)"pur_return_match", (String)"baritemap1");
                    for (Map.Entry booleanEntry : batchRequest.entrySet()) {
                        if (((Boolean)booleanEntry.getValue()).booleanValue()) continue;
                        MutexUtil.batchRelease(mutexIdSet, (String)"pur_return_match", (String)"baritemap1");
                        throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u6709\u5355\u636e\u5728\u5feb\u901f\u9000\u8d27\u4e2d\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"AbstractPurReturnMatchPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    }
                    log.info("AbstractPurReturnMatchPlugin: billIdList:" + SerializationUtils.toJsonString((Object)billIdList));
                    cache.put("billid", SerializationUtils.toJsonString((Object)billIdList));
                    if (customParams.get("returnType") != null) {
                        cache.put(SOURCE_ENTITY_KEY, String.valueOf(customParams.get("returnType")));
                    }
                    this.allotDynamicData();
                } else {
                    this.openQueryFilterPage(new HashMap<String, Object>(8));
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid headEntry = (EntryGrid)this.getControl(HEAD_ENTRY_ENTITY);
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(HEAD_ENTRY_ENTITY);
        int[] rowIndex = new int[dynamicObjectCollection.size()];
        for (int num = 0; num < dynamicObjectCollection.size(); ++num) {
            rowIndex[num] = num;
        }
        headEntry.selectRows(rowIndex, 0);
        if (this.getModel().getEntryEntity(DETAIL_ENTRY_ENTITY).isEmpty()) {
            HashSet<String> selectedRows = new HashSet<String>(rowIndex.length);
            DynamicObjectCollection col = this.getModel().getEntryEntity(HEAD_ENTRY_ENTITY);
            for (int i = 0; i < rowIndex.length; ++i) {
                String poentryid = ((DynamicObject)col.get(rowIndex[i])).getString("poentryid");
                if (!StringUtils.isNotEmpty((String)poentryid) || "0".equals(poentryid)) continue;
                selectedRows.add(poentryid);
            }
            if (CollectionUtils.isEmpty(selectedRows)) {
                log.info("\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u5206\u5f55Id(poEntryId),selectedIndexs={}", (Object)JacksonJsonUtil.toJSON((Object)rowIndex));
            }
            this.bindDetailEntityData(selectedRows);
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List billIdList = (List)customParams.get("billid");
        if (billIdList != null && billIdList.size() > 0) {
            this.getPageCache().remove("billid");
            HashSet mutexIdSet = new HashSet(billIdList);
            MutexUtil.batchRelease(mutexIdSet, (String)"pur_return_match", (String)"baritemap1");
        }
    }

    public void openQueryFilterPage(Map<String, Object> map) {
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"pur_returnquery", map, (CloseCallBack)new CloseCallBack((IFormPlugin)this, ACTION_QUERYFILTER), (ShowType)ShowType.Modal));
    }

    public void allotDynamicData() {
        this.clearData();
        IFormView view = this.getView();
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"pur_request", (String)this.assemblePurRequestSelectFilds("pur_request"), (QFilter[])this.assembleQueryFilter(), (String)"billno desc,materialentry.seq");
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            this.clearData();
            view.updateView();
            view.showMessage(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"AbstractPurReturnMatchPlugin_1", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().beginInit();
        this.getModel().createNewData();
        this.bindEntityData(dynamicObjects, HEAD_ENTRY_ENTITY, "");
        EntryGrid headEntry = (EntryGrid)this.getControl(HEAD_ENTRY_ENTITY);
        headEntry.clearEntryState();
        this.getModel().endInit();
        this.getView().updateView();
    }

    public void bindEntityData(DynamicObjectCollection dynamicObjects, String entityKey, String suffix) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        List propertiesentity = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntityEntity(entityKey).getDynamicObjectType());
        int rowCount = 0;
        TableValueSetter vs = new TableValueSetter(new String[0]);
        String entryIdAndQtyMapCache = this.getPageCache().get("entryIdAndQtyMap");
        Map entryIdAndQtyMap = null;
        entryIdAndQtyMap = entryIdAndQtyMapCache == null ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)entryIdAndQtyMapCache, Map.class);
        for (DynamicObject dynamicObject : dynamicObjects) {
            BigDecimal requestQty;
            Map objectMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)dynamicObject);
            for (Map.Entry entry : objectMap.entrySet()) {
                if (propertiesentity.contains((String)entry.getKey() + suffix) && !"billid".equals(entry.getKey())) {
                    vs.set((String)entry.getKey() + suffix, entry.getValue(), rowCount);
                    continue;
                }
                if (!propertiesentity.contains((String)entry.getKey() + suffix) || !"billid".equals(entry.getKey())) continue;
                vs.set("billid" + suffix, entry.getValue(), rowCount);
            }
            if (HEAD_ENTRY_ENTITY.equals(entityKey)) {
                requestQty = (BigDecimal)entryIdAndQtyMap.get(dynamicObject.getString("poentryid"));
                if (requestQty == null) {
                    requestQty = BigDecimal.ZERO;
                }
                entryIdAndQtyMap.put(dynamicObject.getString("poentryid"), dynamicObject.getBigDecimal("qty").add(requestQty));
            } else if (DETAIL_ENTRY_ENTITY.equals(entityKey)) {
                BigDecimal recQty;
                requestQty = (BigDecimal)entryIdAndQtyMap.get(dynamicObject.getString("poentryid"));
                if (requestQty.compareTo(recQty = dynamicObject.getBigDecimal("qty")) > 0) {
                    vs.set(RECEIVEQTY + suffix, (Object)recQty, rowCount);
                    entryIdAndQtyMap.put(dynamicObject.getString("poentryid"), requestQty.subtract(recQty));
                } else {
                    vs.set(RECEIVEQTY + suffix, (Object)requestQty, rowCount);
                    entryIdAndQtyMap.put(dynamicObject.getString("poentryid"), BigDecimal.ZERO);
                }
            }
            ++rowCount;
        }
        if (HEAD_ENTRY_ENTITY.equals(entityKey)) {
            this.getPageCache().put("entryIdAndQtyMap", SerializationUtils.toJsonString(entryIdAndQtyMap));
        }
        model.batchCreateNewEntryRow(entityKey, vs);
    }

    public QFilter[] assembleQueryFilter() {
        List billIdList;
        String billId;
        String pobillno;
        String material;
        String rcvOrg;
        String billddateFrom;
        String billddate;
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        qFilter.and(new QFilter("cfmstatus", "!=", (Object)ReturnStatusEnum.FINISH.getVal()));
        String supplier = this.getPageCache().get("supplier");
        if (null != supplier && !supplier.isEmpty()) {
            qFilter.and(new QFilter("supplier", "=", (Object)Long.valueOf(supplier)));
        }
        if (null != (billddate = this.getPageCache().get("billdate")) && !billddate.isEmpty()) {
            qFilter.and(new QFilter("billdate", "<=", (Object)DateUtil.string2date((String)billddate, null)));
        }
        if (null != (billddateFrom = this.getPageCache().get("billdatefrom")) && !billddateFrom.isEmpty()) {
            qFilter.and(new QFilter("billdate", ">=", (Object)DateUtil.string2date((String)billddateFrom, null)));
        }
        if (null != (rcvOrg = this.getPageCache().get("rcvorg")) && !rcvOrg.trim().isEmpty()) {
            qFilter.and(new QFilter("org", "=", (Object)Long.valueOf(rcvOrg)));
        }
        if (null != (material = this.getPageCache().get("material")) && !material.isEmpty()) {
            qFilter.and(new QFilter("materialentry.material", "=", (Object)Long.valueOf(material)));
        }
        if (null != (pobillno = this.getPageCache().get("pobillno")) && !pobillno.trim().isEmpty()) {
            qFilter.and(new QFilter("materialentry.pobillno", "=", (Object)pobillno));
        }
        if ((billId = this.getPageCache().get("billid")) != null && null != (billIdList = (List)SerializationUtils.fromJsonString((String)billId, List.class)) && billIdList.size() > 0) {
            ArrayList pkIdList = new ArrayList();
            billIdList.forEach(id -> pkIdList.add(Long.valueOf(id)));
            qFilter.and(new QFilter("id", "in", pkIdList));
        }
        return new QFilter[]{qFilter};
    }

    public String assemblePurRequestSelectFilds(String entityKey) {
        String selectFields = "*";
        switch (entityKey) {
            case "pur_request": {
                selectFields = "id billid,billno,billdate,org.id org,purorg.id purorg,supplier.id supplier,supplier.name suppliername,supplier.number suppliernumber,replenishtype,platform,cfmstatus,materialentry.id entryid,materialentry.material.id material,materialentry.materialdesc materialdesc,materialentry.qty qty,materialentry.unit.id unit,materialentry.basicunit.id basicunit,materialentry.basicqty,materialentry.warehouse warehouse,materialentry.invorg invorg,materialentry.pobillno pobillno,materialentry.pobillid pobillid,materialentry.poentryid poentryid,materialentry.srcbillid srcbillid,materialentry.srcentryid srcentryid,materialentry.taxprice taxprice,materialentry.taxamount taxamount";
                break;
            }
        }
        return selectFields;
    }

    public String assembleSelectFilds(String entityKey) {
        String selectFields = "*";
        switch (entityKey) {
            case "pur_instock": {
                selectFields = "id billid,billno,billdate,org.id org,purorg.id purorg,supplier.id supplier,supplier.name suppliername,supplier.number suppliernumber,materialentry.id entryid,materialentry.material.id material,materialentry.materialdesc materialdesc,materialentry.qty qty,materialentry.unit.id unit,materialentry.basicunit.id basicunit,materialentry.basicqty,materialentry.warehouse warehouse,materialentry.location location,materialentry.pobillno pobillno,materialentry.pobillid pobillid,materialentry.poentryid poentryid,materialentry.srcbillid srcbillid,materialentry.srcentryid srcentryid";
                String selectMorePurInstock = this.selectMorePurInstock();
                if (!StringUtils.isNotEmpty((String)selectMorePurInstock) || !selectMorePurInstock.startsWith(",") || selectMorePurInstock.endsWith(",")) break;
                selectFields = selectFields + selectMorePurInstock;
                break;
            }
            case "pur_receipt": {
                selectFields = "id billid,billno,billdate,org.id org,purorg.id purorg,supplier.id supplier,supplier.name suppliername,supplier.number suppliernumber,isreturn,materialentry.id entryid,materialentry.material.id material,materialentry.materialdesc materialdesc,materialentry.qty qty,materialentry.unit.id unit,materialentry.basicunit.id basicunit,materialentry.basicqty,materialentry.warehouse warehouse,materialentry.pobillno pobillno,materialentry.pobillid pobillid,materialentry.poentryid poentryid,materialentry.srcbillid srcbillid,materialentry.srcentryid srcentryid";
                String selectMorePurReceipt = this.selectMorePurReceipt();
                if (!StringUtils.isNotEmpty((String)selectMorePurReceipt) || !selectMorePurReceipt.startsWith(",") || selectMorePurReceipt.endsWith(",")) break;
                selectFields = selectFields + selectMorePurReceipt;
                break;
            }
        }
        return selectFields;
    }

    public abstract String selectMorePurInstock();

    public abstract String selectMorePurReceipt();

    protected String getBotpBillType(boolean checkIsFeeBizType) {
        if (checkIsFeeBizType) {
            return "pm_puracceptbill";
        }
        String source = this.getPageCache().get(SOURCE_ENTITY_KEY);
        StringBuilder stringBuilder = new StringBuilder();
        if (null == source) {
            stringBuilder.append("im_purinbill");
        } else {
            switch (source) {
                case "1": {
                    stringBuilder.append("im_purinbill");
                    break;
                }
                case "2": {
                    stringBuilder.append("im_purreceivebill");
                    break;
                }
                default: {
                    stringBuilder.append("im_purinbill");
                }
            }
        }
        return stringBuilder.toString();
    }

    protected String assembleSourceEntityKey() {
        String source = this.getPageCache().get(SOURCE_ENTITY_KEY);
        StringBuilder stringBuilder = new StringBuilder();
        if (null == source) {
            stringBuilder.append("pur_instock");
        } else {
            switch (source) {
                case "1": {
                    stringBuilder.append("pur_instock");
                    break;
                }
                case "2": {
                    stringBuilder.append("pur_receipt");
                    break;
                }
                default: {
                    stringBuilder.append("pur_instock");
                }
            }
        }
        return stringBuilder.toString();
    }

    public List<DynamicObject> getSelectedData(String entryKey) {
        ArrayList<DynamicObject> selectDynaObj = new ArrayList<DynamicObject>();
        DynamicObjectCollection col = this.getModel().getEntryEntity(entryKey);
        for (DynamicObject dynamicObject : col) {
            if (dynamicObject.getBigDecimal("receiveqty1").compareTo(BigDecimal.ZERO) == 0) continue;
            selectDynaObj.add(dynamicObject);
        }
        return selectDynaObj;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String entity;
        EntryGrid grid = (EntryGrid)hyperLinkClickEvent.getSource();
        String gridKey = grid.getKey();
        Object val = null;
        String entityKey = null;
        String property = hyperLinkClickEvent.getFieldName();
        String sou = this.getPageCache().get(SOURCE_ENTITY_KEY);
        String string = entity = SUFFIX_DETAIL.equals(sou) ? "pur_instock" : "pur_receipt";
        if (HEAD_ENTRY_ENTITY.equals(gridKey)) {
            val = grid.getModel().getValue(property);
            if ("billno".equals(property)) {
                entityKey = "pur_request";
            } else if ("pobillno".equals(property)) {
                entityKey = "pur_order";
            }
            this.showBillForm(val, entityKey);
        }
        if (DETAIL_ENTRY_ENTITY.equals(gridKey)) {
            val = grid.getModel().getValue(property);
            if ("billno1".equals(property)) {
                entityKey = entity;
            } else if ("pobillno1".equals(property)) {
                entityKey = "pur_order";
            }
            this.showBillForm(val, entityKey);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "baritemap": {
                this.openQueryFilterPage(new HashMap<String, Object>(8));
                this.getView().setEnable(Boolean.TRUE, new String[]{DETAIL_ENTRY_ENTITY});
                this.getPageCache().remove("fromsource");
                break;
            }
            case "baritemap1": {
                IDataModel model = this.getModel();
                if (!this.validateData(model)) {
                    evt.setCancel(true);
                    break;
                }
                this.openCommonBotpListPage(model);
                break;
            }
        }
    }

    private void openCommonBotpListPage(IDataModel model) {
        List headEntryEntityData = DynamicFormUtil.getSelectedData((IFormView)this.getView(), (IDataModel)model, (String)HEAD_ENTRY_ENTITY);
        log.info("\u5355\u636e\u4e0b\u63a8\u670d\u52a1:headEntryEntityData={}", (Object)JacksonJsonUtil.toJSON((Object)headEntryEntityData));
        String replenishtype = ((DynamicObject)headEntryEntityData.get(0)).getString("replenishtype");
        this.getPageCache().put("replenishtype", replenishtype);
        String businessType = this.getPageCache().get(BUSINESSTYPE);
        String bizTypeId = PurBizTypeUtil.getBizTypeByBizTypeId((String)businessType);
        boolean isGoodsPurchase = PurBizTypeUtil.checkIsGoodsBizType((String)bizTypeId);
        this.getPageCache().put(ISGOODSBIZTYPE, Boolean.toString(isGoodsPurchase));
        boolean hasRepcConfig = ApiConfigUtil.hasRepcConfig();
        if (isGoodsPurchase) {
            this.openBotpListPage("pur_receipt", "pur_receipt_return", replenishtype);
        } else if (ApiConfigUtil.hasCQScmConfig() && !hasRepcConfig) {
            boolean checkIsFeeBizType = PurBizTypeUtil.checkIsFeeBizType((String)bizTypeId);
            String billType = this.getBotpBillType(checkIsFeeBizType);
            this.openBotpListPage(billType, billType, replenishtype);
        } else if (ApiConfigUtil.hasXKScmConfig() || hasRepcConfig || ApiConfigUtil.hasEASConfig()) {
            String billType = this.assembleSourceEntityKey();
            if ("pur_instock".equals(billType)) {
                this.openBotpListPage("inware", "inware", replenishtype);
            } else {
                this.openBotpListPage("receive", "receive", replenishtype);
            }
        }
    }

    private boolean validateData(IDataModel model) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(HEAD_ENTRY_ENTITY);
        int[] selectRows = grid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u6570\u636e\u624d\u80fd\u6267\u884c\u4e0b\u63a8\u9000\u8d27\u3002", (String)"AbstractPurReturnMatchPlugin_2", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection col = model.getEntryEntity(HEAD_ENTRY_ENTITY);
        HashMap<Object, BigDecimal> headMap = new HashMap<Object, BigDecimal>(8);
        HashMap<Object, Integer> rowMap = new HashMap<Object, Integer>(8);
        for (int i = 0; i < selectRows.length; ++i) {
            DynamicObject headObject = (DynamicObject)col.get(selectRows[i]);
            Object srcentryid = headObject.get("poentryid");
            BigDecimal qty = (BigDecimal)headMap.get(srcentryid);
            if (qty == null) {
                qty = BigDecimal.ZERO;
            }
            headMap.put(srcentryid, headObject.getBigDecimal("qty").add(qty));
            rowMap.put(srcentryid, selectRows[i] + 1);
        }
        String billId = this.getPageCache().get("billid");
        if (StringUtils.isNotEmpty((String)billId) && selectRows.length != col.size()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5546\u57ce\u552e\u540e\u7533\u8bf7\u53ea\u652f\u6301\u4e00\u6b21\u5168\u90e8\u9000\u8d27\u3002", (String)"AbstractPurReturnMatchPlugin_12", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection entryCols = this.getModel().getEntryEntity(DETAIL_ENTRY_ENTITY);
        for (int row = 0; row < entryCols.size(); ++row) {
            BigDecimal qty;
            DynamicObject dynamicObject = (DynamicObject)entryCols.get(row);
            BigDecimal receiveQty = dynamicObject.getBigDecimal("receiveqty1");
            if (receiveQty.compareTo(qty = dynamicObject.getBigDecimal("qty1")) <= 0) continue;
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u9000\u8d27\u5339\u914d\u884c%1$s\uff0c\u9000\u8d27\u6570\u91cf\u5927\u4e8e\u6536\u8d27/\u5165\u5e93\u6570\u91cf\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u9000\u8d27\u6570\u91cf\u3002", (String)"AbstractPurReturnMatchPlugin_4", (String)"scm-pur-formplugin", (Object[])new Object[0]), row));
            return false;
        }
        DynamicObjectCollection detailEntryEntityData = model.getEntryEntity(DETAIL_ENTRY_ENTITY);
        HashMap<Object, BigDecimal> detailMap = new HashMap<Object, BigDecimal>(8);
        for (Object detailObject : detailEntryEntityData) {
            BigDecimal bigDecimal = detailObject.getBigDecimal("receiveqty1");
            Object srcentryid = detailObject.get("poentryid1");
            BigDecimal qtyOrigin = (BigDecimal)detailMap.get(srcentryid);
            if (qtyOrigin != null) {
                BigDecimal sumQty = qtyOrigin.add(bigDecimal);
                detailMap.put(srcentryid, sumQty);
                continue;
            }
            detailMap.put(srcentryid, bigDecimal);
        }
        StringBuilder sbBig = new StringBuilder();
        for (Map.Entry entry : headMap.entrySet()) {
            Integer row = (Integer)rowMap.get(entry.getKey());
            BigDecimal qty = (BigDecimal)entry.getValue();
            BigDecimal receiveqty = detailMap.get(entry.getKey()) == null ? BigDecimal.ZERO : (BigDecimal)detailMap.get(entry.getKey());
            int receiveqtyScale = receiveqty.scale();
            BigDecimal qty1 = qty.setScale(receiveqtyScale);
            if (qty.compareTo(receiveqty) < 0) {
                sbBig.append(ResManager.loadKDString((String)MessageFormat.format("\u9000\u8d27\u7533\u8bf7\u884c{0},\u672c\u6b21\u9000\u8d27\u6570\u91cf{1}\u8d85\u8fc7\u4e86\u7533\u8bf7\u9000\u8d27\u6570\u91cf{2}\u3002", row, receiveqty, qty1), (String)"AbstractPurBatchReturnPlugin_5", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                sbBig.append(System.lineSeparator());
            }
            if (qty.compareTo(receiveqty) <= 0) continue;
            sbBig.append(ResManager.loadKDString((String)MessageFormat.format("\u9000\u8d27\u7533\u8bf7\u884c{0},\u672c\u6b21\u9000\u8d27\u6570\u91cf{1}\u5c0f\u4e8e\u7533\u8bf7\u9000\u8d27\u6570\u91cf{2}\u3002", row, receiveqty, qty1), (String)"AbstractPurBatchReturnPlugin_6", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            sbBig.append(System.lineSeparator());
        }
        if (StringUtils.isNotEmpty((String)sbBig.toString())) {
            String title = ResManager.loadKDString((String)"\u5b58\u5728\u9000\u8d27\u6570\u91cf\u4e0d\u7b49\u4e8e\u7533\u8bf7\u9000\u8d27\u6570\u91cf\u7684\u5206\u5f55\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u9000\u8d27\u6570\u91cf\u3002", (String)"AbstractPurReturnMatchPlugin_7", (String)"scm-pur-formplugin", (Object[])new Object[0]);
            if (null != billId) {
                String string = ResManager.loadKDString((String)"\uff08\u6ce8\u610f\uff1a\u5546\u57ce\u552e\u540e\u7533\u8bf7\u53ea\u652f\u6301\u4e00\u6b21\u9000\u8d27\uff09", (String)"AbstractPurReturnMatchPlugin_11", (String)"scm-pur-formplugin", (Object[])new Object[0]);
                title = title + string;
            }
            this.getView().showMessage(title, sbBig.toString(), MessageTypes.Default);
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CONFIRMCALLBACK.equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.openCommonBotpListPage(this.getModel());
        }
    }

    public void showBillForm(Object val, String entityKey) {
        if (val == null || entityKey == null || entityKey.isEmpty()) {
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("billno", val);
        DynamicObject dynaObject = ORMUtil.queryOneByPro((String)entityKey, (String)"id,billno", param);
        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)entityKey, (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)((Long)dynaObject.getPkValue()), new HashMap(8), null));
    }

    public Map<String, Object> getBillIdInfo() {
        DynamicObjectCollection detailDataList = this.getModel().getEntryEntity(DETAIL_ENTRY_ENTITY);
        ArrayList<DynamicObject> entryList = new ArrayList<DynamicObject>(detailDataList.size());
        for (DynamicObject dynamicObject : detailDataList) {
            if (dynamicObject.getBigDecimal("receiveqty1").compareTo(BigDecimal.ZERO) == 0) continue;
            entryList.add(dynamicObject);
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        if (entryList.size() == 0) {
            return dataMap;
        }
        HashSet<String> entryIdSet = new HashSet<String>();
        HashSet<String> billIdSet = new HashSet<String>();
        for (DynamicObject entry : entryList) {
            String srcEntryId = String.valueOf(entry.get("srcentryid1"));
            if (!StringUtils.isNotEmpty((String)srcEntryId)) continue;
            entryIdSet.add(srcEntryId);
            String billId = String.valueOf(entry.get("srcbillid1"));
            billIdSet.add(billId);
        }
        dataMap.put("billId", billIdSet);
        dataMap.put("entryId", entryIdSet);
        return dataMap;
    }

    private Map<String, Object> getBillInfo() {
        DynamicObjectCollection detailDataList = this.getModel().getEntryEntity(DETAIL_ENTRY_ENTITY);
        ArrayList<DynamicObject> entryList = new ArrayList<DynamicObject>(detailDataList.size());
        for (DynamicObject dynamicObject : detailDataList) {
            if (dynamicObject.getBigDecimal("receiveqty1").compareTo(BigDecimal.ZERO) == 0) continue;
            entryList.add(dynamicObject);
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        String replenishtype = this.getPageCache().get("replenishtype");
        for (DynamicObject entry : entryList) {
            HashMap<String, Object> detailMap = new HashMap<String, Object>(8);
            Object srcEntryId = entry.get("srcentryid1");
            if (srcEntryId == null || srcEntryId.toString().trim().isEmpty()) continue;
            for (String property : VALID_PRO) {
                Object val = entry.get(property + SUFFIX_DETAIL);
                if (null == val) {
                    detailMap.put(property, "");
                    continue;
                }
                if (val instanceof DynamicObject) {
                    Object number = DynamicObjectUtil.getBDNumberOfValue((DynamicObject)((DynamicObject)val));
                    detailMap.put(property, number);
                    continue;
                }
                detailMap.put(property, val);
            }
            BigDecimal recieveQty = CommonUtil.getBigDecimalPro((Object)entry.get("receiveqty1"));
            String entryIdStr = entry.getString("entryid1");
            String billIdStr = entry.getString("billid1");
            detailMap.put("entryId", srcEntryId);
            detailMap.put("billid", entry.get("srcbillid1"));
            detailMap.put("qty", recieveQty);
            detailMap.put("srcEntryId", entryIdStr);
            detailMap.put("srcBillId", billIdStr);
            this.setMrMode(detailMap, replenishtype);
            dataMap.put(entryIdStr, detailMap);
        }
        return this.groupDataBySrcBillId(dataMap);
    }

    private void setMrMode(Map<String, Object> detailMap, String replenishtype) {
        if ("3".equals(replenishtype)) {
            detailMap.put("mrMode", "B");
        } else {
            detailMap.put("mrMode", "A");
        }
    }

    public Map getParamByrecOrg(String autoAuditStatus) {
        IFormView view = this.getView();
        EntryGrid grid = (EntryGrid)view.getControl(HEAD_ENTRY_ENTITY);
        int[] selectRows = grid.getSelectRows();
        HashMap<String, String> org_IdMap = new HashMap<String, String>(1024);
        DynamicObject orgDyn = null;
        IDataModel model = this.getModel();
        DynamicObjectCollection headCols = model.getEntryEntity(HEAD_ENTRY_ENTITY);
        if (CollectionUtils.isEmpty((Collection)headCols)) {
            return org_IdMap;
        }
        DynamicObject dyn = null;
        for (int index : selectRows) {
            dyn = (DynamicObject)headCols.get(index);
            orgDyn = dyn.getDynamicObject("purorg");
            org_IdMap.put(orgDyn.getString("number"), autoAuditStatus);
        }
        return org_IdMap;
    }

    public Map<String, Object> groupDataBySrcBillId(Map<String, Object> dataMap) {
        HashMap<String, Object> groupedData = new HashMap<String, Object>(8);
        dataMap.forEach((key, val) -> {
            Map data = (Map)val;
            String srcBillId = String.valueOf(data.get("srcBillId"));
            ArrayList<Map> list = (ArrayList<Map>)groupedData.get(srcBillId);
            if (list == null) {
                list = new ArrayList<Map>(10);
            }
            list.add(data);
            groupedData.put(srcBillId, list);
        });
        return groupedData;
    }

    private void openBotpListPage(String sourceEntity, String targetEntity, String replenishtype) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("pbd_common_botp");
        formShowParameter.setCustomParam("sourceentity", (Object)sourceEntity);
        formShowParameter.setCustomParam("targetentity", (Object)targetEntity);
        formShowParameter.setCustomParam("replenishtype", (Object)replenishtype);
        ArrayList<String> element = new ArrayList<String>(10);
        element.add("sourceentity");
        element.add("targetentity");
        formShowParameter.setCustomParam("invisible", element);
        ArrayList<String> visible = new ArrayList<String>(10);
        visible.add("replenishtype");
        formShowParameter.setCustomParam("visible", visible);
        Map<String, Object> billInfoMap = this.getBillIdInfo();
        billInfoMap.put(ISGOODSBIZTYPE, this.getPageCache().get(ISGOODSBIZTYPE));
        formShowParameter.setCustomParam("customParams", billInfoMap);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_BOTPLIST));
        this.getView().showForm(formShowParameter);
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid grid = (EntryGrid)evt.getSource();
        IDataModel model = grid.getModel();
        String entryKey = grid.getKey();
        int[] selectedIndexs = grid.getEntryState().getSelectedRows();
        switch (entryKey) {
            case "head_entryentity": {
                model.deleteEntryData(DETAIL_ENTRY_ENTITY);
                if (selectedIndexs.length <= 0) break;
                HashSet<String> selectedRows = new HashSet<String>(selectedIndexs.length);
                DynamicObjectCollection col = model.getEntryEntity(entryKey);
                if (CollectionUtils.isEmpty((Collection)col)) break;
                for (int i = 0; i < selectedIndexs.length; ++i) {
                    String poentryid = ((DynamicObject)col.get(selectedIndexs[i])).getString("poentryid");
                    if (!StringUtils.isNotEmpty((String)poentryid) || "0".equals(poentryid)) continue;
                    selectedRows.add(poentryid);
                }
                if (CollectionUtils.isEmpty(selectedRows)) {
                    log.info("\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u5206\u5f55Id(poEntryId),selectedIndexs={}", (Object)JacksonJsonUtil.toJSON((Object)selectedIndexs));
                    break;
                }
                this.bindDetailEntityData(selectedRows);
                break;
            }
        }
    }

    private void bindDetailEntityData(Set<String> poentryids) {
        QFilter idfilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        StringBuilder entrystatus = new StringBuilder().append("materialentry").append(".").append("entrystatus");
        idfilter.and(entrystatus.toString(), "=", (Object)BillEntryStatusEnum.COMMON.getVal());
        StringBuilder poentryid = new StringBuilder().append("materialentry").append(".").append("poentryid");
        idfilter.and(poentryid.toString(), "in", poentryids);
        String entityKey = this.assembleSourceEntityKey();
        this.assembleQFilterBySelectFilds(idfilter, entityKey);
        StringBuilder seq = new StringBuilder().append("materialentry").append(".").append("seq");
        DynamicObjectCollection col = QueryServiceHelper.query((String)entityKey, (String)this.assembleSelectFilds(entityKey), (QFilter[])new QFilter[]{idfilter}, (String)seq.toString());
        if (!col.isEmpty()) {
            this.bindEntityData(col, DETAIL_ENTRY_ENTITY, SUFFIX_DETAIL);
        }
    }

    protected void assembleQFilterBySelectFilds(QFilter idfilter, String entityKey) {
        switch (entityKey) {
            case "pur_receipt": {
                idfilter.and("isreturn", "=", (Object)false);
                break;
            }
            case "pur_instock": {
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (name) {
            case "receiveqty1": {
                BigDecimal qty1 = (BigDecimal)this.getModel().getValue("qty1", rowIndex);
                if (qty1.compareTo((BigDecimal)newValue) >= 0) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u9000\u8d27\u6570\u91cf\u5927\u4e8e\u53d1\u8d27\u6570\u91cf\uff0c\u4e0d\u80fd\u9000\u8d27\u54e6\u3002", (String)"AbstractPurReturnMatchPlugin_9", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(name, (Object)0, rowIndex);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "queryfilter": {
                if (returnData == null) break;
                IPageCache cache = this.getPageCache();
                Map map = returnData instanceof Map ? (Map)returnData : new HashMap(8);
                for (Map.Entry entry : map.entrySet()) {
                    cache.put((String)entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
                }
                this.allotDynamicData();
                this.getPageCache().remove("supplier");
                break;
            }
            case "botpList": {
                Map result;
                if (returnData == null || CollectionUtils.isEmpty((Map)(result = (Map)returnData))) break;
                Object botpDataObject = result.get("botpdata");
                Object sourceEntityObject = result.get("sourceentity");
                Object targetEntityObject = result.get("targetentity");
                if (botpDataObject == null || sourceEntityObject == null || targetEntityObject == null) break;
                String botpData = botpDataObject.toString();
                String sourceEntity = sourceEntityObject.toString();
                String targetEntity = targetEntityObject.toString();
                this.doPush(sourceEntity, targetEntity, botpData);
                break;
            }
        }
    }

    public void doPush(String sourceEntity, String targetEntity, String botpNumber) {
        BotpPushArgs pushArgs = new BotpPushArgs();
        pushArgs.setSourceEntityNumber(sourceEntity);
        pushArgs.setTargetEntityNumber(targetEntity);
        pushArgs.setRuleId(botpNumber);
        pushArgs.setBuildConvReport(true);
        pushArgs.setAutoSave(true);
        String businessType = this.getPageCache().get(BUSINESSTYPE);
        String bizTypeByBizTypeId = PurBizTypeUtil.getBizTypeByBizTypeId((String)businessType);
        boolean isGoodsPurchase = PurBizTypeUtil.checkIsGoodsBizType((String)bizTypeByBizTypeId);
        boolean hasRepcConfig = ApiConfigUtil.hasRepcConfig();
        if (ApiConfigUtil.hasCQScmConfig() && !hasRepcConfig || isGoodsPurchase) {
            this.assembleXhPushParam(pushArgs, isGoodsPurchase);
        } else if (ApiConfigUtil.hasXKScmConfig() || hasRepcConfig || ApiConfigUtil.hasEASConfig()) {
            this.assembleXkEasPushParam(pushArgs);
        }
        BotpResult botpResult = null;
        BotpService botpService = BotpServiceFactory.getBotpService((boolean)isGoodsPurchase, (boolean)hasRepcConfig);
        log.info("\u5355\u636e\u4e0b\u63a8\u670d\u52a1:botpService={},pushArgs={}", (Object)botpService.getClass().getName(), (Object)JacksonJsonUtil.toJSON((Object)pushArgs));
        botpResult = botpService.push(pushArgs);
        if (botpResult == null) {
            botpResult = new BotpResult();
            botpResult.setSucced(Boolean.valueOf(false));
            botpResult.setMessage(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u6570\u636e\u6216\u8005\u83b7\u53d6Botp\u89c4\u5219\u5f02\u5e38\u3002", (String)"AbstractPurReturnMatchPlugin_10", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
        log.info("\u5355\u636e\u4e0b\u63a8\u7ed3\u679c:botpResult={}", (Object)JacksonJsonUtil.toJSON((Object)botpResult));
        if (ApiConfigUtil.hasCQScmConfig() && !hasRepcConfig || isGoodsPurchase) {
            Boolean resObj = botpResult.getSucced();
            if (resObj != null && resObj.booleanValue()) {
                this.auditEntityAndWriteBack(targetEntity, botpResult);
            } else {
                this.getView().showMessage(botpResult.getMessage());
            }
        } else if (ApiConfigUtil.hasXKScmConfig() || hasRepcConfig || ApiConfigUtil.hasEASConfig()) {
            this.handleResult(botpResult);
        }
    }

    public void assembleXkEasPushParam(BotpPushArgs pushArgs) {
        String actionName = "";
        actionName = "inware".equals(pushArgs.getSourceEntityNumber()) ? "doIerp2InStock" : "doIerp2Receive";
        String source = "batchReturn";
        pushArgs.setActionName(actionName);
        pushArgs.setSource(source);
        Map<String, Object> billInfoMap = this.getBillInfo();
        String autoAuditStatus = "C";
        billInfoMap.put("billstatus1", this.getParamByrecOrg(autoAuditStatus));
        billInfoMap.put("billstatus", autoAuditStatus);
        pushArgs.setDataMap(billInfoMap);
    }

    private void assembleXhPushParam(BotpPushArgs pushArgs, boolean isGoodsPurchase) {
        DynamicObjectCollection detailDataList = this.getModel().getEntryEntity(DETAIL_ENTRY_ENTITY);
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>(detailDataList.size());
        for (DynamicObject dynamicObject : detailDataList) {
            if (dynamicObject.getBigDecimal("receiveqty1").compareTo(BigDecimal.ZERO) == 0) continue;
            dataList.add(dynamicObject);
        }
        for (DynamicObject dynamicObject : dataList) {
            BigDecimal receiveqty;
            if (isGoodsPurchase) {
                String recEntryId = dynamicObject.getString("entryid1");
                if (recEntryId.isEmpty() || (receiveqty = dynamicObject.getBigDecimal("receiveqty1")).compareTo(BigDecimal.ZERO) <= 0) continue;
                pushArgs.addCustomParam("qty_" + recEntryId, receiveqty.toPlainString());
                continue;
            }
            String srcentryid1 = dynamicObject.getString("srcentryid1");
            if (srcentryid1.isEmpty() || (receiveqty = dynamicObject.getBigDecimal("receiveqty1")).compareTo(BigDecimal.ZERO) <= 0) continue;
            pushArgs.addCustomParam("qty_" + srcentryid1, receiveqty.toPlainString());
        }
        if (log.isInfoEnabled()) {
            log.info("assembleXhPushParam#CustomParams", (Object)SerializationUtils.toJsonString((Object)pushArgs.getCustomParams()));
        }
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(10);
        for (DynamicObject entry : dataList) {
            ListSelectedRow listSelectedRow = new ListSelectedRow();
            if (isGoodsPurchase) {
                listSelectedRow.setEntryEntityKey("materialentry");
                listSelectedRow.setPrimaryKeyValue((Object)entry.getLong("billid1"));
                listSelectedRow.setEntryPrimaryKeyValue((Object)entry.getLong("entryid1"));
            } else {
                listSelectedRow.setEntryEntityKey("billentry");
                listSelectedRow.setPrimaryKeyValue((Object)entry.getLong("srcbillid1"));
                listSelectedRow.setEntryPrimaryKeyValue((Object)entry.getLong("srcentryid1"));
            }
            selectedRowList.add(listSelectedRow);
        }
        if (!selectedRowList.isEmpty()) {
            pushArgs.setSelectedRows(selectedRowList);
        }
    }

    private void auditEntityAndWriteBack(String targetEntity, BotpResult botpResult) {
        boolean auditSuccess = true;
        String operator = null;
        String result = null;
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("WF", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        Integer rowFailCount = botpResult.getRowFailCount();
        if (rowFailCount > 0) {
            String title = ResManager.loadKDString((String)"\u5355\u636e\u8f6c\u6362\u5f02\u5e38", (String)"AbstractPurReturnMatchPlugin_15", (String)"scm-pur-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(title, botpResult.getMessage(), MessageTypes.Default);
            return;
        }
        List targetDataAll = botpResult.getTargetData();
        OperationResult opResult = SaveServiceHelper.saveOperate((String)targetEntity, (DynamicObject[])targetDataAll.toArray(new DynamicObject[0]), (OperateOption)option);
        if (opResult.getSuccessPkIds().isEmpty()) {
            String message = opResult.getMessage() + ExceptionUtil.getErrorInfoDetails((List)opResult.getAllErrorOrValidateInfo());
            this.getView().showMessage(message);
            return;
        }
        botpResult.setData(opResult.getSuccessPkIds());
        List pkIds = botpResult.getData();
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)targetEntity, (Object[])pkIds.toArray(), (OperateOption)option);
        if (submitResult.isSuccess()) {
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)targetEntity, (Object[])pkIds.toArray(), (OperateOption)option);
            if (auditResult.isSuccess()) {
                this.cfmStatusFinish();
                StringBuilder sb = new StringBuilder();
                for (Map.Entry iDAndBillNoEntry : auditResult.getBillNos().entrySet()) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u9000\u8d27\u5355\u7f16\u53f7\uff1a%s\t\n", (String)"AbstractPurReturnMatchPlugin_16", (String)"scm-pur-formplugin", (Object[])new Object[0]), iDAndBillNoEntry.getValue()));
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u9000\u8d27\u6210\u529f", (String)"AbstractPurReturnMatchPlugin_13", (String)"scm-pur-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
            } else {
                operator = "unsubmit";
                auditSuccess = false;
                result = this.getOperatorMsg(auditResult);
            }
        } else {
            operator = "delete";
            auditSuccess = false;
            result = this.getOperatorMsg(submitResult);
        }
        if (auditSuccess) {
            this.getView().close();
        } else {
            this.returnBack(targetEntity, operator, pkIds);
            this.getView().showMessage(result);
        }
    }

    private String getOperatorMsg(OperationResult submitResult) {
        if (submitResult.getInteractionContext() == null) {
            return submitResult.getMessage() + ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo());
        }
        return submitResult.getInteractionContext().getSimpleMessage();
    }

    private void returnBack(String targetEntity, String operator, List<Object> pkIds) {
        if (ECServiceSwitch.isOpened()) {
            try (TXHandle tx = TX.required();){
                CommonParam commonParam = new CommonParam();
                commonParam.put((Object)"businesskeys", pkIds);
                commonParam.put((Object)"entityname", (Object)targetEntity);
                commonParam.put((Object)"operator", (Object)operator);
                ECServiceHelper.execute((String)"pur_return_match_audit_fail_return_back", (String)"redReturnBack", (String)"scm", (String)"pur", (String)"RedReceiptInstockReturnBackService", (Param)commonParam);
            }
        } else if ("unsubmit".equals(operator)) {
            OperationResult unsubmitResult = OperationServiceHelper.executeOperate((String)operator, (String)targetEntity, (Object[])pkIds.toArray(), (OperateOption)OperateOption.create());
            if (unsubmitResult.isSuccess()) {
                OperationServiceHelper.executeOperate((String)"delete", (String)targetEntity, (Object[])pkIds.toArray(), (OperateOption)OperateOption.create());
            }
        } else {
            OperationServiceHelper.executeOperate((String)operator, (String)targetEntity, (Object[])pkIds.toArray(), (OperateOption)OperateOption.create());
        }
    }

    public void handleResult(BotpResult botpResult) {
        if (botpResult == null) {
            return;
        }
        if (botpResult.getSucced().booleanValue()) {
            Map map = (Map)JacksonJsonUtil.fromJson((String)botpResult.getMessage(), Map.class);
            this.writeBackMalReturnReq(map, DETAIL_ENTRY_ENTITY, SUFFIX_DETAIL);
        }
    }

    private void writeBackMalReturnReq(Map<String, Object> map, String entryKey, String index) {
        List<DynamicObject> cols = this.getSelectedData(entryKey);
        StringBuilder msgSB = new StringBuilder();
        HashSet<String> targetDataBillNoSet = new HashSet<String>();
        for (DynamicObject col : cols) {
            Long srcEntryId = col.getLong("entryid" + index);
            String srcEntryIdStr = String.valueOf(srcEntryId);
            String errorMsg = null;
            Map msgMap = (Map)map.get(srcEntryIdStr);
            if (msgMap != null && msgMap.get("billnumber") != null) {
                targetDataBillNoSet.add((String)msgMap.get("billnumber"));
            }
            if (msgMap != null) {
                errorMsg = String.valueOf(msgMap.get("error"));
            }
            if (errorMsg == null || errorMsg.length() == 0 || msgSB.toString().contains(errorMsg)) continue;
            msgSB.append(errorMsg).append(";\n");
        }
        log.info("\u5355\u636e\u4e0b\u63a8\u7ed3\u679c:msgSB={}", (Object)msgSB.toString());
        if (msgSB.length() == 0) {
            this.cfmStatusFinish();
            StringBuilder sb = new StringBuilder();
            for (String billNo : targetDataBillNoSet) {
                sb.append(String.format(ResManager.loadKDString((String)"\u9000\u8d27\u5355\u7f16\u53f7\uff1a%s\t\n", (String)"AbstractPurReturnMatchPlugin_16", (String)"scm-pur-formplugin", (Object[])new Object[0]), billNo));
            }
            this.getView().showMessage(ResManager.loadKDString((String)"\u9000\u8d27\u6210\u529f", (String)"AbstractPurReturnMatchPlugin_13", (String)"scm-pur-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
            this.getView().close();
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)msgSB.toString(), (String)"AbstractPurReturnMatchPlugin_7", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    private void cfmStatusFinish() {
        List billIdList;
        String billId = this.getPageCache().get("billid");
        if (billId != null && (billIdList = (List)SerializationUtils.fromJsonString((String)billId, List.class)) != null && billIdList.size() > 0) {
            ArrayList pkIdList = new ArrayList();
            billIdList.forEach(id -> pkIdList.add(Long.valueOf(id)));
            QFilter idFilter = new QFilter("id", "in", pkIdList);
            DynamicObject[] malReturnReqDynColl = BusinessDataServiceHelper.load((String)"pur_request", (String)this.assemblePurRequestSelectFilds("pur_request"), (QFilter[])new QFilter[]{idFilter});
            if (null != malReturnReqDynColl) {
                for (DynamicObject malReturnReqDyn : malReturnReqDynColl) {
                    malReturnReqDyn.set("cfmstatus", (Object)ReturnStatusEnum.FINISH.getVal());
                }
                SaveServiceHelper.save((DynamicObject[])malReturnReqDynColl);
            }
        }
    }

    private void clearData() {
        IDataModel model = this.getModel();
        model.deleteEntryData(DETAIL_ENTRY_ENTITY);
        model.deleteEntryData(HEAD_ENTRY_ENTITY);
    }
}

