/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.YzjContextMenuClickPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillEntryStatusEnum;
import kd.scm.common.helper.multisystemjoint.MultiDataHandleResult;
import kd.scm.common.helper.multisystemjoint.ScMultiDataHandleServiceHelper;
import kd.scm.common.systemjoint.SystemJointChannelHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BussinessTypeUtils;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.MaterialUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.ScmcUtil;
import kd.scm.common.util.SupplierChatEngineUtil;
import kd.scm.common.util.WriteBackUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.pur.business.PurBatchStockHelper;
import kd.scm.pur.common.ReceiptUtil;
import kd.scm.pur.formplugin.batchreceive.BatchFillEntryHelper;
import kd.scm.pur.formplugin.batchreceive.IBatchReceiveGetData;
import kd.scm.pur.formplugin.batchreceive.IBatchReceiveGetEASTransferProperty;
import kd.scm.pur.formplugin.batchreceive.IBatchReceiveGetFilter;
import kd.scm.pur.formplugin.batchreceive.IBatchReceiveGetSelector;
import kd.scm.pur.formplugin.batchreceive.IBatchReceiveGetXHTransferProperty;
import kd.scm.pur.formplugin.batchreceive.PluginExtendHelper;
import kd.scm.pur.formplugin.batchreceive.PurBatchReceiveContext;
import kd.scm.pur.formplugin.info.SumMaterailInfo;

public class PurBatchReceiveEditPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
HyperLinkClickListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog(PurBatchReceiveEditPlugin.class);
    private static final String HEAD_ENTRY_ENTITY = "head_entryentity";
    private static final String DETAIL_ENTRY_ENTITY = "detail_entryentity";
    private static final String SUFFIX__DETAIL = "1";
    private static final String ALL_ENTRY_ENTITY = "all_entryentity";
    private static final String SUFFIX_ALL = "4";
    private static final String SUM_ENTRY_ENTITY = "sum_matentryentity";
    private static final String SUFFIX_SUM = "2";
    private static final String ACTION_QUERYFILTER = "queryfilter";
    private static final String ACTION_REJECTED = "rejected";
    private static final String ACTION_BOTPLIST = "botpList";
    private static final String TO_INWARE = "toInware";
    private static final String TO_RECEIVE = "toReceive";
    private static String RECEIVEQTY = "receiveqty";
    private static final String IS_FIRST = "isFirst";
    private static final String[] NEED_BATCH_FILL_PRO = new String[]{"receiveqty1", "warehouse1", "location1", "lot1"};
    protected IAppCache restOfReceiveQtyCache = AppCache.get((String)"restOfReceiveQty");
    protected IAppCache originReceiveQtyCache = AppCache.get((String)"originReceiveQty");
    private static final String poped_flag = "scm_pur_bacthreceive_%S";
    private PluginExtendHelper pluginExtendHelper = null;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String jointchanneldata = this.getView().getPageCache().get("jointchanneldata");
        if (jointchanneldata == null) {
            jointchanneldata = SystemJointChannelHelper.getDefaultJointChannelId();
        }
        this.setVisible(SystemJointChannelHelper.hasSpecJointType((String)jointchanneldata, (String)"self"));
    }

    private void setVisible(boolean isCQ) {
        this.getView().setVisible(Boolean.valueOf(isCQ), new String[]{"bar_to_cq_instock", "bartocqreceipt"});
        this.getView().setVisible(Boolean.valueOf(!isCQ), new String[]{"baritemap1", "bar_to_inware", "location1", "warehouse1", "lot1"});
    }

    public void afterCreateNewData(EventObject e) {
        IPageCache cache = this.getPageCache();
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if ("mal_order".equals(customParams.get("sourceBill"))) {
            cache.put("sourceBill", "mal_order");
        }
        if (!SUFFIX__DETAIL.equals(cache.get("isTreeNodeClick"))) {
            TreeView treeView = (TreeView)this.getControl("treeviewap");
            TreeNode node = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"PurBatchReceiveEditPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            treeView.deleteAllNodes();
            treeView.addNode(node);
            treeView.focusNode(node);
        }
        String cacheKey = String.format(poped_flag, this.getView().getPageId());
        cache.put("cacheKey", cacheKey);
        String poped = cache.get(cacheKey);
        if (!SUFFIX__DETAIL.equals(poped)) {
            Object jointchanneldata = customParams.get("jointchanneldata");
            if (jointchanneldata == null) {
                jointchanneldata = SystemJointChannelHelper.getDefaultJointChannelId();
            }
            this.getView().getPageCache().put("jointchanneldata", String.valueOf(jointchanneldata));
            this.allotDynamicData(Boolean.FALSE);
            this.getPageCache().put(cacheKey, SUFFIX__DETAIL);
        }
        this.getModel().setDataChanged(false);
    }

    protected PluginExtendHelper getPluginExtendHelper(PurBatchReceiveContext context) {
        if (this.pluginExtendHelper == null) {
            this.pluginExtendHelper = new PluginExtendHelper(context);
        }
        return this.pluginExtendHelper;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        IFormView view;
        EntryGrid grid;
        DynamicObject[] datas;
        String itemKey = evt.getItemKey();
        if (ACTION_REJECTED.equals(itemKey)) {
            this.checkIsRejected(evt);
        }
        if (null == (datas = (grid = (EntryGrid)(view = this.getView()).getControl(DETAIL_ENTRY_ENTITY)).getEntryData().getDataEntitys()) || datas.length == 0) {
            return;
        }
        if ("baritemap1".equals(itemKey) || "bartocqreceipt".equals(itemKey) || "bar_to_inware".equals(itemKey) || "bar_to_cq_instock".equals(itemKey)) {
            if (!this.receiveCheckIsGoodsBizTypeOnly(itemKey, datas)) {
                evt.setCancel(true);
                return;
            }
            if (!this.checkIsOmBizTypeOnly(itemKey, datas)) {
                evt.setCancel(true);
                return;
            }
            if (!this.checkIsCpOmBizTypeOnly(itemKey, datas) && ("bar_to_inware".equals(itemKey) || "bar_to_cq_instock".equals(itemKey))) {
                evt.setCancel(true);
                return;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (key.isEmpty()) {
            return;
        }
        IFormView view = this.getView();
        switch (key) {
            case "queryfilter": {
                this.openQueryFilterPage();
                break;
            }
            case "goto_receive": {
                HashMap param = new HashMap();
                ListShowParameter listpar = new ListShowParameter();
                listpar.setBillFormId("pur_receipt");
                listpar.setCustomParams(param);
                listpar.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                view.showForm((FormShowParameter)listpar);
                break;
            }
            case "to_receive": {
                String sourceentityname = ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355", (String)"PurBatchReceiveEditPlugin_25", (String)"scm-pur-formplugin", (Object[])new Object[0]);
                String targetentityName = ResManager.loadKDString((String)"\u91c7\u8d2d\u6536\u8d27\u5355", (String)"PurBatchReceiveEditPlugin_26", (String)"scm-pur-formplugin", (Object[])new Object[0]);
                this.doReceiveAndInware(args, "order", "receive", sourceentityname, targetentityName, ACTION_BOTPLIST);
                break;
            }
            case "to_inware": {
                String sourceentityname = ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355", (String)"PurBatchReceiveEditPlugin_25", (String)"scm-pur-formplugin", (Object[])new Object[0]);
                String targetentityName = ResManager.loadKDString((String)"\u91c7\u8d2d\u5165\u5e93\u5355", (String)"PurBatchReceiveEditPlugin_27", (String)"scm-pur-formplugin", (Object[])new Object[0]);
                this.doReceiveAndInware(args, "order", "inware", sourceentityname, targetentityName, ACTION_BOTPLIST);
                break;
            }
            case "to_cq_receive": {
                this.doReceiveAndInware(args, "pm_purorderbill", "im_purreceivebill", null, null, "tocqreceipt");
                break;
            }
            case "to_cq_instock": {
                this.doReceiveAndInware(args, "pm_purorderbill", "im_purinbill", null, null, "tocqinstock");
                break;
            }
            case "batchfillentry": {
                this.valideBatchFillPro(args);
                break;
            }
            case "wechat": {
                this.weChat();
                break;
            }
        }
    }

    private void doReceiveAndInware(BeforeDoOperationEventArgs e, String sourceEntity, String targetEntity, String sourceentityname, String targetEntityName, String callback) {
        boolean isCpOmBizTypeOrder;
        boolean isOmBizTypeOrder;
        boolean isEntryZero = false;
        if (this.checkMaterialEnableshelflife()) {
            e.setCancel(true);
            return;
        }
        if (!this.checkPartRej()) {
            e.setCancel(true);
            return;
        }
        List<DynamicObject> entryList = this.getSelectedData(DETAIL_ENTRY_ENTITY);
        boolean bl = isEntryZero = entryList == null || entryList.size() <= 0;
        if (isEntryZero) {
            this.writePartRejData(null, null);
            e.setCancel(true);
            return;
        }
        boolean isGoodsBizTypeOrder = this.checkIsGoodsBizTypeOrder();
        if (isGoodsBizTypeOrder) {
            sourceEntity = "pur_order";
            targetEntity = "pur_receipt";
            sourceentityname = ResManager.loadKDString((String)"\u534f\u540c\u91c7\u8d2d\u8ba2\u5355", (String)"PurBatchReceiveEditPlugin_31", (String)"scm-pur-formplugin", (Object[])new Object[0]);
            targetEntityName = ResManager.loadKDString((String)"\u91c7\u8d2d\u6536\u8d27\u5355", (String)"PurBatchReceiveEditPlugin_26", (String)"scm-pur-formplugin", (Object[])new Object[0]);
            callback = ACTION_BOTPLIST;
        }
        if (isOmBizTypeOrder = this.checkIsPmOmBussinessType()) {
            if ("tocqinstock".equals(callback)) {
                sourceEntity = "pm_om_purorderbill";
                targetEntity = "im_mdc_omcmplinbill";
            } else if ("tocqreceipt".equals(callback)) {
                sourceEntity = "pm_om_purorderbill";
                targetEntity = "im_purreceivebill";
            }
        }
        if ((isCpOmBizTypeOrder = this.checkIsCpOmBussinessType()) && "tocqinstock".equals(callback)) {
            sourceEntity = "pm_purorderbill";
            targetEntity = "im_mdc_omcmplinbill";
        }
        this.openBotpListPage(sourceEntity, targetEntity, sourceentityname, targetEntityName, entryList, callback);
    }

    private void openBotpListPage(String sourceEntity, String targetEntity, String sourceentityname, String targetentityname, List<DynamicObject> entryList, String callback) {
        boolean isGoodsBizTypeOrder = this.checkIsGoodsBizTypeOrder();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("pbd_common_botp");
        formShowParameter.setCustomParam("sourceentity", (Object)sourceEntity);
        String jointchanneldata = this.getView().getPageCache().get("jointchanneldata");
        formShowParameter.setCustomParam("jointchanneldata", (Object)jointchanneldata);
        formShowParameter.setCustomParam("sourceentity", (Object)sourceEntity);
        formShowParameter.setCustomParam("targetentity", (Object)targetEntity);
        formShowParameter.setCustomParam("sourceentityname", (Object)sourceentityname);
        formShowParameter.setCustomParam("targetentityname", (Object)targetentityname);
        ArrayList<String> element = new ArrayList<String>();
        element.add("replenishtype");
        formShowParameter.setCustomParam("invisible", element);
        Map<String, Object> billInfoMap = this.getBillIdInfo(entryList);
        if (isGoodsBizTypeOrder) {
            billInfoMap.put("isGoodsBizType", "true");
        }
        formShowParameter.setCustomParam("customParams", billInfoMap);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callback));
        this.getView().showForm(formShowParameter);
    }

    public void checkIsRejected(BeforeItemClickEvent evt) {
        IFormView view = this.getView();
        EntryGrid grid = (EntryGrid)view.getControl(HEAD_ENTRY_ENTITY);
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length > 1) {
            evt.setCancel(true);
            this.getView().showMessage(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u62d2\u6536\u4e00\u5f20\u53d1\u8d27\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PurBatchReceiveEditPlugin_1", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        } else if (selectRows.length == 1) {
            int currentIndex;
            IDataModel entryOperate = this.getModel();
            DynamicObject dyn = entryOperate.getEntryRowEntity(HEAD_ENTRY_ENTITY, currentIndex = entryOperate.getEntryCurrentRowIndex(HEAD_ENTRY_ENTITY));
            boolean isreject = this.isRejected(dyn);
            if (!isreject) {
                evt.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u53d1\u8d27\u5355\u5df2\u6536\u8d27\u6216\u5df2\u5165\u5e93\uff0c\u4e0d\u5141\u8bb8\u62d2\u6536\u3002", (String)"PurBatchReceiveEditPlugin_2", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            }
        } else if (selectRows.length == 0) {
            evt.setCancel(true);
            view.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u6570\u636e\u624d\u80fd\u4e0b\u63a8\u3002", (String)"PurBatchReceiveEditPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    public boolean isRejected(DynamicObject dyn) {
        boolean isreject = true;
        String billno = dyn.getString("billno");
        QFilter prodfilter = new QFilter("billno", "=", (Object)billno);
        DynamicObject[] prodArray = BusinessDataServiceHelper.load((String)"pur_saloutstock", (String)"billno,number,materialentry.suminstockqty,materialentry.sumreceiptqty", (QFilter[])new QFilter[]{prodfilter});
        if (prodArray.length > 0) {
            DynamicObjectCollection entryCol = prodArray[0].getDynamicObjectCollection("materialentry");
            DynamicObject entry = null;
            for (int i = 0; i < entryCol.size(); ++i) {
                entry = (DynamicObject)entryCol.get(i);
                if (entry.getBigDecimal("suminstockqty").compareTo(BigDecimal.ZERO) == 0 && entry.getBigDecimal("sumreceiptqty").compareTo(BigDecimal.ZERO) == 0) continue;
                isreject = false;
                break;
            }
        }
        return isreject;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "barrefresh": {
                this.getPageCache().remove("supplier");
                this.allotDynamicData(Boolean.FALSE);
                break;
            }
            case "rejected": {
                this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"pur_rejectreson", new HashMap(), (CloseCallBack)new CloseCallBack((IFormPlugin)this, ACTION_REJECTED), (ShowType)ShowType.Modal));
            }
        }
    }

    protected void weChat() {
        int currentIndex;
        IDataModel entryOperate = this.getModel();
        DynamicObject supplier = (DynamicObject)entryOperate.getEntryRowEntity(HEAD_ENTRY_ENTITY, currentIndex = entryOperate.getEntryCurrentRowIndex(HEAD_ENTRY_ENTITY)).get("supplier");
        Map resultMap = SupplierChatEngineUtil.createSupplierChat((DynamicObject)supplier);
        if ("true".equals(resultMap.get("succed"))) {
            YzjContextMenuClickPlugin yzj = new YzjContextMenuClickPlugin();
            yzj.setView(this.getView());
            HashMap mData = new HashMap();
            mData.put("openId", resultMap.get("data"));
            mData.put("userName", "");
            mData.put("chattype", "chat_pc");
            yzj.yzjInterface("createAndChat", mData);
        } else {
            this.getView().showMessage(resultMap.get("message").toString());
        }
    }

    private void valideBatchFillPro(BeforeDoOperationEventArgs evt) {
        EntryGrid grid = (EntryGrid)this.getControl(DETAIL_ENTRY_ENTITY);
        String fieldKey = grid.getEntryState().getFocusField();
        boolean isValide = false;
        for (String pro : NEED_BATCH_FILL_PRO) {
            if (!fieldKey.equals(pro)) continue;
            isValide = true;
            break;
        }
        if (!isValide) {
            DynamicProperty pro = (DynamicProperty)this.getModel().getDataEntityType().findProperty(fieldKey);
            if (null != pro) {
                this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u6b64\u5217\u201c{0}\u201d\u4e0d\u652f\u6301\u6279\u91cf\u586b\u5145,\u53ea\u652f\u6301\u586b\u5145\u201c\u6536\u8d27\u6570\u91cf\u201d\u3001\u201c\u4ed3\u5e93\u201d\u3001\u201c\u5e93\u4f4d\u201d\u3001\u201c\u6279\u53f7\u201d\u3002", (String)"PurBatchReceiveEditPlugin_35", (String)"scm-pur-formplugin", (Object[])new Object[0]), pro.getDisplayName().toString()));
            } else if (!StringUtils.isBlank((String)fieldKey)) {
                this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u6b64\u5217\u201c{0}\u201d\u4e0d\u652f\u6301\u6279\u91cf\u586b\u5145,\u53ea\u652f\u6301\u586b\u5145\u201c\u6536\u8d27\u6570\u91cf\u201d\u3001\u201c\u4ed3\u5e93\u201d\u3001\u201c\u5e93\u4f4d\u201d\u3001\u201c\u6279\u53f7\u201d\u3002", (String)"PurBatchReceiveEditPlugin_35", (String)"scm-pur-formplugin", (Object[])new Object[0]), fieldKey));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5217,\u53ea\u652f\u6301\u586b\u5145\u201c\u6536\u8d27\u6570\u91cf\u201d\u3001\u201c\u4ed3\u5e93\u201d\u3001\u201c\u5e93\u4f4d\u201d\u3001\u201c\u6279\u53f7\u201d\u3002", (String)"PurBatchReceiveEditPlugin_28", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            }
            evt.setCancel(true);
        } else {
            BatchFillEntryHelper.batchFillRow(this.getView(), DETAIL_ENTRY_ENTITY);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        final IDataModel dataModel = this.getModel();
        final IFormView formView = this.getView();
        this.addItemClickListeners(new String[]{"tbmain"});
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        if (treeView != null) {
            treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
        BasedataEdit warehouse1 = (BasedataEdit)this.getControl("warehouse1");
        warehouse1.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                Object org;
                int row = beforeF7SelectEvent.getRow();
                DynamicObject rowEntity = dataModel.getEntryRowEntity(PurBatchReceiveEditPlugin.DETAIL_ENTRY_ENTITY, row);
                if (null != rowEntity && null != (org = rowEntity.get("org1"))) {
                    ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    if (org instanceof DynamicObject) {
                        formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("createorg", "=", ((DynamicObject)org).getPkValue()));
                    } else {
                        beforeF7SelectEvent.setCancel(true);
                        formView.showMessage(ResManager.loadKDString((String)"\u5355\u636e\u65e0\u6536\u8d27\u65b9\u4e0d\u80fd\u6dfb\u52a0\u4ed3\u5e93\u3002", (String)"PurBatchReceiveEditPlugin_6", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    }
                }
            }
        });
        BasedataEdit location1 = (BasedataEdit)this.getControl("location1");
        location1.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                int row = beforeF7SelectEvent.getRow();
                DynamicObject rowEntity = dataModel.getEntryRowEntity(PurBatchReceiveEditPlugin.DETAIL_ENTRY_ENTITY, row);
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                Object warehouse = rowEntity.get("warehouse1");
                if (!(warehouse instanceof DynamicObject)) {
                    beforeF7SelectEvent.setCancel(true);
                    formView.showMessage(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u4ed3\u5e93", (String)"PurBatchReceiveEditPlugin_7", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    return;
                }
                QFilter destFilter = new QFilter("id", "=", ((DynamicObject)warehouse).getPkValue());
                DynamicObject[] destArray = BusinessDataServiceHelper.load((String)"bd_warehouse", (String)"id,name,number,entryentity.id,entryentity.location", (QFilter[])new QFilter[]{destFilter});
                HashSet<Long> idSet = new HashSet<Long>();
                if (destArray.length > 0) {
                    for (int i = 0; i < destArray.length; ++i) {
                        DynamicObjectCollection entry = destArray[i].getDynamicObjectCollection("entryentity");
                        for (int j = 0; j < entry.size(); ++j) {
                            DynamicObject location = ((DynamicObject)entry.get(j)).getDynamicObject("location");
                            if (null == location) continue;
                            idSet.add(location.getLong("id"));
                        }
                    }
                }
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", idSet));
            }
        });
        EntryGrid headGrid = (EntryGrid)this.getView().getControl(HEAD_ENTRY_ENTITY);
        headGrid.addRowClickListener((RowClickEventListener)this);
        headGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid detailGrid = (EntryGrid)this.getView().getControl(DETAIL_ENTRY_ENTITY);
        detailGrid.addHyperClickListener((HyperLinkClickListener)this);
        detailGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        boolean isGoodsBizTypeOrder = this.checkIsGoodsBizTypeOrder();
        switch (closedCallBackEvent.getActionId()) {
            case "queryfilter": {
                if (returnData == null) {
                    return;
                }
                IPageCache cache = this.getPageCache();
                Map map = returnData instanceof Map ? (Map)returnData : new HashMap();
                for (Map.Entry entry : map.entrySet()) {
                    cache.put((String)entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
                }
                this.allotDynamicData(Boolean.FALSE);
                this.getPageCache().remove("supplier");
                this.getView().updateView();
                break;
            }
            case "botpList": {
                Map result = (Map)returnData;
                if (returnData == null || CollectionUtils.isEmpty((Map)result)) break;
                Object botpDataObject = result.get("botpdata");
                Object targetEntityObject = result.get("targetentity");
                if (botpDataObject == null || targetEntityObject == null) break;
                String botpData = botpDataObject.toString();
                String targetEntity = targetEntityObject.toString();
                if ("inware".equals(targetEntityObject)) {
                    this.toInware(String.valueOf(botpData));
                    break;
                }
                if ("receive".equals(targetEntityObject)) {
                    this.toRecive(botpData);
                    break;
                }
                if (!"pur_receipt".equals(targetEntityObject) || !isGoodsBizTypeOrder) break;
                this.goodsBizTypeOrderPushReceipt();
                break;
            }
            case "tocqreceipt": {
                if (isGoodsBizTypeOrder) {
                    this.goodsBizTypeOrderPushReceipt();
                    break;
                }
            }
            case "tocqinstock": {
                Map result = (Map)returnData;
                if (returnData == null || CollectionUtils.isEmpty((Map)result)) break;
                Object botpDataObject = result.get("botpdata");
                Object sourceEntityObject = result.get("sourceentity");
                Object targetEntityObject = result.get("targetentity");
                if (botpDataObject == null || targetEntityObject == null) break;
                String appId = null;
                String botpData = botpDataObject.toString();
                String sourceentity = sourceEntityObject.toString();
                String targetEntity = targetEntityObject.toString();
                PurBatchReceiveContext context = new PurBatchReceiveContext();
                PluginExtendHelper.calculateScore(IBatchReceiveGetXHTransferProperty.class.getSimpleName(), context);
                Map<String, String> transferPropertyMap = context.getTransferPropertyMap();
                HashMap<String, String> customParam = new HashMap<String, String>(1);
                customParam.put("keyField", "billid1");
                customParam.put("billNoField", "billno1");
                customParam.put("transferPropertyMap", JSON.toJSONString(transferPropertyMap));
                customParam.put("sourceEntity", sourceentity);
                customParam.put("targetEntity", targetEntity);
                customParam.put("botpNumber", botpData);
                MultiDataHandleResult executeManualSceneHandle = new MultiDataHandleResult();
                if ("im_purinbill".equals(targetEntity)) {
                    appId = "pm";
                    executeManualSceneHandle = ScMultiDataHandleServiceHelper.executeManualSceneHandle((String)"manualtoinbill", this.getSelectedData(DETAIL_ENTRY_ENTITY), (String)"billid1", (String)"jointdatachannelid1", customParam);
                } else if ("im_purreceivebill".equals(targetEntity)) {
                    appId = "pm";
                    executeManualSceneHandle = "pm_om_purorderbill".equals(sourceentity) ? ScMultiDataHandleServiceHelper.executeManualSceneHandle((String)"manualtoreceivebypmom", this.getSelectedData(DETAIL_ENTRY_ENTITY), (String)"billid1", (String)"jointdatachannelid1", customParam) : ScMultiDataHandleServiceHelper.executeManualSceneHandle((String)"manualtoreceive", this.getSelectedData(DETAIL_ENTRY_ENTITY), (String)"billid1", (String)"jointdatachannelid1", customParam);
                } else if ("im_mdc_omcmplinbill".equals(targetEntity)) {
                    appId = "im";
                    executeManualSceneHandle = ScMultiDataHandleServiceHelper.executeManualSceneHandle((String)"manualtoinbillbyom", this.getSelectedData(DETAIL_ENTRY_ENTITY), (String)"billid1", (String)"jointdatachannelid1", customParam);
                }
                String message = executeManualSceneHandle.getMessage();
                Map resultMap = null;
                if (!executeManualSceneHandle.isSuccess()) {
                    this.getView().showMessage(executeManualSceneHandle.getExceptionMessage());
                    break;
                }
                if (!StringUtils.isBlank((String)message)) {
                    try {
                        resultMap = (Map)SerializationUtils.fromJsonString((String)message, Map.class);
                    }
                    catch (Exception e) {
                        log.warn((Throwable)e);
                    }
                }
                if (resultMap == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u53d1\u751f\u4e86\u610f\u6599\u4e4b\u5916\u7684\u5f02\u5e38\u3002", (String)"PurBatchReceiveEditPlugin_40", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    break;
                }
                Object resObj = resultMap.get("succed");
                if (resObj != null && ((Boolean)resObj).booleanValue()) {
                    List pkIds = (List)resultMap.get("data");
                    HashMap<String, String> inOrRecNoMap = this.queryInwareOrReciveNo("pur_saloutstock", pkIds, null, true, targetEntity);
                    this.writePartRejData(inOrRecNoMap, null);
                    if (pkIds != null && !pkIds.isEmpty() && pkIds.size() == 1) {
                        BillShowParameter billShowParameter = new BillShowParameter();
                        billShowParameter.setFormId(targetEntity);
                        billShowParameter.setBillStatus(BillOperationStatus.EDIT);
                        billShowParameter.setPkId(pkIds.get(0));
                        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                        billShowParameter.setAppId(appId);
                        this.getView().showForm((FormShowParameter)billShowParameter);
                    } else if (pkIds != null && !pkIds.isEmpty() && pkIds.size() > 1) {
                        ListShowParameter listShowParameter = new ListShowParameter();
                        listShowParameter.setBillFormId(targetEntity);
                        listShowParameter.setFormId("bos_list");
                        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                        listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)pkIds));
                        listShowParameter.setAppId(appId);
                        this.getView().showForm((FormShowParameter)listShowParameter);
                    }
                    this.allotDynamicData(Boolean.FALSE);
                    break;
                }
                if (resObj == null) break;
                this.getView().showMessage(resultMap.get("message").toString());
                break;
            }
            case "rejected": {
                this.updateResonToPurSalout(closedCallBackEvent);
                break;
            }
        }
    }

    public void toInware(String botpNumber) {
        this.toReciveOrInware(botpNumber, TO_INWARE, "inware", "pur_outstock", "pur_instock");
    }

    public void toRecive(String botpNumber) {
        this.toReciveOrInware(botpNumber, TO_RECEIVE, "receive", "pur_outstock", "pur_receipt");
    }

    private void updateResonToPurSalout(ClosedCallBackEvent closedCallBackEvent) {
        if (null != closedCallBackEvent.getReturnData()) {
            String reason = String.valueOf(closedCallBackEvent.getReturnData());
            this.writePartRejData(null, reason);
        }
    }

    private HashMap<String, String> queryInwareOrReciveNo(String entityNumber, List<Object> pkIds, Map<String, Object> retMap, boolean isCQ, String targetEntity) {
        HashMap<String, String> billNoMap = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)targetEntity)) {
            return null;
        }
        if (isCQ) {
            if (null != pkIds && pkIds.size() > 0 && StringUtils.isNotEmpty((String)entityNumber)) {
                QFilter qFilter = new QFilter("id", "in", pkIds);
                DynamicObjectCollection colObj = QueryServiceHelper.query((String)targetEntity, (String)"id,billno, billentry.mainbillentryid entryid,billentry.srcsysbillentryid saloutentryid", (QFilter[])new QFilter[]{qFilter});
                if (null == colObj || colObj.size() == 0) {
                    return null;
                }
                for (DynamicObject obj : colObj) {
                    String saloutEntryId = obj.getString("saloutentryid");
                    if (StringUtils.isNotEmpty((String)saloutEntryId)) {
                        billNoMap.put(saloutEntryId, obj.getString("billno"));
                        continue;
                    }
                    billNoMap.put(obj.getString("entryid"), obj.getString("billno"));
                }
            }
        } else if (null != retMap && retMap.size() > 0) {
            retMap.forEach((k, v) -> {
                Map tempMap;
                String errorMsg;
                if (null != v && StringUtils.isEmpty((String)(errorMsg = String.valueOf((tempMap = (Map)v).get("error"))))) {
                    billNoMap.put((String)k, tempMap.get("billnumber").toString());
                }
            });
        }
        return billNoMap;
    }

    public boolean checkPartRej() {
        IFormView view = this.getView();
        EntryGrid grid = (EntryGrid)view.getControl(DETAIL_ENTRY_ENTITY);
        DynamicObject[] datas = grid.getEntryData().getDataEntitys();
        if (null == datas || datas.length == 0) {
            return true;
        }
        StringBuilder sBuilder = new StringBuilder();
        boolean allEmptyFlag = true;
        for (int i = 0; i < datas.length; ++i) {
            DynamicObject tempObject = datas[i];
            BigDecimal rejQty = tempObject.getBigDecimal("newrejqty1");
            BigDecimal receiveQty = tempObject.getBigDecimal("receiveqty1");
            Object reasonObj = tempObject.get("rejreason1");
            rejQty = null == rejQty ? BigDecimal.ZERO : rejQty;
            BigDecimal bigDecimal = receiveQty = null == receiveQty ? BigDecimal.ZERO : receiveQty;
            if (rejQty.compareTo(BigDecimal.ZERO) > 0 && (null == reasonObj || StringUtils.isEmpty((String)reasonObj.toString()))) {
                sBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7b2c{0}\u884c\u4e0d\u5408\u683c\u539f\u56e0\u3002", (String)"PurBatchReceiveEditPlugin_9", (String)"scm-pur-formplugin", (Object[])new Object[0]), String.valueOf(i + 1)));
                sBuilder.append(System.lineSeparator());
            }
            if (rejQty.compareTo(BigDecimal.ZERO) == 0 && receiveQty.compareTo(BigDecimal.ZERO) == 0) continue;
            allEmptyFlag = false;
        }
        if (allEmptyFlag) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6570\u91cf\u4fe1\u606f\u3002", (String)"PurBatchReceiveEditPlugin_10", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            return false;
        }
        String msg = sBuilder.toString();
        if (!StringUtils.isEmpty((String)msg)) {
            this.getView().showMessage(msg);
            return false;
        }
        return true;
    }

    public void writePartRejData(HashMap<String, String> inOrRecBillNoMap, String wholeRejReason) {
        IDataModel model = this.getModel();
        List<DynamicObject> entryCols = this.getSelectedData(DETAIL_ENTRY_ENTITY);
        if (null == entryCols || entryCols.isEmpty()) {
            return;
        }
        HashMap rejDataMap = new HashMap();
        ArrayList<String> poOrderIdList = new ArrayList<String>();
        ArrayList<Long> saloutIdList = new ArrayList<Long>();
        HashMap<String, Object> detailDataMap = null;
        boolean onlyRejFlag = true;
        for (int i = 0; i < entryCols.size(); ++i) {
            String poEntryIdStr;
            BigDecimal rejQtyDecimal;
            DynamicObject obj = entryCols.get(i);
            if (null == obj) continue;
            if (null != inOrRecBillNoMap && !inOrRecBillNoMap.isEmpty()) {
                onlyRejFlag = false;
            }
            Object rejQty = obj.get("newrejqty1");
            Object revQtyObj = obj.get("qty1");
            String rejReason = obj.getString("rejreason1");
            if (!StringUtils.isEmpty((String)wholeRejReason)) {
                rejReason = wholeRejReason;
                rejQty = revQtyObj;
            }
            if (null == rejQty || (rejQtyDecimal = new BigDecimal(rejQty.toString())).compareTo(BigDecimal.ZERO) <= 0 || !StringUtils.isEmpty((String)obj.getString("reason1"))) continue;
            detailDataMap = new HashMap<String, Object>();
            String orderNoStr = obj.getString("pobillno1");
            saloutIdList.add(obj.getLong("billid1"));
            String poEntryId = obj.getString("poentryid1");
            Object materialObj = obj.get("material1");
            String entryId = obj.getString("entryid1");
            Object unitObj = obj.get("unit1");
            String orderId = obj.getString("pobillid1");
            poOrderIdList.add(poEntryId);
            String inOrRecBillNo = null;
            String saloutEntryId = null == entryId ? "" : entryId.toString();
            String string = poEntryIdStr = null == poEntryId ? "" : poEntryId.toString();
            if (null != inOrRecBillNoMap && !inOrRecBillNoMap.isEmpty() && null != entryId && StringUtils.isEmpty((String)(inOrRecBillNo = inOrRecBillNoMap.get(entryId.toString())))) {
                inOrRecBillNo = inOrRecBillNoMap.get(poEntryIdStr);
            }
            detailDataMap.put("pobillno_rej", orderNoStr);
            detailDataMap.put("inbillno_rej", inOrRecBillNo);
            detailDataMap.put("materialid_rej", materialObj);
            detailDataMap.put("rejdate_rej", TimeServiceHelper.now());
            detailDataMap.put("rejectqty_rej", rejQtyDecimal);
            detailDataMap.put("rejectreason_rej", rejReason);
            detailDataMap.put("poentryid_rej", poEntryId);
            detailDataMap.put("pobillid_rej", orderId);
            detailDataMap.put("unitid_rej", unitObj);
            if (!StringUtils.isEmpty((String)saloutEntryId)) {
                rejDataMap.put(saloutEntryId, detailDataMap);
            } else if (!StringUtils.isEmpty((String)poEntryIdStr)) {
                rejDataMap.put(poEntryIdStr, detailDataMap);
            }
            model.setValue("newrejqty1", (Object)BigDecimal.ZERO, i);
            model.setValue("rejreason1", (Object)"", i);
        }
        WriteBackUtil.partRejWriteBack(poOrderIdList, saloutIdList, rejDataMap, null, (String)"add");
        if (!StringUtils.isEmpty((String)wholeRejReason) || onlyRejFlag) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"PurBatchReceiveEditPlugin_11", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            this.getPageCache().remove("supplier");
            this.allotDynamicData(Boolean.FALSE);
        }
    }

    public void toReciveOrInware(String botpNumber, String action, String tobilltype, String billtype, String targetEntity) {
        this.setButtonEnableStatus("baritemap1", false);
        Map batchExtEntryPro = PurBatchStockHelper.assembleBatchExtEntryPro();
        Map<String, Object> billInfoMap = this.getBillInfo(batchExtEntryPro);
        if (billInfoMap.size() > 0) {
            if (ApiConfigUtil.hasEASScmConfig()) {
                ScmcUtil.putSplitStrategyMap(billInfoMap);
            }
            billInfoMap.put("billstatus1", this.getParamByrecOrg("recbillstatus"));
            billInfoMap.put("billstatus", ParamUtil.getParam((String)"eae607fb000143ac", (String)"recbillstatus"));
            billInfoMap.put("botpNumber", botpNumber);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("tobilltype", tobilltype);
            param.put("billtype", billtype);
            param.put("data", billInfoMap);
            param.put("action", action);
            param.put("code", "200");
            ApiUtil.putUserNUmberData(param, (String)"scp_saloutstock");
            log.info(((Object)param).toString());
            String msg = null;
            msg = TO_INWARE.equals(action) ? ApiUtil.purSaloutToInware(param) : ApiUtil.purSaloutToRec(param);
            Map<String, Object> map = this.handleResult(msg);
            HashMap<String, String> inOrRecNoMap = this.queryInwareOrReciveNo("pur_saloutstock", null, map, false, targetEntity);
            this.writePartRejData(inOrRecNoMap, null);
        }
        this.setButtonEnableStatus("baritemap1", true);
    }

    private void setButtonEnableStatus(String btnKey, boolean isEnable) {
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{btnKey});
    }

    public Map<String, Object> getBillIdInfo(List<DynamicObject> entryList) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        if (entryList.size() == 0) {
            return dataMap;
        }
        HashSet<String> entryIdSet = new HashSet<String>();
        HashSet<String> billIdSet = new HashSet<String>();
        for (DynamicObject entry : entryList) {
            String srcEntryId = String.valueOf(entry.get("poentryid1"));
            if (!StringUtils.isNotEmpty((String)srcEntryId)) continue;
            entryIdSet.add(srcEntryId);
            String billId = String.valueOf(entry.get("pobillid1"));
            billIdSet.add(billId);
        }
        dataMap.put("billId", billIdSet);
        dataMap.put("entryId", entryIdSet);
        return dataMap;
    }

    public Map<String, Object> getBillIdInfo() {
        List<DynamicObject> entryList = this.getSelectedData(DETAIL_ENTRY_ENTITY);
        return this.getBillIdInfo(entryList);
    }

    @Deprecated
    public boolean isAllEntryIsZero() {
        List<DynamicObject> entryList = this.getSelectedData(DETAIL_ENTRY_ENTITY);
        return entryList == null || entryList.size() <= 0;
    }

    public Map getParamByrecOrg(String billtype) {
        IFormView view = this.getView();
        EntryGrid grid = (EntryGrid)view.getControl(HEAD_ENTRY_ENTITY);
        int[] selectRows = grid.getSelectRows();
        HashSet<String> recOrgIdSet = new HashSet<String>(1024);
        HashMap<String, String> org_IdMap = new HashMap<String, String>(1024);
        DynamicObject orgDyn = null;
        IDataModel model = this.getModel();
        DynamicObjectCollection headCols = model.getEntryEntity(HEAD_ENTRY_ENTITY);
        DynamicObject dyn = null;
        for (int index : selectRows) {
            dyn = (DynamicObject)headCols.get(index);
            orgDyn = dyn.getDynamicObject("org");
            recOrgIdSet.add(orgDyn.getString("id"));
            org_IdMap.put(orgDyn.getString("number"), orgDyn.getString("id"));
        }
        Map paramMap = ParamUtil.getParam((String)"eae607fb000143ac", (String)billtype, recOrgIdSet);
        for (Map.Entry map : org_IdMap.entrySet()) {
            org_IdMap.put((String)map.getKey(), (String)paramMap.get(map.getValue()));
        }
        return org_IdMap;
    }

    public Map<String, Object> getBillInfo(Map<String, String> batchExtEntryPro) {
        List<DynamicObject> entryList = this.getSelectedData(DETAIL_ENTRY_ENTITY);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        for (DynamicObject entry : entryList) {
            HashMap<String, Object> detailMap = new HashMap<String, Object>();
            Object srcEntryId = entry.get("poentryid1");
            if (srcEntryId == null || srcEntryId.toString().trim().isEmpty()) continue;
            PurBatchReceiveContext context = new PurBatchReceiveContext();
            PluginExtendHelper.calculateScore(IBatchReceiveGetEASTransferProperty.class.getSimpleName(), context);
            Map<String, String> transferPropertyMap = context.getTransferPropertyMap();
            for (Map.Entry<String, String> row : transferPropertyMap.entrySet()) {
                Object val = entry.get(row.getKey() + SUFFIX__DETAIL);
                String property = row.getValue();
                if (null == val) {
                    detailMap.put(property, "");
                    continue;
                }
                if (val instanceof DynamicObject) {
                    Object number = DynamicObjectUtil.getBDNumberOfValue((DynamicObject)((DynamicObject)val));
                    detailMap.put(property, number);
                    continue;
                }
                detailMap.put(property, val);
            }
            BigDecimal recieveQty = CommonUtil.getBigDecimalPro((Object)entry.get(RECEIVEQTY + SUFFIX__DETAIL));
            String entryIdStr = entry.getString("entryid1");
            String billIdStr = entry.getString("billid1");
            String billNoStr = entry.getString("billno1");
            Date proddate = entry.getDate("proddate1");
            Date duedate = entry.getDate("duedate1");
            String lot1 = entry.getString("lot1");
            String suplot1 = entry.getString("suplot1");
            detailMap.put("entryId", srcEntryId);
            detailMap.put("billid", entry.get("pobillid1"));
            detailMap.put("qty", recieveQty);
            detailMap.put("srcEntryId", entryIdStr);
            detailMap.put("srcBillId", billIdStr);
            detailMap.put("srcBillNo", billNoStr);
            detailMap.put("proddate", proddate == null ? "" : DateUtil.date2str((Date)proddate, (String)"yyyy-MM-dd"));
            detailMap.put("mfg", proddate == null ? "" : proddate);
            detailMap.put("duedate", duedate == null ? "" : DateUtil.date2str((Date)duedate, (String)"yyyy-MM-dd"));
            detailMap.put("exp", duedate == null ? "" : duedate);
            detailMap.put("lot", lot1);
            detailMap.put("suplot", suplot1);
            if (ApiConfigUtil.hasEASScmConfig()) {
                detailMap.put("extFieldSet", batchExtEntryPro.values());
            }
            Map assembleExtStockData = PurBatchStockHelper.assembleExtStockData((DynamicObject)entry, batchExtEntryPro);
            detailMap.putAll(assembleExtStockData);
            if (ApiConfigUtil.hasXKScmConfig()) {
                Map batchExtHeadPro;
                Map assembleExtHeadStockData;
                if (!CollectionUtils.isEmpty((Map)assembleExtStockData)) {
                    String assembleExtDataString = this.assembleExtDataString(assembleExtStockData);
                    detailMap.put("EOtherFields", assembleExtDataString);
                }
                if (!CollectionUtils.isEmpty((Map)(assembleExtHeadStockData = PurBatchStockHelper.assembleExtStockData((DynamicObject)entry, (Map)(batchExtHeadPro = PurBatchStockHelper.assembleBatchExtHeadPro()))))) {
                    String assembleExtDataString = this.assembleExtDataString(assembleExtHeadStockData);
                    detailMap.put("HOtherFields", assembleExtDataString);
                }
            }
            dataMap.put(entryIdStr, detailMap);
        }
        return this.groupDataBySrcBillId(dataMap);
    }

    private String assembleExtDataString(Map<String, String> billMap) {
        StringBuilder extDataString = new StringBuilder();
        for (Map.Entry<String, String> entry : billMap.entrySet()) {
            extDataString.append(entry.getKey()).append(":").append(entry.getValue()).append(";");
        }
        return extDataString.toString();
    }

    @Deprecated
    public Map<String, Object> getBillInfo() {
        Map batchExtEntryPro = PurBatchStockHelper.assembleBatchExtEntryPro();
        return this.getBillInfo(batchExtEntryPro);
    }

    public Map<String, Object> groupDataBySrcBillId(Map<String, Object> dataMap) {
        HashMap<String, Object> groupedData = new HashMap<String, Object>();
        if (ApiConfigUtil.hasXKScmConfig() && !dataMap.isEmpty()) {
            Collection<Object> values = dataMap.values();
            List<Object> valueList = new ArrayList<Object>(values);
            int num = 0;
            while (!valueList.isEmpty()) {
                valueList = this.setGroupedData(valueList, groupedData, ++num);
            }
        } else {
            dataMap.forEach((key, val) -> {
                Map data = (Map)val;
                String srcBillId = String.valueOf(data.get("srcBillId"));
                ArrayList<Map> list = (ArrayList<Map>)groupedData.get(srcBillId);
                if (list == null) {
                    list = new ArrayList<Map>();
                }
                list.add(data);
                groupedData.put(srcBillId, list);
            });
        }
        return groupedData;
    }

    private List<Object> setGroupedData(List<Object> values, Map<String, Object> groupedData, int num) {
        ArrayList<Object> unDoData = new ArrayList<Object>();
        for (Object o : values) {
            Map data = (Map)o;
            String srcBillId = String.valueOf(data.get("srcBillId"));
            String entryId = String.valueOf(data.get("entryId"));
            String srcBillIdStr = srcBillId + num;
            ArrayList<Map> list = (ArrayList<Map>)groupedData.get(srcBillIdStr);
            if (list == null) {
                list = new ArrayList<Map>();
                list.add(data);
                groupedData.put(srcBillIdStr, list);
                continue;
            }
            boolean present = list.stream().filter(l -> l.get("entryId").equals(entryId)).findAny().isPresent();
            if (!present) {
                list.add(data);
                groupedData.put(srcBillIdStr, list);
                continue;
            }
            unDoData.add(data);
        }
        return unDoData;
    }

    public List<DynamicObject> getSelectedData(String entryKey) {
        IFormView view = this.getView();
        EntryGrid grid = (EntryGrid)view.getControl(entryKey);
        int[] selectRows = grid.getSelectRows();
        ArrayList<DynamicObject> selectDynaObj = new ArrayList<DynamicObject>();
        if (selectRows == null || selectRows.length == 0) {
            view.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u6570\u636e\u624d\u80fd\u4e0b\u63a8\u3002", (String)"PurBatchReceiveEditPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            return selectDynaObj;
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection entryCols = model.getEntryEntity(entryKey);
        entryCols.forEach(entry -> {
            BigDecimal qty = entry.getBigDecimal(RECEIVEQTY + SUFFIX__DETAIL);
            if (qty.compareTo(BigDecimal.ZERO) > 0) {
                selectDynaObj.add((DynamicObject)entry);
            }
        });
        return ReceiptUtil.getAvailableData(selectDynaObj, (String)SUFFIX__DETAIL);
    }

    public Map<String, Object> handleResult(String msg) {
        if (msg == null) {
            return null;
        }
        try {
            Map map = (Map)JacksonJsonUtil.fromJson((String)msg, Map.class);
            log.info("\u89e3\u6790\u6210\u529f");
            this.dealDataByMsg(map, DETAIL_ENTRY_ENTITY, SUFFIX__DETAIL);
            log.info("\u8be6\u60c5\u89e3\u6790\u6210\u529f");
            this.dealDataByMsg(map, ALL_ENTRY_ENTITY, SUFFIX_ALL);
            log.info("\u6240\u6709\u89e3\u6790\u6210\u529f");
            return map;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e{0}{1}\u3002", (String)"PurBatchReceiveEditPlugin_13", (String)"scm-pur-formplugin", (Object[])new Object[0]), "==>", msg));
        }
    }

    private void dealDataByMsg(Map<String, Object> map, String entryKey, String index) {
        IDataModel model = this.getModel();
        DynamicObjectCollection cols = model.getEntryEntity(entryKey);
        StringBuilder msgSB = new StringBuilder();
        BigDecimal receiveQty = BigDecimal.ZERO;
        BigDecimal restOfReceiveQty = BigDecimal.ZERO;
        BigDecimal rejQty = BigDecimal.ZERO;
        String srcEntryIdStr = null;
        Map restOfQtyMap = (Map)this.restOfReceiveQtyCache.get(this.getView().getPageId(), Map.class);
        Map originReceiveQtyMap = (Map)this.originReceiveQtyCache.get(this.getView().getPageId(), Map.class);
        for (int i = 0; i < cols.size(); ++i) {
            DynamicObject col = (DynamicObject)cols.get(i);
            Long srcEntryId = col.getLong("entryid" + index);
            srcEntryIdStr = String.valueOf(srcEntryId);
            String errorMsg = null;
            Object billNumber = null;
            Object mapObj = map.get(srcEntryIdStr);
            if (mapObj == null) continue;
            Map msgMap = (Map)mapObj;
            errorMsg = String.valueOf(msgMap.get("error"));
            if (errorMsg.isEmpty() || errorMsg.length() == 0) {
                billNumber = msgMap.get("billnumber");
                model.setValue("tobillno" + index, billNumber, i);
            }
            if (TO_RECEIVE.equals(msgMap.get("billtype"))) {
                model.setValue("tobilltype" + index, (Object)ResManager.loadKDString((String)"\u6536\u8d27\u5355", (String)"PurBatchReceiveEditPlugin_14", (String)"scm-pur-formplugin", (Object[])new Object[0]), i);
            } else if (TO_INWARE.equals(msgMap.get("billtype"))) {
                model.setValue("tobilltype" + index, (Object)ResManager.loadKDString((String)"\u5165\u5e93\u5355", (String)"PurBatchReceiveEditPlugin_15", (String)"scm-pur-formplugin", (Object[])new Object[0]), i);
            }
            Object billstatus = msgMap.get("billstatus");
            if (billstatus != null && !billstatus.toString().isEmpty()) {
                model.setValue("tobillstatus" + index, msgMap.get("billstatus"), i);
            }
            if (errorMsg != null && errorMsg.length() != 0) {
                model.setValue("reason" + index, (Object)errorMsg, i);
                if (msgSB.toString().contains(errorMsg)) continue;
                if (billNumber != null && !msgSB.toString().contains(billNumber.toString())) {
                    msgSB.append(billNumber);
                }
                msgSB.append(errorMsg).append(";\n");
                continue;
            }
            model.setValue("reason" + index, null, i);
            receiveQty = col.getBigDecimal(RECEIVEQTY + index);
            if (SUFFIX__DETAIL.equals(index)) {
                rejQty = col.getBigDecimal("newrejqty1");
            }
            if (null == restOfQtyMap) continue;
            restOfReceiveQty = (BigDecimal)restOfQtyMap.get(srcEntryIdStr);
            if (restOfReceiveQty != null && !SUFFIX_ALL.equals(index)) {
                restOfQtyMap.put(srcEntryIdStr, restOfReceiveQty.subtract(receiveQty).subtract(rejQty));
            }
            if (restOfReceiveQty != null) {
                model.setValue(RECEIVEQTY + index, restOfQtyMap.get(srcEntryIdStr), i);
            }
            if (!SUFFIX__DETAIL.equals(index) || null == originReceiveQtyMap || null == originReceiveQtyMap.get(srcEntryIdStr)) continue;
            BigDecimal subtract = ((BigDecimal)originReceiveQtyMap.get(srcEntryIdStr)).subtract(receiveQty).subtract(rejQty);
            originReceiveQtyMap.put(srcEntryIdStr, subtract);
        }
        this.originReceiveQtyCache.put(this.getView().getPageId(), (Object)originReceiveQtyMap);
        this.restOfReceiveQtyCache.put(this.getView().getPageId(), (Object)restOfQtyMap);
        if (SUFFIX_ALL.equals(index)) {
            return;
        }
        IFormView view = this.getView();
        if (msgSB.length() == 0) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u6210\u529f\u3002", (String)"PurBatchReceiveEditPlugin_16", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        } else {
            view.showMessage(ResManager.loadKDString((String)"\u751f\u6210\u5355\u636e\u5931\u8d25\u3002", (String)"PurBatchReceiveEditPlugin_17", (String)"scm-pur-formplugin", (Object[])new Object[0]), msgSB.toString(), MessageTypes.Default);
        }
    }

    private void allotDynamicData(Boolean isGoodsOrderPush) {
        log.info("###batchReceive \u5f00\u59cb\u67e5\u8be2\u6570\u636e");
        IFormView view = this.getView();
        PurBatchReceiveContext context = new PurBatchReceiveContext();
        PluginExtendHelper helper = this.getPluginExtendHelper(context);
        context.setCacheParams(view.getPageCache().getAll());
        context.setIsFirst(this.getPageCache().get(IS_FIRST));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        context.setCustomfilter(customParams.get("customfilter"));
        context.setEnttityKey(this.assembleShowEntryKey());
        this.getPageCache().put(IS_FIRST, SUFFIX__DETAIL);
        PluginExtendHelper.calculateScore(IBatchReceiveGetSelector.class.getSimpleName(), context);
        PluginExtendHelper.calculateScore(IBatchReceiveGetFilter.class.getSimpleName(), context);
        PluginExtendHelper.calculateScore(IBatchReceiveGetData.class.getSimpleName(), context);
        DynamicObject[] dynamicObjects = context.getDynamicObjects();
        dynamicObjects = this.doOtherFilter(dynamicObjects);
        String sourceBill = this.getPageCache().get("sourceBill");
        if ("mal_order".equals(sourceBill)) {
            List purOrderEntryId = (List)customParams.get("purOrderEntryIds");
            dynamicObjects = this.doFromMalOrderJumpFilter(dynamicObjects, purOrderEntryId);
        }
        log.info("###batchReceive \u67e5\u8be2\u6570\u636e\u7ed3\u675f");
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            this.clearData();
            this.bindTreeData(null);
            view.updateView();
            if (!isGoodsOrderPush.booleanValue()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"PurBatchReceiveEditPlugin_18", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        this.clearData();
        if (!SUFFIX__DETAIL.equals(this.getPageCache().get("isTreeNodeClick"))) {
            this.bindTreeData(dynamicObjects);
        }
        log.info("###\u5f00\u59cb\u6784\u9020\u6570\u636e!");
        this.bindEntityData(dynamicObjects, HEAD_ENTRY_ENTITY, "");
        EntryGrid headEntry = (EntryGrid)this.getControl(HEAD_ENTRY_ENTITY);
        headEntry.clearEntryState();
    }

    @Deprecated
    public Map<String, Map<String, Object>> assembleQueryFilterMap() {
        HashMap<String, Map<String, Object>> queryFilterMap = new HashMap<String, Map<String, Object>>();
        return queryFilterMap;
    }

    protected String assembleShowEntryKey() {
        String keyStr;
        Map showParameterMap = this.getView().getFormShowParameter().getShowParameter().getCustomParams();
        if (showParameterMap != null && (keyStr = (String)showParameterMap.get("ENTRY_KEY")) != null) {
            return keyStr;
        }
        return "pur_saloutstock";
    }

    @Deprecated
    public String assembleSelectFilds(String entityKey) {
        String selectFields = "";
        if (entityKey.equals("pur_saloutstock")) {
            selectFields = DynamicObjectUtil.getSelectfields((String)entityKey, (boolean)false);
            selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)entityKey, (String)"materialentry", (boolean)false);
        }
        return selectFields;
    }

    public DynamicObject[] doOtherFilter(DynamicObject[] dynamicObjects) {
        return dynamicObjects;
    }

    private void clearData() {
        IDataModel model = this.getModel();
        model.deleteEntryData(HEAD_ENTRY_ENTITY);
        model.deleteEntryData(DETAIL_ENTRY_ENTITY);
        model.deleteEntryData(SUM_ENTRY_ENTITY);
        model.deleteEntryData(ALL_ENTRY_ENTITY);
    }

    public void bindEntityData(DynamicObject[] dynamicObjects, String entryEntityKey, String index) {
        if (dynamicObjects == null || dynamicObjects.length <= 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        List propertiesentity = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntityEntity(entryEntityKey).getDynamicObjectType());
        int rowCount = 0;
        TableValueSetter vs = new TableValueSetter(new String[0]);
        HashSet<Object> idSet = new HashSet<Object>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (idSet.contains(dynamicObject.get("id"))) continue;
            idSet.add(dynamicObject.get("id"));
            Map objectMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)dynamicObject);
            for (Map.Entry entry : objectMap.entrySet()) {
                if (propertiesentity.contains((String)entry.getKey() + index) && !"id".equals(entry.getKey())) {
                    vs.set((String)entry.getKey() + index, entry.getValue(), rowCount);
                    continue;
                }
                if (!propertiesentity.contains((String)entry.getKey() + index) || !"id".equals(entry.getKey())) continue;
                vs.set("billid" + index, entry.getValue(), rowCount);
            }
            ++rowCount;
        }
        model.batchCreateNewEntryRow(entryEntityKey, vs);
        this.bindDetailEntityData(dynamicObjects, ALL_ENTRY_ENTITY, SUFFIX_ALL);
    }

    protected void bindDetailEntityData(DynamicObject[] dynamicObj, String entryEntityKey, String index) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        List propertiesentity = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntityEntity(entryEntityKey).getDynamicObjectType());
        Map orderAvailableDataMap = PurBatchStockHelper.assembleSalOutStcokData((DynamicObject[])dynamicObj);
        if (dynamicObj == null || dynamicObj.length <= 0) {
            return;
        }
        int rowCount = 0;
        HashSet<Object> entryIdSet = new HashSet<Object>();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        HashMap<String, BigDecimal> restOfQtyMap = new HashMap<String, BigDecimal>();
        for (DynamicObject bill : dynamicObj) {
            DynamicObjectCollection entryDynamicObjects = DynamicObjectUtil.getEntryEntityData((DynamicObject)bill);
            for (DynamicObject entry : entryDynamicObjects) {
                if (entryIdSet.contains(entry.getPkValue())) continue;
                entryIdSet.add(entry.getPkValue());
                Long entryId = entry.getLong("id");
                Map RowMap = (Map)orderAvailableDataMap.get(entryId);
                BigDecimal availableSalQty = BigDecimal.ZERO;
                if (RowMap != null) {
                    availableSalQty = (BigDecimal)RowMap.get("qty");
                }
                BigDecimal totalRejQty = CommonUtil.getBigDecimalPro((Object)entry.get("rejectqty"));
                availableSalQty = availableSalQty.subtract(totalRejQty);
                restOfQtyMap.put(String.valueOf(entry.getPkValue()), availableSalQty);
                if (availableSalQty.compareTo(BigDecimal.ZERO) <= 0 || entry.getString("entrystatus").equals(BillEntryStatusEnum.CLOSED.getVal())) continue;
                Map objectMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)entry);
                for (Map.Entry entryMap : objectMap.entrySet()) {
                    if (propertiesentity.contains((String)entryMap.getKey() + index) && !"id".equals(entryMap.getKey())) {
                        vs.set((String)entryMap.getKey() + index, entryMap.getValue(), rowCount);
                        continue;
                    }
                    if (!propertiesentity.contains((String)entryMap.getKey() + index) || !"id".equals(entryMap.getKey())) continue;
                    vs.set("billid" + index, entryMap.getValue(), rowCount);
                }
                Map billObjectMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)bill);
                for (Map.Entry entryMap : billObjectMap.entrySet()) {
                    if (!propertiesentity.contains((String)entryMap.getKey() + index)) continue;
                    vs.set((String)entryMap.getKey() + index, entryMap.getValue(), rowCount);
                }
                vs.set("entryid" + index, entry.getPkValue(), rowCount);
                vs.set(RECEIVEQTY + index, (Object)availableSalQty, rowCount);
                vs.set("rejqty" + index, (Object)totalRejQty, rowCount);
                vs.set("billno" + index, bill.get("billno"), rowCount);
                vs.set("billid" + index, bill.getPkValue(), rowCount);
                ++rowCount;
            }
        }
        this.restOfReceiveQtyCache.put(this.getView().getPageId(), restOfQtyMap);
        model.batchCreateNewEntryRow(entryEntityKey, vs);
    }

    public void bindTreeData(DynamicObject[] dynamicObjects) {
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        TreeNode rootNode = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"PurBatchReceiveEditPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        treeView.deleteAllNodes();
        treeView.addNode(rootNode);
        treeView.focusNode(rootNode);
        if (dynamicObjects == null || dynamicObjects.length <= 0) {
            return;
        }
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        HashSet<String> nodeIdSet = new HashSet<String>();
        for (DynamicObject obj : dynamicObjects) {
            String supplierPk;
            DynamicObject supplier = obj.getDynamicObject("supplier");
            if (null == supplier || nodeIdSet.contains(supplierPk = String.valueOf(supplier.getPkValue()))) continue;
            nodeIdSet.add(supplierPk);
            TreeNode node = new TreeNode("0", supplierPk, supplier.getString("name"));
            treeNodes.add(node);
        }
        treeView.addNodes(treeNodes);
        treeView.expand("0");
    }

    public void initialize() {
        super.initialize();
    }

    public void hyperLinkClick(HyperLinkClickEvent heperLinkEvent) {
        EntryGrid grid = (EntryGrid)heperLinkEvent.getSource();
        String gridKey = grid.getKey();
        Object val = null;
        String entityKey = null;
        String property = heperLinkEvent.getFieldName();
        if (gridKey.equals(HEAD_ENTRY_ENTITY)) {
            val = grid.getModel().getValue(property);
            if ("billno".equals(property)) {
                entityKey = "pur_saloutstock";
            }
            this.showBillForm(val, entityKey);
        } else if (gridKey.equals(DETAIL_ENTRY_ENTITY)) {
            val = grid.getModel().getValue(property);
            if ("billno1".equals(property)) {
                entityKey = "pur_saloutstock";
            } else if ("pobillno1".equals(property)) {
                entityKey = "pur_order";
            }
            this.showBillForm(val, entityKey);
        }
    }

    public void showBillForm(Object val, String entityKey) {
        if (val == null || entityKey == null || entityKey.isEmpty()) {
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("billno", val);
        DynamicObject dynaObject = ORMUtil.queryOneByPro((String)entityKey, (String)"id,billno", param);
        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)entityKey, (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)((Long)dynaObject.getPkValue()), new HashMap(), null));
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        if (!nodeId.equals("0")) {
            this.getPageCache().put("isTreeNodeClick", SUFFIX__DETAIL);
            this.getPageCache().put("supplier", nodeId.toString());
        } else {
            this.getPageCache().remove("supplier");
        }
        this.allotDynamicData(Boolean.FALSE);
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        treeView.focusNode(new TreeNode("0", evt.getNodeId().toString(), ""));
        this.getPageCache().put("isTreeNodeClick", "0");
        this.getView().updateView();
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid grid = (EntryGrid)evt.getSource();
        IDataModel model = grid.getModel();
        String entryKey = grid.getKey();
        if (HEAD_ENTRY_ENTITY.equals(entryKey)) {
            int[] selectedIndexs = grid.getEntryState().getSelectedRows();
            ArrayList<DynamicObject> selectedRows = new ArrayList<DynamicObject>(selectedIndexs.length);
            DynamicObjectCollection col = model.getEntryEntity(entryKey);
            for (int i = 0; i < selectedIndexs.length; ++i) {
                selectedRows.add((DynamicObject)col.get(selectedIndexs[i]));
            }
            model.deleteEntryData(DETAIL_ENTRY_ENTITY);
            this.addDetailData(selectedRows, DETAIL_ENTRY_ENTITY, SUFFIX__DETAIL);
            this.sumMaterialQty(SUM_ENTRY_ENTITY, SUFFIX_SUM);
        }
    }

    public void addDetailData(List<DynamicObject> selectedRows, String entryKey, String index) {
        this.getModel().beginInit();
        int rowCount = 0;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection allEntryEntityCol = model.getEntryEntity(ALL_ENTRY_ENTITY);
        HashMap<String, BigDecimal> originReceiveQtyMap = new HashMap<String, BigDecimal>();
        List propertiesentity = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntryEntity(entryKey).getDynamicObjectType());
        TableValueSetter vs = new TableValueSetter(new String[0]);
        HashMap<String, String> materialEnableshelflifeMap = new HashMap<String, String>(8);
        for (DynamicObject selectRow : selectedRows) {
            String billId = selectRow.get("billid").toString();
            for (DynamicObject row : allEntryEntityCol) {
                String currBillId = row.get("billid4").toString();
                String entryId = row.get("entryid4").toString();
                if (!billId.equals(currBillId)) continue;
                Map objectMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)row);
                BigDecimal receiveQty = BigDecimal.ZERO;
                for (Map.Entry entry : objectMap.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    String newKey = key.replaceAll(SUFFIX_ALL, SUFFIX__DETAIL);
                    if ("receiveqty1".equals(newKey)) {
                        receiveQty = receiveQty.add(new BigDecimal(value.toString()));
                    }
                    if (propertiesentity.contains(newKey) && !"id".equals(newKey) && !"seq".equals(newKey)) {
                        vs.set(newKey, value, rowCount);
                    }
                    if (!"materialnametext1".equals(newKey) || value != null && !value.equals("")) continue;
                    vs.set(newKey, (Object)row.getString("material4.name"), rowCount);
                }
                this.setMaterialEnableshelflifeMap(row.getString("org4.id"), row.getString("material4.id"), materialEnableshelflifeMap);
                originReceiveQtyMap.put(entryId, receiveQty);
                ++rowCount;
            }
        }
        if (!CollectionUtils.isEmpty(materialEnableshelflifeMap)) {
            this.getPageCache().put("materialEnableshelflifeMap", JSON.toJSONString(materialEnableshelflifeMap));
        }
        this.originReceiveQtyCache.put(this.getView().getPageId(), originReceiveQtyMap);
        model.batchCreateNewEntryRow(entryKey, vs);
        this.getView().updateView(entryKey);
        this.setRowEnable();
        this.setSelect(entryKey, index, "");
        this.getModel().endInit();
    }

    private void setMaterialEnableshelflifeMap(String orgid, String materialid, Map<String, String> materialEnableshelflifeMap) {
        if (StringUtils.isEmpty((String)orgid) || StringUtils.isEmpty((String)materialid) || this.getPageCache().get("enableshelflifemgr" + orgid + materialid) != null) {
            return;
        }
        HashSet<Long> materialSet = new HashSet<Long>(1);
        materialSet.add(Long.parseLong(materialid));
        Map materialMap = MaterialUtil.getMaterialInventoryinfo(materialSet, (long)Long.parseLong(orgid), (String)"materialid,id,enablelot,enableshelflifemgr");
        boolean enableshelflifemgr = false;
        boolean enablelot = false;
        if (materialMap.get(Long.parseLong(materialid)) != null) {
            DynamicObject materialInvInfo = (DynamicObject)materialMap.get(Long.parseLong(materialid));
            enableshelflifemgr = materialInvInfo.getBoolean("enableshelflifemgr");
            enablelot = materialInvInfo.getBoolean("enablelot");
        }
        materialEnableshelflifeMap.put("enableshelflifemgr" + orgid + materialid, String.valueOf(enableshelflifemgr));
        materialEnableshelflifeMap.put("enablelot" + orgid + materialid, String.valueOf(enablelot));
    }

    public void setSelect(String entryKey, String index, String key) {
        IDataModel model = this.getModel();
        DynamicObjectCollection col = model.getEntryEntity(entryKey);
        EntryGrid grid = (EntryGrid)this.getView().getControl(entryKey);
        ArrayList<Integer> selectedList = new ArrayList<Integer>();
        for (int i = 0; i < col.size(); ++i) {
            String rowKey = ((DynamicObject)col.get(i)).get("billid" + index).toString();
            if (key.equals(rowKey)) {
                selectedList.add(i);
                continue;
            }
            if (!key.isEmpty()) continue;
            selectedList.add(i);
        }
        if (selectedList.size() > 0) {
            int[] selected = CommonUtil.list2Array(selectedList);
            grid.selectRows(selected, 1);
        }
    }

    public void sumMaterialQty(String entryKey, String index) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(entryKey);
        DynamicObjectCollection detailEntryEntityCol = model.getEntryEntity(DETAIL_ENTRY_ENTITY);
        HashMap<String, SumMaterailInfo> sumMaterialMap = new HashMap<String, SumMaterailInfo>();
        for (DynamicObject col : detailEntryEntityCol) {
            long materialId = DynamicObjectUtil.getDynamicObjectPk((DynamicObject)col, (String)"material1");
            long unitId = DynamicObjectUtil.getDynamicObjectPk((DynamicObject)col, (String)"unit1");
            String key = String.valueOf(materialId) + unitId;
            BigDecimal qty = CommonUtil.getBigDecimalPro((Object)col.get("qty1"));
            BigDecimal receiveQty = CommonUtil.getBigDecimalPro((Object)col.get("receiveqty1"));
            String materialnametext = col.getString("materialnametext1");
            SumMaterailInfo sumMaterial = (SumMaterailInfo)sumMaterialMap.get(key);
            if (sumMaterial == null) {
                sumMaterial = new SumMaterailInfo();
                sumMaterial.setKey(key).setMaterialId(materialId).setUnitId(unitId).setMaterialnametext(materialnametext);
                sumMaterial.addQty(qty).addReceiveQty(receiveQty);
                sumMaterialMap.put(key, sumMaterial);
                continue;
            }
            sumMaterial.addQty(qty).addReceiveQty(receiveQty);
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int rowCount = 0;
        for (Map.Entry entry : sumMaterialMap.entrySet()) {
            vs.set("groupkey" + index, (Object)((SumMaterailInfo)entry.getValue()).getKey(), rowCount);
            vs.set("material" + index, (Object)((SumMaterailInfo)entry.getValue()).getMaterialId(), rowCount);
            vs.set("unit" + index, (Object)((SumMaterailInfo)entry.getValue()).getUnitId(), rowCount);
            vs.set("qty" + index, (Object)((SumMaterailInfo)entry.getValue()).getQty(), rowCount);
            vs.set("receiveqty" + index, (Object)((SumMaterailInfo)entry.getValue()).getReceiveQty(), rowCount);
            vs.set("materialnametext" + index, (Object)((SumMaterailInfo)entry.getValue()).getMaterialnametext(), rowCount);
            ++rowCount;
        }
        model.batchCreateNewEntryRow(entryKey, vs);
    }

    public void openQueryFilterPage() {
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"pur_sendquery", new HashMap(), (CloseCallBack)new CloseCallBack((IFormPlugin)this, ACTION_QUERYFILTER), (ShowType)ShowType.Modal));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int rowIndex;
        String property = e.getProperty().getName();
        IDataModel model = this.getModel();
        Map originReceiveQtyMap = (Map)this.originReceiveQtyCache.get(this.getView().getPageId(), Map.class);
        if ("receiveqty1".equals(property)) {
            ChangeData[] changedData = e.getChangeSet();
            DynamicObjectCollection sumCols = model.getEntryEntity(SUM_ENTRY_ENTITY);
            for (ChangeData data : changedData) {
                boolean isOverMaxRece = false;
                boolean isOverMaxReceAndRej = false;
                DynamicObject dynamicObj = data.getDataEntity();
                BigDecimal oldVal = CommonUtil.getBigDecimalPro((Object)data.getOldValue());
                BigDecimal newVal = CommonUtil.getBigDecimalPro((Object)data.getNewValue());
                rowIndex = data.getRowIndex();
                String entryid1 = dynamicObj.getString("entryid1");
                BigDecimal receiveQty = originReceiveQtyMap != null ? (BigDecimal)originReceiveQtyMap.get(entryid1) : null;
                BigDecimal rejQtyBigDecimal = dynamicObj.getBigDecimal("newrejqty1");
                if (receiveQty != null) {
                    if (newVal.compareTo(receiveQty) > 0) {
                        this.getView().showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6536\u8d27\u6570\u91cf\u4e0d\u5141\u8bb8\u5927\u4e8e\u7684\u53d1\u8d27\u6570\u91cf\u3002", (String)"PurBatchReceiveEditPlugin_19", (String)"scm-pur-formplugin", (Object[])new Object[0]), String.valueOf(rowIndex + 1)));
                        isOverMaxRece = true;
                    } else if (null != receiveQty && null != rejQtyBigDecimal && rejQtyBigDecimal.add(newVal).compareTo(receiveQty) > 0) {
                        this.getView().showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6536\u8d27\u6570\u91cf\u548c\u4e0d\u5408\u683c\u6570\u91cf\u4e4b\u548c\u4e0d\u5141\u8bb8\u5927\u4e8e\u7684\u53d1\u8d27\u6570\u91cf\u3002", (String)"PurBatchReceiveEditPlugin_20", (String)"scm-pur-formplugin", (Object[])new Object[0]), String.valueOf(rowIndex + 1)));
                        isOverMaxReceAndRej = true;
                    }
                    long materialId = DynamicObjectUtil.getDynamicObjectPk((DynamicObject)dynamicObj, (String)"material1");
                    long unitId = DynamicObjectUtil.getDynamicObjectPk((DynamicObject)dynamicObj, (String)"unit1");
                    String groupKey = String.valueOf(materialId) + unitId;
                    for (int i = 0; i < sumCols.size(); ++i) {
                        String sumGroupKey = ((DynamicObject)sumCols.get(i)).getString("groupkey2");
                        if (!groupKey.equals(sumGroupKey)) continue;
                        receiveQty = CommonUtil.getBigDecimalPro((Object)((DynamicObject)sumCols.get(i)).get(RECEIVEQTY + SUFFIX_SUM));
                        model.setValue(RECEIVEQTY + SUFFIX_SUM, (Object)receiveQty.add(newVal.subtract(oldVal)), i);
                    }
                }
                if (isOverMaxRece) {
                    this.getModel().setValue("receiveqty1", (Object)receiveQty, rowIndex);
                }
                if (!isOverMaxReceAndRej) continue;
                this.getModel().setValue("newrejqty1", (Object)BigDecimal.ZERO, rowIndex);
            }
        }
        if ("newrejqty1".equals(property)) {
            ChangeData[] changedData;
            for (ChangeData data : changedData = e.getChangeSet()) {
                DynamicObject dynamicObj = data.getDataEntity();
                rowIndex = data.getRowIndex();
                String entryid1 = dynamicObj.getString("entryid1");
                BigDecimal receiveQty = originReceiveQtyMap != null ? (BigDecimal)originReceiveQtyMap.get(entryid1) : null;
                BigDecimal rejQtyBigDecimal = dynamicObj.getBigDecimal("newrejqty1");
                BigDecimal recQty = dynamicObj.getBigDecimal("receiveqty1");
                if (receiveQty == null || null == receiveQty || null == rejQtyBigDecimal || rejQtyBigDecimal.add(recQty).compareTo(receiveQty) <= 0) continue;
                this.getView().showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6536\u8d27\u6570\u91cf\u548c\u4e0d\u5408\u683c\u6570\u91cf\u4e4b\u548c\u4e0d\u5141\u8bb8\u5927\u4e8e\u7684\u53d1\u8d27\u6570\u91cf\u3002", (String)"PurBatchReceiveEditPlugin_20", (String)"scm-pur-formplugin", (Object[])new Object[0]), String.valueOf(rowIndex + 1)));
                this.getModel().setValue("newrejqty1", (Object)BigDecimal.ZERO, rowIndex);
            }
        }
        if ("warehouse1".equals(property)) {
            rowIndex = e.getChangeSet()[0].getRowIndex();
            model.setValue("location1", null, rowIndex);
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.restOfReceiveQtyCache.remove(this.getView().getPageId());
        this.originReceiveQtyCache.remove(this.getView().getPageId());
    }

    private boolean checkMaterialEnableshelflife() {
        DynamicObjectCollection col = this.getModel().getEntryEntity(DETAIL_ENTRY_ENTITY);
        StringBuilder msg = new StringBuilder();
        boolean enableshelflife = false;
        int rowIndex = 1;
        Map materialEnableshelflifeMap = new HashMap(8);
        String materialEnableshelflifeMapStr = this.getPageCache().get("materialEnableshelflifeMap");
        if (!StringUtils.isEmpty((String)materialEnableshelflifeMapStr)) {
            materialEnableshelflifeMap = (Map)JSON.parseObject((String)materialEnableshelflifeMapStr, Map.class);
        }
        for (DynamicObject row : col) {
            boolean enableshelflifemgr = false;
            boolean enablelot = false;
            if (!CollectionUtils.isEmpty(materialEnableshelflifeMap)) {
                enableshelflifemgr = Boolean.parseBoolean((String)materialEnableshelflifeMap.get("enableshelflifemgr" + row.getString("org1.id") + row.getString("material1.id")));
                enablelot = Boolean.parseBoolean((String)materialEnableshelflifeMap.get("enablelot" + row.getString("org1.id") + row.getString("material1.id")));
            }
            Date proddate = row.getDate("proddate1");
            Date duedate = row.getDate("duedate1");
            if (enableshelflifemgr && (proddate == null || duedate == null)) {
                msg.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u7269\u6599\u5df2\u5f00\u542f\u4fdd\u8d28\u671f\u7ba1\u7406\uff0c\u751f\u4ea7\u65e5\u671f\u548c\u5230\u671f\u65e5\u671f\u4e0d\u5141\u8bb8\u4e3a\u7a7a,\u8bf7\u8f93\u5165\u3002", (String)"PurBatchReceiveEditPlugin_21", (String)"scm-pur-formplugin", (Object[])new Object[0]), String.valueOf(rowIndex)));
                msg.append(System.lineSeparator());
                enableshelflife = true;
            }
            if (enableshelflifemgr && proddate != null && duedate != null && proddate.after(duedate)) {
                msg.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u7269\u6599\u5df2\u5f00\u542f\u4fdd\u8d28\u671f\u7ba1\u7406\uff0c\u751f\u4ea7\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5230\u671f\u65e5\u671f,\u8bf7\u8f93\u5165\u3002", (String)"PurBatchReceiveEditPlugin_37", (String)"scm-pur-formplugin", (Object[])new Object[0]), String.valueOf(rowIndex)));
                msg.append(System.lineSeparator());
                enableshelflife = true;
            }
            ++rowIndex;
        }
        String message = ResManager.loadKDString((String)"\u751f\u6210\u5355\u636e\u5931\u8d25\u3002", (String)"PurBatchReceiveEditPlugin_17", (String)"scm-pur-formplugin", (Object[])new Object[0]);
        if (enableshelflife) {
            this.getView().showMessage(message, msg.toString(), MessageTypes.Default);
        }
        return enableshelflife;
    }

    private void setRowEnable() {
        DynamicObjectCollection col = this.getModel().getEntryEntity(DETAIL_ENTRY_ENTITY);
        IFormView view = this.getView();
        int rowIndex = 0;
        Map materialEnableshelflifeMap = new HashMap(8);
        String materialEnableshelflifeMapStr = this.getPageCache().get("materialEnableshelflifeMap");
        if (StringUtils.isEmpty((String)materialEnableshelflifeMapStr)) {
            materialEnableshelflifeMap = (Map)JSON.parseObject((String)materialEnableshelflifeMapStr, Map.class);
        }
        for (DynamicObject row : col) {
            boolean enableshelflifemgr = false;
            boolean enablelot = false;
            if (!CollectionUtils.isEmpty(materialEnableshelflifeMap)) {
                enableshelflifemgr = Boolean.parseBoolean((String)materialEnableshelflifeMap.get("enableshelflifemgr" + row.getString("org1.id") + row.getString("material1.id")));
                enablelot = Boolean.parseBoolean((String)materialEnableshelflifeMap.get("enablelot" + row.getString("org1.id") + row.getString("material1.id")));
            }
            view.setEnable(Boolean.valueOf(enableshelflifemgr), rowIndex, new String[]{"proddate1"});
            view.setEnable(Boolean.valueOf(enableshelflifemgr), rowIndex, new String[]{"duedate1"});
            view.setEnable(Boolean.valueOf(enablelot), rowIndex, new String[]{"lot1"});
            ++rowIndex;
        }
    }

    @Deprecated
    public String getBotpRule(String targetBillType) {
        Map<String, Object> billInfoMap = this.getBillIdInfo();
        String rules = "";
        if (billInfoMap.size() > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            billInfoMap.put("targetBillType", targetBillType);
            billInfoMap.put("srctype", "order");
            param.put("data", billInfoMap);
            param.put("code", "200");
            rules = ApiUtil.botpQuery(param);
            if (StringUtils.isNotEmpty((String)rules)) {
                // empty if block
            }
        }
        return rules;
    }

    @Deprecated
    public void openBotpListPage(List<Object> ruleList, String toBillType) {
        Map ruleMap;
        Object error;
        IFormView view = this.getView();
        if (ruleList.size() == 1 && null != (error = (ruleMap = (Map)ruleList.get(0)).get("error")) && error.toString().trim().length() > 0) {
            view.showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8f6c\u6362\u89c4\u5219\uff0c\u539f\u56e0\uff1a{0}\u3002", (String)"PurBatchReceiveEditPlugin_12", (String)"scm-pur-formplugin", (Object[])new Object[0]), error));
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("rules", ruleList);
        param.put("tobilltype", toBillType);
        view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)"pur_botp_list", param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, ACTION_BOTPLIST), (ShowType)ShowType.Modal));
    }

    private boolean receiveCheckIsGoodsBizTypeOnly(String itemKey, DynamicObject[] datas) {
        boolean hasGoodsType = false;
        boolean hasMaterialType = false;
        for (DynamicObject data : datas) {
            DynamicObject businesstype = data.getDynamicObject("businesstype1");
            if (MalNewOrderUtils.checkIsGoodsBizType((DynamicObject)businesstype)) {
                hasGoodsType = true;
                if ("bar_to_inware".equals(itemKey) || "bar_to_cq_instock".equals(itemKey)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u884c\u5305\u542b\u5546\u54c1\u7c7b\u91c7\u8d2d\uff0c\u4e0d\u652f\u6301\u751f\u6210\u5165\u5e93\u5355\u3002", (String)"PurBatchReceiveEditPlugin_30", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    return false;
                }
            } else {
                hasMaterialType = true;
            }
            if (!hasGoodsType || !hasMaterialType) continue;
            this.getView().showMessage(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u8bb0\u5f55\u4e2d\u5b58\u5728\u5546\u54c1\u7c7b\u91c7\u8d2d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PurBatchReceiveEditPlugin_29", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkIsOmBizTypeOnly(String itemKey, DynamicObject[] datas) {
        ArrayList<DynamicObject> omDynamicObjects = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> notOmDynamicObjects = new ArrayList<DynamicObject>(8);
        for (DynamicObject data : datas) {
            DynamicObject businesstype = data.getDynamicObject("businesstype1");
            if (BussinessTypeUtils.checkIsPmOmBussinessType((DynamicObject)businesstype)) {
                omDynamicObjects.add(data);
                continue;
            }
            notOmDynamicObjects.add(data);
        }
        if (!omDynamicObjects.isEmpty() && !notOmDynamicObjects.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5de5\u5e8f\u59d4\u5916\u8ba2\u5355\u548c\u5176\u4ed6\u8ba2\u5355\u4e0d\u80fd\u540c\u65f6\u751f\u6210\u5165\u5e93\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PurBatchReceiveEditPlugin_39", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkIsCpOmBizTypeOnly(String itemKey, DynamicObject[] datas) {
        ArrayList<DynamicObject> omDynamicObjects = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> notOmDynamicObjects = new ArrayList<DynamicObject>(8);
        for (DynamicObject data : datas) {
            DynamicObject businesstype = data.getDynamicObject("businesstype1");
            if (BussinessTypeUtils.checkIsCpOmBussinessType((DynamicObject)businesstype)) {
                omDynamicObjects.add(data);
                continue;
            }
            notOmDynamicObjects.add(data);
        }
        if (!omDynamicObjects.isEmpty() && !notOmDynamicObjects.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4ea7\u54c1\u5de5\u5e8f\u59d4\u5916\u8ba2\u5355\u548c\u5176\u4ed6\u8ba2\u5355\u4e0d\u80fd\u540c\u65f6\u751f\u6210\u5165\u5e93\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PurBatchReceiveEditPlugin_41", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkIsCpOmBussinessType() {
        DynamicObject[] datas;
        IFormView view = this.getView();
        EntryGrid grid = (EntryGrid)view.getControl(DETAIL_ENTRY_ENTITY);
        for (DynamicObject data : datas = grid.getEntryData().getDataEntitys()) {
            DynamicObject businesstype = data.getDynamicObject("businesstype1");
            if (!BussinessTypeUtils.checkIsCpOmBussinessType((DynamicObject)businesstype)) continue;
            return true;
        }
        return false;
    }

    private boolean checkIsPmOmBussinessType() {
        DynamicObject[] datas;
        IFormView view = this.getView();
        EntryGrid grid = (EntryGrid)view.getControl(DETAIL_ENTRY_ENTITY);
        for (DynamicObject data : datas = grid.getEntryData().getDataEntitys()) {
            DynamicObject businesstype = data.getDynamicObject("businesstype1");
            if (!BussinessTypeUtils.checkIsPmOmBussinessType((DynamicObject)businesstype)) continue;
            return true;
        }
        return false;
    }

    private boolean checkIsGoodsBizTypeOrder() {
        DynamicObject[] datas;
        IFormView view = this.getView();
        EntryGrid grid = (EntryGrid)view.getControl(DETAIL_ENTRY_ENTITY);
        for (DynamicObject data : datas = grid.getEntryData().getDataEntitys()) {
            DynamicObject businesstype = data.getDynamicObject("businesstype1");
            if (!MalNewOrderUtils.checkIsGoodsBizType((DynamicObject)businesstype)) continue;
            return true;
        }
        return false;
    }

    private void goodsBizTypeOrderPushReceipt() {
        List<DynamicObject> dataList = this.getSelectedData(DETAIL_ENTRY_ENTITY);
        Map<String, Object> resData = this.handleGoodsBizTypeOrderData(dataList);
        StringBuilder sb = (StringBuilder)resData.get("resMessage");
        this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6210\u6536\u8d27\u5355\u6210\u529f\u3002", (String)"PurBatchReceiveEditPlugin_33", (String)"scm-pur-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
        this.getPageCache().remove("supplier");
        this.allotDynamicData(Boolean.TRUE);
    }

    private Map<String, Object> handleGoodsBizTypeOrderData(List<DynamicObject> dataList) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
        while (dataList.size() > 0 && !Boolean.FALSE.equals(returnMap.get("succed"))) {
            dataList = this.pushGoodsBizTypeOrder(dataList, returnMap);
        }
        return returnMap;
    }

    private List<DynamicObject> pushGoodsBizTypeOrder(List<DynamicObject> dataList, Map<String, Object> returnMap) {
        returnMap.put("succed", Boolean.FALSE);
        ArrayList<DynamicObject> undoData = new ArrayList<DynamicObject>(dataList.size());
        ArrayList<String> entryIds = new ArrayList<String>(dataList.size());
        HashMap<String, String> entryIdsAndReceiptNum = new HashMap<String, String>(dataList.size());
        HashSet<Long> poBillIdSet = new HashSet<Long>(dataList.size());
        for (DynamicObject dynamicObject : dataList) {
            if (0 >= dynamicObject.getBigDecimal("receiveqty1").compareTo(BigDecimal.ZERO)) continue;
            String poentryId = dynamicObject.getString("poentryid1");
            if (entryIdsAndReceiptNum.get(poentryId) != null) {
                undoData.add(dynamicObject);
                continue;
            }
            entryIds.add(poentryId);
            entryIdsAndReceiptNum.put(poentryId, dynamicObject.getString("receiveqty1"));
            poBillIdSet.add(dynamicObject.getLong("pobillid1"));
        }
        String selectFields = "id, materialentry.id";
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("isGoodsBizTypeOrder", "true");
        customParams.put("realNum", SerializationUtils.toJsonString(entryIdsAndReceiptNum));
        Date now = TimeServiceHelper.now();
        List targetData = MalOrderUtil.doAutoPushAndAudit((String)"pur_order", (String)"pur_receipt", (String)"materialentry", new ArrayList(entryIds), (String)selectFields, (boolean)true, customParams);
        if (targetData == null || targetData.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91c7\u8d2d\u6536\u8d27\u5355\u4e0b\u63a8\u5931\u8d25\u3002", (String)"PurBatchReceiveEditPlugin_38", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            this.getPageCache().remove("supplier");
            return undoData;
        }
        HashSet<Long> idSet = new HashSet<Long>();
        for (DynamicObject dynamicObject : targetData) {
            if (dynamicObject.getLong("id") == 0L) continue;
            idSet.add(dynamicObject.getLong("id"));
        }
        DynamicObjectCollection purReceiptDynColl = QueryServiceHelper.query((String)"pur_receipt", (String)"id,billno,materialentry.poentryid poentryid", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)});
        StringBuilder sb = returnMap.get("resMessage") == null ? new StringBuilder() : (StringBuilder)returnMap.get("resMessage");
        HashSet<String> hasIdSet = new HashSet<String>();
        HashSet<String> billNoSet = new HashSet<String>();
        for (DynamicObject dynamicObject : purReceiptDynColl) {
            if (!billNoSet.contains(dynamicObject.getString("billno"))) {
                sb.append(String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u6536\u8d27\u5355\uff1a%s\n", (String)"PurBatchReceiveEditPlugin_32", (String)"scm-pur-formplugin", (Object[])new Object[0]), dynamicObject.getString("billno")));
                billNoSet.add(dynamicObject.getString("billno"));
            }
            hasIdSet.add(dynamicObject.getString("poentryid"));
        }
        if (hasIdSet.size() < targetData.size()) {
            for (String id : hasIdSet) {
                entryIds.remove(id);
            }
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"pur_order", (Long[])poBillIdSet.toArray(new Long[0]));
            Set trackDownIdSet = (Set)targetBills.get("pur_receipt");
            QFilter qFilter = new QFilter("id", "in", (Object)trackDownIdSet);
            qFilter.and(new QFilter("materialentry.poentryid", "in", entryIds));
            qFilter.and(new QFilter("createtime", ">", (Object)now));
            DynamicObjectCollection trackDownPurReceiptDynColl = QueryServiceHelper.query((String)"pur_receipt", (String)"id,billno,createtime,materialentry.qty qty,materialentry.poentryid poentryid", (QFilter[])new QFilter[]{qFilter});
            for (DynamicObject dynamicObject : trackDownPurReceiptDynColl) {
                BigDecimal receiptQty = new BigDecimal((String)entryIdsAndReceiptNum.get(dynamicObject.getString("poentryid")));
                if (dynamicObject.getBigDecimal("qty").compareTo(receiptQty) != 0 || billNoSet.contains(dynamicObject.getString("billno"))) continue;
                sb.append(String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u6536\u8d27\u5355\uff1a%s\n", (String)"PurBatchReceiveEditPlugin_32", (String)"scm-pur-formplugin", (Object[])new Object[0]), dynamicObject.getString("billno")));
                billNoSet.add(dynamicObject.getString("billno"));
            }
        }
        returnMap.put("succed", Boolean.TRUE);
        returnMap.put("resMessage", sb);
        return undoData;
    }

    private DynamicObject[] doFromMalOrderJumpFilter(DynamicObject[] dynamicObjects, List<String> purOrderEntryIds) {
        ArrayList<DynamicObject> newDynList = new ArrayList<DynamicObject>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection entryCol = dynamicObject.getDynamicObjectCollection("materialentry");
            Iterator iterator = entryCol.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                String poEntryId = entry.getString("poentryid");
                if (purOrderEntryIds.contains(poEntryId)) continue;
                iterator.remove();
            }
            if (entryCol.isEmpty()) continue;
            newDynList.add(dynamicObject);
        }
        return newDynList.toArray(new DynamicObject[0]);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        this.getModel().putContextVariable("MODEL_BOSENTRYSERVERFILTERSORT", (Object)true);
    }
}

