/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.enums.ReturnStatusEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicFormUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.common.util.OrgUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class PurBatchReturnPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
HyperLinkClickListener,
RowClickEventListener {
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    protected static final String RECEIVEQTY = "receiveqty";
    protected static final String OPENSOURCE = "opensource";
    protected static final String ACTION_BOTPLIST = "botpList";
    protected static String poped_flag = "scm_pur_bacthreturn_%S";
    protected static final String SOURCE_ENTITY_KEY = "source";
    protected static final String ACTION_QUERYFILTER = "queryfilter";
    protected static final StringBuilder botpRule = new StringBuilder();
    protected static final String TO_INWARE = "toInware";
    protected static final String TO_RECEIVE = "toReceive";
    protected static final String HEAD_ENTRY_ENTITY = "head_entryentity";
    protected static final String DETAIL_ENTRY_ENTITY = "detail_entryentity";
    protected static final String SUFFIX_DETAIL = "1";
    protected static final char SUFFIX_DETAIL_CHAR = '1';
    protected static final String SUFFIX_SUM = "2";
    protected static final String SUFFIX_ALL = "4";
    protected static final char SUFFIX_ALL_CHAR = '4';
    protected static final String ALL_ENTRY_ENTITY = "all_entryentity";
    protected static final String SUM_ENTRY_ENTITY = "sum_matentryentity";
    public static final String PARTITION = "_";
    public static final String INSTOCK = "1";
    public static final String RECEIPT = "2";
    private static final String[] VALID_PRO = new String[]{"warehouse", "location", "lot", "project", "trace", "unit", "basicUnit", "note"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        EntryGrid headGrid = (EntryGrid)this.getView().getControl(HEAD_ENTRY_ENTITY);
        headGrid.addRowClickListener((RowClickEventListener)this);
        headGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid detailGrid = (EntryGrid)this.getView().getControl(DETAIL_ENTRY_ENTITY);
        detailGrid.addHyperClickListener((HyperLinkClickListener)this);
        detailGrid.addRowClickListener((RowClickEventListener)this);
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (ApiConfigUtil.hasEASConfig()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"baritemap1"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap1"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        IPageCache cache = this.getPageCache();
        super.afterCreateNewData(e);
        if (!"1".equals(cache.get("isTreeNodeClick"))) {
            TreeView treeView = (TreeView)this.getControl("treeviewap");
            TreeNode node = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"PurBatchReturnPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            treeView.deleteAllNodes();
            treeView.addNode(node);
            treeView.focusNode(node);
        }
        String cacheKey = String.format(poped_flag, this.getView().getPageId());
        String poped = cache.get(cacheKey);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!"1".equals(poped)) {
            this.getPageCache().put(cacheKey, "1");
            if (customParams.containsKey("customfilter")) {
                this.allotDynamicData();
            } else {
                FormShowParameter showParameter = this.getView().getFormShowParameter();
                String source = (String)showParameter.getCustomParam(SOURCE_ENTITY_KEY);
                if (null != source && source.equals("mall")) {
                    this.getPageCache().put("fromsource", "mall");
                    this.getView().setEnable(Boolean.FALSE, new String[]{DETAIL_ENTRY_ENTITY});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap"});
                    Long returnreqId = Long.valueOf((String)showParameter.getCustomParam("billid"));
                    QFilter idfilter = new QFilter("id", "=", (Object)returnreqId);
                    String selectProperties = "id,entryentity.pobillno,materialentry.qty,entryentity.poentryid,entryentity.pobillid";
                    DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"mal_returnreq", (String)selectProperties, (QFilter[])new QFilter[]{idfilter});
                    if (obj == null) {
                        this.openQueryFilterPage(new HashMap());
                    } else {
                        DynamicObjectCollection entries = obj.getDynamicObjectCollection("entryentity");
                        if (entries.size() > 0) {
                            String pobillno = ((DynamicObject)entries.get(0)).getString("pobillno");
                            cache.put("pobillno", pobillno);
                            DynamicObject purOrderDyn = QueryServiceHelper.queryOne((String)"pur_order", (String)"id,logstatus", (QFilter[])new QFilter[]{new QFilter("materialentry.pobillid", "=", (Object)((DynamicObject)entries.get(0)).getString("pobillid"))});
                            String logStatus = purOrderDyn.getString("logstatus");
                            if (LogisticsStatusEnum.ALLINSTOCK.getVal().equals(logStatus) || LogisticsStatusEnum.PARTINSTOCK.getVal().equals(logStatus)) {
                                cache.put(SOURCE_ENTITY_KEY, "1");
                            } else {
                                cache.put(SOURCE_ENTITY_KEY, "2");
                            }
                            this.allotDynamicData();
                        } else {
                            this.openQueryFilterPage(new HashMap());
                        }
                    }
                } else {
                    this.openQueryFilterPage(new HashMap());
                }
            }
        }
    }

    public void openQueryFilterPage(HashMap map) {
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"pur_returnquery", (Map)map, (CloseCallBack)new CloseCallBack((IFormPlugin)this, ACTION_QUERYFILTER), (ShowType)ShowType.Modal));
    }

    public void openReturnListPage() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put(OPENSOURCE, "batchReturn");
        String entityKey = "pur_return";
        if ("2".equals(this.getPageCache().get(SOURCE_ENTITY_KEY))) {
            entityKey = "pur_receipt_return";
        }
        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowListFormParam((String)entityKey, paramMap, null));
    }

    public void allotDynamicData() {
        this.clearData();
        String entityKey = this.assembleSourceEntityKey();
        IFormView view = this.getView();
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityKey, (String)this.assembleSelectFilds(entityKey), (QFilter[])this.assembleQueryFilter(), (String)"billno desc,materialentry.seq");
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            this.clearData();
            this.bindTreeData(null);
            view.updateView();
            view.showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"PurBatchReturnPlugin_1", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().beginInit();
        this.getModel().createNewData();
        this.getModel().endInit();
        if (!"1".equals(this.getPageCache().get("isTreeNodeClick"))) {
            this.bindTreeData(dynamicObjects);
        }
        this.bindEntityData(dynamicObjects, HEAD_ENTRY_ENTITY, "");
        this.bindAllEntityData(dynamicObjects, ALL_ENTRY_ENTITY, SUFFIX_ALL);
        EntryGrid headEntry = (EntryGrid)this.getControl(HEAD_ENTRY_ENTITY);
        headEntry.clearEntryState();
    }

    public void bindAllEntityData(DynamicObjectCollection dynamicObjects, String allEntryEntity, String suffix) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        List propertiesentity = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntityEntity(allEntryEntity).getDynamicObjectType());
        model.batchCreateNewEntryRow(allEntryEntity, DynamicFormUtil.batchBindData((DynamicObjectCollection)dynamicObjects, (List)propertiesentity, (String)suffix));
    }

    public void bindEntityData(DynamicObjectCollection dynamicObjects, String entityKey, String suffix) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        List propertiesentity = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntityEntity(entityKey).getDynamicObjectType());
        int rowCount = 0;
        HashSet<Object> idSet = new HashSet<Object>();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (idSet.contains(dynamicObject.get("billid"))) continue;
            Map objectMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)dynamicObject);
            for (Map.Entry entry : objectMap.entrySet()) {
                if (propertiesentity.contains((String)entry.getKey() + suffix) && !"billid".equals(entry.getKey())) {
                    vs.set((String)entry.getKey() + suffix, entry.getValue(), rowCount);
                    continue;
                }
                if (!propertiesentity.contains((String)entry.getKey() + suffix) || !"billid".equals(entry.getKey())) continue;
                vs.set("billid" + suffix, entry.getValue(), rowCount);
            }
            ++rowCount;
            idSet.add(dynamicObject.get("billid"));
        }
        model.batchCreateNewEntryRow(entityKey, vs);
    }

    protected void bindDetailEntityData(DynamicObjectCollection dynamicObjects, String entityKey, String suffix) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        List propertiesentity = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntityEntity(entityKey).getDynamicObjectType());
        model.batchCreateNewEntryRow(entityKey, DynamicFormUtil.batchBindData((DynamicObjectCollection)dynamicObjects, (List)propertiesentity, (String)suffix));
    }

    protected void bindDetailEntityData(List<DynamicObject> dynamicObjects, String entityKey, String suffix) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        List propertiesEntity = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntityEntity(entityKey).getDynamicObjectType());
        DataEntityPropertyCollection properties = dynamicObjects.get(0).getDynamicObjectType().getProperties();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int rowIndex = 0;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String source = this.getPageCache().get("fromsource");
        HashMap<String, String> returnQtyMap = null;
        if (null != source && source.equals("mall")) {
            returnQtyMap = this.malReturnDetailEntityData(showParameter);
            this.log.info("@@\u9000\u8d27\u52a9\u624b-\u552e\u540e\u7533\u8bf7\u5355\u5206\u5f55returnQtyMap\uff1a" + returnQtyMap);
        }
        for (DynamicObject bill : dynamicObjects) {
            if (null != source && source.equals("mall")) {
                String key = bill.getString("poentryid4");
                if (StringUtils.isEmpty((String)key)) continue;
                String qty = null;
                if (returnQtyMap != null) {
                    qty = returnQtyMap.get(key);
                }
                if (qty == null) {
                    qty = "0";
                }
                for (IDataEntityProperty entityType : properties) {
                    String proName = entityType.getName().toLowerCase().replace('4', '1');
                    Object value = entityType.getValue((Object)bill);
                    if ("receiveqty1".equals(proName)) {
                        vs.set("receiveqty1", (Object)qty, rowIndex);
                        vs.set("seq", (Object)key.split(PARTITION)[0], rowIndex);
                        continue;
                    }
                    if (proName.equals("seq") || !propertiesEntity.contains(proName)) continue;
                    vs.set(proName, value, rowIndex);
                }
            } else {
                for (IDataEntityProperty entityType : properties) {
                    String proName = entityType.getName().toLowerCase().replace('4', '1');
                    Object value = entityType.getValue((Object)bill);
                    if (!propertiesEntity.contains(proName)) continue;
                    vs.set(proName, value, rowIndex);
                }
            }
            ++rowIndex;
        }
        model.batchCreateNewEntryRow(entityKey, vs);
        this.getView().updateView(entityKey);
    }

    private HashMap<String, String> malReturnDetailEntityData(FormShowParameter showParameter) {
        HashMap<String, String> map = new HashMap<String, String>();
        Long returnreqId = Long.valueOf((String)showParameter.getCustomParam("billid"));
        QFilter idfilter = new QFilter("id", "=", (Object)returnreqId);
        String selectProperties = "id,entryentity.material.id,entryentity.pobillno,entryentity.qty,entryentity.poentryid,entryentity.pobillid,entryentity.seq";
        DynamicObjectCollection returnReqOrderEntries = QueryServiceHelper.query((String)"mal_returnreq", (String)selectProperties, (QFilter[])new QFilter[]{idfilter}, (String)"entryentity.seq");
        for (DynamicObject entry : returnReqOrderEntries) {
            map.put(entry.getString("entryentity.poentryid"), entry.getString("entryentity.qty"));
        }
        return map;
    }

    public void bindTreeData(DynamicObjectCollection dynamicObjects) {
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        TreeNode rootNode = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"PurBatchReturnPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        treeView.deleteAllNodes();
        treeView.addNode(rootNode);
        treeView.focusNode(rootNode);
        if (dynamicObjects == null || dynamicObjects.size() <= 0) {
            return;
        }
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        Iterator iterator = dynamicObjects.iterator();
        while (iterator.hasNext()) {
            HashSet<String> nodeIdSet = new HashSet<String>();
            DynamicObject obj = (DynamicObject)iterator.next();
            String supplierPk = obj.getString("supplier");
            if (nodeIdSet.contains(supplierPk)) continue;
            nodeIdSet.add(supplierPk);
            TreeNode node = new TreeNode("0", supplierPk, obj.getString("suppliername"));
            treeNodes.add(node);
        }
        treeView.addNodes(treeNodes);
        treeView.expand("0");
    }

    public void sumMaterialQty(String sumEntryEntity, String suffixSum) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(sumEntryEntity);
        DynamicObjectCollection detailEntryEntityCol = model.getEntryEntity(DETAIL_ENTRY_ENTITY);
        HashMap<String, SumMaterailInfo> sumMaterialMap = new HashMap<String, SumMaterailInfo>();
        for (DynamicObject col : detailEntryEntityCol) {
            long materialId = DynamicObjectUtil.getDynamicObjectPk((DynamicObject)col, (String)"material1");
            long unitId = DynamicObjectUtil.getDynamicObjectPk((DynamicObject)col, (String)"unit1");
            String key = String.valueOf(materialId) + String.valueOf(unitId);
            BigDecimal qty = CommonUtil.getBigDecimalPro((Object)col.get("qty1"));
            BigDecimal receiveQty = CommonUtil.getBigDecimalPro((Object)col.get("receiveqty1"));
            SumMaterailInfo sumMaterial = (SumMaterailInfo)sumMaterialMap.get(key);
            if (sumMaterial == null) {
                sumMaterial = new SumMaterailInfo();
                sumMaterial.setKey(key).setMaterialId(materialId).setUnitId(unitId);
                sumMaterial.addQty(qty).addReceiveQty(receiveQty);
                sumMaterialMap.put(key, sumMaterial);
                continue;
            }
            sumMaterial.addQty(qty).addReceiveQty(receiveQty);
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int rowCount = 0;
        for (Map.Entry entry : sumMaterialMap.entrySet()) {
            vs.set("groupkey" + suffixSum, (Object)((SumMaterailInfo)entry.getValue()).getKey(), rowCount);
            vs.set("material" + suffixSum, (Object)((SumMaterailInfo)entry.getValue()).getMaterialId(), rowCount);
            vs.set("unit" + suffixSum, (Object)((SumMaterailInfo)entry.getValue()).getUnitId(), rowCount);
            vs.set("qty" + suffixSum, (Object)((SumMaterailInfo)entry.getValue()).getQty(), rowCount);
            vs.set(RECEIVEQTY + suffixSum, (Object)((SumMaterailInfo)entry.getValue()).getReceiveQty(), rowCount);
            ++rowCount;
        }
        model.batchCreateNewEntryRow(sumEntryEntity, vs);
    }

    public QFilter[] assembleQueryFilter() {
        String pobillno;
        String material;
        String rcvOrg;
        String billddateFrom;
        String billddate;
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        String entityKey = this.assembleSourceEntityKey();
        String supplier = this.getPageCache().get("supplier");
        if (null != supplier && !supplier.isEmpty()) {
            qFilter.and(new QFilter("supplier", "=", (Object)Long.valueOf(supplier)));
        }
        if (null != (billddate = this.getPageCache().get("billdate")) && !billddate.isEmpty()) {
            qFilter.and(new QFilter("billdate", "<=", (Object)DateUtil.string2date((String)billddate, null)));
        }
        if (null != (billddateFrom = this.getPageCache().get("billdatefrom")) && !billddateFrom.isEmpty()) {
            qFilter.and(new QFilter("billdate", ">=", (Object)DateUtil.string2date((String)billddateFrom, null)));
        }
        if (null != (rcvOrg = this.getPageCache().get("rcvorg")) && !rcvOrg.trim().isEmpty()) {
            qFilter.and(new QFilter("org", "=", (Object)Long.valueOf(rcvOrg)));
        }
        if (null != (material = this.getPageCache().get("material")) && !material.isEmpty()) {
            qFilter.and(new QFilter("materialentry.material", "=", (Object)Long.valueOf(material)));
        }
        if (null != (pobillno = this.getPageCache().get("pobillno")) && !pobillno.trim().isEmpty()) {
            qFilter.and(new QFilter("materialentry.pobillno", "match", (Object)pobillno));
        }
        if ("pur_receipt".equals(entityKey)) {
            qFilter.and(new QFilter("isreturn", "!=", (Object)"1"));
        }
        List orglist = OrgUtil.getAllInvViewPermissionOrgs((String)entityKey);
        qFilter.and("org", "in", (Object)orglist);
        return new QFilter[]{qFilter};
    }

    public String assembleSelectFilds(String entityKey) {
        String selectFields = "*";
        switch (entityKey) {
            case "pur_instock": {
                selectFields = "id billid,billno,billdate,org.id org,purorg.id purorg,supplier.id supplier,supplier.name suppliername,supplier.number suppliernumber,materialentry.id entryid,materialentry.material.id material,materialentry.materialdesc materialdesc,materialentry.qty qty,materialentry.unit.id unit,materialentry.basicunit.id basicunit,materialentry.basicqty,materialentry.warehouse warehouse,materialentry.location location,materialentry.pobillno pobillno,materialentry.pobillid pobillid,materialentry.poentryid poentryid,materialentry.srcbillid srcbillid,materialentry.srcentryid srcentryid";
                break;
            }
            case "pur_receipt": {
                selectFields = "id billid,billno,billdate,org.id org,purorg.id purorg,supplier.id supplier,supplier.name suppliername,supplier.number suppliernumber,materialentry.id entryid,materialentry.material.id material,materialentry.materialdesc materialdesc,materialentry.qty qty,materialentry.unit.id unit,materialentry.basicunit.id basicunit,materialentry.basicqty,materialentry.warehouse warehouse,materialentry.pobillno pobillno,materialentry.pobillid pobillid,materialentry.poentryid poentryid,materialentry.srcbillid srcbillid,materialentry.srcentryid srcentryid";
            }
        }
        return selectFields;
    }

    protected String assembleSourceEntityKey() {
        String source = this.getPageCache().get(SOURCE_ENTITY_KEY);
        StringBuilder stringBuilder = new StringBuilder();
        if (null == source) {
            stringBuilder.append("pur_instock");
        } else {
            switch (source) {
                case "1": {
                    stringBuilder.append("pur_instock");
                    break;
                }
                case "2": {
                    stringBuilder.append("pur_receipt");
                    break;
                }
                default: {
                    stringBuilder.append("pur_instock");
                }
            }
        }
        return stringBuilder.toString();
    }

    public List<DynamicObject> getSelectedData(String entryKey) {
        ArrayList<DynamicObject> selectDynaObj = new ArrayList<DynamicObject>();
        IDataModel model = this.getModel();
        DynamicObjectCollection entryCols = model.getEntryEntity(entryKey);
        entryCols.forEach(entry -> {
            BigDecimal qty = entry.getBigDecimal("receiveqty1");
            if (qty.compareTo(BigDecimal.ZERO) > 0) {
                selectDynaObj.add((DynamicObject)entry);
            }
        });
        return selectDynaObj;
    }

    public String getBotpRule(String targetBillType) {
        Map<String, Object> billInfoMap = this.getBillIdInfo();
        String rules = "";
        if (billInfoMap.size() > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            billInfoMap.put("srctype", targetBillType);
            billInfoMap.put("targetBillType", targetBillType);
            param.put("data", billInfoMap);
            param.put("code", "200");
            rules = ApiUtil.botpQuery(param);
            if (StringUtils.isNotEmpty((String)rules)) {
                // empty if block
            }
        }
        return rules;
    }

    public Map<String, Object> getBillIdInfo() {
        List<DynamicObject> entryList = this.getSelectedData(DETAIL_ENTRY_ENTITY);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        if (entryList.size() == 0) {
            return dataMap;
        }
        HashSet<String> entryIdSet = new HashSet<String>();
        HashSet<String> billIdSet = new HashSet<String>();
        for (DynamicObject entry : entryList) {
            String srcEntryId = String.valueOf(entry.get("srcentryid1"));
            if (!StringUtils.isNotEmpty((String)srcEntryId)) continue;
            entryIdSet.add(srcEntryId);
            String billId = String.valueOf(entry.get("srcbillid1"));
            billIdSet.add(billId);
        }
        dataMap.put("billId", billIdSet);
        dataMap.put("entryId", entryIdSet);
        return dataMap;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String entity;
        EntryGrid grid = (EntryGrid)hyperLinkClickEvent.getSource();
        String gridKey = grid.getKey();
        Object val = null;
        String entityKey = null;
        String property = hyperLinkClickEvent.getFieldName();
        String sou = this.getPageCache().get(SOURCE_ENTITY_KEY);
        String string = entity = "1".equals(sou) ? "pur_instock" : "pur_receipt";
        if (HEAD_ENTRY_ENTITY.equals(gridKey)) {
            val = grid.getModel().getValue(property);
            if ("billno".equals(property)) {
                entityKey = entity;
            }
            this.showBillForm(val, entityKey);
        } else if (DETAIL_ENTRY_ENTITY.equals(gridKey)) {
            val = grid.getModel().getValue(property);
            if ("billno1".equals(property)) {
                entityKey = entity;
            } else if ("pobillno1".equals(property)) {
                entityKey = "pur_order";
            }
            this.showBillForm(val, entityKey);
        }
    }

    public void showBillForm(Object val, String entityKey) {
        if (val == null || entityKey == null || entityKey.isEmpty()) {
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("billno", val);
        DynamicObject dynaObject = ORMUtil.queryOneByPro((String)entityKey, (String)"id,billno", param);
        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)entityKey, (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)((Long)dynaObject.getPkValue()), new HashMap(), null));
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "baritemap1": {
                Long returnreqId;
                QFilter idfilter;
                String selectProperties;
                DynamicObject malReturnReqDyn;
                FormShowParameter showParameter = this.getView().getFormShowParameter();
                String source = (String)showParameter.getCustomParam(SOURCE_ENTITY_KEY);
                if ("mall".equals(source) && (malReturnReqDyn = QueryServiceHelper.queryOne((String)"mal_returnreq", (String)(selectProperties = "cfmstatus,billno"), (QFilter[])new QFilter[]{idfilter = new QFilter("id", "=", (Object)(returnreqId = Long.valueOf((String)showParameter.getCustomParam("billid"))))})) != null && ReturnStatusEnum.FINISH.getVal().equals(malReturnReqDyn.getString("cfmstatus"))) {
                    this.getView().showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u5173\u8054\u7684\u552e\u540e\u7533\u8bf7\u5355{0}{1}\u3002", (String)"PurBatchReturnPlugin_11", (String)"scm-pur-formplugin", (Object[])new Object[0]), malReturnReqDyn.getString("billno"), ResManager.loadKDString((String)"\u786e\u8ba4\u72b6\u6001\u4e3a\u5df2\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u4e0b\u63a8\u3002", (String)"PurBatchReturnPlugin_12", (String)"scm-pur-formplugin", (Object[])new Object[0])));
                    evt.setCancel(true);
                    return;
                }
                EntryGrid grid = (EntryGrid)this.getView().getControl(HEAD_ENTRY_ENTITY);
                int[] selectRows = grid.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u6570\u636e\u624d\u80fd\u6267\u884c\u4e0b\u63a8\u9000\u8d27\u3002", (String)"PurBatchReturnPlugin_2", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
                IDataModel model = this.getModel();
                boolean zeroFlag = true;
                DynamicObjectCollection entryCols = model.getEntryEntity(DETAIL_ENTRY_ENTITY);
                for (DynamicObject check : entryCols) {
                    if (BigDecimal.ZERO.compareTo(check.getBigDecimal("receiveqty1")) >= 0) continue;
                    zeroFlag = false;
                }
                if (zeroFlag) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u68c0\u6d4b\u53d1\u73b0\u9009\u62e9\u7684\u884c\u672a\u586b\u5199\u9000\u8d27\u6570\u91cf\uff0c\u65e0\u9700\u751f\u6210\u9000\u8d27\u5355\u3002", (String)"PurBatchReturnPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
                botpRule.setLength(0);
                String billType = this.assembleSourceEntityKey();
                if ("pur_instock".equals(billType)) {
                    botpRule.append(this.getBotpRule("inware"));
                } else {
                    botpRule.append(this.getBotpRule("receive"));
                }
                String receiveRules = botpRule.toString();
                if (!StringUtils.isEmpty((String)receiveRules) && !"[]".equals(receiveRules)) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"PurBatchReturnPlugin_4", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "baritemap": {
                this.openQueryFilterPage(new HashMap());
                this.getView().setEnable(Boolean.TRUE, new String[]{DETAIL_ENTRY_ENTITY});
                this.getPageCache().remove("fromsource");
                break;
            }
            case "baritemap1": {
                JSONArray list;
                try {
                    String receiveRules = botpRule.toString();
                    JacksonJsonUtil.fromJson((String)receiveRules, List.class);
                    list = JSONArray.fromObject((Object)receiveRules);
                }
                catch (Exception e) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"PurBatchReturnPlugin_4", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (list == null || list.size() <= 0) break;
                Object errorMsg = ((JSONObject)list.get(0)).get("error");
                if (errorMsg != null && !StringUtils.isEmpty((String)String.valueOf(errorMsg))) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"PurBatchReturnPlugin_4", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    return;
                }
                String billType = this.assembleSourceEntityKey();
                if ("pur_instock".equals(billType)) {
                    this.openBotpListPage((List<Object>)list, "inware");
                    break;
                }
                this.openBotpListPage((List<Object>)list, "receive");
                break;
            }
            case "baritemap2": {
                this.openReturnListPage();
            }
        }
    }

    protected void openBotpListPage(List<Object> ruleList, String toBillType) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("rules", ruleList);
        param.put("tobilltype", toBillType);
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"pur_botp_list", param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, ACTION_BOTPLIST), (ShowType)ShowType.Modal));
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        if (!nodeId.equals("0")) {
            this.getPageCache().put("isTreeNodeClick", "1");
            this.getPageCache().put("supplier", nodeId.toString());
        } else {
            this.getPageCache().remove("supplier");
        }
        this.allotDynamicData();
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        treeView.focusNode(new TreeNode("0", evt.getNodeId().toString(), ""));
        this.getPageCache().put("isTreeNodeClick", "0");
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid grid = (EntryGrid)evt.getSource();
        IDataModel model = grid.getModel();
        String entryKey = grid.getKey();
        int[] selectedIndexs = grid.getEntryState().getSelectedRows();
        switch (entryKey) {
            case "head_entryentity": {
                model.deleteEntryData(DETAIL_ENTRY_ENTITY);
                if (selectedIndexs.length <= 0) break;
                ArrayList<String> selectedRows = new ArrayList<String>(selectedIndexs.length);
                DynamicObjectCollection col = model.getEntryEntity(entryKey);
                for (int i = 0; i < selectedIndexs.length; ++i) {
                    selectedRows.add(((DynamicObject)col.get(selectedIndexs[i])).getString("billid"));
                }
                DynamicObjectCollection allEntitys = this.getModel().getEntryEntity(ALL_ENTRY_ENTITY);
                this.bindDetailEntityData(allEntitys.stream().filter(node -> selectedRows.contains(node.get("billid4"))).collect(Collectors.toList()), DETAIL_ENTRY_ENTITY, "1");
                this.sumMaterialQty(SUM_ENTRY_ENTITY, "2");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (name) {
            case "receiveqty1": {
                BigDecimal qty1 = (BigDecimal)this.getModel().getValue("qty1", rowIndex);
                if (qty1.compareTo((BigDecimal)newValue) >= 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9000\u8d27\u6570\u91cf\u5927\u4e8e\u53d1\u8d27\u6570\u91cf\uff0c\u4e0d\u80fd\u9000\u8d27\u54e6\u3002", (String)"PurBatchReturnPlugin_5", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(name, (Object)0, rowIndex);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "queryfilter": {
                if (returnData == null) break;
                IPageCache cache = this.getPageCache();
                Map map = returnData instanceof Map ? (Map)returnData : new HashMap();
                for (Map.Entry entry : map.entrySet()) {
                    cache.put((String)entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
                }
                this.allotDynamicData();
                this.getPageCache().remove("supplier");
                break;
            }
            case "botpList": {
                if (returnData == null) break;
                Map result = (Map)returnData;
                Object ruleNumber = result.get("rule");
                if (ruleNumber == null) {
                    return;
                }
                Object toBillType = result.get("tobilltype");
                if ("inware".equals(toBillType)) {
                    this.toInware(String.valueOf(ruleNumber));
                    break;
                }
                if (!"receive".equals(toBillType)) break;
                this.toRecive(String.valueOf(ruleNumber));
                break;
            }
        }
    }

    public void toInware(String botpNumber) {
        Map<String, Object> billInfoMap = this.getBillInfo();
        if (billInfoMap.size() > 0) {
            billInfoMap.put("botpNumber", botpNumber);
            billInfoMap.put(SOURCE_ENTITY_KEY, "batchReturn");
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("tobilltype", "inware");
            param.put("billtype", "pur_outstock");
            param.put("data", billInfoMap);
            param.put("action", TO_INWARE);
            param.put("code", "200");
            String msg = ApiUtil.purSaloutToInware(param);
            this.handleResult(msg);
        }
    }

    public void toRecive(String botpNumber) {
        Map<String, Object> billInfoMap = this.getBillInfo();
        if (billInfoMap.size() > 0) {
            billInfoMap.put("botpNumber", botpNumber);
            billInfoMap.put(SOURCE_ENTITY_KEY, "batchReturn");
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("tobilltype", "receive");
            param.put("billtype", "pur_outstock");
            param.put("data", billInfoMap);
            param.put("action", TO_RECEIVE);
            param.put("code", "200");
            String msg = ApiUtil.purSaloutToRec(param);
            this.handleResult(msg);
        }
    }

    public void handleResult(String msg) {
        if (msg == null) {
            return;
        }
        try {
            Map map = (Map)JacksonJsonUtil.fromJson((String)msg, Map.class);
            this.dealDataByMsg(map, DETAIL_ENTRY_ENTITY, "1");
            this.dealDataByMsg(map, ALL_ENTRY_ENTITY, SUFFIX_ALL);
            String source = this.getPageCache().get("fromsource");
            if (null != source && source.equals("mall")) {
                this.writeBackMalReturnReq(map, DETAIL_ENTRY_ENTITY, "1");
            }
        }
        catch (Exception e) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e{0}{1}\u3002", (String)"PurBatchReturnPlugin_6", (String)"scm-pur-formplugin", (Object[])new Object[0]), "==>", msg));
        }
    }

    private void writeBackMalReturnReq(Map<String, Object> map, String entryKey, String index) {
        String mallReturnReqId;
        DynamicObject malReturnReqDyn;
        IDataModel model = this.getModel();
        DynamicObjectCollection cols = model.getEntryEntity(entryKey);
        StringBuilder msgSB = new StringBuilder();
        for (int i = 0; i < cols.size(); ++i) {
            DynamicObject col = (DynamicObject)cols.get(i);
            Long srcEntryId = col.getLong("entryid" + index);
            String srcEntryIdStr = String.valueOf(srcEntryId);
            String errorMsg = null;
            Object billNumber = null;
            Map msgMap = (Map)map.get(srcEntryIdStr);
            if (msgMap != null) {
                errorMsg = String.valueOf(msgMap.get("error"));
            }
            if (errorMsg == null || errorMsg.length() == 0 || msgSB.toString().contains(errorMsg)) continue;
            msgSB.append(errorMsg).append(";\n");
        }
        if (msgSB.length() == 0 && null != (malReturnReqDyn = BusinessDataServiceHelper.loadSingle((Object)(mallReturnReqId = (String)this.getView().getFormShowParameter().getCustomParam("billid")), (String)"mal_returnreq"))) {
            malReturnReqDyn.set("cfmstatus", (Object)ReturnStatusEnum.FINISH.getVal());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{malReturnReqDyn});
        }
    }

    public void dealDataByMsg(Map<String, Object> map, String entryKey, String index) {
        IDataModel model = this.getModel();
        DynamicObjectCollection cols = model.getEntryEntity(entryKey);
        StringBuilder msgSB = new StringBuilder();
        String srcEntryIdStr = null;
        for (int i = 0; i < cols.size(); ++i) {
            DynamicObject col = (DynamicObject)cols.get(i);
            Long srcEntryId = col.getLong("entryid" + index);
            srcEntryIdStr = String.valueOf(srcEntryId);
            String errorMsg = null;
            Object billNumber = null;
            Map msgMap = (Map)map.get(srcEntryIdStr);
            if (msgMap != null) {
                errorMsg = String.valueOf(msgMap.get("error"));
                billNumber = msgMap.get("billnumber");
                model.setValue("tobillno" + index, billNumber, i);
                if (TO_RECEIVE.equals(msgMap.get("billtype"))) {
                    model.setValue("tobilltype" + index, (Object)ResManager.loadKDString((String)"\u6536\u8d27\u5355", (String)"PurBatchReturnPlugin_7", (String)"scm-pur-formplugin", (Object[])new Object[0]), i);
                } else if (TO_INWARE.equals(msgMap.get("billtype"))) {
                    model.setValue("tobilltype" + index, (Object)ResManager.loadKDString((String)"\u5165\u5e93\u5355", (String)"PurBatchReturnPlugin_8", (String)"scm-pur-formplugin", (Object[])new Object[0]), i);
                }
                model.setValue("tobillstatus" + index, msgMap.get("billstatus"), i);
            }
            if (errorMsg != null && errorMsg.length() != 0) {
                model.setValue("reason" + index, (Object)errorMsg, i);
                if (msgSB.toString().contains(errorMsg)) continue;
                if (billNumber != null && !msgSB.toString().contains(billNumber.toString())) {
                    msgSB.append(billNumber);
                }
                msgSB.append(errorMsg).append(";\n");
                continue;
            }
            model.setValue("reason" + index, null, i);
        }
        if (SUFFIX_ALL.equals(index)) {
            return;
        }
        IFormView view = this.getView();
        if (msgSB.length() == 0) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u6210\u529f\u3002", (String)"PurBatchReturnPlugin_9", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        } else {
            view.showMessage(ResManager.loadKDString((String)"\u751f\u6210\u5355\u636e\u5931\u8d25\u3002", (String)"PurBatchReturnPlugin_10", (String)"scm-pur-formplugin", (Object[])new Object[0]), msgSB.toString(), MessageTypes.Default);
        }
    }

    public Map<String, Object> getBillInfo() {
        List<DynamicObject> entryList = this.getSelectedData(DETAIL_ENTRY_ENTITY);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        for (DynamicObject entry : entryList) {
            HashMap<String, Object> detailMap = new HashMap<String, Object>();
            Object srcEntryId = entry.get("srcentryid1");
            if (srcEntryId == null || srcEntryId.toString().trim().isEmpty()) continue;
            Object tobillstatus = entry.get("tobillstatus1");
            if ("3".equals(tobillstatus)) {
                // empty if block
            }
            for (String property : VALID_PRO) {
                Object val = entry.get(property + "1");
                if (null == val) {
                    detailMap.put(property, "");
                    continue;
                }
                if (val instanceof DynamicObject) {
                    Object number = DynamicObjectUtil.getBDNumberOfValue((DynamicObject)((DynamicObject)val));
                    detailMap.put(property, number);
                    continue;
                }
                detailMap.put(property, val);
            }
            BigDecimal recieveQty = CommonUtil.getBigDecimalPro((Object)entry.get("receiveqty1"));
            String entryIdStr = entry.getString("entryid1");
            String billIdStr = entry.getString("billid1");
            detailMap.put("entryId", srcEntryId);
            detailMap.put("billid", entry.get("srcbillid1"));
            detailMap.put("qty", recieveQty.multiply(new BigDecimal("-1")));
            detailMap.put("srcEntryId", entryIdStr);
            detailMap.put("srcBillId", billIdStr);
            dataMap.put(entryIdStr, detailMap);
            Long entryId = Long.valueOf(entryIdStr);
            Long l = Long.valueOf(billIdStr);
        }
        return this.groupDataBySrcBillId(dataMap);
    }

    public Map<String, Object> groupDataBySrcBillId(Map<String, Object> dataMap) {
        HashMap<String, Object> groupedData = new HashMap<String, Object>();
        dataMap.forEach((key, val) -> {
            Map data = (Map)val;
            String srcBillId = String.valueOf(data.get("srcBillId"));
            ArrayList<Map> list = (ArrayList<Map>)groupedData.get(srcBillId);
            if (list == null) {
                list = new ArrayList<Map>();
            }
            list.add(data);
            groupedData.put(srcBillId, list);
        });
        return groupedData;
    }

    private void clearData() {
        IDataModel model = this.getModel();
        model.deleteEntryData(SUM_ENTRY_ENTITY);
        model.deleteEntryData(ALL_ENTRY_ENTITY);
        model.deleteEntryData(DETAIL_ENTRY_ENTITY);
        model.deleteEntryData(HEAD_ENTRY_ENTITY);
    }

    public static class SumMaterailInfo {
        private String key;
        private long materialId;
        private long unitId;
        private List<BigDecimal> qtyList = new ArrayList<BigDecimal>();
        private List<BigDecimal> receiveQtyList = new ArrayList<BigDecimal>();

        public SumMaterailInfo setKey(String key) {
            this.key = key;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public long getMaterialId() {
            return this.materialId;
        }

        public SumMaterailInfo setMaterialId(long materialId) {
            this.materialId = materialId;
            return this;
        }

        public long getUnitId() {
            return this.unitId;
        }

        public SumMaterailInfo setUnitId(long unitId) {
            this.unitId = unitId;
            return this;
        }

        public BigDecimal getQty() {
            BigDecimal sumQty = BigDecimal.ZERO;
            for (BigDecimal qty : this.qtyList) {
                sumQty = sumQty.add(qty);
            }
            return sumQty;
        }

        public SumMaterailInfo addQty(BigDecimal qty) {
            this.qtyList.add(qty);
            return this;
        }

        public BigDecimal getReceiveQty() {
            BigDecimal sumReceiveQty = BigDecimal.ZERO;
            for (BigDecimal qty : this.receiveQtyList) {
                sumReceiveQty = sumReceiveQty.add(qty);
            }
            return sumReceiveQty;
        }

        public SumMaterailInfo addReceiveQty(BigDecimal receiveQty) {
            this.receiveQtyList.add(receiveQty);
            return this;
        }
    }
}

