/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.pur.common.blueprintshare.PurBluePrintBizHelper;

public class PurBluePrintPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
UploadListener {
    private static final Log log = LogFactory.getLog(PurBluePrintPlugin.class);

    public void registerListener(EventObject e) {
        try {
            super.registerListener(e);
            BasedataEdit contact = (BasedataEdit)this.getControl("contact");
            if (contact != null) {
                contact.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
            Toolbar toolbar = (Toolbar)this.getControl("tbmain");
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u51fa\u9519\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PurBluePrintPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        try {
            String fieldName = beforeF7SelectEvent.getProperty().getName();
            int row = beforeF7SelectEvent.getRow();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            if (fieldName.equals("contact")) {
                this.setContactFilter(beforeF7SelectEvent, dataEntity, row);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u51fa\u9519\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PurBluePrintPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        try {
            String filedName = e.getProperty().getName();
            IDataModel model = this.getModel();
            ChangeData changeData = e.getChangeSet()[0];
            switch (filedName) {
                case "supplier": {
                    this.supplierValueChange(changeData, model);
                    break;
                }
                case "version": {
                    this.versionValueChange(changeData, model);
                    break;
                }
                case "materiel": {
                    this.materielValueChange(changeData, model);
                }
            }
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u51fa\u9519\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PurBluePrintPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    private void setContactFilter(BeforeF7SelectEvent beforeF7SelectEvent, DynamicObject dataEntity, int row) {
        DynamicObject supplier = ((DynamicObject)dataEntity.getDynamicObjectCollection("supplierentry").get(row)).getDynamicObject("supplier");
        if (supplier == null) {
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        Long bizPartnerId = supplier.getLong("bizpartner_id");
        beforeF7SelectEvent.getCustomQFilters().add(new QFilter("bizpartner", "=", (Object)bizPartnerId));
    }

    private void materielValueChange(ChangeData changeData, IDataModel model) {
        DynamicObject org = (DynamicObject)model.getValue("createorg");
        DynamicObject materiel = (DynamicObject)changeData.getNewValue();
        String version = (String)model.getValue("version");
        if (version == null || org == null || materiel == null) {
            model.setValue("islatestversion", (Object)false);
            return;
        }
        Long createOrgId = (Long)org.getPkValue();
        Long materielId = (Long)materiel.getPkValue();
        if (createOrgId == null || materielId == null) {
            model.setValue("islatestversion", (Object)false);
            return;
        }
        Boolean isLatestVersion = PurBluePrintBizHelper.isLatestVersion((String)version, (Long)createOrgId, (Long)materielId);
        model.setValue("islatestversion", (Object)isLatestVersion);
    }

    private void versionValueChange(ChangeData changeData, IDataModel model) {
        DynamicObject org = (DynamicObject)model.getValue("createorg");
        DynamicObject materiel = (DynamicObject)model.getValue("materiel");
        if (materiel == null || org == null) {
            model.setValue("islatestversion", (Object)false);
            return;
        }
        String version = (String)changeData.getNewValue();
        Long createOrgId = (Long)org.getPkValue();
        Long materielId = (Long)materiel.getPkValue();
        if (createOrgId == null || materielId == null) {
            model.setValue("islatestversion", (Object)false);
            return;
        }
        Boolean isLatestVersion = PurBluePrintBizHelper.isLatestVersion((String)version, (Long)createOrgId, (Long)materielId);
        model.setValue("islatestversion", (Object)isLatestVersion);
    }

    private void supplierValueChange(ChangeData changeData, IDataModel model) {
        int rowIndex = changeData.getRowIndex();
        DynamicObject supplier = (DynamicObject)changeData.getNewValue();
        if (supplier == null) {
            return;
        }
        Long bizPartnerId = supplier.getLong("bizpartner.id");
        model.setValue("bizpartner", (Object)bizPartnerId, rowIndex);
        HashSet<Long> bizpartnerIdSet = new HashSet<Long>();
        bizpartnerIdSet.add(bizPartnerId);
        Map adminSupUserId = BizPartnerUtil.getEnableAdminSupplierUserIdsMapByBizPartner(bizpartnerIdSet);
        List supplierUserIds = (List)adminSupUserId.get(bizPartnerId);
        if (supplierUserIds == null || supplierUserIds.isEmpty()) {
            model.setValue("contact", null, rowIndex);
            model.setValue("phonenumber", null, rowIndex);
            return;
        }
        Long supplierUserId = (Long)supplierUserIds.get(0);
        model.setValue("contact", (Object)supplierUserId, rowIndex);
        DynamicObject contact = (DynamicObject)model.getValue("contact", rowIndex);
        if (contact == null) {
            model.setValue("phonenumber", null, rowIndex);
            return;
        }
        model.setValue("phonenumber", contact.get("number"), rowIndex);
    }
}

