/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.scm.common.checkmapping.PurCheckMappingFieldProp;
import kd.scm.common.checkmapping.PurCheckMappingUtils;

public final class PurCheckBillMappingPlugin
extends AbstractFormPlugin {
    private static final String PURCHECKBILLMAPPING = "pur_check_mapping_%S_%S";
    private List<String> fixedEntryKey = Arrays.asList("curr", "settleorg", "supplier", "intaxamount", "deducttaxamount", "taxtype3", "businesstype_in3", "material3", "pobillid3", "entryid3", "billid3", "poentryid3", "actbillno3", "invorg3", "entrypurorg3", "purorg3", "loccurr3", "exchrate3", "tax3", "amount3", "dctamount3", "dctrate3", "price3", "warehouse3", "curr3", "ispresent3", "taxrate3", "taxrateid3", "taxprice3", "cfmqty3", "unmatchqty3", "cfmamt3", "materialdesc3", "goods3", "materialname3", "srcentryid3", "srcbillid3", "discounttype3", "qty3", "pobillno3", "taxamount3", "sourcebill3", "billdate3", "outbillno3", "pcbillno3", "billno3", "inputamount3", "unit3", "linetype3", "unmatchtaxamount3", "remark3");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"targetobjcolno", "sourcebillcolno", "formuladesc"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        model.beginInit();
        IFormView view = this.getView();
        this.initFixedData(model);
        model.endInit();
        view.updateView();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        List targetFieldPropFixeds = PurCheckMappingUtils.getPurCheckMappingFieldProps(new ArrayList(8), (Boolean)false, (Boolean)true);
        String targetFixedPropsCacheKey = String.format(PURCHECKBILLMAPPING, "colsmap", this.getView().getPageId());
        this.getPageCache().put(targetFixedPropsCacheKey, JSON.toJSONString((Object)targetFieldPropFixeds));
        DynamicObject source = model.getDataEntity().getDynamicObject("sourcebill");
        if (source == null) {
            return;
        }
        String entityKey = source.getString("number");
        FormMetadata formmeta = PurCheckMappingUtils.getFormMetaData((String)entityKey);
        if (formmeta == null) {
            return;
        }
        this.setSourceFieldPropCache(formmeta, "sourceBillCol");
        this.setSourceEntrykey(view, model, formmeta);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (key) {
            case "sourcebill": 
            case "sourceentrykey": {
                DynamicObject source = model.getDataEntity().getDynamicObject("sourcebill");
                if (source == null) {
                    view.getModel().setValue("sourceentrykey", null);
                    return;
                }
                String entityKey = source.getString("number");
                FormMetadata formmeta = PurCheckMappingUtils.getFormMetaData((String)entityKey);
                if (formmeta == null) {
                    return;
                }
                this.setSourceFieldPropCache(formmeta, "sourceBillCol");
                if (!"sourcebill".equals(key)) break;
                this.setSourceEntrykey(view, model, formmeta);
                this.clearSourceBill(view, model);
                break;
            }
            case "sourcebillcolno": {
                this.doClearSourceFieldValue("sourcebillcol", e.getChangeSet());
                break;
            }
            case "targetobjcolno": {
                this.doClearSourceFieldValue("targetobjcol", e.getChangeSet());
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        Control ctlSource = (Control)evt.getSource();
        switch (key = ctlSource.getKey()) {
            case "sourcebillcolno": {
                this.clickSourceBillCol(key, "colsmap", "targetobjcol");
                break;
            }
            case "targetobjcolno": {
                this.clickTargetFixedBillCol(key, "colsmap");
                break;
            }
            case "formuladesc": {
                this.clickFormuladesc(key, "colsmap");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        switch (actionId = e.getActionId()) {
            case "colsmap_sourcebillcol_callback": {
                this.callBackSourcebillcol(e);
                break;
            }
            case "colsmap_targetbillcol_callback": {
                this.callBackSourcebillcol(e);
                break;
            }
            case "colsmap_formula_callback": {
                this.callBackFormula(e);
                break;
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        int[] rowIndexs = e.getRowIndexs();
        Map varMap = e.getVarMap();
        if (varMap == null) {
            return;
        }
        Object entryPropName = varMap.get("entryProp.name");
        if ("colsmap".equals(entryPropName)) {
            StringBuilder sb = new StringBuilder();
            for (int rowIndex : rowIndexs) {
                Boolean ispresit = (Boolean)this.getModel().getValue("ispresit", rowIndex);
                if (!ispresit.booleanValue()) continue;
                sb.append(rowIndex + 1).append(",");
            }
            if (sb != null && sb.length() > 0) {
                StringBuilder deleteCharAt = sb.deleteCharAt(sb.length() - 1);
                String message = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6570\u636e\u4e3a\u9884\u7f6e\u884c\u4e0d\u80fd\u5220\u9664\u3002", (String)"PurCheckBillMappingPlugin_6", (String)"scm-pur-formplugin", (Object[])new Object[]{deleteCharAt.toString(), new Object[0]});
                this.getView().showTipNotification(message);
                e.setCancel(true);
            }
        }
    }

    private void callBackSourcebillcol(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        Object returnData = e.getReturnData();
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            if ("colsmap_sourcebillcol_callback".equals(e.getActionId())) {
                String entityKey = "colsmap";
                this.setSourceObjCol(entityKey, model, data);
            } else if ("colsmap_targetbillcol_callback".equals(e.getActionId())) {
                String entityKey = "colsmap";
                this.setTargetObjCol(entityKey, model, data);
            }
        }
    }

    private void setSourceObjCol(String entityKey, IDataModel model, Map<String, Object> data) {
        List<PurCheckMappingFieldProp> sourceFieldProp = this.getCacheFieldProp("sourceBillCol");
        Integer row = (Integer)Optional.ofNullable(data.get("$row")).orElse(0);
        Object keyObj = data.get("key");
        if (keyObj == null) {
            return;
        }
        String key = (String)keyObj;
        Optional<PurCheckMappingFieldProp> findFirst = sourceFieldProp.stream().filter(f -> key.equals(f.getSourcebillcol())).findFirst();
        if (!findFirst.isPresent()) {
            return;
        }
        PurCheckMappingFieldProp fieldProp = findFirst.get();
        model.setValue("sourcebillcol", (Object)fieldProp.getSourcebillcol(), row.intValue());
        model.setValue("sourcebillcolno", (Object)fieldProp.getSourcebillcolno(), row.intValue());
        this.getView().updateView(entityKey, row.intValue());
    }

    private void setTargetObjCol(String entityKey, IDataModel model, Map<String, Object> data) {
        List<PurCheckMappingFieldProp> tarFieldProp = this.getCacheFieldProp(entityKey);
        Integer row = (Integer)Optional.ofNullable(data.get("$row")).orElse(0);
        Object keyObj = data.get("key");
        if (keyObj == null) {
            return;
        }
        String key = (String)keyObj;
        Optional<PurCheckMappingFieldProp> findFirst = tarFieldProp.stream().filter(f -> key.equals(f.getTargetobjcol())).findFirst();
        if (!findFirst.isPresent()) {
            return;
        }
        PurCheckMappingFieldProp fieldProp = findFirst.get();
        model.setValue("targetobjcol", (Object)fieldProp.getTargetobjcol(), row.intValue());
        model.setValue("targetobjcolno", (Object)fieldProp.getTargetobjcolno(), row.intValue());
        model.setValue("ispresit", (Object)false, row.intValue());
        this.getView().updateView(entityKey, row.intValue());
    }

    private void callBackFormula(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData != null) {
            CRCondition formula = (CRCondition)SerializationUtils.fromJsonString((String)returnData.toString(), CRCondition.class);
            if ("colsmap_formula_callback".equals(e.getActionId())) {
                int row = this.getModel().getEntryCurrentRowIndex("colsmap");
                if (formula != null) {
                    this.getModel().setValue("formula_tag", (Object)returnData.toString());
                    this.getModel().setValue("formuladesc", (Object)formula.getExprDesc(), row);
                    this.getView().updateView("colsmap", row);
                }
            }
        }
    }

    private void setSourceEntrykey(IFormView view, IDataModel model, FormMetadata formmeta) {
        List entityAps = PurCheckMappingUtils.getEntityAp((FormMetadata)formmeta);
        if (entityAps == null) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)view.getControl("sourceentrykey");
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(8);
        for (PurCheckMappingFieldProp entry : entityAps) {
            String key = entry.getSourcebillcol();
            String value = entry.getSourcebillcolno();
            ComboItem comboItem = new ComboItem(new LocaleString(value + "(" + key + ")"), key);
            list.add(comboItem);
        }
        comboEdit.setComboItems(list);
        String sourceentrykey = view.getModel().getDataEntity().getString("sourceentrykey");
        if (StringUtils.isNotEmpty((String)sourceentrykey)) {
            view.getModel().setValue("sourceentrykey", (Object)sourceentrykey);
        } else {
            view.getModel().setValue("sourceentrykey", (Object)((PurCheckMappingFieldProp)entityAps.get(0)).getSourcebillcol());
        }
    }

    private List<PurCheckMappingFieldProp> getCacheFieldProp(String preKey) {
        String cacheKey = String.format(PURCHECKBILLMAPPING, preKey, this.getView().getPageId());
        String cacheValue = this.getPageCache().get(cacheKey);
        List fieldProps = JSONArray.parseArray((String)cacheValue, PurCheckMappingFieldProp.class);
        return fieldProps;
    }

    private void setSourceFieldPropCache(FormMetadata formmeta, String preKey) {
        IDataModel model = this.getModel();
        ArrayList fieldProps = new ArrayList(8);
        PurCheckMappingUtils.getBillProkey((FormMetadata)formmeta, fieldProps, (Boolean)false);
        String sourceentrykey = model.getDataEntity().getString("sourceentrykey");
        String materialEntryKey = StringUtils.isEmpty((String)sourceentrykey) ? "materialentry" : sourceentrykey;
        Map materialentry = PurCheckMappingUtils.getProEntitykey((FormMetadata)formmeta, (String)materialEntryKey);
        PurCheckMappingUtils.getProItemMap((Map)materialentry, fieldProps, new ArrayList(8), (Boolean)false, (Boolean)false);
        String cacheKey = String.format(PURCHECKBILLMAPPING, preKey, this.getView().getPageId());
        this.getPageCache().remove(cacheKey);
        this.getPageCache().put(cacheKey, JSON.toJSONString(fieldProps));
    }

    private void clickFormuladesc(String fieldKey, String purCheckBillEntryKey) {
        int row = this.getModel().getEntryCurrentRowIndex(purCheckBillEntryKey);
        DynamicObject sourceDyc = (DynamicObject)this.getModel().getValue("sourcebill");
        if (sourceDyc == null) {
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u6765\u6e90\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u5355\u636e\u3002", (String)"PurCheckBillMappingPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        String sourcebillEntityName = sourceDyc.getString("number");
        IPageCache pageCache = this.getPageCache();
        IFormView view = this.getView();
        PurCheckMappingUtils.showForm((AbstractFormPlugin)this, (IFormView)view, (IPageCache)pageCache, (String)sourcebillEntityName, (String)purCheckBillEntryKey, (int)row);
    }

    private void doClearSourceFieldValue(String key, ChangeData[] changeDatas) {
        for (ChangeData changeData : changeDatas) {
            Object newValue = changeData.getNewValue();
            if (newValue != null && !StringUtils.isEmpty((String)changeData.getNewValue().toString())) continue;
            this.getModel().setValue(key, null, changeData.getRowIndex());
        }
    }

    private void clickSourceBillCol(String key, String entryKey, String targetobjcol) {
        int index;
        DynamicObject source = this.getModel().getDataEntity().getDynamicObject("sourcebill");
        if (source == null) {
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u6765\u6e90\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u5355\u636e\u3002", (String)"PurCheckBillMappingPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        List<PurCheckMappingFieldProp> sourceFieldProp = this.getCacheFieldProp("sourceBillCol");
        if (CollectionUtils.isEmpty(sourceFieldProp)) {
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u6765\u6e90\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u5355\u636e\u3002", (String)"PurCheckBillMappingPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        IDataModel model = this.getModel();
        String prop = (String)model.getValue(targetobjcol, index = model.getEntryCurrentRowIndex(entryKey));
        if (StringUtils.isEmpty((String)prop)) {
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u884c\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u540d\u79f0\u3002", (String)"PurCheckBillMappingPlugin_1", (String)"scm-pur-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        ArrayList<String> excludeKeys = new ArrayList<String>(8);
        this.showSelectFieldForm(sourceFieldProp, excludeKeys, entryKey + "_sourcebillcol_callback", index, "source");
    }

    private void clickTargetFixedBillCol(String key, String entryKey) {
        List<PurCheckMappingFieldProp> fieldProp = this.getCacheFieldProp(entryKey);
        if (CollectionUtils.isEmpty(fieldProp)) {
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u76ee\u6807\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PurCheckBillMappingPlugin_4", (String)"scm-pur-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex(entryKey);
        ArrayList<String> excludeKeys = new ArrayList<String>(8);
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection colsmapCol = dataEntity.getDynamicObjectCollection("colsmap");
        for (DynamicObject dy : colsmapCol) {
            String targetobjcolno = dy.getString("targetobjcol");
            excludeKeys.add(targetobjcolno);
        }
        this.showSelectFieldForm(fieldProp, excludeKeys, entryKey + "_targetbillcol_callback", index, "target");
    }

    private void showSelectFieldForm(List<PurCheckMappingFieldProp> fieldProps, List<String> excludeKeys, String callback, Integer row, String source) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pbd_select_prop");
        String nodesJson = PurCheckBillMappingPlugin.bulidNodesJson(fieldProps, source, excludeKeys, "id");
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getCustomParams().put("$row", row);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callback));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public static String bulidNodesJson(List<PurCheckMappingFieldProp> fieldProps, String source, List<String> excludeKeys, String key) {
        String billKDString = ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u5217\u8868", (String)"PurCheckBillMappingPlugin_5", (String)"scm-pur-formplugin", (Object[])new Object[0]);
        TreeNode treeNode = new TreeNode("", "bill", billKDString, true);
        ArrayList<Object> pkIds = new ArrayList<Object>(8);
        for (PurCheckMappingFieldProp prop : fieldProps) {
            if ("source".equals(source)) {
                if (!CollectionUtils.isEmpty(excludeKeys) && excludeKeys.contains(prop.getSourcebillcol())) continue;
                PurCheckBillMappingPlugin.buildSourceTree(fieldProps, excludeKeys, treeNode, pkIds, prop, key);
                continue;
            }
            if (!CollectionUtils.isEmpty(excludeKeys) && excludeKeys.contains(prop.getTargetobjcol())) continue;
            PurCheckBillMappingPlugin.buildTargetTree(fieldProps, excludeKeys, treeNode, pkIds, prop, key);
        }
        String nodesJson = SerializationUtils.toJsonString((Object)treeNode);
        return nodesJson;
    }

    private static void buildSourceTree(List<PurCheckMappingFieldProp> fieldProps, List<String> excludeKeys, TreeNode treeNode, List<Object> pkIds, PurCheckMappingFieldProp prop, String key) {
        TreeNode parentNode = new TreeNode("bill", prop.getSourcebillcol(), prop.getSourcebillcolno() + "(" + prop.getSourcebillcol() + ")");
        treeNode.addChild(parentNode);
    }

    private static void buildTargetTree(List<PurCheckMappingFieldProp> fieldProps, List<String> excludeKeys, TreeNode treeNode, List<Object> pkIds, PurCheckMappingFieldProp prop, String key) {
        TreeNode parentNode = new TreeNode("bill", prop.getTargetobjcol(), prop.getTargetobjcolno() + "(" + prop.getTargetobjcol() + ")");
        treeNode.addChild(parentNode);
    }

    private void clearSourceBill(IFormView view, IDataModel model) {
        model.beginInit();
        DynamicObjectCollection closMap = model.getEntryEntity("colsmap");
        if (!closMap.isEmpty()) {
            for (int i = 0; i < closMap.size(); ++i) {
                model.setValue("sourcebillcolno", null, i);
                model.setValue("sourcebillcol", null, i);
                model.setValue("formuladesc", null, i);
            }
        }
        model.endInit();
        view.updateView("colsmap");
    }

    private void initFixedData(IDataModel model) {
        List fieldProps = PurCheckMappingUtils.getPurCheckMappingFieldProps(this.fixedEntryKey, (Boolean)true, (Boolean)true);
        model.deleteEntryData("colsmap");
        this.createEntityProp(model, fieldProps, "colsmap");
    }

    private Map<String, Integer> createEntityProp(IDataModel model, List<PurCheckMappingFieldProp> fieldProps, String entryKey) {
        HashMap<String, Integer> entityIndexMap = new HashMap<String, Integer>(8);
        int rowIndex = 0;
        for (PurCheckMappingFieldProp fieldProp : fieldProps) {
            rowIndex = model.insertEntryRow(entryKey, rowIndex);
            model.setValue("targetobjcol", (Object)fieldProp.getTargetobjcol(), rowIndex);
            model.setValue("targetobjcolno", (Object)fieldProp.getTargetobjcolno(), rowIndex);
            model.setValue("ispresit", (Object)true, rowIndex);
        }
        return entityIndexMap;
    }
}

