/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.checkmapping.PurCheckMappingFieldProp;
import kd.scm.common.checkmapping.PurCheckMappingUtils;

public final class PurCheckGroupConfigPlugin
extends AbstractFormPlugin {
    private static final String PURCHECKBILLMAPPING = "pur_check_mapping_%S_%S";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initGroupByData();
    }

    private void initGroupByData() {
        FormMetadata targetFormmeta = PurCheckMappingUtils.getFormMetaData((String)"pur_handcheck");
        List excludeGroupField = PurCheckMappingUtils.getProQtyOrPriceEntitykey((FormMetadata)targetFormmeta);
        excludeGroupField.add("groupkey");
        excludeGroupField.add("checkstatus");
        excludeGroupField.add("datefrom");
        excludeGroupField.add("dateto");
        ArrayList<PurCheckMappingFieldProp> groupByFieldProps = new ArrayList<PurCheckMappingFieldProp>(8);
        Map sumentryentity = PurCheckMappingUtils.getProEntitykey((FormMetadata)targetFormmeta, (String)"sumentryentity");
        PurCheckMappingUtils.getProItemMap((Map)sumentryentity, groupByFieldProps, (List)excludeGroupField, (Boolean)false, (Boolean)true);
        String groupPropsCacheKey = String.format(PURCHECKBILLMAPPING, "groupBy", this.getView().getPageId());
        this.getPageCache().put(groupPropsCacheKey, JSON.toJSONString(groupByFieldProps));
        this.setGroupby(this.getView(), this.getModel(), groupByFieldProps);
    }

    private void setGroupby(IFormView view, IDataModel model, List<PurCheckMappingFieldProp> groupByFieldProps) {
        if (groupByFieldProps == null) {
            return;
        }
        MulComboEdit comboEdit = (MulComboEdit)view.getControl("groupby");
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(8);
        for (PurCheckMappingFieldProp entry : groupByFieldProps) {
            String key = entry.getTargetobjcol();
            String value = entry.getTargetobjcolno();
            ComboItem comboItem = new ComboItem(new LocaleString(value + "(" + key + ")"), key);
            list.add(comboItem);
        }
        comboEdit.setComboItems(list);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"pur_check_group_config", (String)"groupby", null, (String)"createtime desc", (int)1);
        String groupbykey = "";
        if (!CollectionUtils.isEmpty((Collection)dys)) {
            groupbykey = ((DynamicObject)dys.get(0)).getString("groupby");
        }
        if (StringUtils.isNotEmpty((String)groupbykey)) {
            model.setValue("groupby", (Object)groupbykey);
            view.updateView("groupby");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control srcCtrl = (Control)evt.getSource();
        switch (srcCtrl.getKey()) {
            case "btnok": {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                String groupby = dataEntity.getString("groupby");
                DynamicObject[] loads = BusinessDataServiceHelper.load((String)"pur_check_group_config", (String)"id,groupby,modifier,modifytime", null, (String)"createtime desc", (int)1);
                DynamicObject load = null;
                if (loads != null && loads.length > 0) {
                    load = loads[0];
                } else {
                    load = BusinessDataServiceHelper.newDynamicObject((String)"pur_check_group_config");
                    load.set("number", (Object)"defaultgroup");
                    load.set("name", (Object)"defaultgroup");
                    load.set("creator", (Object)RequestContext.get().getCurrUserId());
                    load.set("createtime", (Object)TimeServiceHelper.now());
                }
                load.set("modifier", (Object)RequestContext.get().getCurrUserId());
                load.set("modifytime", (Object)TimeServiceHelper.now());
                load.set("groupby", (Object)groupby);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{load});
                this.getView().close();
                break;
            }
        }
    }
}

