/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.BizPartnerUtil;

public class PurConsmatreialPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        Object supplier = model.getValue("supplier");
        if (null == supplier) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"supperson"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        IDataModel dataModel = this.getModel();
        IFormView formView = this.getView();
        this.addItemClickListeners(new String[]{"tbmain"});
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit supperson = (BasedataEdit)this.getControl("supperson");
        supperson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void suppersonFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
        IDataModel model = this.getModel();
        Object supplier = model.getValue("supplier");
        if (null != supplier) {
            HashSet<Long> users = new HashSet<Long>(1024);
            DynamicObject supDyn = (DynamicObject)supplier;
            Long bizPartnerBySupplier = BizPartnerUtil.getBizPartnerBySupplier((Object)supDyn.getLong("id"));
            QFilter qFilter = new QFilter("bizpartner.id", "=", (Object)bizPartnerBySupplier);
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            DynamicObjectCollection pur_supusers = QueryServiceHelper.query((String)"pur_supuser", (String)"user.id", (QFilter[])qFilter.toArray());
            for (DynamicObject supuser : pur_supusers) {
                Long userId = supuser.getLong("user.id");
                users.add(userId);
            }
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            qFilter = new QFilter("id", "in", users);
            formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
            formShowParameter.setCustomParam("externalUserType", (Object)"3");
            formShowParameter.setCustomParam("isIncludeAllSub", (Object)true);
        }
    }

    public void materialFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        HashSet<String> objectNum = new HashSet<String>(1024);
        objectNum.add("bd_material");
        objectNum.add("bd_warehouse");
        objectNum.add("bos_org");
        objectNum.add("bd_materialgroup");
        qFilter.and(new QFilter("entryentity.associationobject.id", "in", objectNum));
        DynamicObject[] msplan_plan_dimensions = BusinessDataServiceHelper.load((String)"msplan_plan_dimension", (String)"entryentity.associationobject,id", (QFilter[])qFilter.toArray());
        HashSet<Long> dimensionIdSet = new HashSet<Long>(1024);
        for (DynamicObject dyn : msplan_plan_dimensions) {
            DynamicObject[] entrys = dyn.getDynamicObjectCollection("entryentity");
            HashSet<String> associateSet = new HashSet<String>(1024);
            for (DynamicObject entry : entrys) {
                associateSet.add(entry.getDynamicObject("associationobject").getString("id"));
            }
            if (associateSet.size() == 2 && associateSet.contains("bos_org") && (associateSet.contains("bd_material") || associateSet.contains("bd_materialgroup"))) {
                dimensionIdSet.add(dyn.getLong("id"));
            }
            if (associateSet.size() != 3 || !associateSet.contains("bos_org") || !associateSet.contains("bd_warehouse") || !associateSet.contains("bd_material") && !associateSet.contains("bd_materialgroup")) continue;
            dimensionIdSet.add(dyn.getLong("id"));
        }
        qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("dimension.id", "in", dimensionIdSet));
        Date currentSystemTime = TimeServiceHelper.getCurrentSystemTime();
        qFilter.and(new QFilter("entryentity.datestart", "<", (Object)currentSystemTime));
        qFilter.and(new QFilter("entryentity.dateend", ">", (Object)currentSystemTime));
        String selectors = "number,status,enable,entryentity.bd_material";
        DynamicObject[] msplan_invlevels = BusinessDataServiceHelper.load((String)"msplan_invlevel", (String)selectors, (QFilter[])qFilter.toArray());
        HashSet<Long> maetrialIDSet = new HashSet<Long>(1024);
        for (DynamicObject dyn : msplan_invlevels) {
            DynamicObjectCollection entrys = dyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (null == entry.getDynamicObject("bd_material")) continue;
                maetrialIDSet.add(entry.getDynamicObject("bd_material").getLong("id"));
            }
        }
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", maetrialIDSet));
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("audit".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model;
        Object supplier;
        String name = e.getProperty().getName();
        if (name.equals("supplier") && null != (supplier = (model = this.getModel()).getValue("supplier"))) {
            DynamicObject supuser;
            Long userId;
            DynamicObject[] users;
            this.getModel().setValue("supperson", null);
            DynamicObject supDyn = (DynamicObject)supplier;
            Long bizPartnerBySupplier = BizPartnerUtil.getBizPartnerBySupplier((Object)supDyn.getLong("id"));
            QFilter qFilter = new QFilter("bizpartner.id", "=", (Object)bizPartnerBySupplier);
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            qFilter.and(new QFilter("isadmin", "=", (Object)"1"));
            DynamicObjectCollection pur_supusers = QueryServiceHelper.query((String)"pur_supuser", (String)"user.id", (QFilter[])qFilter.toArray());
            if (pur_supusers.size() > 0 && (users = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,number,name", (QFilter[])(qFilter = new QFilter("id", "=", (Object)(userId = Long.valueOf((supuser = (DynamicObject)pur_supusers.get(0)).getLong("user.id"))))).toArray())).length > 0) {
                this.getModel().setValue("supperson", (Object)users[0]);
            }
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"supperson"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if ("material".equals(name)) {
            this.materialFilter(beforeF7SelectEvent);
        }
        if ("supperson".equals(name)) {
            this.suppersonFilter(beforeF7SelectEvent);
        }
    }
}

