/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.scm.pur.formplugin.util.CRFormulaModel;
import kd.scm.pur.formplugin.util.FormulaHelper;

public final class PurFormulaEditPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String POINT = ".";
    private static final String FEXPRESSION = "fexpression";
    private static final String TREENODES = "treenodes";
    private static final String FORMULA = "formula";
    private static final String BTNOK = "btnok";
    private static final String BTNCANCEL = "btncancel";
    private static final String CLR = "clr";
    private static final String BACKSPACE = "backspace";
    private static final String RIGHT_BRACKETS = ")";
    private static final String LEFT_BRACKETS = "(";
    private static final String HEADNODEID = "0";
    private static final String BILLHEAD = "billhead";
    private static final String TV_FIELDS = "tv_fields";
    private static final String FTRANEXPR = "ftranexpr";
    private static final String TYPE = "type";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK, BTNCANCEL});
        this.addClickListeners(new String[]{"btnfunction", CLR, BACKSPACE});
        this.addClickListeners(new String[]{"btnadd", "btnsubtraction", "btnmultiplication", "btndivison", "btnequal", "btnnotequal", "btnlessthen", "btnmorethen", "btnlessequal", "btnmoreequal", "btnand", "btnor", "btnleft", "btnright"});
        TreeView tv = (TreeView)this.getView().getControl(TV_FIELDS);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam(FORMULA);
        FormulaHelper.initData(this.getModel(), conditonJson);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String json = (String)this.getView().getFormShowParameter().getCustomParam(TREENODES);
        if (StringUtils.isNotEmpty((String)json)) {
            FormulaHelper.fillTreeNodes(this.getView(), json);
        } else {
            FormulaHelper.addTreeRootNode(this.getView());
        }
    }

    private void clickCompareButton(String compareKey) {
        String compareValue = "";
        switch (compareKey) {
            case "btnadd": {
                compareValue = "+";
                break;
            }
            case "btnsubtraction": {
                compareValue = "-";
                break;
            }
            case "btnmultiplication": {
                compareValue = "*";
                break;
            }
            case "btndivison": {
                compareValue = "/";
                break;
            }
            case "btnequal": {
                compareValue = "=";
                break;
            }
            case "btnnotequal": {
                compareValue = "<>";
                break;
            }
            case "btnlessthen": {
                compareValue = "<";
                break;
            }
            case "btnmorethen": {
                compareValue = ">";
                break;
            }
            case "btnlessequal": {
                compareValue = "<=";
                break;
            }
            case "btnmoreequal": {
                compareValue = ">=";
                break;
            }
            case "btnand": {
                compareValue = "and";
                break;
            }
            case "btnor": {
                compareValue = "or";
                break;
            }
            case "btnleft": {
                compareValue = LEFT_BRACKETS;
                break;
            }
            case "btnright": {
                compareValue = RIGHT_BRACKETS;
                break;
            }
        }
        if (!StringUtils.isBlank((String)compareValue)) {
            FormulaHelper.insertExpression(this.getView(), compareKey, FEXPRESSION, compareValue);
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String currNodeId = (String)e.getNodeId();
        if (HEADNODEID.equals(currNodeId)) {
            currNodeId = "";
        }
        FormulaHelper.insertExpression(this.getView(), TV_FIELDS, FEXPRESSION, currNodeId);
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (BTNOK.equalsIgnoreCase(ctlSource.getKey())) {
            String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam(FORMULA);
            CRFormulaModel formulaObj = FormulaHelper.deserialize(conditonJson);
            FormulaHelper.getFormulaObj(this.getModel(), formulaObj);
            try {
                if (StringUtils.isEmpty((String)formulaObj.getExpression())) {
                    this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)formulaObj));
                    this.getView().close();
                    return;
                }
                String json = (String)this.getView().getFormShowParameter().getCustomParam(TREENODES);
                String tranExpr = FormulaHelper.tranExpression(formulaObj.getExpression(), json);
                formulaObj.getLocaleExprTran().setItem(Lang.defaultLang().toString(), (Object)tranExpr);
            }
            catch (Exception var6) {
                this.log.error((Throwable)var6);
                formulaObj.getLocaleExprTran().setItem(Lang.defaultLang().toString(), (Object)formulaObj.getExpression());
            }
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)formulaObj));
            this.getView().close();
        } else if (BTNCANCEL.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        } else if (CLR.equalsIgnoreCase(ctlSource.getKey())) {
            this.getModel().setValue(FEXPRESSION, (Object)"");
            FormulaHelper.setCursorIndex(this.getView(), FEXPRESSION, 0);
        } else if (BACKSPACE.equalsIgnoreCase(ctlSource.getKey())) {
            FormulaHelper.backSpaceExpression(this.getView(), BACKSPACE, FEXPRESSION);
        } else {
            this.clickCompareButton(ctlSource.getKey());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equalsIgnoreCase(FEXPRESSION)) {
            String expression = (String)this.getModel().getValue(FEXPRESSION);
            if (StringUtils.isEmpty((String)expression)) {
                this.getModel().setValue(FTRANEXPR, (Object)"");
                return;
            }
            String json = (String)this.getView().getFormShowParameter().getCustomParam(TREENODES);
            String tranExpr = "";
            try {
                tranExpr = FormulaHelper.tranExpression(expression, json);
            }
            catch (Exception var6) {
                this.log.error((Throwable)var6);
                tranExpr = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u89e3\u6790\u9519\u8bef\uff0c\u81ea\u52a8\u7ffb\u8bd1\u5931\u8d25\u3002", (String)"PurFormulaEditPlugin_1", (String)"scm-pur-formplugin", (Object[])new Object[0]);
            }
            this.getModel().setValue(FTRANEXPR, (Object)tranExpr);
        }
    }
}

