/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.EntryHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.ORMUtil;
import kd.scm.common.checkmapping.PurCheckMappingUtils;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MutexUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.pur.business.PurInvoiceJointHelper;
import kd.scm.pur.business.PurJointChannelHelper;
import kd.scm.pur.common.PurInvoiceUtil;
import kd.scm.pur.common.ecinvoice.service.impl.GenericEcInvoiceService;
import kd.scm.pur.formplugin.PurFilterInitListPlugin;
import kd.scm.pur.service.IPurInvoiceService;
import kd.scm.pur.servicehelper.ServiceFactory;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class PurInvoiceListPlugin
extends PurFilterInitListPlugin {
    private static final Log log = LogFactory.getLog(PurInvoiceListPlugin.class);
    private static final String GENERATE_REIMBURSE = "generatereimburse";
    private DynamicObject currentObj = null;
    public static final String PLATFORM = "platform";
    private static final String PUR_ENTRYENTITY = "entryentity1";
    private static final String SAL_ENTRYENTITY = "materialentry";
    private static final String ACTION_BOTPLIST = "botpList";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean xhConfig = PurJointChannelHelper.defaultChannelHasSpecJointSystemType((String)"self");
        this.setVisibleByJointChanel(xhConfig);
    }

    private void setVisibleByJointChanel(boolean xhConfig) {
        if (!xhConfig) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tb_itemap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tb_confirm"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tb_confirm"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tb_itemap"});
        }
    }

    private void setDisVisibleByJointChanel() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"tb_itemap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"tb_confirm"});
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        ListSelectedRowCollection listSelectedRowCollection = evt.getListSelectedRowCollection();
        Object[] primaryKeyValues = listSelectedRowCollection.getPrimaryKeyValues();
        try {
            DynamicObject billJointChannelCache = PurInvoiceJointHelper.getInvoiceJointChannelCache((Object[])primaryKeyValues);
            boolean hasDefaultJointChannel = PurJointChannelHelper.hasDefaultJointChannel((DynamicObject)billJointChannelCache, (String)"self");
            this.setVisibleByJointChanel(hasDefaultJointChannel);
        }
        catch (Exception e) {
            this.setDisVisibleByJointChanel();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u96c6\u6210\u7cfb\u7edf\u76f8\u540c\uff0c\u624d\u80fd\u540c\u65f6\u751f\u6210\u5e94\u4ed8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PurInvoiceListPlugin_24", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    public void entryHyperLinkClick(EntryHyperLinkClickEvent entryHyperLinkClickEvent) {
        super.entryHyperLinkClick(entryHyperLinkClickEvent);
        String fieldName = entryHyperLinkClickEvent.getFieldName();
        if ("checkbillno1".equals(fieldName)) {
            Object pkVal = entryHyperLinkClickEvent.getEntryPk();
            QFilter qf = new QFilter("entryentity1.id", "=", pkVal);
            DynamicObject checkObj = QueryServiceHelper.queryOne((String)"pur_invoice", (String)"id,billno,entryentity1.checkbillno1 checkbillno1", (QFilter[])new QFilter[]{qf});
            String checkBillNo = checkObj.getString(fieldName);
            QFilter qfcheck = new QFilter("billno", "=", (Object)checkBillNo);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"pur_check", (String)"id,billno", (QFilter[])new QFilter[]{qfcheck});
            if (null != dynamicObject) {
                BillShowParameter showParam = BillFormUtil.assembleShowBillFormParam((String)"pur_check", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)dynamicObject.getLong("id"), null, null);
                this.getView().showForm((FormShowParameter)showParam);
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs hyperLinkClick) {
        String fieldName = hyperLinkClick.getHyperLinkClickEvent().getFieldName();
        if ("checkbillno".equals(fieldName)) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            Object pkVal = list.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            HashMap<String, Object> idMap = new HashMap<String, Object>(1);
            idMap.put("id", pkVal);
            DynamicObject checkObj = ORMUtil.querySingleByPro((String)"pur_invoice", (String)"id,billno,checkbillno", idMap);
            String checkBillNo = checkObj.getString(fieldName);
            HashMap<String, String> billnoMap = new HashMap<String, String>(1);
            billnoMap.put("billno", checkBillNo);
            DynamicObject dynamicObject = ORMUtil.querySingleByPro((String)"pur_check", (String)"id,billno", billnoMap);
            if (null != dynamicObject) {
                BillShowParameter showParam = BillFormUtil.assembleShowBillFormParam((String)"pur_check", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)dynamicObject.getLong("id"), null, null);
                this.getView().showForm((FormShowParameter)showParam);
                hyperLinkClick.setCancel(true);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List arrayList = e.getQFilters();
        arrayList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()).and("origin", "=", (Object)"1").or("origin", "=", (Object)"2"));
    }

    public void afterCreateNewData(EventObject e) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        QFilter filter = new QFilter("supplier", "!=", (Object)0);
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setFilter(filter);
        billList.setQueryFilterParameter(filterParameter);
        billList.refresh();
        this.initButtonVisable();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("generateap".equals(operateKey)) {
            formOperate.getOption().setVariableValue("batchop_batchsize", String.valueOf(1));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey = ((AbstractOperate)e.getSource()).getOperateKey();
        IFormView view = this.getView();
        if (null != e.getOperationResult() && e.getOperationResult().isSuccess()) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            Object[] pks = list.getSelectedRows().getPrimaryKeyValues();
            if ("confirm".equals(operateKey)) {
                String message = e.getOperationResult().getMessage();
                if (message == null || message.trim().length() == 0) {
                    e.getOperationResult().setShowMessage(false);
                }
                if (pks.length == 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u6570\u636e\uff0c\u5426\u5219\u65e0\u6cd5\u4e0b\u63a8\u3002", (String)"PurInvoiceListPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    return;
                }
                String sb = this.checkStatus(pks);
                if (!sb.isEmpty()) {
                    view.showMessage(sb, String.valueOf(sb), MessageTypes.Default);
                    return;
                }
                DynamicObject[] dynamicObjs = this.getSelectObjs(pks);
                if (dynamicObjs.length == 0 && sb.length() > 0) {
                    view.showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4ee5\u751f\u6210\u5e94\u4ed8\u7684\u5355\u636e\u3002", (String)"PurInvoiceListPlugin_1", (String)"scm-pur-formplugin", (Object[])new Object[0]), String.valueOf(sb), MessageTypes.Default);
                    return;
                }
                if ("confirm".equals(operateKey)) {
                    if (dynamicObjs.length != 0 && sb.length() == 0) {
                        this.toConfirm();
                    }
                    if (dynamicObjs.length != 0 && sb.length() > 0) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u4ee5\u4e0b\u5355\u636e\u4e0d\u7b26\u5408\u89c4\u5219\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PurInvoiceListPlugin_2", (String)"scm-pur-formplugin", (Object[])new Object[0]), String.valueOf(sb), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("confirm"));
                    }
                }
            } else if ("logquery".equals(operateKey)) {
                FormShowParameter param = null;
                IListView listView = (IListView)this.getView();
                Object[] primaryKeyValues = listView.getSelectedRows().getPrimaryKeyValues();
                if (primaryKeyValues.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u540c\u65f6\u67e5\u8be2\u4e00\u6761\u6570\u636e\u7684\u7269\u6d41\u4fe1\u606f\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PurInvoiceListPlugin_23", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    return;
                }
                String entryId = listView.getBillFormId();
                HashMap<String, Object> customFilter = new HashMap<String, Object>();
                customFilter.put("pkidcoll", primaryKeyValues);
                customFilter.put("ENTRY_KEY", entryId);
                boolean hasThirdSupplier = false;
                boolean hasSupSupplier = false;
                DynamicObjectCollection invoiceDynCol = QueryServiceHelper.query((String)"pur_invoice", (String)"id,supplier,entryentity1.ecorder,entryentity1.id,entryentity1.entryjdorder.number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
                HashSet<String> dsChildOrderIds = new HashSet<String>();
                String source = null;
                Long supplierId = (Long)((DynamicObject)invoiceDynCol.get(0)).get("supplier");
                source = GenericEcInvoiceService.getSource((Long)supplierId);
                for (DynamicObject invoiceDyn : invoiceDynCol) {
                    String childOrderId;
                    String jdChildOrderId = invoiceDyn.getString("entryentity1.entryjdorder.number");
                    String dsChildOrderId = invoiceDyn.getString("entryentity1.ecorder");
                    if (StringUtils.isNotEmpty((String)dsChildOrderId) && null == jdChildOrderId && null != (childOrderId = MalNewOrderUtils.getSubOrderId((String)source, (String)dsChildOrderId))) {
                        dsChildOrderIds.add(childOrderId);
                    }
                    if (null != jdChildOrderId) {
                        dsChildOrderIds.add(jdChildOrderId);
                    }
                    if (null != dsChildOrderId || null != jdChildOrderId) {
                        hasThirdSupplier = true;
                        continue;
                    }
                    hasSupSupplier = true;
                }
                log.info("@@jdChildOrderIds:" + JSONArray.fromObject(dsChildOrderIds));
                if (hasThirdSupplier && hasSupSupplier) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u9009\u62e9\u7684\u6570\u636e\u5305\u542b\u7b2c\u4e09\u65b9\u5546\u57ce\u4f9b\u5e94\u5546\u548c\u534f\u540c\u4f9b\u5e94\u5546\uff0c\u8bf7\u5206\u5f00\u67e5\u8be2\u3002", (String)"PurInvoiceListPlugin_6", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!dsChildOrderIds.isEmpty()) {
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setFormId("pbd_logistics");
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put("ecChildOrderids", dsChildOrderIds);
                    paramMap.put("LOGISTICS_TYPE", "invoice");
                    paramMap.put(PLATFORM, source);
                    showParameter.setCustomParams(paramMap);
                    view.showForm(showParameter);
                } else {
                    param = BillFormUtil.assembleShowDynamicFormParam((String)"pur_invlogquery", customFilter, null, (ShowType)ShowType.MainNewTabPage);
                    this.getView().showForm(param);
                }
            } else if (GENERATE_REIMBURSE.equals(operateKey)) {
                if (pks.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u6570\u636e\uff0c\u5426\u5219\u65e0\u6cd5\u4e0b\u63a8\u3002", (String)"PurInvoiceListPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                } else {
                    QFilter cuscomFilter = new QFilter("entryentity1.isentrypay", "!=", (Object)"1").and("cfmstatus", "=", (Object)"B");
                    DynamicObjectCollection purInvoiceCol = this.querySelectObjs(pks, cuscomFilter);
                    if (!purInvoiceCol.isEmpty()) {
                        if (!this.batchCheckIsGoodsBizTypeId(purInvoiceCol)) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u5546\u54c1\u7c7b\u91c7\u8d2d\u624d\u80fd\u751f\u6210\u5bf9\u516c\u62a5\u9500\u5355\u3002", (String)"PurInvoiceEditPlugin_7", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                        } else {
                            ArrayList<Long> purInvoiceIds = new ArrayList<Long>(purInvoiceCol.size());
                            for (DynamicObject purInvoice : purInvoiceCol) {
                                purInvoiceIds.add(purInvoice.getLong("id"));
                            }
                            this.checkGenErMutex(purInvoiceIds);
                            IPurInvoiceService purInvoiceService = (IPurInvoiceService)ServiceFactory.getService(IPurInvoiceService.class);
                            try {
                                ConvertOperationResult convertOperationResult = purInvoiceService.generatePublicReimburseBill(purInvoiceIds);
                                if (convertOperationResult.getTargetBillIds().size() > 1) {
                                    ListShowParameter listShowParameter = BillFormUtil.assembleShowListFormParam((String)"er_publicreimbursebill", null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, GENERATE_REIMBURSE));
                                    ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                                    HashSet<Long> idSet = new HashSet<Long>(32);
                                    for (Object id : convertOperationResult.getTargetBillIds()) {
                                        idSet.add((Long)id);
                                    }
                                    qFilters.add(new QFilter("id", "in", idSet));
                                    listShowParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
                                    this.getView().showForm((FormShowParameter)listShowParameter);
                                }
                                long targetId = 0L;
                                for (Object successId : convertOperationResult.getTargetBillIds()) {
                                    targetId = (Long)successId;
                                }
                                this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"er_publicreimbursebill", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)targetId, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, GENERATE_REIMBURSE)));
                            }
                            catch (Exception exception) {
                                log.warn("generatePublicReimburseBill:" + ExceptionUtil.getStackTrace((Throwable)exception));
                                throw new KDBizException((Throwable)exception, new ErrorCode("generatePublicReimburseBill", exception.getMessage()), new Object[0]);
                            }
                            finally {
                                this.releaseGenErMutex();
                            }
                        }
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5ba1\u6838\u3001\u5df2\u7b7e\u6536\u4e14\u672a\u751f\u6210\u4e0b\u6e38\u5355\u636e\u7684\u53d1\u7968\u7b7e\u6536\u5355\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PurInvoiceListPlugin_20", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    }
                }
            }
        } else {
            BillList list = (BillList)this.getView().getControl("billlistap");
            Object[] pks = list.getSelectedRows().getPrimaryKeyValues();
            if ("confirminvoice".equals(operateKey) && pks.length > 1) {
                List validateErrors;
                ValidateResultCollection validateResult = e.getOperationResult().getValidateResult();
                if (validateResult != null && (validateErrors = validateResult.getValidateErrors()) != null && !validateErrors.isEmpty()) {
                    return;
                }
                int errcount = e.getOperationResult().getMessage().split("\n").length;
                String errmsg = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u5f20\u5355\u636e\uff0c\u53d1\u7968\u7b7e\u6536\u6210\u529f{1}\u5f20\uff0c\u5931\u8d25{2}\u5f20\u3002", (String)"PurInvoiceListPlugin_16", (String)"scm-pur-formplugin", (Object[])new Object[0]), pks.length, pks.length - errcount, errcount);
                e.getOperationResult().setShowMessage(false);
                this.getView().showMessage(errmsg, e.getOperationResult().getMessage(), MessageTypes.Default);
                this.getView().updateView();
            }
            if ("unsubmit".equals(operateKey) && pks.length > 1) {
                int errcount = e.getOperationResult().getMessage().split("\n").length;
                String errmsg = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u5f20\u5355\u636e\uff0c\u64a4\u9500\u7b7e\u6536\u6210\u529f{1}\u5f20\uff0c\u5931\u8d25{2}\u5f20\u3002", (String)"PurInvoiceListPlugin_17", (String)"scm-pur-formplugin", (Object[])new Object[0]), pks.length, pks.length - errcount, errcount);
                e.getOperationResult().setShowMessage(false);
                this.getView().showMessage(errmsg, e.getOperationResult().getMessage(), MessageTypes.Default);
                this.getView().updateView();
            }
        }
    }

    private void checkGenErMutex(List<Long> purInvoiceIds) {
        HashSet<Long> purInvoiceIdSet = new HashSet<Long>(purInvoiceIds);
        HashSet<String> successMutexs = new HashSet<String>(purInvoiceIdSet.size());
        for (Long id : purInvoiceIdSet) {
            boolean request = MutexUtil.request((String)String.valueOf(id), (String)"pur_invoice", (String)GENERATE_REIMBURSE);
            if (!request) {
                for (String successMutex : successMutexs) {
                    MutexUtil.release((String)successMutex, (String)"pur_invoice", (String)GENERATE_REIMBURSE);
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u6b63\u5728\u751f\u6210\u5bf9\u516c\u62a5\u9500\u5355\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"PurInvoiceListPlugin_21", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            }
            successMutexs.add(String.valueOf(id));
        }
        this.getPageCache().put("successMutexs", JSONArray.fromObject(successMutexs).toString());
    }

    private void releaseGenErMutex() {
        String successMutexsStr = this.getPageCache().get("successMutexs");
        if (StringUtils.isNotEmpty((String)successMutexsStr)) {
            JSONArray ja = JSONArray.fromObject((Object)successMutexsStr);
            for (int i = 0; i < ja.size(); ++i) {
                MutexUtil.release((String)ja.getString(i), (String)"pur_invoice", (String)GENERATE_REIMBURSE);
            }
        }
    }

    private boolean batchCheckIsGoodsBizTypeId(DynamicObjectCollection purInvoiceCol) {
        HashSet<String> poBillIdSet = new HashSet<String>(purInvoiceCol.size());
        for (DynamicObject purInvoice : purInvoiceCol) {
            String poBillId = purInvoice.getString("entryentity1.pobillid1");
            if (!poBillIdSet.add(poBillId) || PurInvoiceUtil.checkIsGoodsBizTypeId((String)poBillId)) continue;
            return false;
        }
        return true;
    }

    private DynamicObjectCollection querySelectObjs(Object[] pks, QFilter cuscomFilter) {
        return QueryServiceHelper.query((String)"pur_invoice", (String)"id,entryentity1.isentrypay,entryentity1.poentryid1,entryentity1.pobillid1", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks).and(cuscomFilter)});
    }

    private String checkStatus(Object[] pks) {
        StringBuilder sb = new StringBuilder();
        Set deductBills = PurCheckMappingUtils.getDeductBill();
        QFilter qFilter = new QFilter("id", "in", (Object)pks);
        qFilter.and("entryentity1.srcbilltype1", "not in", (Object)deductBills);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pur_invoice", (String)"billno,cfmstatus,billstatus,entryentity1.isentrypay isentrypay,entryentity1.pobillid1 pobillid", (QFilter[])new QFilter[]{qFilter}, (String)"billno");){
            DataSet statusGroupBy = dataSet.copy();
            DataSet pobillIdGroupBy = dataSet.copy();
            DataSet statusDataSet = statusGroupBy.groupBy(new String[]{"billno", "cfmstatus", "billstatus", "isentrypay"}).finish();
            while (statusDataSet.hasNext()) {
                Row row = statusDataSet.next();
                String billno = row.getString("billno");
                Object isentrypay = row.get("isentrypay");
                if ("1".equals(isentrypay)) {
                    sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e{0}\u5df2\u751f\u6210\u4e0b\u6e38\u5355\u636e\u3002", (String)"PurInvoiceListPlugin_7", (String)"scm-pur-formplugin", (Object[])new Object[0]), billno)).append('\n');
                    continue;
                }
                if (!"B".equals(row.get("cfmstatus"))) {
                    sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e{0}\uff0c\u7b7e\u6536\u72b6\u6001\u4e0d\u662f\u5df2\u7b7e\u6536\uff0c\u4e0d\u80fd\u751f\u6210\u4e0b\u6e38\u5355\u636e\u3002", (String)"PurInvoiceListPlugin_8", (String)"scm-pur-formplugin", (Object[])new Object[0]), billno)).append('\n');
                    continue;
                }
                if ("C".equals(row.get("billstatus"))) continue;
                sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e{0}\uff0c\u5355\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u5ba1\u6838\uff0c\u4e0d\u80fd\u7b7e\u6536\u3002", (String)"PurInvoiceListPlugin_9", (String)"scm-pur-formplugin", (Object[])new Object[0]), billno)).append('\n');
            }
            statusDataSet.close();
            DataSet pobillIdDataSet = pobillIdGroupBy.groupBy(new String[]{"billno", "pobillid"}).finish();
            while (pobillIdDataSet.hasNext()) {
                Row row = pobillIdDataSet.next();
                String billno = row.getString("billno");
                if (!PurInvoiceUtil.checkIsGoodsBizTypeId((String)row.getString("pobillid"))) continue;
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e{0}\uff0c\u4e1a\u52a1\u7c7b\u578b\u4e3a\u975e\u5546\u54c1\u7c7b\u91c7\u8d2d\u624d\u80fd\u751f\u6210\u5e94\u4ed8\u3002", (String)"PurInvoiceListPlugin_19", (String)"scm-pur-formplugin", (Object[])new Object[0]), billno));
            }
            pobillIdDataSet.close();
        }
        return sb.toString();
    }

    private void toConfirm() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] pks = list.getSelectedRows().getPrimaryKeyValues();
        IFormView view = this.getView();
        DynamicObject[] dynamicObjs = this.getSelectObjs(pks);
        if (!this.isSameSrcBillType(dynamicObjs)) {
            view.showMessage(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u4e0d\u4e00\u6837\uff0c\u65e0\u6cd5\u751f\u6210\u5e94\u4ed8\u3002", (String)"PurInvoiceListPlugin_10", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean enableWriteOffFlag = QueryServiceHelper.exists((String)"pur_updateparamconfig", (QFilter[])new QFilter[]{new QFilter("paramkey", "=", (Object)"writeoffkey").and(new QFilter("paramvalue", "=", (Object)"Y"))});
        if (ApiConfigUtil.hasEASScmConfig() && enableWriteOffFlag) {
            this.toInvoice(pks, new HashMap<String, String>(1024));
            return;
        }
        Map rulesMap = PurInvoiceUtil.getBotpRule((DynamicObject[])dynamicObjs, (String)"otherbill");
        if (rulesMap.size() == 0 || StringUtils.isEmpty((String)((String)rulesMap.get("receipt"))) && StringUtils.isEmpty((String)((String)rulesMap.get("instock"))) && StringUtils.isEmpty((String)((String)rulesMap.get("instockreturn"))) && StringUtils.isEmpty((String)((String)rulesMap.get("appurreced"))) && StringUtils.isEmpty((String)((String)rulesMap.get("propertyconvert")))) {
            view.showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"PurInvoiceListPlugin_11", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            return;
        }
        this.toConfirm(view, pks, rulesMap);
    }

    private void toConfirm(IFormView view, Object[] pks, Map<String, String> rulesMap) {
        StringBuilder errorMessage = new StringBuilder();
        HashMap<String, List<Object>> ruleListMap = new HashMap<String, List<Object>>();
        for (Map.Entry<String, String> entry : rulesMap.entrySet()) {
            try {
                JSONArray inwareRuleList = JSONArray.fromObject((Object)entry.getValue());
                ruleListMap.put(entry.getKey(), (List<Object>)inwareRuleList);
            }
            catch (Exception ex) {
                log.info(ExceptionUtil.getStackTrace((Throwable)ex));
                errorMessage.append(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef\u3002", (String)"PurInvoiceListPlugin_12", (String)"scm-pur-formplugin", (Object[])new Object[0])).append(ex.getLocalizedMessage());
            }
        }
        if (errorMessage.length() > 0) {
            view.showMessage(errorMessage.toString());
            return;
        }
        if (ruleListMap.size() > 0) {
            if (ruleListMap.size() == 1 && (null != ruleListMap.get("receipt") || null != ruleListMap.get("instock") || null != ruleListMap.get("instockreturn") || null != ruleListMap.get("appurreced"))) {
                if (null != ruleListMap.get("receipt")) {
                    this.toInvoice(pks, ruleListMap, "receipt");
                } else if (null != ruleListMap.get("instock")) {
                    this.toInvoice(pks, ruleListMap, "instock");
                } else if (null != ruleListMap.get("instockreturn")) {
                    this.toInvoice(pks, ruleListMap, "instockreturn");
                } else if (null != ruleListMap.get("appurreced")) {
                    this.toInvoice(pks, ruleListMap, "appurreced");
                }
            } else {
                this.openBotpListPage(CommonUtil.objs2str((Object[])pks), ruleListMap, "otherbill");
            }
        }
    }

    private void toInvoice(Object[] pks, Map<String, List<Object>> ruleListMap, String key) {
        HashMap<String, String> ruleMap = new HashMap<String, String>();
        JSONObject json = null;
        json = JSONObject.fromObject((Object)ruleListMap.get(key).get(0));
        if (!json.getString("error").isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)json.getString("error"), (String)"PurInvoiceListPlugin_14", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            return;
        }
        if (null == json.get("number")) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8fd4\u56de\u8f6c\u6362\u89c4\u5219\u4e0d\u5bf9\uff0c\u6ca1\u6709\u53d6\u5230\u8f6c\u6362\u89c4\u5219\u7f16\u7801\u3002", (String)"PurInvoiceListPlugin_13", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            return;
        }
        ruleMap.put(key, json.getString("number"));
        if ("instockreturn".equals(key) || "appurreced".equals(key)) {
            if (ApiConfigUtil.hasXKScmConfig()) {
                this.toInvoice(pks, ruleMap);
            }
        } else {
            this.toInvoice(pks, ruleMap);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("confirm".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.toConfirm();
        }
    }

    private boolean isSameSrcBillType(DynamicObject[] invoiceObjs) {
        boolean isSame = false;
        int hasPurEntryCount = 0;
        int hasSaleEntryCount = 0;
        for (DynamicObject invoice : invoiceObjs) {
            DynamicObjectCollection purEntryCol = invoice.getDynamicObjectCollection(PUR_ENTRYENTITY);
            DynamicObjectCollection saleEntryCol = invoice.getDynamicObjectCollection(SAL_ENTRYENTITY);
            if (purEntryCol != null && !purEntryCol.isEmpty()) {
                ++hasPurEntryCount;
            }
            if (saleEntryCol == null || saleEntryCol.isEmpty()) continue;
            ++hasSaleEntryCount;
        }
        if (hasPurEntryCount + hasSaleEntryCount == 2 * invoiceObjs.length || hasPurEntryCount + hasSaleEntryCount == invoiceObjs.length) {
            isSame = true;
        }
        return isSame;
    }

    private void toInvoice(Object[] pks, Map<String, String> ruleMap2) {
        OperateOption operateOption = OperateOption.create();
        String str = SerializationUtils.toJsonString(ruleMap2);
        log.info("\u751f\u6210\u5e94\u4ed8\u524dbotp\u89c4\u5219\u4e3a\uff1a{}", (Object)str);
        operateOption.setVariableValue("ruleMap", str);
        this.getView().invokeOperation("generateap", operateOption);
    }

    private DynamicObject[] getSelectObjs(Object[] objs) {
        HashMap param = new HashMap(2);
        ArrayList<Long> idList = new ArrayList<Long>(objs.length);
        for (Object obj : objs) {
            idList.add(Long.valueOf(String.valueOf(obj)));
        }
        HashMap<String, ArrayList<Long>> idMap = new HashMap<String, ArrayList<Long>>(1);
        idMap.put("in", idList);
        param.put("id", idMap);
        HashMap<String, String> statusMap = new HashMap<String, String>(1);
        statusMap.put("=", ConfirmStatusEnum.CONFIRM.getVal());
        param.put("cfmstatus", statusMap);
        HashMap<String, String> billstatusMap = new HashMap<String, String>(1);
        billstatusMap.put("=", BillStatusEnum.AUDIT.getVal());
        param.put("billstatus", billstatusMap);
        HashMap<String, String> isPayMap = new HashMap<String, String>(1);
        isPayMap.put("!=", "1");
        param.put("entryentity1.isentrypay", isPayMap);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"pur_invoice", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"pur_invoice", (String)SAL_ENTRYENTITY, (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"pur_invoice", (String)PUR_ENTRYENTITY, (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"pur_invoice", (String)"entryentity", (boolean)false);
        return ORMUtil.load((String)"pur_invoice", (String)selectFields, param);
    }

    private void openBotpListPage(String pkStr, Map<String, List<Object>> ruleListMap, String toBillType) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("rules", ruleListMap.get("instock"));
        param.put("tobilltype", toBillType);
        param.put("pkstr", pkStr);
        param.put("rules1", ruleListMap.get("receipt"));
        param.put("tobilltype1", toBillType);
        param.put("pkstr1", pkStr);
        param.put("rule11", ruleListMap.get("instockreturn"));
        param.put("tobilltype11", toBillType);
        param.put("pkstr11", pkStr);
        param.put("rulereceive", ruleListMap.get("appurreced"));
        param.put("tobilltypereceive", toBillType);
        param.put("pkstrreceive", pkStr);
        param.put("rulepropertyconvert", ruleListMap.get("propertyconvert"));
        param.put("tobilltypepropertyconvert", toBillType);
        param.put("pkstrpropertyconvert", pkStr);
        FormShowParameter formParam = BillFormUtil.assembleShowDynamicFormParam((String)"check_botp_list", param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, ACTION_BOTPLIST), (ShowType)ShowType.Modal);
        this.getView().showForm(formParam);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        switch (closedCallBackEvent.getActionId()) {
            case "botpList": {
                Object botpList_condition = closedCallBackEvent.getReturnData();
                if (botpList_condition == null) {
                    return;
                }
                Map result = (Map)botpList_condition;
                Object instockruleNumber = result.get("rule");
                Object orderRuleNumber = result.get("rule1");
                HashMap<String, String> ruleMap = new HashMap<String, String>();
                if (instockruleNumber != null) {
                    ruleMap.put("instock", instockruleNumber.toString());
                }
                if (orderRuleNumber != null) {
                    ruleMap.put("receipt", orderRuleNumber.toString());
                }
                if (ApiConfigUtil.hasXKScmConfig()) {
                    Object rulePropertyConvert;
                    Object ruleReceive;
                    Object ruleNumber11 = result.get("rule11");
                    if (ruleNumber11 != null) {
                        ruleMap.put("instockreturn", String.valueOf(ruleNumber11));
                    }
                    if ((ruleReceive = result.get("rulereceive")) != null) {
                        ruleMap.put("appurreced", String.valueOf(ruleReceive));
                    }
                    if ((rulePropertyConvert = result.get("rulepropertyconvert")) != null) {
                        ruleMap.put("propertyconvert", String.valueOf(rulePropertyConvert));
                    }
                }
                Object[] pks = CommonUtil.str2objs((String)String.valueOf(result.get("pkstr")), (String)",");
                this.toInvoice(pks, ruleMap);
                break;
            }
            case "generatereimburse": {
                this.releaseGenErMutex();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String clickKey = evt.getItemKey();
        FormShowParameter param = null;
        IListView listView = (IListView)this.getView();
        Object[] primaryKeyValues = listView.getSelectedRows().getPrimaryKeyValues();
        String entryId = listView.getBillFormId();
        HashMap<String, Object> customFilter = new HashMap<String, Object>();
        customFilter.put("pkidcoll", primaryKeyValues);
        customFilter.put("ENTRY_KEY", entryId);
        switch (clickKey) {
            case "tblloginput": {
                param = BillFormUtil.assembleShowDynamicFormParam((String)"pur_invloginfo", customFilter, null, (ShowType)ShowType.NonModal);
                this.getView().showForm(param);
                break;
            }
            case "tblviewinvoice": {
                String invAddress = this.currentObj.getString("invaddress");
                this.getView().openUrl(invAddress);
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String clickKey = evt.getItemKey();
        if (StringUtils.isEmpty((String)clickKey)) {
            return;
        }
        if (clickKey.equals("tblviewinvoice")) {
            this.currentObj = BillFormUtil.getSelectData((IFormView)this.getView(), (String)"pur_invoice");
            if (this.currentObj == null) {
                evt.setCancel(true);
                return;
            }
        }
        switch (clickKey) {
            case "tblviewinvoice": {
                String invAddress = this.currentObj.getString("invaddress");
                if (invAddress != null && !invAddress.isEmpty() && (invAddress.startsWith("https://") || invAddress.startsWith("http://"))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u4e0b\u8f7d\u5730\u5740\u4e3a\u7a7a\u6216\u65e0\u6548\uff0c\u4e0d\u80fd\u4e0b\u8f7d\u6d4f\u89c8\u3002", (String)"PurInvoiceListPlugin_15", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
    }

    public void initButtonVisable() {
        IFormView view = this.getView();
        if (!ApiConfigUtil.hasEASConfig()) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_cq_confirm"});
            view.setVisible(Boolean.FALSE, new String[]{"tblconfirm"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"bar_cq_confirm"});
            view.setVisible(Boolean.TRUE, new String[]{"tblconfirm"});
        }
    }

    public void pageRelease(EventObject e) {
        this.releaseGenErMutex();
    }
}

