/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.pur.formplugin.PurGenericLogisticsInfoQueryPlugin;

public final class PurLogisticsInfoQueryPlugin
extends PurGenericLogisticsInfoQueryPlugin
implements RowClickEventListener {
    private static Log log = LogFactory.getLog(PurLogisticsInfoQueryPlugin.class);

    public String[] getEntityKeys() {
        return new String[]{"scp_order", "scp_saloutstock", "scp_receive"};
    }

    @Override
    protected void allotClickDynamicData() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        HashMap commonFilterMap = new HashMap(4);
        Map param = parameter.getCustomParams();
        if (null != param.get("pkidcoll")) {
            List pks = (List)param.get("pkidcoll");
            HashSet<Long> idSet = new HashSet<Long>(1024);
            for (Object id : pks) {
                idSet.add(Long.parseLong(id.toString()));
            }
            HashMap<String, HashSet<Long>> IdMap = new HashMap<String, HashSet<Long>>();
            IdMap.put("in", idSet);
            commonFilterMap.put("id", IdMap);
        }
        HashMap filterMap = new HashMap();
        ArrayList dynamicObjects = new ArrayList();
        HashMap<String, String> statusMap = new HashMap<String, String>();
        statusMap.put("=", "C");
        commonFilterMap.put("billstatus", statusMap);
        HashMap<String, String> scpPueKey = new HashMap<String, String>(3);
        scpPueKey.put("scp_order", "pur_order");
        scpPueKey.put("scp_saloutstock", "pur_saloutstock");
        scpPueKey.put("scp_receive", "pur_receive");
        for (String entityKey : this.getEntityKeys()) {
            filterMap.clear();
            HashMap<String, List> orgMap = new HashMap<String, List>(10);
            List orglist = OrgUtil.getUserHasPermissionOrgs((String)((String)scpPueKey.get(entityKey)));
            orgMap.put("in", orglist);
            commonFilterMap.put("org", orgMap);
            filterMap.putAll(commonFilterMap);
            filterMap.putAll(this.assembleFilterValue(entityKey));
            List queryResult = InfoQueryUtil.queryDynamicData(entityKey, InfoQueryUtil.assembleSelectFlied(entityKey), filterMap);
            dynamicObjects.addAll(queryResult);
            if (!entityKey.equalsIgnoreCase("scp_order") || queryResult.size() <= 0) continue;
            HashMap orderOther = new HashMap();
            List<Long> orderIds = queryResult.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
            Map tBills = BFTrackerServiceHelper.findTargetBills((String)"scp_order", (Long[])orderIds.toArray(new Long[0]));
            if (tBills == null || tBills.size() <= 0) continue;
            Set outStockids = (Set)tBills.get("scp_outstock");
            HashMap<String, Set> idMap = new HashMap<String, Set>();
            idMap.put("in", outStockids);
            orderOther.put("id", idMap);
            dynamicObjects.addAll(InfoQueryUtil.queryDynamicData("scp_saloutstock", InfoQueryUtil.assembleSelectFlied("scp_saloutstock"), orderOther));
        }
        if (dynamicObjects.size() > 0) {
            this.allotDynamicData(dynamicObjects);
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e\uff0c\u91cd\u65b0\u8f93\u5165\u67e5\u8be2\u6761\u4ef6\u3002", (String)"PurLogisticsInfoQueryPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            this.clearData();
        }
    }

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String isClick = this.getPageCache().get("isclickquery");
        if (isClick == null || "0".equals(isClick)) {
            Date nowDate = TimeServiceHelper.now();
            this.getModel().setValue("flog_startdate", (Object)DateUtil.formatStartDate((Date)DateUtil.addMonth((Date)nowDate, (int)-1)));
            this.getModel().setValue("flog_enddate", (Object)DateUtil.formatStartDate((Date)nowDate));
            this.allotClickDynamicData();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_querystart": {
                this.getPageCache().put("isclickquery", "1");
                this.allotClickDynamicData();
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid grid = (EntryGrid)evt.getSource();
        IDataModel model = grid.getModel();
        String entryKey = grid.getKey();
        if ("entryentity".equals(entryKey)) {
            int[] selectedRows = grid.getEntryState().getSelectedRows();
            DynamicObjectCollection col = model.getEntryEntity(entryKey);
            DynamicObject dynamicObject = (DynamicObject)col.get(selectedRows[0]);
            if (dynamicObject != null) {
                HashMap<String, Object> queryLogMap = new HashMap<String, Object>();
                Map plainObject2Map = DynamicObjectUtil.plainObject2Map((DynamicObject)dynamicObject);
                if (plainObject2Map.containsKey("logbillno") && plainObject2Map.containsKey("logsupplier")) {
                    DynamicObject logsupplier = dynamicObject.getDynamicObject("logsupplier");
                    if (logsupplier != null) {
                        queryLogMap.put("com", logsupplier.get("number"));
                    }
                    queryLogMap.put("num", dynamicObject.get("logbillno"));
                    log.info(((Object)((Object)this)).getClass().getName() + queryLogMap);
                    List resultData = this.queryLogData(queryLogMap);
                    log.info(((Object)((Object)this)).getClass().getName() + resultData);
                    this.allotLogDynamicData(resultData);
                }
            }
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        super.entryRowClick(evt);
    }
}

