/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.util.EcDateUtil;
import kd.scm.common.enums.BillEntryStatusEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DateUtil;
import net.sf.json.util.JSONUtils;

public class PurMalOrderCancelEventServicelPlugin
implements IEventServicePlugin {
    private static final Log log = LogFactory.getLog(PurMalOrderCancelEventServicelPlugin.class);

    public Object handleEvent(KDBizEvent event) {
        EntityEvent e = (EntityEvent)event;
        List businesskeys = e.getBusinesskeys();
        log.info("\u4e8b\u4ef6\u8ba2\u9605\u53c2\u6570mal_order fid={}", (Object)JSONUtils.valueToString((Object)businesskeys));
        DynamicObject[] orderDynamicObjects = this.getPurPrderDynamicObjectBySrcbillid(businesskeys);
        if (orderDynamicObjects == null || orderDynamicObjects.length == 0) {
            return event.getEventId();
        }
        HashSet malOrderIds = new HashSet(16);
        businesskeys.forEach(id -> malOrderIds.add(Long.parseLong(id)));
        QFilter qFilter = new QFilter("id", "in", malOrderIds);
        qFilter.and(new QFilter("entryentity.entrystatus", "=", (Object)"F"));
        String selectors = "billstatus,id,entryentity.id,entryentity.entrystatus";
        DynamicObjectCollection orders = QueryServiceHelper.query((String)"mal_order", (String)selectors, (QFilter[])qFilter.toArray());
        HashSet<String> allCancelIds = new HashSet<String>(16);
        HashSet<String> allCancelEntryIds = new HashSet<String>(16);
        for (DynamicObject order : orders) {
            String id2 = order.getString("id");
            String entryId = order.getString("entryentity.id");
            if ("Z".equals(order.getString("billstatus"))) {
                allCancelIds.add(id2);
            }
            allCancelIds.add(id2);
            allCancelEntryIds.add(entryId);
        }
        for (DynamicObject orderDynamic : orderDynamicObjects) {
            Date currDate = DateUtil.string2date((String)EcDateUtil.getFormatCurrentTime(), (String)"yyyy-MM-dd HH:mm:ss");
            String srcEntryId = orderDynamic.getString("materialentry.srcentryid");
            String srcBillId = orderDynamic.getString("materialentry.srcbillid");
            if (allCancelIds.contains(srcBillId)) {
                orderDynamic.set("closedate", (Object)currDate);
                orderDynamic.set("closer", (Object)RequestContext.get().getCurrUserId());
                orderDynamic.set("billstatus", (Object)BillStatusEnum.CLOSED.getVal());
                orderDynamic.set("cfmstatus", (Object)"");
            }
            DynamicObjectCollection dynamicObjectEntitys = orderDynamic.getDynamicObjectCollection("materialentry");
            for (DynamicObject dynamicObjectEntity : dynamicObjectEntitys) {
                if (!allCancelEntryIds.contains(srcEntryId) || BillEntryStatusEnum.CLOSED.getVal().equals(dynamicObjectEntity.getString("entrystatus"))) continue;
                dynamicObjectEntity.set("rowclosedate", (Object)currDate);
                dynamicObjectEntity.set("rowcloser", (Object)RequestContext.get().getCurrUserId());
                dynamicObjectEntity.set("entrystatus", (Object)BillEntryStatusEnum.CLOSED.getVal());
            }
        }
        SaveServiceHelper.save((DynamicObject[])orderDynamicObjects);
        return event.getEventId();
    }

    public DynamicObject[] getPurPrderDynamicObjectBySrcbillid(List<String> ids) {
        String selectFields = "cfmstatus,id,billstatus,closer,closedate,materialentry.srcentryid,materialentry.id,materialentry.rowcloser,materialentry.rowclosedate,materialentry.entrystatus";
        HashSet malOrderFIds = new HashSet(ids.size());
        ids.forEach(id -> malOrderFIds.add(id));
        QFilter filter = new QFilter("materialentry.srcbillid", "in", malOrderFIds);
        return BusinessDataServiceHelper.load((String)"pur_order", (String)selectFields, (QFilter[])new QFilter[]{filter});
    }
}

