/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.pur.business.PurJointChannelHelper;
import kd.scm.pur.common.PurIscSchemaImportUtils;

public class PurParamEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log log = LogFactory.getLog(PurParamEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit iscblink = (BasedataEdit)this.getView().getControl("iscblink");
        if (iscblink != null) {
            iscblink.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        if (ApiConfigUtil.hasCQScmConfig()) {
            this.setBarValue();
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean isautoreceive = dataEntity.getBoolean("isautoreceive");
        String autocreatebilltype = dataEntity.getString("autocreatebilltype");
        if (isautoreceive && (autocreatebilltype == null || autocreatebilltype.isEmpty())) {
            this.getModel().setValue("autocreatebilltype", (Object)"receiptbill");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (null != ApiConfigUtil.getEasConfig()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"easapinvoiceflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexenable_easap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelaptax"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"easapinvoiceflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexenable_easap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelaptax"});
        }
        this.setBarVisiable();
        this.setConnectErpEnable();
    }

    private void setConnectErpEnable() {
        ArrayList<String> verifyEntityNumbers = new ArrayList<String>(16);
        verifyEntityNumbers.add("pur_order");
        verifyEntityNumbers.add("pur_receipt");
        verifyEntityNumbers.add("pur_instock");
        boolean isEnable = PurJointChannelHelper.checkMultiJointSystem(verifyEntityNumbers);
        this.getView().setEnable(Boolean.valueOf(!isEnable), new String[]{"connecterp", "iscblink"});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IDataEntityProperty dataEntityProperty = beforeF7SelectEvent.getProperty();
        String propertyName = dataEntityProperty.getName();
        if ("iscblink".equals(propertyName)) {
            String connecterp = this.getModel().getDataEntity().getString("connecterp");
            if (connecterp != null && !connecterp.trim().isEmpty()) {
                String dataBaseType;
                switch (connecterp) {
                    case "eas": {
                        dataBaseType = "eas";
                        break;
                    }
                    case "k3cloud": {
                        dataBaseType = "k3cloud";
                        break;
                    }
                    default: {
                        dataBaseType = "self";
                    }
                }
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("database_type", "=", (Object)dataBaseType));
            } else {
                beforeF7SelectEvent.setCancel(true);
            }
        }
    }

    private void setBarVisiable() {
        String connecterp = this.getModel().getDataEntity().getString("connecterp");
        if ("0".equals(connecterp)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap3"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3"});
        }
    }

    private void setBarValue() {
        String connecterp = this.getModel().getDataEntity().getString("connecterp");
        if ("0".equals(connecterp)) {
            this.getModel().setValue("recbillstatus", (Object)"A");
            this.getModel().setValue("insbillstatus", (Object)"A");
            this.getModel().setValue("acceptbillstatus", (Object)"A");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSets;
        String name = e.getProperty().getName();
        if ("connecterp".equals(name)) {
            ChangeData changeData = e.getChangeSet()[0];
            ChangeData[] newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            this.connectErpChange(oldValue, newValue);
            this.setBarValue();
            this.setBarVisiable();
        }
        if ("iscblink".equals(name)) {
            this.setBarValue();
            this.setBarVisiable();
        }
        for (ChangeData changeSet : changeSets = e.getChangeSet()) {
            boolean isenableinvcloud;
            boolean isautoreceive;
            int rowIndex = changeSet.getRowIndex();
            Object oldValue = changeSet.getOldValue();
            Object newValue = changeSet.getNewValue();
            if (("insbillstatus".equals(name) || "recbillstatus".equals(name) || "createuserstrategy".equals(name) || "acceptbillstatus".equals(name)) && (newValue == null || StringUtils.isEmpty((String)newValue.toString()))) {
                this.getModel().setValue(name, oldValue, rowIndex);
            }
            if ("isautoreceive".equals(name) && (isautoreceive = ((Boolean)newValue).booleanValue())) {
                this.getModel().setValue("autocreatebilltype", (Object)"receiptbill");
            }
            if (!"isenableinvcloud".equals(name) || (isenableinvcloud = ((Boolean)newValue).booleanValue())) continue;
            this.getModel().setValue("invoicecloudxh", (Object)"xh");
        }
        if ("invoicecloudxh".equals(name)) {
            ChangeData changeData = e.getChangeSet()[0];
            Object newValue = changeData.getNewValue();
            boolean isenableinvcloud = this.getModel().getDataEntity().getBoolean("isenableinvcloud");
            if (isenableinvcloud && "aws".equals(newValue)) {
                PurIscSchemaImportUtils util = new PurIscSchemaImportUtils();
                util.decompressionFileAndImport("SRM_AWS/ISC_APIC_SCRIPT.zip");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        String customValue = messageBoxClosedEvent.getCustomVaule();
        if ("connecterpchangeconfirm".equalsIgnoreCase(callBackId) && customValue != null && !customValue.isEmpty()) {
            Map confirmMap = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
            if (MessageBoxResult.Yes.equals((Object)messageBoxResult)) {
                this.clearIscLink();
            } else {
                this.setValueConnectErp(confirmMap.get("oldValue"));
            }
        }
    }

    private void connectErpChange(Object oldValue, Object newValue) {
        if (newValue != null) {
            String message = ResManager.loadKDString((String)"\u5207\u6362\"\u8fde\u63a5ERP\u7cfb\u7edf\"\u4f1a\u5bf9\u73b0\u8fde\u63a5\u7cfb\u7edf\u672a\u5b8c\u6210\u7684\u8ba2\u5355\u9020\u6210\u6570\u636e\u9519\u4e71\uff0c\u8bf7\u786e\u8ba4ERP\u4e2d\u6240\u6709\u8ba2\u5355\u6267\u884c\u5b8c\u6bd5\u540e\u518d\u8fdb\u884c\u5207\u6362\u3002\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"", (String)"", (Object[])new Object[0]);
            HashMap<String, String> confirmMap = new HashMap<String, String>(1);
            confirmMap.put("newValue", newValue.toString());
            confirmMap.put("oldValue", oldValue.toString());
            this.getView().showConfirm(message, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("connecterpchangeconfirm", (IFormPlugin)this), null, SerializationUtils.toJsonString(confirmMap));
        } else {
            this.clearIscLink();
        }
    }

    private void clearIscLink() {
        this.getModel().beginInit();
        this.getModel().setValue("iscblink", null);
        this.getView().updateView("iscblink");
        this.getModel().endInit();
    }

    private void setValueConnectErp(Object valueConnectErp) {
        this.getModel().beginInit();
        this.getModel().setValue("connecterp", valueConnectErp);
        this.getView().updateView("connecterp");
        this.getModel().endInit();
    }

    private void linkSaveIscLink() {
        Object connecterpParam = ParamUtil.getParamObj((String)"eae607fb000143ac", (String)"connecterp");
        Object iscLinkParam = ParamUtil.getParamObj((String)"eae607fb000143ac", (String)"iscblink");
        if (connecterpParam != null && !connecterpParam.toString().isEmpty()) {
            DynamicObject[] scdatachannle = BusinessDataServiceHelper.load((String)"pbd_scdatachannel", (String)"isclink,isdefault", (QFilter[])new QFilter[]{new QFilter("connecterp", "=", connecterpParam)});
            if (iscLinkParam != null) {
                for (DynamicObject data : scdatachannle) {
                    data.set("isclink_id", ((Map)iscLinkParam).get("id"));
                }
            }
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])scdatachannle);
            if (scdatachannle != null && scdatachannle.length > 0) {
                OperationServiceHelper.executeOperate((String)"setdefaultchannel", (String)"pbd_scdatachannel", (Object[])new Object[]{scdatachannle[0].getPkValue()}, (OperateOption)OperateOption.create());
            }
        }
    }

    public void pageRelease(EventObject e) {
        this.linkSaveIscLink();
    }
}

