/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.util.EmalParamsUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BizTypeHelper;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.check.ThirdOrderCheckUtil;

public class ThirdDataFilterPlugin
extends AbstractFormPlugin {
    public static final long MALORDER_BILLTYPE_ID = 1317361223599179776L;

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit thirdCheckOrder = (BasedataEdit)this.getControl("paymentbillno");
        thirdCheckOrder.addBeforeF7SelectListener(beforeF7SelectEvent -> beforeF7SelectEvent.addCustomQFilter(new QFilter("source", "=", this.getModel().getValue("srctype"))));
        BasedataEdit settleOrg = (BasedataEdit)this.getControl("settleorg");
        settleOrg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId());
            if (!hasPermOrgResult.hasAllOrgPerm()) {
                beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
            }
        });
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId());
            if (!hasPermOrgResult.hasAllOrgPerm()) {
                beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
            }
        });
        BasedataEdit bussinessType = (BasedataEdit)this.getView().getControl("businesstype");
        bussinessType.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            List bizTypeIds = BizTypeHelper.getAllBizTypes((String)"mal_order", (Long)1317361223599179776L);
            if (!CollectionUtils.isEmpty((Collection)bizTypeIds)) {
                beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", (Object)bizTypeIds));
            }
        });
    }

    private void openThirdCheck() {
        ListShowParameter param = null;
        IDataModel model = this.getModel();
        String billno = null;
        DynamicObject paymentbillno = (DynamicObject)model.getValue("paymentbillno");
        if (null != paymentbillno) {
            billno = paymentbillno.getString("number");
        }
        boolean recheck = true;
        if (!StringUtils.isEmpty((String)billno)) {
            try {
                ThirdOrderCheckUtil.createThirdCheckOrder((String)billno, (boolean)recheck);
                List<String> ecChildOrderIds = this.getEcChildOrderIds(billno);
                ThirdOrderCheckUtil.updateInvoiceState(ecChildOrderIds, (String)((String)this.getModel().getValue("srctype")));
            }
            catch (Exception exception) {
                this.getView().showErrMessage(ResManager.loadKDString((String)"\u5bf9\u8d26\u53d1\u751f\u9519\u8bef", (String)"ThirdDataFilterPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]), exception.getMessage());
            }
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.putAll(this.getView().getFormShowParameter().getCustomParams());
        params.put("billno", billno);
        if (!CollectionUtils.isEmpty((Collection)((Collection)model.getValue("settleorg")))) {
            DynamicObjectCollection settleorgCollection = (DynamicObjectCollection)model.getValue("settleorg");
            ArrayList<Long> settleorgList = new ArrayList<Long>();
            for (DynamicObject settleorg : settleorgCollection) {
                settleorgList.add(Long.valueOf(String.valueOf(settleorg.getDynamicObject("fbasedataid").getPkValue())));
            }
            params.put("settleorg", settleorgList);
        }
        if (!CollectionUtils.isEmpty((Collection)((Collection)model.getValue("org")))) {
            DynamicObjectCollection orgCollection = (DynamicObjectCollection)model.getValue("org");
            ArrayList<Long> orgList = new ArrayList<Long>();
            for (DynamicObject org : orgCollection) {
                orgList.add(Long.valueOf(String.valueOf(org.getDynamicObject("fbasedataid").getPkValue())));
            }
            params.put("purorg", orgList);
        }
        if (!CollectionUtils.isEmpty((Collection)((Collection)model.getValue("businesstype")))) {
            DynamicObjectCollection businesstypeCol = (DynamicObjectCollection)model.getValue("businesstype");
            ArrayList<Long> businesstypeList = new ArrayList<Long>();
            for (DynamicObject businesstype : businesstypeCol) {
                businesstypeList.add(Long.valueOf(String.valueOf(businesstype.getDynamicObject("fbasedataid").getPkValue())));
            }
            params.put("businesstype", businesstypeList);
        }
        this.getView().returnDataToParent(params);
        param = BillFormUtil.assembleShowListFormParam((String)"pur_thirdcheckorder", params, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "comfirmaction"));
        this.getView().showForm((FormShowParameter)param);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object status;
        super.closedCallBack(closedCallBackEvent);
        if ("comfirmaction".equals(closedCallBackEvent.getActionId()) && null == (status = this.getView().getFormShowParameter().getCustomParams().get("status"))) {
            this.getView().close();
        }
    }

    public List<String> getEcChildOrderIds(String billno) {
        ArrayList<String> result = new ArrayList<String>();
        DynamicObjectCollection checkOrderDynCol = QueryServiceHelper.query((String)"pur_thirdcheckorder", (String)"childbillno", (QFilter[])new QFilter[]{new QFilter("paymentbillno", "=", (Object)billno)});
        for (DynamicObject checkOrderDyn : checkOrderDynCol) {
            String childbillno = checkOrderDyn.getString("childbillno");
            if (!StringUtils.isNotEmpty((String)childbillno)) continue;
            result.add(childbillno);
        }
        return result;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("check".equals(opKey) && operationResult != null && operationResult.isSuccess()) {
            this.openThirdCheck();
        }
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if ("mal".equals(this.getView().getFormShowParameter().getAppId()) && MalOrderUtil.getDefaultMalVersion()) {
            this.getView().executeClientCommand("setCaption", new Object[]{ResManager.loadKDString((String)"\u7535\u5546\u5bf9\u8d26", (String)"ThirdDataFilterPlugin_1", (String)"scm-pur-formplugin", (Object[])new Object[0])});
        }
        this.getModel().setDataChanged(false);
        this.initSrctype();
    }

    public void initSrctype() {
        ComboEdit srctypeComb = (ComboEdit)this.getControl("srctype");
        List openedMalNos = EmalParamsUtil.getOpenedEmalNumberList();
        if (openedMalNos != null && !openedMalNos.isEmpty()) {
            ArrayList ecPlatformEnums = new ArrayList(openedMalNos.size());
            openedMalNos.forEach(openedMalNo -> ecPlatformEnums.add(EcPlatformEnum.fromVal((String)openedMalNo)));
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(ecPlatformEnums.size());
            for (EcPlatformEnum ecPlatformEnum : ecPlatformEnums) {
                ComboItem comboItem = new ComboItem(new LocaleString(ecPlatformEnum.getName()), ecPlatformEnum.getVal());
                items.add(comboItem);
            }
            srctypeComb.setComboItems(items);
        }
    }
}

