/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.batchreceive;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.BillEntryStatusEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.pur.business.PurBatchStockHelper;
import kd.scm.pur.formplugin.batchreceive.IBatchReceiveGetData;
import kd.scm.pur.formplugin.batchreceive.PurBatchReceiveContext;

public class BatchReceiveGetData
implements IBatchReceiveGetData {
    private static final long serialVersionUID = -5907798153610230863L;

    @Override
    public void process(PurBatchReceiveContext context) {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)context.getEnttityKey(), (String)context.getSelector(), (QFilter[])new QFilter[]{context.getFilter()}, (String)"billdate desc");
        dynamicObjects = this.doOtherFilter(dynamicObjects, context.getCacheParams());
        context.setDynamicObjects(dynamicObjects);
    }

    public DynamicObject[] doOtherFilter(DynamicObject[] dynamicObjects, Map<String, String> cacheParams) {
        boolean onlylookme = Boolean.parseBoolean(cacheParams.get("onlylookme"));
        ArrayList<DynamicObject> newDynList = new ArrayList<DynamicObject>(dynamicObjects.length);
        DynamicObject entry = null;
        DynamicObjectCollection entryCol = null;
        HashSet<String> coreEntryIds = new HashSet<String>(1024);
        for (DynamicObject dyn : dynamicObjects) {
            entryCol = dyn.getDynamicObjectCollection("materialentry");
            for (DynamicObject dynamicObject : entryCol) {
                String poEntryId = dynamicObject.getString("poentryid");
                if (poEntryId == null || poEntryId.isEmpty()) continue;
                coreEntryIds.add(poEntryId);
            }
        }
        if (coreEntryIds.size() <= 0) {
            return dynamicObjects;
        }
        QFilter orderFilter = new QFilter("materialentry.poentryid", "in", coreEntryIds);
        if (onlylookme) {
            orderFilter.and(new QFilter("person.user.id", "=", (Object)RequestContext.get().getCurrUserId()).or(new QFilter("creator.id", "=", (Object)RequestContext.get().getCurrUserId())));
        }
        HashMap customParamMap = new HashMap(16);
        List orderData = PurBatchStockHelper.queryOrderDataCoreEntryIds((QFilter)orderFilter, customParamMap);
        Map orderAvailableQtyMap = PurBatchStockHelper.modifyOrderData((List)orderData);
        HashSet<String> matchOrderEntryIdSet = new HashSet<String>(1024);
        for (DynamicObject order : orderData) {
            boolean acceptanceFlag;
            Object acceptance = order.get("acceptance");
            String poentryid = order.getString("poentryid");
            BigDecimal availableOrderBasicQty = orderAvailableQtyMap.getOrDefault(poentryid, BigDecimal.ZERO);
            boolean entryStatusFlag = !BillEntryStatusEnum.CLOSED.getVal().equals(order.getString("entrystatus"));
            boolean billStatusFlag = !BillStatusEnum.CLOSED.getVal().equals(order.getString("billstatus"));
            boolean bl = acceptanceFlag = acceptance == null || (Boolean)acceptance == false || MalNewOrderUtils.checkIsGoodsBizTypeId((Long)((Long)order.get("businesstype")));
            if (availableOrderBasicQty.compareTo(BigDecimal.ZERO) <= 0 || !entryStatusFlag || !billStatusFlag || !acceptanceFlag) continue;
            matchOrderEntryIdSet.add(order.getString("poentryid"));
        }
        if (!matchOrderEntryIdSet.isEmpty()) {
            for (DynamicObject dyn : dynamicObjects) {
                entryCol = dyn.getDynamicObjectCollection("materialentry");
                for (int i = entryCol.size() - 1; i >= 0; --i) {
                    entry = (DynamicObject)entryCol.get(i);
                    String poEntryId = entry.getString("poentryid");
                    if (matchOrderEntryIdSet.contains(poEntryId)) continue;
                    entryCol.remove((Object)entry);
                }
                if (entryCol.isEmpty()) continue;
                newDynList.add(dyn);
            }
        }
        return newDynList.toArray(new DynamicObject[0]);
    }
}

