/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.Copy;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.common.helper.SRMSetRowColorHelper;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.pur.business.PurDeliveryScheduleHelper;
import kd.scm.pur.business.PurSalOutStockHelper;

public final class PurDeliveryScheduleEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static String[] setColorPro = new String[]{"promiseqty", "promisedate", "supplierremark"};

    public void preOpenForm(PreOpenFormEventArgs e) {
        Object pkId;
        super.preOpenForm(e);
        FormShowParameter showParameter = e.getFormShowParameter();
        Object checkcopyop = showParameter.getCustomParam("checkcopyop");
        if (checkcopyop != null && "true".equalsIgnoreCase(checkcopyop.toString()) && (pkId = ((BillShowParameter)showParameter).getPkId()) != null && PurDeliveryScheduleHelper.verifyIsDraw((Long)Long.parseLong(pkId.toString())).booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(this.getDrawMessage());
        }
    }

    public void registerListener(EventObject e) {
        EntryGrid grid;
        BasedataEdit warehouse;
        BasedataEdit unit;
        BasedataEdit material;
        BasedataEdit supplierlink;
        BasedataEdit supplier;
        BasedataEdit person;
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        if (org != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((person = (BasedataEdit)this.getControl("person")) != null) {
            person.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplier = (BasedataEdit)this.getControl("supplier")) != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplierlink = (BasedataEdit)this.getControl("supplierlink")) != null) {
            supplierlink.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)this.getControl("material")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((unit = (BasedataEdit)this.getControl("unit")) != null) {
            unit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((warehouse = (BasedataEdit)this.getControl("warehouse")) != null) {
            warehouse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((grid = (EntryGrid)this.getView().getControl("materialentry")) != null) {
            grid.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Long billId;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Copy && PurDeliveryScheduleHelper.verifyIsDraw((Long)(billId = Long.valueOf(Long.parseLong(((Copy)source).getView().getModel().getDataEntity().getPkValue().toString())))).booleanValue()) {
            args.setCancel(true);
            ((Copy)source).getView().showErrorNotification(this.getDrawMessage());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        IDataModel model = this.getModel();
        switch (proName) {
            case "supplier": {
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (!(newValue instanceof DynamicObject)) break;
                HashSet<Long> bizpartnerIdSet = new HashSet<Long>(1);
                Long bizpartnerId = null;
                bizpartnerId = ((DynamicObject)newValue).getLong("bizpartner_id");
                if (bizpartnerId == null) break;
                bizpartnerIdSet.add(bizpartnerId);
                Map adminSupUserId = BizPartnerUtil.getEnableAdminSupplierUserIdsMapByBizPartner(bizpartnerIdSet);
                List supplierIds = (List)adminSupUserId.get(bizpartnerId);
                if (supplierIds == null || supplierIds.size() <= 0) break;
                this.getModel().setValue("supplierlink", supplierIds.get(0));
                break;
            }
            case "material": {
                for (ChangeData changeData : e.getChangeSet()) {
                    DynamicObject materialsPurchase;
                    Object changeDataNewValue = changeData.getNewValue();
                    int rowIndex = changeData.getRowIndex();
                    if (!(changeDataNewValue instanceof DynamicObject)) continue;
                    DynamicObject material = (DynamicObject)changeDataNewValue;
                    if (material.getLocaleString("name") != null) {
                        model.setValue("materialname", (Object)material.getLocaleString("name").toString(), rowIndex);
                    }
                    if (material.getDynamicObject("baseunit") != null) {
                        model.setValue("basicunit", material.getDynamicObject("baseunit").getPkValue(), rowIndex);
                    }
                    if ((materialsPurchase = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialpurchaseinfo", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)material.getLong("id"))})) != null && materialsPurchase.getDynamicObject("purchaseunit") != null) {
                        model.setValue("unit", materialsPurchase.getDynamicObject("purchaseunit").getPkValue(), rowIndex);
                    }
                    this.setBaseQty(model, rowIndex, changeDataNewValue);
                }
            }
            case "qty": 
            case "unit": {
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                Object newValue = e.getChangeSet()[0].getNewValue();
                this.setBaseQty(model, rowIndex, newValue);
                break;
            }
        }
    }

    private void setBaseQty(IDataModel model, int rowIndex, Object newValue) {
        BigDecimal baseQty = BigDecimal.ZERO;
        if (null != newValue) {
            BigDecimal qty1 = new BigDecimal(String.valueOf(model.getValue("qty", rowIndex)));
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            DynamicObject basicunit = (DynamicObject)model.getValue("basicunit", rowIndex);
            if (null != material && null != unit && null != basicunit) {
                baseQty = CommonUtil.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)qty1, (DynamicObject)basicunit);
            }
        }
        model.setValue("basicqty", (Object)baseQty, rowIndex);
    }

    private void setRowColor() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("materialentry");
        ArrayList csList = SRMSetRowColorHelper.assmbleCellStyle((int)this.getModel().getEntryRowCount("materialentry"), (String[])setColorPro);
        grid.setCellStyle((List)csList);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String proName = beforeF7SelectEvent.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("materialentry");
        switch (proName) {
            case "org": {
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", (Object)OrgUtil.getAllPurViewPermissionOrgs((String)this.getModel().getDataEntityType().getName())));
                break;
            }
            case "supplierlink": {
                DynamicObject supplier = dataEntity.getDynamicObject("supplier");
                DynamicObject bizpartner = dataEntity.getDynamicObject("bizpartner");
                Long bizpartnerId = null;
                if (bizpartner != null) {
                    bizpartnerId = bizpartner.getLong("id");
                }
                if (bizpartnerId == null && supplier != null) {
                    bizpartnerId = supplier.getLong("bizpartner_id");
                }
                if (bizpartnerId != null && !Objects.equals(bizpartnerId, 0L)) {
                    beforeF7SelectEvent.getCustomQFilters().add(new QFilter("bizpartner", "=", (Object)bizpartnerId));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4f9b\u5e94\u5546\u6570\u636e\u3002", (String)"PurDeliveryScheduleEdit_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                break;
            }
            case "person": {
                DynamicObject org = dataEntity.getDynamicObject("org");
                if (org == null) break;
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("createorg", "=", (Object)org.getLong("id")));
                break;
            }
            case "entryrcvorg": {
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", (Object)OrgUtil.getAllInvViewPermissionOrgs((String)this.getModel().getDataEntityType().getName())));
                break;
            }
            case "unit": {
                Object masterMaterial = this.getModel().getValue("material", rowIndex);
                if (masterMaterial == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (String)"PurDeliveryScheduleEdit_1", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                DynamicObject baseUnit = (DynamicObject)this.getModel().getValue("basicunit", rowIndex);
                long srcmuId = baseUnit == null ? 0L : (Long)baseUnit.getPkValue();
                DynamicObject material = (DynamicObject)masterMaterial;
                Long masterMaterialId = (Long)material.getPkValue();
                List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)srcmuId, (String)"1");
                QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "warehouse": {
                Object entryrcvorg = this.getModel().getValue("entryrcvorg", rowIndex);
                if (entryrcvorg != null) {
                    QFilter qFilter = null;
                    try {
                        qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", (Long)((DynamicObject)entryrcvorg).getLong("id"));
                        showParameter.getListFilterParameter().getQFilters().add(qFilter);
                    }
                    catch (Exception exception) {
                        SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)exception);
                    }
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u8d27\u7ec4\u7ec7\u3002", (String)"PurDeliveryScheduleEdit_2", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                break;
            }
        }
    }

    private String getDrawMessage() {
        return ResManager.loadKDString((String)"\u5173\u8054\u751f\u6210\u7684\u5355\u636e\u4e0d\u652f\u6301\u590d\u5236\u3002", (String)"PurDeliveryScheduleEdit_3", (String)"scm-pur-formplugin", (Object[])new Object[0]);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if ("sumoutstockqty".equals(fieldName)) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity("materialentry", hyperLinkClickEvent.getRowIndex());
            Object entryPrimaryKeyValue = dynamicObject.get("id");
            FormShowParameter formShowParameter = PurSalOutStockHelper.assembleShowParameter((String)"pur_saloutstock", (String)"pur_saloutstock", (List)PurDeliveryScheduleHelper.assembleLinkSalOutBillIds((Object)entryPrimaryKeyValue));
            this.getView().showForm(formShowParameter);
        }
    }
}

