/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.edit;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.MaterialUtil;
import kd.scm.common.util.PurBizPersonUtil;
import kd.scm.pur.formplugin.util.PurSupplierContacterUtil;

public final class PurProblemNoticeEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit person;
        super.registerListener(e);
        BasedataEdit contacter = (BasedataEdit)this.getControl("contacter");
        if (contacter != null) {
            contacter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((person = (BasedataEdit)this.getControl("person")) != null) {
            person.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String proName = beforeF7SelectEvent.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        switch (proName) {
            case "contacter": {
                DynamicObject supplier = dataEntity.getDynamicObject("supplier");
                DynamicObject bizpartner = dataEntity.getDynamicObject("bizpartner");
                Long bizpartnerId = null;
                if (bizpartner != null) {
                    bizpartnerId = bizpartner.getLong("id");
                }
                if (bizpartnerId == null && supplier != null) {
                    bizpartnerId = supplier.getLong("bizpartner_id");
                }
                if (bizpartnerId != null && !Objects.equals(bizpartnerId, 0L)) {
                    beforeF7SelectEvent.getCustomQFilters().add(new QFilter("bizpartner", "=", (Object)bizpartnerId));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4f9b\u5e94\u5546\u6570\u636e\u3002", (String)"PurProblemNoticeEdit_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                break;
            }
            case "person": {
                DynamicObject org = dataEntity.getDynamicObject("org");
                if (org == null) break;
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("createorg", "=", (Object)org.getLong("id")));
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject person = dataEntity.getDynamicObject("person");
        if (person == null) {
            this.getModel().setValue("person", (Object)PurBizPersonUtil.getBizPerson());
            this.getView().updateView("person");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        int rowIndex = 0;
        Object modelValue = null;
        switch (propertyName) {
            case "supplier": {
                rowIndex = e.getChangeSet()[0].getRowIndex();
                modelValue = model.getValue(propertyName, rowIndex);
                if (!(modelValue instanceof DynamicObject)) break;
                PurSupplierContacterUtil.supplierChange(model, (DynamicObject)modelValue);
                break;
            }
            case "materialid": {
                rowIndex = e.getChangeSet()[0].getRowIndex();
                modelValue = model.getValue(propertyName, rowIndex);
                if (!(modelValue instanceof DynamicObject)) break;
                MaterialUtil.materialChanged((IDataModel)model, (String)propertyName, (DynamicObject)((DynamicObject)modelValue), (String)"materialentry", (int)rowIndex);
                DynamicObject baseunit = ((DynamicObject)modelValue).getDynamicObject("baseunit");
                if (null == baseunit) break;
                model.setValue("baseunitid", null == baseunit ? Long.valueOf(0L) : baseunit.getPkValue(), rowIndex);
                break;
            }
            case "qty": {
                rowIndex = e.getChangeSet()[0].getRowIndex();
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("materialentry", rowIndex);
                PurProblemNoticeEdit.updateEntryBasicQtyByLineIndex(entryRowEntity);
                this.getView().updateView("materialentry");
                break;
            }
        }
    }

    public static void updateEntryBasicQtyByLineIndex(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return;
        }
        BigDecimal newQty = dynamicObject.getBigDecimal("qty");
        DynamicObject materialObj = dynamicObject.getDynamicObject("materialid");
        DynamicObject unitObj = dynamicObject.getDynamicObject("unit");
        DynamicObject basicUnitObj = dynamicObject.getDynamicObject("baseunitid");
        if (null != materialObj && null != unitObj && null != basicUnitObj) {
            BigDecimal basicQty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)newQty, (DynamicObject)basicUnitObj);
            basicQty = null == basicQty ? BigDecimal.ZERO : basicQty;
            dynamicObject.set("baseqty", (Object)basicQty);
        }
    }
}

