/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.edit;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.scm.common.enums.QualityRectificEnum;
import kd.scm.common.enums.QualityRectificStatusEnum;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.PurBizPersonUtil;
import kd.scm.pur.common.enums.ProblemTypeEnum;
import kd.scm.pur.formplugin.PurCoreBillEditPlugin;
import kd.scm.pur.formplugin.util.PurSupplierContacterUtil;

public final class PurQualityRectificEdit
extends PurCoreBillEditPlugin
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        BasedataEdit person;
        super.registerListener(e);
        BasedataEdit contacter = (BasedataEdit)this.getControl("contacter");
        if (contacter != null) {
            contacter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((person = (BasedataEdit)this.getControl("person")) != null) {
            person.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        Map sourceData = e.getSourceData();
        Object source = e.getSource();
        Object supplier = sourceData.get("supplier");
        IDataModel model = this.getModel();
        if (supplier != null) {
            DynamicObject supplierDy = ((BillModel)source).getDataEntity().getDynamicObject("supplier");
            PurSupplierContacterUtil.supplierChange(model, supplierDy);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject person = dataEntity.getDynamicObject("person");
        if (person == null) {
            this.getModel().setValue("person", (Object)PurBizPersonUtil.getBizPerson());
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Date icarequiretime = dataEntity.getDate("icarequiretime");
        Date pcarequiretime = dataEntity.getDate("pcarequiretime");
        Date verifyrequiretime = dataEntity.getDate("verifyrequiretime");
        Date endDate = DateUtil.formatStartDate((Date)new Date());
        if (icarequiretime != null && endDate.compareTo(icarequiretime) > 0) {
            this.getModel().setValue("icarequiretime", null);
        }
        if (pcarequiretime != null && endDate.compareTo(pcarequiretime) > 0) {
            this.getModel().setValue("pcarequiretime", null);
        }
        if (verifyrequiretime != null && endDate.compareTo(verifyrequiretime) > 0) {
            this.getModel().setValue("verifyrequiretime", null);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("confirm")) {
            this.confirmBefore(true);
        } else {
            this.confirmBefore(false);
        }
    }

    @Override
    protected String getStatusTabVal() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String icastatus = dataEntity.getString("icastatus");
        String pcastatus = dataEntity.getString("pcastatus");
        String verifystatus = dataEntity.getString("verifystatus");
        String cancelstatus = dataEntity.getString("cancelstatus");
        if ("Z".equalsIgnoreCase(cancelstatus)) {
            return QualityRectificStatusEnum.FINISH.getValue();
        }
        if (QualityRectificEnum.PENDINGFEEDBACK.getValue().equals(icastatus) && QualityRectificEnum.PENDINGFEEDBACK.getValue().equals(pcastatus) && QualityRectificEnum.PENDINGFEEDBACK.getValue().equals(verifystatus)) {
            return QualityRectificStatusEnum.START.getValue();
        }
        if (!QualityRectificEnum.CONFIRMED.getValue().equals(icastatus) && QualityRectificEnum.PENDINGFEEDBACK.getValue().equals(pcastatus) && QualityRectificEnum.PENDINGFEEDBACK.getValue().equals(verifystatus)) {
            return QualityRectificStatusEnum.ICA.getValue();
        }
        if (QualityRectificEnum.CONFIRMED.getValue().equals(icastatus) && !QualityRectificEnum.CONFIRMED.getValue().equals(pcastatus) && QualityRectificEnum.PENDINGFEEDBACK.getValue().equals(verifystatus)) {
            return QualityRectificStatusEnum.PCA.getValue();
        }
        if (QualityRectificEnum.CONFIRMED.getValue().equals(icastatus) && QualityRectificEnum.CONFIRMED.getValue().equals(pcastatus) && !QualityRectificEnum.CONFIRMED.getValue().equals(verifystatus)) {
            return QualityRectificStatusEnum.VILIFY.getValue();
        }
        if (QualityRectificEnum.CONFIRMED.getValue().equals(icastatus) && QualityRectificEnum.CONFIRMED.getValue().equals(pcastatus) && QualityRectificEnum.CONFIRMED.getValue().equals(verifystatus)) {
            return QualityRectificStatusEnum.FINISH.getValue();
        }
        return "";
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldName = beforeF7SelectEvent.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        switch (fieldName) {
            case "contacter": {
                DynamicObject supplier = dataEntity.getDynamicObject("supplier");
                DynamicObject bizpartner = dataEntity.getDynamicObject("bizpartner");
                Long bizpartnerId = null;
                if (bizpartner != null) {
                    bizpartnerId = bizpartner.getLong("id");
                }
                if (bizpartnerId == null && supplier != null) {
                    bizpartnerId = supplier.getLong("bizpartner_id");
                }
                if (bizpartnerId != null && !Objects.equals(bizpartnerId, 0L)) {
                    beforeF7SelectEvent.getCustomQFilters().add(new QFilter("bizpartner", "=", (Object)bizpartnerId));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4f9b\u5e94\u5546\u6570\u636e\u3002", (String)"PurQualityRectificationEdit_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                break;
            }
            case "person": {
                DynamicObject org = dataEntity.getDynamicObject("org");
                if (org == null) break;
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("createorg", "=", (Object)org.getLong("id")));
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        int rowIndex = 0;
        Object modelValue = null;
        switch (propertyName) {
            case "supplier": {
                rowIndex = e.getChangeSet()[0].getRowIndex();
                modelValue = model.getValue(propertyName, rowIndex);
                if (!(modelValue instanceof DynamicObject)) break;
                PurSupplierContacterUtil.supplierChange(model, (DynamicObject)modelValue);
                break;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != afterDoOperationEventArgs.getOperationResult() && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "confirmbefore": {
                    this.confirmBefore(true);
                    break;
                }
                case "returnconfirm": {
                    this.confirmBefore(false);
                    if (null != customParams.get("confirm")) {
                        this.getView().invokeOperation("close");
                    }
                    this.getView().getFormShowParameter().getCustomParams().remove("confirm");
                    break;
                }
                case "confirm": {
                    if (null != customParams.get("confirm")) {
                        this.getView().getFormShowParameter().getCustomParams().remove("confirm");
                        this.getView().invokeOperation("close");
                        break;
                    }
                    this.getView().invokeOperation("refresh");
                    break;
                }
            }
        }
    }

    private void confirmBefore(boolean status) {
        this.setBottomVisible(status);
        if (status) {
            this.setFieldVisible();
            this.setNameBasedOnStatus();
            this.setProblemtypeCombo();
        }
    }

    private void setBottomVisible(Boolean status) {
        this.getView().setVisible(status, new String[]{"bar_confirm", "bar_returnconfirm"});
        this.getView().setVisible(Boolean.valueOf(status == false), new String[]{"bar_submit", "bar_unsubmit", "bar_new", "bar_drawclaim", "bar_audit", "bar_unaudit", "bar_confirmbefore", "bar_close", "bar_cancel", "bar_print", "bar_printsetting", "bar_more", "bar_refresh"});
        this.getView().setVisible(status, new String[]{"confirmhandle"});
    }

    private void setNameBasedOnStatus() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String icastatus = dataEntity.getString("icastatus");
        String pcastatus = dataEntity.getString("pcastatus");
        String verifystatus = dataEntity.getString("verifystatus");
        if (PurQualityRectificEdit.isPendingConfirmation(icastatus).booleanValue()) {
            this.setControlName(ResManager.loadKDString((String)"ICA\u786e\u8ba4", (String)"PurQualityRectificationEdit_1", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            return;
        }
        if (PurQualityRectificEdit.isPendingConfirmation(pcastatus).booleanValue()) {
            this.setControlName(ResManager.loadKDString((String)"PCA\u786e\u8ba4", (String)"PurQualityRectificationEdit_2", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            return;
        }
        if (PurQualityRectificEdit.isPendingConfirmation(verifystatus).booleanValue()) {
            this.setControlName(ResManager.loadKDString((String)"\u9a8c\u8bc1\u786e\u8ba4", (String)"PurQualityRectificationEdit_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    private void setProblemtypeCombo() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String icastatus = dataEntity.getString("icastatus");
        ComboEdit comboEdit = (ComboEdit)this.getControl("problemtype");
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(8);
        ComboItem comboItem = new ComboItem(new LocaleString(ProblemTypeEnum.CONFIRMED.getDesc()), ProblemTypeEnum.CONFIRMED.getValue());
        list.add(comboItem);
        ComboItem comboItem1 = new ComboItem(new LocaleString(ProblemTypeEnum.PENDINGREFEEDBACK.getDesc()), ProblemTypeEnum.PENDINGREFEEDBACK.getValue());
        list.add(comboItem1);
        if (PurQualityRectificEdit.isPendingConfirmation(icastatus).booleanValue()) {
            ComboItem comboItem2 = new ComboItem(new LocaleString(ProblemTypeEnum.ICAPCACONFIRMED.getDesc()), ProblemTypeEnum.ICAPCACONFIRMED.getValue());
            list.add(comboItem2);
        }
        comboEdit.setComboItems(list);
    }

    private static Boolean isPendingConfirmation(String status) {
        return QualityRectificEnum.PENDINGCONFIRMATION.getValue().equals(status) || QualityRectificEnum.PENDINGREFEEDBACK.getValue().equals(status);
    }

    private void setControlName(String name) {
        HashMap<String, String> nameMap = new HashMap<String, String>(8);
        HashMap<String, HashMap<String, String>> map = new HashMap<String, HashMap<String, String>>(8);
        nameMap.put("zh_CN", name);
        map.put("text", nameMap);
        this.getView().updateControlMetadata("confirmhandle", map);
    }

    private void setFieldVisible() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String icastatus = dataEntity.getString("icastatus");
        String pcastatus = dataEntity.getString("pcastatus");
        String verifystatus = dataEntity.getString("verifystatus");
        if (QualityRectificEnum.CONFIRMED.getValue().equals(icastatus) && QualityRectificEnum.CONFIRMED.getValue().equals(pcastatus) && !QualityRectificEnum.CONFIRMED.getValue().equals(verifystatus)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"problemsummary"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"problemsummary"});
        }
    }
}

