/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.list;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pur.common.blueprintshare.po.BluePrintMateriel;
import kd.scm.pur.common.constant.PurBlueprintShareConstant;
import org.apache.commons.lang.StringUtils;

public class PurBluePrintListPlugin
extends AbstractTreeListPlugin {
    private static final Log log = LogFactory.getLog(PurBluePrintListPlugin.class);

    public void registerListener(EventObject e) {
        try {
            Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        catch (Exception exception) {
            log.error("registerListener\uff1a" + exception);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u51fa\u9519\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PurBluePrintPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    public void itemClick(ItemClickEvent e) {
        try {
            String itemKey = e.getItemKey();
            if ("getblueprint".equalsIgnoreCase(itemKey)) {
                this.openGetBluePrintView();
            } else if ("updateblueprint".equalsIgnoreCase(itemKey)) {
                this.openUpdateBluePrintView();
            }
        }
        catch (Exception exception) {
            log.error("itemClick\uff1a" + exception);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u51fa\u9519\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PurBluePrintPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    private void openGetBluePrintView() {
        String currentNodeId;
        String rootId;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pur_get_blueprint");
        formShowParameter.setCustomParam("getType", (Object)"get");
        TreeListModel treeModel = (TreeListModel)this.getTreeModel();
        if (treeModel != null && !StringUtils.equals((String)(rootId = treeModel.getRoot().getId()), (String)(currentNodeId = (String)treeModel.getCurrentNodeId()))) {
            formShowParameter.setCustomParam("group", (Object)currentNodeId);
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void openUpdateBluePrintView() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows.isEmpty()) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pur_get_blueprint");
        formShowParameter.setCustomParam("getType", (Object)"update");
        List ids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        String queryParma = PurBlueprintShareConstant.buildQueryParma((String[])new String[]{"materiel", "id"});
        DynamicObject[] bluePrintShares = BusinessDataServiceHelper.load((String)"pur_blueprint_share", (String)queryParma, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        ArrayList<BluePrintMateriel> bluePrintMateriels = new ArrayList<BluePrintMateriel>(bluePrintShares.length);
        for (DynamicObject bluePrintShare : bluePrintShares) {
            long id = bluePrintShare.getLong("id");
            long materielId = bluePrintShare.getLong("materiel.id");
            String materielNumber = bluePrintShare.getString("materiel.number");
            BluePrintMateriel bluePrintMateriel = new BluePrintMateriel(Long.valueOf(id), materielNumber, Long.valueOf(materielId));
            bluePrintMateriels.add(bluePrintMateriel);
        }
        if (!bluePrintMateriels.isEmpty()) {
            formShowParameter.setCustomParam("blueprintmateriel", bluePrintMateriels);
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        try {
            ListSelectedRowCollection selectedRows;
            int size;
            AbstractOperate operate = (AbstractOperate)args.getSource();
            String operateKey = operate.getOperateKey();
            if (operateKey.equals("updateblueprint") && (size = (selectedRows = this.getSelectedRows()).size()) > 1000) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u6700\u591a\u5141\u8bb8\u6267\u884c {} \u6761\u6570\u636e\u3002", (String)"PurGetBluePrint_5", (String)"scm-pur-formplugin", (Object[])new Object[]{1000}));
                args.setCancel(true);
            }
        }
        catch (Exception e) {
            log.error("beforeDoOperation\uff1a" + e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u51fa\u9519\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PurBluePrintPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }
}

