/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.OrderUtil;
import kd.scm.pur.formplugin.PurCoreListPlugin;
import kd.scm.pur.formplugin.util.ErrorMsgProcessUtil;
import net.sf.json.JSONArray;

public class PurOrderListPlugin
extends PurCoreListPlugin {
    private static Log log = LogFactory.getLog(PurOrderListPlugin.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (!ApiConfigUtil.hasEASConfig()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnpublishorder"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"issyn"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnpublishorder"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"issyn"});
        }
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        Map filterMap = BillFormUtil.getCustomParamsForList((Map)this.getView().getFormShowParameter().getCustomParams());
        if (filterMap.size() > 0) {
            qFilters.addAll(CommonUtil.getQueryListFilter((Map)filterMap));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (ApiConfigUtil.hasEASConfig()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnpublishorder"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnpublishorder"});
        }
    }

    public static QFilter getCustomParamsForList(Map<String, Object> showParameterMap) {
        QFilter qFilter = null;
        Object customFilter = showParameterMap.get("customfilter");
        if (customFilter != null) {
            JSONArray object = JSONArray.fromObject((Object)customFilter);
            HashSet idSet = new HashSet();
            if (object != null && object.size() > 0) {
                idSet.addAll(object);
            }
            if (idSet.size() > 0) {
                qFilter = new QFilter("materialentry.pobillid", "in", idSet);
            }
        }
        return qFilter;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        super.beforeDoOperation(beforeDoOperationEventArgs);
        String operateKey = ((AbstractOperate)beforeDoOperationEventArgs.getSource()).getOperateKey();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String clickKey = evt.getItemKey();
        if ("btnpublishorder".equals(clickKey)) {
            IListView listView = (IListView)this.getView();
            try {
                Object[] primaryKeyValues = listView.getSelectedRows().getPrimaryKeyValues();
                ArrayList<Object> pks = new ArrayList<Object>(Arrays.asList(primaryKeyValues));
                QFilter pkfilter = new QFilter("id", "in", pks);
                QFilter synFilter = new QFilter("issyn", "!=", (Object)"1");
                pkfilter.and(synFilter);
                DynamicObject[] purorders = BusinessDataServiceHelper.load((String)"pur_order", (String)"id", (QFilter[])new QFilter[]{pkfilter});
                ArrayList<Object> unSynpks = new ArrayList<Object>(purorders.length);
                for (DynamicObject purorder : purorders) {
                    unSynpks.add(purorder.get("id"));
                }
                if (unSynpks.size() > 0) {
                    Object result = OrderUtil.synCreateEasOrder(pks, (String)"pur_order", (Boolean)true);
                    this.handleAfterSynOrder(result, pks);
                    listView.showMessage(ResManager.loadKDString((String)"\u8ba2\u5355\u53d1\u5e03\u5b8c\u6210", (String)"PurOrderListPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                } else {
                    listView.showMessage(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u5f20\u672a\u540c\u6b65\u7684\u5355\u636e\u3002", (String)"PurOrderListPlugin_1", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Exception exception) {
                if (ErrorMsgProcessUtil.isEipBaseException(exception)) {
                    listView.showMessage(ResManager.loadKDString((String)"\u8ba2\u5355\u53d1\u5e03\u5931\u8d25", (String)"PurOrderListPlugin_2", (String)"scm-pur-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"PurOrderListPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]), MessageTypes.Default);
                } else {
                    listView.showMessage(ResManager.loadKDString((String)"\u8ba2\u5355\u53d1\u5e03\u5931\u8d25", (String)"PurOrderListPlugin_2", (String)"scm-pur-formplugin", (Object[])new Object[0]), exception.getMessage(), MessageTypes.Default);
                }
                log.error("@@@kd.scm.pur.formplugin.list.PurOrderListPlugin.afterExecuteOperationTransaction(AfterOperationArgs)\u540c\u6b65\u51fa\u9519\uff0c\u51fa\u9519\u539f\u56e0\uff1a" + ExceptionUtil.getStackTrace((Throwable)exception));
            }
        }
    }

    public void handleAfterSynOrder(Object result, List<Object> pks) {
    }
}

