/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.list;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.pur.formplugin.list.PuStockListProvider;
import org.apache.commons.collections.CollectionUtils;

public class PurStockListPlugin
extends AbstractListPlugin {
    private static final int MAX_SAVE_LEN = 200000;

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        String fieldName;
        HyperLinkClickEvent event = e.getHyperLinkClickEvent();
        BillList billList = (BillList)this.getControl("billlistap");
        Object focusRowPkId = billList.getFocusRowPkId();
        DynamicObject purStock = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)"pur_stock", (String)"org,supplier,bizpartner,material");
        DynamicObject material = purStock.getDynamicObject("material");
        DynamicObject org = purStock.getDynamicObject("org");
        DynamicObject supplier = purStock.getDynamicObject("supplier");
        if (material == null || org == null || supplier == null) {
            return;
        }
        long orgId = purStock.getDynamicObject("org").getLong("id");
        long supplierId = purStock.getDynamicObject("supplier").getLong("id");
        long materialId = material.getLong("id");
        switch (fieldName = event.getFieldName()) {
            case "updatelog": {
                e.setCancel(true);
                HashMap<String, Long> paramMap = new HashMap<String, Long>(2);
                paramMap.put("org", orgId);
                paramMap.put("supplier", supplierId);
                paramMap.put("material", materialId);
                OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"pur_inventory_log", (ShowType)ShowType.Modal, paramMap, null);
                break;
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new PuStockListProvider());
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "obtain": {
                this.obtainNewData();
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private DynamicObjectCollection obtainNewData() {
        QFilter invqFilter = this.initQfilter();
        return this.loadNewInventory(invqFilter);
    }

    private QFilter initQfilter() {
        QFilter invqFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter supplierFilter = new QFilter("supplier.issuppcolla", "=", (Object)true);
        invqFilter.and(new QFilter("materialentry.entrystatus", "=", (Object)"A"));
        invqFilter.and(new QFilter("materialentry.material.id", "!=", (Object)0));
        invqFilter.and(new QFilter("materialentry.material.number", "!=", (Object)""));
        invqFilter.and(new QFilter("materialentry.basicqty", ">", (Object)BigDecimal.ZERO));
        invqFilter.and(new QFilter("materialentry.basicunit", "!=", (Object)0));
        List userHasAllPurPermissionOrgs = OrgUtil.getUserHasAllPurPermissionOrgs();
        invqFilter.and(new QFilter("org", "in", (Object)userHasAllPurPermissionOrgs));
        HashSet<String> logisticsStatusSet = new HashSet<String>();
        logisticsStatusSet.add(LogisticsStatusEnum.ALLRECIPT.getVal());
        logisticsStatusSet.add(LogisticsStatusEnum.ALLINSTOCK.getVal());
        invqFilter.and(supplierFilter).and(new QFilter("materialentry.rowlogstatus", "not in", logisticsStatusSet));
        return invqFilter;
    }

    private DynamicObjectCollection loadNewInventory(QFilter qFilter) {
        QFilter[] filters = new QFilter[]{qFilter};
        String selectFields = "id,org,supplier,bizpartner,materialentry.material,materialentry.basicqty,materialentry.basicunit ";
        DynamicObjectCollection purOrders = QueryServiceHelper.query((String)"pur_order", (String)selectFields, (QFilter[])filters);
        HashMap<String, DynamicObject> groupData = new HashMap<String, DynamicObject>(1024);
        for (DynamicObject purOrder : purOrders) {
            String org = purOrder.getString("org");
            String supplier = purOrder.getString("supplier");
            String material = purOrder.getString("materialentry.material");
            if (material == null || supplier == null) continue;
            String keyStr = org + "_" + material + "_" + supplier;
            if (groupData.containsKey(keyStr)) {
                DynamicObject purStock = (DynamicObject)groupData.get(keyStr);
                BigDecimal newQty = purOrder.getBigDecimal("materialentry.basicqty").add(((DynamicObject)groupData.get(keyStr)).getBigDecimal("orderqty"));
                purStock.set("orderqty", (Object)newQty);
                groupData.put(keyStr, purStock);
                continue;
            }
            DynamicObjectType dynamicObjectType = BusinessDataServiceHelper.newDynamicObject((String)"pur_stock").getDynamicObjectType();
            DynamicObject purStock = new DynamicObject(dynamicObjectType);
            purStock.set("org", (Object)purOrder.getLong("org"));
            purStock.set("supplier", (Object)purOrder.getLong("supplier"));
            purStock.set("bizpartner", (Object)purOrder.getLong("bizpartner"));
            purStock.set("material", (Object)purOrder.getLong("materialentry.material"));
            purStock.set("orderqty", (Object)purOrder.getBigDecimal("materialentry.basicqty"));
            purStock.set("unit", purOrder.get("materialentry.basicunit"));
            groupData.put(keyStr, purStock);
        }
        this.dealBackTableData(groupData);
        DynamicObjectCollection newImInv = new DynamicObjectCollection();
        for (Map.Entry map : groupData.entrySet()) {
            newImInv.add(map.getValue());
        }
        return newImInv;
    }

    private void dealBackTableData(Map<String, DynamicObject> groupData) {
        Map<String, DynamicObject> backDataMap = this.loadBackTable();
        Set<String> backDataKeySet = backDataMap.keySet();
        Set<String> newDataKeySet = groupData.keySet();
        List needDeleteKeySet = (List)CollectionUtils.subtract(backDataKeySet, newDataKeySet);
        List needAddKeySet = (List)CollectionUtils.subtract(newDataKeySet, backDataKeySet);
        List needUpdateKeySet = (List)CollectionUtils.subtract(backDataKeySet, (Collection)needDeleteKeySet);
        this.dealDeleteSet(backDataMap, needDeleteKeySet);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        if (needUpdateKeySet.size() > 0) {
            this.dealUpdateSet(groupData, backDataMap, needUpdateKeySet, updateList);
        }
        this.saveDataToDb(updateList);
        ArrayList<DynamicObject> addList = new ArrayList<DynamicObject>();
        if (needAddKeySet.size() > 0) {
            this.dealAddSet(groupData, needAddKeySet, addList);
        }
        this.saveDataToDb(addList);
    }

    private void saveDataToDb(ArrayList<DynamicObject> updateList) {
        ArrayList<DynamicObject> splitDynamicObjectList = new ArrayList<DynamicObject>(200000);
        for (DynamicObject dynamicObject : updateList) {
            splitDynamicObjectList.add(dynamicObject);
            if (splitDynamicObjectList.size() != 200000) continue;
            SaveServiceHelper.save((DynamicObject[])splitDynamicObjectList.toArray(new DynamicObject[200000]));
            splitDynamicObjectList.clear();
        }
        if (!splitDynamicObjectList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])splitDynamicObjectList.toArray(new DynamicObject[splitDynamicObjectList.size()]));
        }
    }

    private void dealUpdateSet(Map<String, DynamicObject> groupData, Map<String, DynamicObject> backDataMap, List<String> needUpdateKeySet, ArrayList<DynamicObject> addAndUpdateList) {
        for (String updateKey : needUpdateKeySet) {
            DynamicObject newData = groupData.get(updateKey);
            BigDecimal newOrderqty = newData.getBigDecimal("orderqty");
            DynamicObject backData = backDataMap.get(updateKey);
            backData.set("orderqty", (Object)newOrderqty);
            addAndUpdateList.add(backData);
        }
    }

    private void dealAddSet(Map<String, DynamicObject> groupData, List<String> needAddKeySet, ArrayList<DynamicObject> addAndUpdateList) {
        for (String addKey : needAddKeySet) {
            DynamicObject purStock = groupData.get(addKey);
            addAndUpdateList.add(purStock);
        }
    }

    private void dealDeleteSet(Map<String, DynamicObject> backDataMap, List<String> needDeleteKeySet) {
        ArrayList<Long> deleteList = new ArrayList<Long>();
        HashSet<String> matchDeleteKey = new HashSet<String>(1024);
        HashSet<Long> supplierIds = new HashSet<Long>(1024);
        for (String deleteKey : needDeleteKeySet) {
            DynamicObject dynamicObject = backDataMap.get(deleteKey);
            long id = dynamicObject.getLong("id");
            if (0L != dynamicObject.getLong("supplier.id")) {
                supplierIds.add(dynamicObject.getLong("supplier.id"));
            }
            matchDeleteKey.add(dynamicObject.getString("material.id") + dynamicObject.getString("org.id"));
            deleteList.add(id);
        }
        QFilter deleteFilter = new QFilter("id", "in", deleteList);
        DeleteServiceHelper.delete((String)"pur_stock", (QFilter[])new QFilter[]{deleteFilter});
        if (supplierIds.size() > 0) {
            QFilter qFilter = new QFilter("supplier.id", "in", supplierIds);
            DynamicObjectCollection scp_inventorylog_record = QueryServiceHelper.query((String)"scp_inventorylog_record", (String)"id,material.id,org.id", (QFilter[])qFilter.toArray());
            HashSet<Long> deleteIds = new HashSet<Long>(1024);
            for (DynamicObject info : scp_inventorylog_record) {
                String key = info.getString("material.id") + info.getString("org.id");
                if (!matchDeleteKey.contains(key)) continue;
                deleteIds.add(info.getLong("id"));
            }
            if (deleteIds.size() > 0) {
                QFilter recordQFilter = new QFilter("id", "in", deleteIds);
                DeleteServiceHelper.delete((String)"scp_inventorylog_record", (QFilter[])recordQFilter.toArray());
            }
        }
    }

    private Map<String, DynamicObject> loadBackTable() {
        String selectFields = "id,org,material,bizpartner,supplier,orderqty,inventoryqty,updatetime,unit";
        DynamicObject[] backTableData = BusinessDataServiceHelper.load((String)"pur_stock", (String)selectFields, null);
        HashMap<String, DynamicObject> groupTableData = new HashMap<String, DynamicObject>(1024);
        for (DynamicObject dynamicObject : backTableData) {
            String orgId = dynamicObject.getString("org.id");
            String materialId = dynamicObject.getString("material.id");
            String supplierId = dynamicObject.getString("supplier.id");
            String keyStr = orgId + "_" + materialId + "_" + supplierId;
            groupTableData.put(keyStr, dynamicObject);
        }
        return groupTableData;
    }
}

