/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.report;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.IReportListModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.jd.JdApiUtil;
import kd.scm.common.enums.PurEcInvoiceEnum;
import kd.scm.common.jd.util.JDAccessTokenUtil;
import kd.scm.common.jd.util.JDHttpsUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.JDOrderUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.ValidateMatchUtil;
import kd.scm.pur.common.PurInvoiceUtil;
import kd.scm.pur.formplugin.util.PurEcInvoiceAllHelper;
import kd.scm.pur.formplugin.util.PurEcInvoiceHelper;
import net.sf.json.JSONObject;

public class PurEcInvoiceRequestFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private Log logger = LogFactory.getLog(PurEcInvoiceRequestFormPlugin.class);
    private static final String REPORTLIST = "reportlistap";
    private static final String PLATFORM = "platform";
    private static final String BD_ADMINDIVISION = "bd_admindivision";
    private static final String CURRENCY = "currency";
    private static final String INVOICEREQ = "invoicereq";
    private static final String INVOICEALL = "invoiceall";
    private static final String REPAIRDATA = "repairdata";
    private static final String PUSHINVOICE = "pushinvoice";
    private static final String VIEWINVOICE = "viewinvoice";
    private static final String CONFIRMRECEIVE = "confirmreceive";
    private static final String UPDATEINVOICE = "updateinvoice";
    private static final String REVNAME = "revname";
    private static final String REVADDRESS = "revaddress";
    private static final String REVADDRESSDETAIL = "revaddressdetail";
    private static final String WHOLEADDRESS = "wholeaddress";
    private static final String JDADDRESSNUM = "jdaddressnum";
    private static final String REVPHONE = "revphone";
    private static final String SELECTALL = "selectall";
    private static final String CLEARALL = "clearall";

    public void registerListener(EventObject e) {
        ReportList list = (ReportList)this.getView().getControl(REPORTLIST);
        list.addHyperClickListener((HyperLinkClickListener)this);
        list.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (StringUtils.isNotBlank((CharSequence)MalOrderUtil.getDefaultCurrency())) {
            this.getModel().setValue(CURRENCY, (Object)MalOrderUtil.getDefaultCurrency());
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{REVADDRESSDETAIL});
        this.setDeaultHistoryAddress();
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        if (StringUtils.equals((CharSequence)"purno", (CharSequence)args.getFieldName())) {
            QFilter filter = new QFilter("billno", "=", (Object)args.getRowData().getString("purno"));
            DynamicObject orderDyo = QueryServiceHelper.queryOne((String)"pur_order", (String)"billno,id", (QFilter[])new QFilter[]{filter});
            if (null != orderDyo) {
                Long malOrderBillPk = orderDyo.getLong("id");
                BillShowParameter billShowParameter = BillFormUtil.assembleShowBillFormParam((String)"pur_order", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)malOrderBillPk, null, null);
                this.getView().showForm((FormShowParameter)billShowParameter);
            }
        }
    }

    public boolean checkBeforeInvoice(BeforeDoOperationEventArgs event, String key) {
        int[] selectIndexs = this.getSelectIndex();
        if (INVOICEALL.equals(key) && selectIndexs != null && selectIndexs.length >= 500) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u5e76\u5f00\u7968\u7684\u5b50\u8ba2\u5355\u6570\u4e0d\u80fd\u8d85\u8fc7500\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PurEcInvoiceRequestFormPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            return false;
        }
        StringBuilder sb = new StringBuilder();
        if (StringUtils.equals((CharSequence)key, (CharSequence)INVOICEREQ) || StringUtils.equals((CharSequence)key, (CharSequence)INVOICEALL)) {
            String phone;
            if (StringUtils.isBlank((Object)this.getModel().getValue(REVNAME))) {
                sb.append(ResManager.loadKDString((String)"\u59d3\u540d,", (String)"PurEcInvoiceRequestFormPlugin_1", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)(phone = String.valueOf(this.getModel().getValue(REVPHONE))))) {
                sb.append(ResManager.loadKDString((String)"\u8054\u7cfb\u65b9\u5f0f,", (String)"PurEcInvoiceRequestFormPlugin_2", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            }
            if (null == this.getModel().getValue(REVADDRESS)) {
                sb.append(ResManager.loadKDString((String)"\u7701\u5e02\u533a,", (String)"PurEcInvoiceRequestFormPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((Object)this.getModel().getValue(REVADDRESSDETAIL))) {
                sb.append(ResManager.loadKDString((String)"\u8be6\u7ec6\u5730\u5740,", (String)"PurEcInvoiceRequestFormPlugin_4", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            }
            if (sb.length() > 1) {
                sb.deleteCharAt(sb.length() - 1);
                sb.append(ResManager.loadKDString((String)"\u4e3a\u5fc5\u5f55\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"PurEcInvoiceRequestFormPlugin_5", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)phone) && !ValidateMatchUtil.isTel((String)phone) && !ValidateMatchUtil.isMobileExact((String)phone)) {
                if (sb.length() > 1) {
                    sb.append('\n');
                }
                sb.append(ResManager.loadKDString((String)"\u6536\u7968\u4eba\u8054\u7cfb\u65b9\u5f0f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u60a8\u7684\u624b\u673a\u53f7\u7801\u6216\u56fa\u5b9a\u7535\u8bdd\u3002", (String)"PurEcInvoiceRequestFormPlugin_6", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            }
            if (sb.toString().length() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6536\u7968\u4eba\u4fe1\u606f\u586b\u5199\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PurEcInvoiceRequestFormPlugin_7", (String)"scm-pur-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
                return false;
            }
            if (selectIndexs.length > 0) {
                DynamicObjectCollection dyoCol = this.getSelectedDyObject(selectIndexs);
                List<String> stateList = this.check4InvoiceState(dyoCol);
                List<String> stockList = this.check4InvoiceAmount(dyoCol);
                List<String> titleList = this.check4InvoiceTitle(dyoCol);
                if (stateList.size() > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5f00\u7968\u72b6\u6001\u4e3a\u5f85\u7533\u8bf7\uff0c\u9a73\u56de\u6216\u5f00\u7968\u5931\u8d25\u7684\u7535\u5546\u8ba2\u5355\u624d\u80fd\u8fdb\u884c\u5f00\u7968\u7533\u8bf7\u3002", (String)"PurEcInvoiceRequestFormPlugin_8", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (stockList.size() > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u8fdb\u884c\u6536\u8d27\u5904\u7406\u7684\u7535\u5546\u8ba2\u5355\u624d\u80fd\u8fdb\u884c\u5f00\u7968\u7533\u8bf7\uff0c\u8bf7\u8054\u7cfb\u6536\u8d27\u4eba\u8fdb\u884c\u6536\u8d27\u5904\u7406\u3002", (String)"PurEcInvoiceRequestFormPlugin_9", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (StringUtils.isBlank((Object)this.getModel().getValue(JDADDRESSNUM))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u7968\u4eba\u4eac\u4e1c\u5730\u5740\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406\u3002", (String)"PurEcInvoiceRequestFormPlugin_10", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (titleList.size() > 0) {
                    this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u7535\u5546\u5b50\u8ba2\u5355{0}\u5bf9\u5e94\u7684\u5f00\u7968\u5355\u4f4d\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PurEcInvoiceRequestFormPlugin_30", (String)"scm-pur-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", titleList)));
                    return false;
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PurEcInvoiceRequestFormPlugin_11", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public List<String> check4InvoiceTitle(DynamicObjectCollection dyoCol) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (DynamicObject dyo : dyoCol) {
            String title = dyo.getString("invoiceorg.ffirmname.zh_CN");
            if (!StringUtils.isBlank((CharSequence)title)) continue;
            resultList.add(dyo.getString("jdchildorderid"));
        }
        return resultList;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String address;
        String addressNumber;
        super.propertyChanged(e);
        String property = e.getProperty().getName();
        IDataModel model = this.getModel();
        if (StringUtils.equalsIgnoreCase((CharSequence)property, (CharSequence)REVADDRESS)) {
            boolean isCity;
            addressNumber = (String)model.getValue(REVADDRESS);
            address = this.getAreaFullName(addressNumber);
            boolean bl = isCity = StringUtils.contains((CharSequence)address, (CharSequence)ResManager.loadKDString((String)"\u5317\u4eac", (String)"PurEcInvoiceRequestFormPlugin_13", (String)"scm-pur-formplugin", (Object[])new Object[0])) || StringUtils.contains((CharSequence)address, (CharSequence)ResManager.loadKDString((String)"\u4e0a\u6d77", (String)"PurEcInvoiceRequestFormPlugin_14", (String)"scm-pur-formplugin", (Object[])new Object[0])) || StringUtils.contains((CharSequence)address, (CharSequence)ResManager.loadKDString((String)"\u5929\u6d25", (String)"PurEcInvoiceRequestFormPlugin_15", (String)"scm-pur-formplugin", (Object[])new Object[0])) || StringUtils.contains((CharSequence)address, (CharSequence)ResManager.loadKDString((String)"\u91cd\u5e86", (String)"PurEcInvoiceRequestFormPlugin_16", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            if (StringUtils.isNotBlank((CharSequence)address) && (address.split("_").length >= 3 && !isCity || address.split("_").length >= 2 && isCity)) {
                this.setWholeAddress(address);
                this.getView().setEnable(Boolean.TRUE, new String[]{REVADDRESSDETAIL});
                this.setJdAddress(address);
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{REVADDRESSDETAIL});
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)property, (CharSequence)REVADDRESSDETAIL)) {
            if (null != model.getValue(REVADDRESS)) {
                addressNumber = (String)model.getValue(REVADDRESS);
                address = this.getAreaFullName(addressNumber);
                if (StringUtils.isNotBlank((CharSequence)address) && address.split("_").length >= 3) {
                    this.setWholeAddress(address);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5c06\u7701\u5e02\u533a\u586b\u5199\u5b8c\u6574\u3002", (String)"PurEcInvoiceRequestFormPlugin_12", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5c06\u7701\u5e02\u533a\u586b\u5199\u5b8c\u6574\u3002", (String)"PurEcInvoiceRequestFormPlugin_12", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void setWholeAddress(String address) {
        StringBuilder sb = new StringBuilder();
        String[] addrstr = address.split("_");
        String detailAddr = (String)this.getModel().getValue(REVADDRESSDETAIL);
        int startIndex = 0;
        if (StringUtils.contains((CharSequence)address, (CharSequence)ResManager.loadKDString((String)"\u5317\u4eac", (String)"PurEcInvoiceRequestFormPlugin_13", (String)"scm-pur-formplugin", (Object[])new Object[0])) || StringUtils.contains((CharSequence)address, (CharSequence)ResManager.loadKDString((String)"\u4e0a\u6d77", (String)"PurEcInvoiceRequestFormPlugin_14", (String)"scm-pur-formplugin", (Object[])new Object[0])) || StringUtils.contains((CharSequence)address, (CharSequence)ResManager.loadKDString((String)"\u5929\u6d25", (String)"PurEcInvoiceRequestFormPlugin_15", (String)"scm-pur-formplugin", (Object[])new Object[0])) || StringUtils.contains((CharSequence)address, (CharSequence)ResManager.loadKDString((String)"\u91cd\u5e86", (String)"PurEcInvoiceRequestFormPlugin_16", (String)"scm-pur-formplugin", (Object[])new Object[0]))) {
            startIndex = 1;
        }
        for (int i = startIndex; i < addrstr.length; ++i) {
            sb.append(addrstr[i]);
        }
        sb.append('_').append(null != detailAddr ? detailAddr : "");
        this.getModel().setValue(WHOLEADDRESS, (Object)sb.toString());
    }

    private void setJdAddress(String address) {
        StringBuilder sb = new StringBuilder();
        try {
            List<String> addressList = this.getJDAddrNumberByAddr(RequestContext.get().getTenantId(), address);
            if (null != addressList && addressList.size() > 0) {
                addressList.forEach(str -> sb.append((String)str).append('_'));
                this.getModel().setValue(JDADDRESSNUM, (Object)sb.substring(0, sb.length() - 1));
            }
        }
        catch (Exception exception) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4eac\u4e1c\u5730\u5740\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"PurEcInvoiceRequestFormPlugin_17", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    private List<String> getJDAddrNumberByAddr(String enterpriseID, String address) {
        if (address.isEmpty()) {
            return null;
        }
        String rsJson = this.getAddressJonString(enterpriseID, address);
        this.logger.info("@@@PurEcInvoiceRequestFormPlugin.getAddressJonString\u8c03\u7528\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a" + rsJson);
        JSONObject jsonObject = JSONObject.fromObject((Object)rsJson);
        ArrayList<String> addrList = null;
        if (jsonObject.getBoolean("success")) {
            addrList = new ArrayList<String>();
            JSONObject result = jsonObject.getJSONObject("result");
            if (!result.getString("provinceId").isEmpty()) {
                addrList.add(result.getString("provinceId"));
            }
            if (!result.getString("cityId").isEmpty()) {
                addrList.add(result.getString("cityId"));
            }
            if (!result.getString("countyId").isEmpty()) {
                addrList.add(result.getString("countyId"));
            }
        }
        return addrList;
    }

    private String getAddressJonString(String enterpriseID, String adress) {
        if (adress.isEmpty()) {
            return null;
        }
        String data = "&address=" + adress;
        String token = JDAccessTokenUtil.getAccessTokenByKD((String)enterpriseID);
        return JDHttpsUtil.httpsJDPost((String)"https://bizapi.jd.com/api/area/getJDAddressFromAddress", (String)("token=" + token + data));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        switch (operateKey = ((AbstractOperate)event.getSource()).getOperateKey()) {
            case "viewinvoice": {
                int[] selectIndex = this.getSelectIndex();
                if (null != selectIndex && selectIndex.length == 1) {
                    DynamicObjectCollection dyoCol = this.getSelectedDyObject(selectIndex);
                    if (null == dyoCol || dyoCol.size() != 1) break;
                    String number = ((DynamicObject)dyoCol.get(0)).getString("jdchildorderid");
                    QFilter qFilter1 = new QFilter("number", "=", (Object)number);
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"pbd_jdorder", (String)"invaddress,number", (QFilter[])new QFilter[]{qFilter1});
                    if (null != dynamicObject) {
                        String invaddress = dynamicObject.getString("invaddress");
                        if (StringUtils.isNotBlank((CharSequence)invaddress) && !invaddress.equals("null")) {
                            this.getView().openUrl(invaddress);
                            break;
                        }
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u7535\u5b50\u53d1\u7968\u53ef\u4f9b\u9884\u89c8\u3002", (String)"PurEcInvoiceRequestFormPlugin_18", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u7535\u5b50\u53d1\u7968\u53ef\u4f9b\u9884\u89c8\u3002", (String)"PurEcInvoiceRequestFormPlugin_18", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (null != selectIndex && selectIndex.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u4e14\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u67e5\u9605\u53d1\u7968\u3002", (String)"PurEcInvoiceRequestFormPlugin_19", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PurEcInvoiceRequestFormPlugin_11", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                break;
            }
            case "invoicereq": {
                boolean result = this.checkBeforeInvoice(event, operateKey);
                if (!result) break;
                this.invoiceRequest();
                break;
            }
            case "invoiceall": {
                boolean result = this.checkBeforeInvoice(event, operateKey);
                if (!result) break;
                this.invoiceAll();
                break;
            }
            case "repairdata": {
                int[] select = this.getSelectIndex();
                if (null != select && select.length == 1) {
                    DynamicObject dynamicObject;
                    String jdOrderId;
                    DynamicObjectCollection dyoCol = this.getSelectedDyObject(select);
                    if (null == dyoCol || dyoCol.size() != 1 || !StringUtils.isNotBlank((CharSequence)(jdOrderId = ((DynamicObject)dyoCol.get(0)).getString("jdchildorderid"))) || null == (dynamicObject = this.getJdOrder(((DynamicObject)dyoCol.get(0)).getString("jdchildorderid"))) || !dynamicObject.getString("number").equals(dynamicObject.getString("jdorderid"))) break;
                    String token = JDAccessTokenUtil.getAccessTokenByKD((String)RequestContext.get().getTenantId());
                    Map childJdOrderIdMap = JDOrderUtil.getJdChildOrderIdMap((String)token, (String)jdOrderId);
                    String remittanceCode = JdApiUtil.selectRemittanceCode((int)2, (int)0, (String)jdOrderId, (int)0, (int)1, (String)"", (int)0, (BigDecimal)dynamicObject.getBigDecimal("taxamount"));
                    Map<String, Long> numberJdOrderIdMap = this.getNumberJdOrderIdMap(childJdOrderIdMap, remittanceCode, dynamicObject);
                    QFilter filter = new QFilter("jdorderid", "=", (Object)jdOrderId);
                    DynamicObject malOrder = BusinessDataServiceHelper.loadSingle((String)"mal_order", (String)"entryentity,entryentity.goods,entryentity.jdorder", (QFilter[])new QFilter[]{filter});
                    DynamicObjectCollection maColl = malOrder.getDynamicObjectCollection("entryentity");
                    for (DynamicObject coll : maColl) {
                        if (Boolean.parseBoolean((String)childJdOrderIdMap.get("isHasChildOrder"))) {
                            coll.set("jdorder", (Object)numberJdOrderIdMap.get(((DynamicObject)coll.get("goods")).get("number")));
                            continue;
                        }
                        coll.set("jdorder", (Object)numberJdOrderIdMap.get("jdorder"));
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{malOrder});
                    DynamicObject purOrder = BusinessDataServiceHelper.loadSingle((String)"pur_order", (String)"materialentry,materialentry.goods,materialentry.jdorder", (QFilter[])new QFilter[]{filter});
                    DynamicObjectCollection purColl = purOrder.getDynamicObjectCollection("materialentry");
                    for (DynamicObject coll : purColl) {
                        if (Boolean.parseBoolean((String)childJdOrderIdMap.get("isHasChildOrder"))) {
                            coll.set("jdorder", (Object)numberJdOrderIdMap.get(((DynamicObject)coll.get("goods")).get("number")));
                            continue;
                        }
                        coll.set("jdorder", (Object)numberJdOrderIdMap.get("jdorder"));
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{purOrder});
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\u3002", (String)"PurEcInvoiceRequestFormPlugin_20", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                break;
            }
            case "pushinvoice": {
                int[] index = this.getSelectIndex();
                if (null != index && index.length == 1) {
                    try {
                        DynamicObjectCollection dyoCol = this.getSelectedDyObject(index);
                        Map<String, Object> dataMap = this.getDataMap(dyoCol);
                        HashMap<String, String> invoiceMap = new HashMap<String, String>();
                        invoiceMap.put("jdchildorderid", ((DynamicObject)dyoCol.get(0)).getString("jdchildorderid"));
                        invoiceMap.put("invtype", ((DynamicObject)dyoCol.get(0)).getString("invtype"));
                        invoiceMap.put("invdetail", "1");
                        invoiceMap.put("invoiceamount", String.valueOf(((DynamicObject)dyoCol.get(0)).getBigDecimal("invoiceamount").setScale(2)));
                        PurEcInvoiceHelper purInvoice = new PurEcInvoiceHelper();
                        purInvoice.autoCreatePurInvoice(dataMap, invoiceMap);
                        break;
                    }
                    catch (Exception e) {
                        throw new KDBizException(ExceptionUtil.getStackTrace((Throwable)e));
                    }
                }
                if (null != index && index.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u4e14\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u67e5\u9605\u53d1\u7968\u3002", (String)"PurEcInvoiceRequestFormPlugin_19", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PurEcInvoiceRequestFormPlugin_11", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                break;
            }
            case "confirmreceive": {
                int[] selectIndexs = this.getSelectIndex();
                if (selectIndexs.length > 0) {
                    boolean flag = true;
                    Set<String> jdChildOrderSet = this.getJdChildOrderId(this.getSelectedDyObject(selectIndexs));
                    try {
                        JDOrderUtil.updateJdStateInfo(jdChildOrderSet);
                    }
                    catch (Exception e) {
                        flag = false;
                        this.logger.error("@@@\u624b\u5de5\u66f4\u65b0\u4eac\u4e1c\u5355\u72b6\u6001\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
                    }
                    String resultstr = JDOrderUtil.confirmRecieve(jdChildOrderSet);
                    if ((resultstr == null || resultstr.length() < 2) && flag) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6536\u8d27\u72b6\u6001\u6210\u529f\u3002", (String)"PurEcInvoiceRequestFormPlugin_21", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    this.getView().showMessage(ResManager.loadKDString((String)"\u66f4\u65b0\u6536\u8d27\u72b6\u6001\u5931\u8d25\u3002", (String)"PurEcInvoiceRequestFormPlugin_22", (String)"scm-pur-formplugin", (Object[])new Object[0]), resultstr, MessageTypes.Default);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PurEcInvoiceRequestFormPlugin_11", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                break;
            }
            case "updateinvoice": {
                try {
                    int[] selectIndexs = this.getSelectIndex();
                    if (selectIndexs.length > 0) {
                        Set<String> jdChildOrderSet = this.getJdChildOrderId(this.getSelectedDyObject(selectIndexs));
                        JDOrderUtil.updateJdInvoiceInfo(jdChildOrderSet);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u5f00\u7968\u72b6\u6001\u6210\u529f\u3002", (String)"PurEcInvoiceRequestFormPlugin_23", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                        this.getView().invokeOperation("refresh");
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PurEcInvoiceRequestFormPlugin_11", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u5f00\u7968\u72b6\u6001\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"PurEcInvoiceRequestFormPlugin_24", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    this.logger.error("@@@\u624b\u5de5\u66f4\u65b0\u53d1\u7968\u7b7e\u6536\u53d1\u7968\u4fe1\u606f\u3001\u72b6\u6001\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
                }
                break;
            }
            case "selectall": {
                ReportList list = (ReportList)this.getView().getControl(REPORTLIST);
                list.getEntryState().setSelectAllRows(true);
                list.selectRows(this.getAllRowIndex(), 1);
                break;
            }
            case "clearall": {
                ReportList list = (ReportList)this.getView().getControl(REPORTLIST);
                list.clearEntryState();
                break;
            }
            case "logquery": {
                try {
                    int[] selectIndexs = this.getSelectIndex();
                    if (selectIndexs.length > 0) {
                        List<String> jdChildOrderSet = this.getJdChildOrderIdList(this.getSelectedDyObject(selectIndexs));
                        PurInvoiceUtil.showJdInvoiceLogistics(jdChildOrderSet, (IFormView)this.getView());
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PurEcInvoiceRequestFormPlugin_11", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    break;
                }
                catch (Exception e) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u53d1\u7968\u7269\u6d41\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"PurEcInvoiceRequestFormPlugin_25", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    this.logger.error("@@@\u83b7\u53d6\u53d1\u7968\u7269\u6d41\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
                }
            }
        }
    }

    private DynamicObject getJdOrder(String jdOrderId) {
        QFilter filter = new QFilter("number", "=", (Object)jdOrderId);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"pbd_jdorder", (boolean)false);
        DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"pbd_jdorder", (String)(selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"pbd_jdorder", (String)"entryentity", (boolean)false)), (QFilter[])new QFilter[]{filter});
        if (dyos != null && dyos.length > 0) {
            return dyos[0];
        }
        return null;
    }

    private Map<String, Long> getNumberJdOrderIdMap(Map<String, Object> childJdOrderIdMap, String remittanceCode, DynamicObject jdOrder) {
        HashMap<String, Long> resultMap = new HashMap();
        if (Boolean.parseBoolean((String)childJdOrderIdMap.get("isHasChildOrder"))) {
            resultMap = JDOrderUtil.saveChildOrder(childJdOrderIdMap, (String)remittanceCode, (DynamicObject)jdOrder);
        } else {
            jdOrder.set("paycode", (Object)remittanceCode);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{jdOrder});
            resultMap.put("jdorder", jdOrder.getLong("id"));
        }
        return resultMap;
    }

    private Set<String> getJdChildOrderId(DynamicObjectCollection dyoCol) {
        HashSet<String> resultSet = new HashSet<String>();
        for (DynamicObject dyo : dyoCol) {
            resultSet.add(dyo.getString("jdchildorderid"));
        }
        return resultSet;
    }

    private List<String> getJdChildOrderIdList(DynamicObjectCollection dyoCol) {
        ArrayList<String> resultSet = new ArrayList<String>();
        for (DynamicObject dyo : dyoCol) {
            resultSet.add(dyo.getString("jdchildorderid"));
        }
        return resultSet;
    }

    protected void invoiceAll() {
        int[] selectIndexs = this.getSelectIndex();
        if (selectIndexs.length > 0) {
            DynamicObjectCollection dyoCol = this.getSelectedDyObject(selectIndexs);
            HashMap<String, Number> paraMap = new HashMap<String, Number>(1);
            int ordernum = dyoCol.size();
            HashSet<String> orgSet = new HashSet<String>();
            BigDecimal settleamt = new BigDecimal("0.0");
            DynamicObject org = null;
            for (DynamicObject bill : dyoCol) {
                org = bill.getDynamicObject("invoiceorg");
                if (org != null) {
                    orgSet.add(org.getPkValue().toString());
                }
                settleamt = settleamt.add(bill.getBigDecimal("invoiceamount"));
            }
            paraMap.put("ordernum", ordernum);
            paraMap.put("orgnum", orgSet.size());
            paraMap.put("settleamt", settleamt);
            CloseCallBack pushCallBack = new CloseCallBack((IFormPlugin)this, INVOICEALL);
            OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"pur_invoicepush", (ShowType)ShowType.Modal, paraMap, (CloseCallBack)pushCallBack);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PurEcInvoiceRequestFormPlugin_11", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    private int[] getAllRowIndex() {
        ReportList list = (ReportList)this.getView().getControl(REPORTLIST);
        int rowCount = list.getReportModel().getRowCount();
        int[] rowIndex = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            rowIndex[i] = i + 1;
        }
        return rowIndex;
    }

    protected void invoiceRequest() {
        PurEcInvoiceHelper purInvoice = new PurEcInvoiceHelper();
        int[] selectIndexs = this.getSelectIndex();
        DynamicObjectCollection dyoCol = this.getSelectedDyObject(selectIndexs);
        Map<String, Object> dataMap = this.getDataMap(dyoCol);
        List<String> failList = purInvoice.invoiceSubmit(dataMap);
        if (failList.size() > 0) {
            String errorMsg = failList.size() == dyoCol.size() ? ResManager.loadKDString((String)"\u5f00\u7968\u5931\u8d25\u3002", (String)"PurEcInvoiceRequestFormPlugin_26", (String)"scm-pur-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u90e8\u5206\u5f00\u7968\u6210\u529f\u3002", (String)"PurEcInvoiceRequestFormPlugin_27", (String)"scm-pur-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(errorMsg, MessageFormat.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7535\u5546\u5b50\u8ba2\u5355\u53f7\u5f00\u7968\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\uff0c\u5931\u8d25\u5355\u53f7\uff1a{0}\u3002", (String)"PurEcInvoiceRequestFormPlugin_28", (String)"scm-pur-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", failList)), MessageTypes.Default);
            this.getView().invokeOperation("refresh");
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u5f00\u7968\u6210\u529f\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8\u5f00\u7968\u72b6\u6001\u53ca\u5f00\u7968\u7ed3\u679c\u3002", (String)"PurEcInvoiceRequestFormPlugin_29", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    protected List<String> check4InvoiceState(DynamicObjectCollection dyoCol) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (DynamicObject dyo : dyoCol) {
            String state = dyo.getString("jdinvoicestate");
            if (StringUtils.equals((CharSequence)PurEcInvoiceEnum.PREREQUEST.getVal(), (CharSequence)state) || StringUtils.equals((CharSequence)PurEcInvoiceEnum.INVOICEFAILED.getVal(), (CharSequence)state) || StringUtils.equals((CharSequence)PurEcInvoiceEnum.REJECT.getVal(), (CharSequence)state) || StringUtils.equals((CharSequence)PurEcInvoiceEnum.CANCEL.getVal(), (CharSequence)state)) continue;
            resultList.add(dyo.getString("jdchildorderid"));
        }
        return resultList;
    }

    protected List<String> check4InvoiceAmount(DynamicObjectCollection dyoCol) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (DynamicObject dyo : dyoCol) {
            BigDecimal stockAmount = dyo.getBigDecimal("stockamount");
            if (stockAmount.compareTo(BigDecimal.ZERO) != 0) continue;
            resultList.add(dyo.getString("jdchildorderid"));
        }
        return resultList;
    }

    protected Map<String, Object> getDataMap(DynamicObjectCollection dyoCol) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("data", dyoCol);
        result.put(PLATFORM, ((DynamicObject)dyoCol.get(0)).getString(PLATFORM));
        result.put(REVNAME, this.getModel().getValue(REVNAME));
        result.put(REVPHONE, this.getModel().getValue(REVPHONE));
        result.put(WHOLEADDRESS, this.getModel().getValue(WHOLEADDRESS));
        result.put(JDADDRESSNUM, this.getModel().getValue(JDADDRESSNUM));
        result.put(REVADDRESS, this.getModel().getValue(REVADDRESS));
        result.put(REVADDRESSDETAIL, this.getModel().getValue(REVADDRESSDETAIL));
        return result;
    }

    private int[] getSelectIndex() {
        ReportList list = (ReportList)this.getView().getControl(REPORTLIST);
        return list.getEntryState().getSelectedRows();
    }

    protected DynamicObjectCollection getSelectedDyObject(int[] selectedIndexs) {
        ReportList list = (ReportList)this.getView().getControl(REPORTLIST);
        IReportListModel reportModel = list.getReportModel();
        DynamicObjectCollection selectedRowsDyObject = new DynamicObjectCollection();
        for (int i = 0; i < selectedIndexs.length; ++i) {
            DynamicObject entryObject = reportModel.getRowData(selectedIndexs[i]);
            if (entryObject == null) continue;
            selectedRowsDyObject.add((Object)entryObject);
        }
        return selectedRowsDyObject;
    }

    private String getAreaFullName(String city) {
        QFilter idfilter = new QFilter("id", "=", (Object)Long.valueOf(city));
        DynamicObject address = QueryServiceHelper.queryOne((String)BD_ADMINDIVISION, (String)"id,fullname,name", (QFilter[])new QFilter[]{idfilter});
        String fullname = address.getString("fullname");
        return fullname;
    }

    private void setDeaultHistoryAddress() {
        String selectFields = "revname,revphone,revaddress";
        String userId = RequestContext.get().getUserId();
        QFilter filter = new QFilter("creator", "=", (Object)Long.valueOf(userId));
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"pur_invoice", (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)"billdate desc");
        if (null != dyoCol && dyoCol.size() > 0) {
            String[] complexAddr = ((DynamicObject)dyoCol.get(0)).getString(REVADDRESS).split("&");
            this.getModel().setValue(REVNAME, (Object)((DynamicObject)dyoCol.get(0)).getString(REVNAME));
            this.getModel().setValue(REVPHONE, (Object)((DynamicObject)dyoCol.get(0)).getString(REVPHONE));
            if (complexAddr.length >= 3) {
                this.getModel().setValue(REVADDRESS, (Object)complexAddr[1]);
                this.getModel().setValue(WHOLEADDRESS, (Object)complexAddr[0]);
                this.getModel().setValue(JDADDRESSNUM, (Object)complexAddr[2]);
                if (complexAddr[0].split("_").length > 1) {
                    this.getModel().setValue(REVADDRESSDETAIL, (Object)complexAddr[0].split("_")[1]);
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String callBackId = e.getActionId();
        this.logger.info("\u786e\u8ba4\u5408\u5e76\u5f00\u7968-------------------" + callBackId);
        if (INVOICEALL.equals(callBackId) && e.getReturnData() != null) {
            this.invoiceall(callBackId);
        }
    }

    private void invoiceall(String callBackId) {
        int[] selectIndexs = this.getSelectIndex();
        PurEcInvoiceAllHelper purInvoice = new PurEcInvoiceAllHelper();
        DynamicObjectCollection dyoCol = this.getSelectedDyObject(selectIndexs);
        HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>(dyoCol.size());
        HashMap<String, String> invoceTypeMap = new HashMap<String, String>(dyoCol.size());
        for (DynamicObject bill : dyoCol) {
            amountMap.put(bill.getString("jdchildorderid"), bill.getBigDecimal("invoiceamount"));
            invoceTypeMap.put(bill.getString("jdchildorderid"), bill.getString("invtype"));
        }
        Map<String, Object> dataMap = this.getDataMap(dyoCol);
        dataMap.put("amountmap", amountMap);
        dataMap.put("invoceTypeMap", invoceTypeMap);
        this.logger.info("\u5408\u5e76\u5f00\u7968\u5f00\u59cb-------------------" + callBackId);
        List<String> failList = purInvoice.invoiceSubmit(dataMap);
        this.logger.info("\u5408\u5e76\u5f00\u7968\u7ed3\u675f-------------------" + callBackId);
        if (failList.size() > 0) {
            String errorMsg = failList.size() == dyoCol.size() ? ResManager.loadKDString((String)"\u5f00\u7968\u5931\u8d25\u3002", (String)"PurEcInvoiceRequestFormPlugin_26", (String)"scm-pur-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u90e8\u5206\u5f00\u7968\u6210\u529f\u3002", (String)"PurEcInvoiceRequestFormPlugin_27", (String)"scm-pur-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(errorMsg, MessageFormat.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7535\u5546\u5b50\u8ba2\u5355\u53f7\u5f00\u7968\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\uff0c\u5931\u8d25\u5355\u53f7\uff1a{0}\u3002", (String)"PurEcInvoiceRequestFormPlugin_28", (String)"scm-pur-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", failList)), MessageTypes.Default);
            this.getView().invokeOperation("refresh");
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u5f00\u7968\u6210\u529f\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8\u5f00\u7968\u72b6\u6001\u53ca\u5f00\u7968\u7ed3\u679c\u3002", (String)"PurEcInvoiceRequestFormPlugin_29", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }
}

