/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.suppliercollenable;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pur.business.suppliercoll.PurSupplierCollInitiateHelper;

public final class PurSupplierCollAssignEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit supplier = (BasedataEdit)this.getView().getControl("supplier");
        if (supplier != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject supplier;
        super.afterCreateNewData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity != null && (supplier = dataEntity.getDynamicObject("supplier")) != null) {
            this.setSupplierCheckValue(supplier.getLong("id"));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IDataEntityProperty dataEntityProperty = beforeF7SelectEvent.getProperty();
        String propertyName = dataEntityProperty.getName();
        if ("supplier".equals(propertyName)) {
            QFilter qFilter = PurSupplierCollInitiateHelper.assembleAvailableSupplierQFilter();
            qFilter = qFilter.and(new QFilter("issuppcolla", "!=", (Object)"1"));
            beforeF7SelectEvent.getCustomQFilters().add(qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("supplier".equals(name) && (newValue = e.getChangeSet()[0].getNewValue()) instanceof DynamicObject) {
            DynamicObject supplier = (DynamicObject)newValue;
            this.setSupplierCheckValue(supplier.getLong("id"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof FormOperate) {
            args.setCancel(true);
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject supplier = dataEntity.getDynamicObject("supplier");
            if (supplier != null) {
                Map supplierCollMap;
                HashSet<Long> supplierIds = new HashSet<Long>(1);
                supplierIds.add(supplier.getLong("id"));
                HashMap customParamMap = new HashMap(1);
                if (!dataEntity.getDataEntityState().getFromDatabase() && !(supplierCollMap = PurSupplierCollInitiateHelper.insertSupplierColl(supplierIds, customParamMap)).isEmpty()) {
                    Long supplierCollId = (Long)supplierCollMap.keySet().stream().findFirst().get();
                    BillModel billModel = (BillModel)this.getModel();
                    billModel.setPKValue((Object)supplierCollId);
                    billModel.load((Object)supplierCollId);
                    this.getView().updateView();
                }
                this.getModel().setDataChanged(false);
            }
        }
    }

    private void setSupplierCheckValue(Long supplierCheckValue) {
        DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)supplierCheckValue, (String)"bd_supplier");
        this.getModel().setValue("number", (Object)supplier.getString("number"));
        this.getModel().setValue("name", (Object)supplier.getString("name"));
        DynamicObject createorg = supplier.getDynamicObject("createorg");
        if (createorg != null) {
            this.getModel().setValue("createorg", (Object)createorg.getLong("id"));
            DynamicObject useorg = supplier.getDynamicObject("useorg");
            if (useorg != null) {
                this.getModel().setValue("useorg", (Object)useorg.getLong("id"));
            } else {
                this.getModel().setValue("useorg", (Object)createorg.getLong("id"));
            }
        }
    }
}

