/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.suppliercollenable;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pur.business.suppliercoll.PurSupplierCollInitiateHelper;
import kd.scm.pur.common.constant.SupplierAssignConstants;

public final class PurSupplierCollAssignList
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(PurSupplierCollAssignList.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (PurSupplierCollInitiateHelper.verifyNeedInitialize()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5df2\u6709\u4e00\u6279\u4f9b\u5e94\u5546\u542f\u7528\u91c7\u8d2d\u534f\u540c\uff0c\u5c06\u521d\u59cb\u5316\u8fd9\u4e00\u90e8\u5206\u4f9b\u5e94\u5546\uff0c\u65b9\u4fbf\u540e\u7eed\u540c\u610f\u7ba1\u7406\u7ef4\u62a4\u3002", (String)"PurSupplierCollAssignList_0", (String)"scm-pur-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener("verifyNeedInitializeAction", (IFormPlugin)this));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        IFormView formView;
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        String operationKey = evt.getOperationKey();
        Toolbar toolbar = (Toolbar)evt.getSource();
        if ("bardisablecoll".equals(itemKey) && (formView = toolbar.getView()) instanceof ListView) {
            ListSelectedRowCollection selectedRows = ((ListView)formView).getSelectedRows();
            HashSet supplierCollIds = new HashSet(16);
            StringBuilder message = new StringBuilder();
            if (selectedRows == null || selectedRows.isEmpty()) {
                message.append(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u5e94\u5546\u3002", (String)"PurSupplierCollAssignList_1", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                this.getView().showTipNotification(message.toString(), Integer.valueOf("800"));
                evt.setCancel(true);
            } else {
                selectedRows.forEach(listSelectedRow -> supplierCollIds.add(listSelectedRow.getPrimaryKeyValue()));
            }
            HashSet<Long> supplierIds = new HashSet<Long>(1024);
            HashSet<Long> inactiveSupplierIds = new HashSet<Long>(1024);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"pur_suppliercollinfo", (String)"supplier,issuppliercoll", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierCollIds)}, (String)"id");){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long supplierId = row.getLong("supplier");
                    if (row.getBoolean("issuppliercoll").booleanValue()) {
                        supplierIds.add(supplierId);
                        continue;
                    }
                    inactiveSupplierIds.add(supplierId);
                }
            }
            if (supplierIds.isEmpty() && !inactiveSupplierIds.isEmpty()) {
                evt.setCancel(true);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5df2\u5173\u95ed\u91c7\u8d2d\u534f\u540c\u3002", (String)"PurSupplierCollAssignList_10", (String)"scm-pur-formplugin", (Object[])new Object[0]), Integer.valueOf(Integer.parseInt("8000")));
            }
            if (!supplierIds.isEmpty()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5173\u95ed\u91c7\u8d2d\u534f\u540c\u540e\u4f9b\u5e94\u5546\u7684\u5355\u636e\u65e0\u6cd5\u81ea\u52a8\u5b9e\u65f6\u540c\u6b65\u5230SRM\uff0c\u786e\u5b9a\u8981\u5173\u95ed\u534f\u540c\u5417\uff1f", (String)"PurSupplierCollAssignList_3", (String)"scm-pur-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("disableCollAction", (IFormPlugin)this), null, SerializationUtils.toJsonString(supplierIds));
            } else {
                evt.setCancel(true);
            }
        }
        if ("barinitializedata".equals(itemKey)) {
            this.inactiveInitialize();
        }
        if ("barenablecoll".equals(itemKey) || "new".equals(operationKey)) {
            evt.setCancel(true);
            this.showInitiateForm();
        }
        if ("bardragbilldata".equals(itemKey) || "bardragbilldata".equals(operationKey)) {
            ListSelectedRowCollection selectedRows;
            evt.setCancel(true);
            formView = toolbar.getView();
            HashSet<Object> supplierCollIds = new HashSet<Object>(16);
            if (formView instanceof ListView && (selectedRows = ((ListView)formView).getSelectedRows()) != null && !selectedRows.isEmpty()) {
                selectedRows.forEach(listSelectedRow -> supplierCollIds.add(listSelectedRow.getPrimaryKeyValue()));
            }
            this.showDragBillDataForm(supplierCollIds);
        }
    }

    private void showInactiveForm(FormShowParameter formShowParameter) {
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        formShowParameter.setFormId("pur_inactivecoll");
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("780px");
        formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "disableCollAction"));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("selectsupplieraction".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) instanceof ListSelectedRowCollection) {
            HashSet<Long> supplierIds = new HashSet<Long>(64);
            for (ListSelectedRow supplier : (ListSelectedRowCollection)returnData) {
                supplierIds.add(Long.parseLong(supplier.getPrimaryKeyValue().toString()));
            }
            HashMap supplierUpdateInfoMap = new HashMap(supplierIds.size());
            supplierIds.forEach(row -> supplierUpdateInfoMap.put(row, Boolean.TRUE));
            HashMap<String, String> customParamMap = new HashMap<String, String>(1);
            customParamMap.put(PurSupplierCollInitiateHelper.PROCESSSOURCE, "process");
            String taskId = PurSupplierCollInitiateHelper.dispatchUpdateSupplierCollTask(supplierUpdateInfoMap, customParamMap);
            this.showProcessTask(taskId);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u5217\u8868\u67e5\u8be2\u3002", (String)"PurSupplierCollAssignList_4", (String)"scm-pur-formplugin", (Object[])new Object[0]), Integer.valueOf(Integer.parseInt("8000")));
            ((ListView)this.getView()).refresh();
        }
        if ("processTaskAction".equals(actionId)) {
            ((ListView)this.getView()).refresh();
        }
        if ("disableCollAction".equals(actionId)) {
            ((ListView)this.getView()).refresh();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("verifyNeedInitializeAction".equals(callBackId)) {
            this.inactiveInitialize();
        }
        if ("disableCollAction".equals(callBackId) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            Collection supplierIds = (Collection)SerializationUtils.fromJsonString((String)messageBoxClosedEvent.getCustomVaule(), Collection.class);
            HashMap supplierUpdateInfoMap = new HashMap(1024);
            HashSet canCloseSupplierIds = new HashSet(1024);
            Map verifySupplierCollMap = PurSupplierCollInitiateHelper.querySuppplierTryColseInfo((Collection)supplierIds);
            supplierIds.forEach(row -> {
                if (!verifySupplierCollMap.containsKey(row)) {
                    supplierUpdateInfoMap.put(row, Boolean.FALSE);
                } else {
                    canCloseSupplierIds.add(row);
                }
            });
            if (!supplierUpdateInfoMap.isEmpty()) {
                HashMap customParamMap = new HashMap(8);
                PurSupplierCollInitiateHelper.updateSupplierColl(supplierUpdateInfoMap, customParamMap);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5173\u95ed\u91c7\u8d2d\u534f\u540c\u6210\u529f\u3002", (String)"PurSupplierCollAssignList_9", (String)"scm-pur-formplugin", (Object[])new Object[0]), Integer.valueOf(Integer.parseInt("8000")));
                ((ListView)this.getView()).refresh();
            }
            if (!canCloseSupplierIds.isEmpty()) {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setCustomParam("content", (Object)ResManager.loadKDString((String)"\u5171{0}\u4e2a\u4f9b\u5e94\u5546\uff0c\u5173\u95ed\u6210\u529f{1}\u4e2a\uff0c\u5931\u8d25{2}\u4e2a\u3002", (String)"PurSupplierCollAssignList_7", (String)"scm-pur-formplugin", (Object[])new Object[]{supplierIds.size(), supplierUpdateInfoMap.size(), canCloseSupplierIds.size()}));
                formShowParameter.setCustomParam(SupplierAssignConstants.SUPPLIERIDS, (Object)SerializationUtils.toJsonString(canCloseSupplierIds));
                this.showInactiveForm(formShowParameter);
            } else {
                ((ListView)this.getView()).refresh();
            }
        }
    }

    private void inactiveInitialize() {
        String taskId = PurSupplierCollInitiateHelper.dispatchInitializeSupplierCollTask();
        this.showProcessTask(taskId);
    }

    private void showProcessTask(String taskId) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("pur_taskprogress");
        param.setCustomParam("taskId", (Object)taskId);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.getOpenStyle().setTargetKey("taskId");
        param.setStatus(OperationStatus.VIEW);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "processTaskAction"));
        this.getView().showForm(param);
    }

    private void showInitiateForm() {
        ListShowParameter listShowParameter = new ListShowParameter();
        QFilter qFilter = PurSupplierCollInitiateHelper.assembleAvailableSupplierQFilter();
        qFilter = qFilter.and(new QFilter("issuppcolla", "!=", (Object)"1"));
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        listShowParameter.setFormId("bos_basedatatreelistf7");
        listShowParameter.setBillFormId("bd_supplier");
        listShowParameter.setLookUp(true);
        listShowParameter.setShowTitle(false);
        listShowParameter.setMultiSelect(true);
        listShowParameter.setMustInput(true);
        listShowParameter.setShowClose(true);
        listShowParameter.setHasRight(true);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u4f9b\u5e94\u5546\u5f00\u542f\u91c7\u8d2d\u534f\u540c\u3002", (String)"PurSupplierCollAssignList_6", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectsupplieraction"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showDragBillDataForm(Collection<Object> supplierCollIds) {
        ReportShowParameter formShowParameter = new ReportShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (supplierCollIds != null && !supplierCollIds.isEmpty()) {
            formShowParameter.setCustomParam(SupplierAssignConstants.SUPPLIERCOLLIDS, (Object)SerializationUtils.toJsonString(supplierCollIds));
        }
        formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        formShowParameter.setFormId("pur_dragbilltool");
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("1376px");
        styleCss.setHeight("780px");
        formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }
}

