/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.suppliercollenable;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mvc.form.FormView;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public final class PurTaskProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
        if (progressBar != null) {
            progressBar.addProgressListener((ProgresssListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object taskId = this.getView().getFormShowParameter().getCustomParam("taskId");
        if (taskId != null && !taskId.toString().isEmpty()) {
            this.putTaskId(taskId.toString());
            this.startBar();
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button && ("btnclose".equals(key = ((Button)source).getKey()) || "btnmin".equals(key))) {
            String taskId = this.getTaskId();
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (taskId != null && !taskInfo.isTaskEnd()) {
                FormView parentView = (FormView)this.getView().getParentView();
                if (parentView == null) {
                    parentView = (FormView)this.getView().getMainView();
                }
                if (parentView != null) {
                    parentView.showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u521d\u59cb\u5316\u4efb\u52a1\u672a\u5b8c\u6210\uff0c\u9000\u51fa\u540e\u8bf7\u901a\u8fc7\u201c\u7cfb\u7edf\u670d\u52a1\u4e91>\u8c03\u5ea6\u4e2d\u5fc3>\u8fd0\u884c\u65e5\u5fd7\u201d\u83dc\u5355\u67e5\u770b\u201c\u542f\u7528\u91c7\u8d2d\u534f\u540c\u5355\u636e\u540c\u6b65\u4efb\u52a1\u201d\u4efb\u52a1\u8fdb\u5ea6\u3002", (String)"PurTaskProgressPlugin_1", (String)"scm-pur-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
                }
            }
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        String taskId = this.getTaskId();
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo.isTaskEnd()) {
            this.complete(taskInfo, progressEvent);
        } else {
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            } else if (progress == 0) {
                BigDecimal lastPercent;
                BigDecimal currencyPercent;
                BigDecimal full = new BigDecimal("100");
                Integer progressPercent = this.getProgressPercent(taskId);
                BigDecimal fixedPercent = currencyPercent = new BigDecimal(progressPercent);
                if (BigDecimal.ZERO.compareTo(currencyPercent) == 0) {
                    fixedPercent = currencyPercent.add(BigDecimal.ONE);
                }
                if ((lastPercent = full.subtract(fixedPercent).divide(full, 2, RoundingMode.UP)).compareTo(BigDecimal.ONE) < 0) {
                    lastPercent = lastPercent.add(BigDecimal.ONE);
                }
                BigDecimal resultPercent = lastPercent.add(currencyPercent);
                progress = resultPercent.intValue();
                this.putProgressPercent(taskId, progress);
            }
            progressEvent.setProgress(progress);
        }
    }

    private String getTaskId() {
        return this.getPageCache().get("initiateinit_taskid");
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.start();
        this.getView().setVisible(Boolean.TRUE, new String[]{"btnmin"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnclose"});
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.stop();
        bar.setPercent(100);
        Label lblprogress = (Label)this.getView().getControl("lblprogress");
        if (lblprogress != null) {
            lblprogress.setText(ResManager.loadKDString((String)"\u5904\u7406\u5b8c\u6210", (String)"PurTaskProgressPlugin_2", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnmin"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"btnclose"});
    }

    private void putTaskId(String taskId) {
        this.getPageCache().put("initiateinit_taskid", taskId);
    }

    private void complete(TaskInfo taskInfo, ProgressEvent e) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)taskInfo.getStatus())) {
            this.stopBar();
        } else {
            e.setProgress(100);
            this.stopBar();
        }
    }

    private Integer getProgressPercent(String taskId) {
        String progressString = this.getPageCache().get(taskId);
        int progressPercent = 0;
        if (progressString != null && !progressString.isEmpty()) {
            progressPercent = Integer.parseInt(progressString);
        }
        return progressPercent;
    }

    private void putProgressPercent(String taskId, Integer progressPercent) {
        this.getPageCache().put(taskId, progressPercent.toString());
    }
}

