/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.PlatformEnums;
import kd.scm.common.enums.PurEcInvoiceEnum;
import kd.scm.common.jd.errorcode.JDAPIErrorCode;
import kd.scm.common.jd.util.JDAccessTokenUtil;
import kd.scm.common.jd.util.JDHttpsUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pur.common.ecinvoice.service.impl.GenericEcInvoiceService;
import net.sf.json.JSONObject;

public class PurEcInvoiceHelper {
    private static Log log = LogFactory.getLog(PurEcInvoiceHelper.class);

    public List<String> invoiceSubmit(Map<String, Object> dataMap) {
        DynamicObjectCollection dyoCol = (DynamicObjectCollection)dataMap.get("data");
        ArrayList<String> failList = new ArrayList<String>();
        HashMap<String, String> invoiceMap = new HashMap<String, String>();
        HashMap<String, String> invoiceStateMap = new HashMap<String, String>();
        HashMap<String, String> markIdMap = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        StringBuilder errorsb = new StringBuilder();
        block22: for (DynamicObject dyo : dyoCol) {
            String data = this.getInvoiceSubmitData(dyo, dataMap, invoiceMap);
            String jdChildOrderId = dyo.getString("jdchildorderid");
            sb.append("jdchildorderid").append(jdChildOrderId).append(System.lineSeparator());
            sb.append("@@@invoiceSubmit apply invoice data\uff1a").append(data).append(System.lineSeparator());
            String json = JDHttpsUtil.httpsJDPost((String)"https://bizapi.jd.com/api/invoice/submit", (String)data);
            sb.append("@@@result:").append(json).append(System.lineSeparator());
            JSONObject node = JSONObject.fromObject((Object)json);
            if (node.getBoolean("success")) {
                String code;
                switch (code = node.getString("resultCode")) {
                    case "2007": 
                    case "3304": 
                    case "5002": 
                    case "3302": {
                        failList.add(jdChildOrderId);
                        invoiceStateMap.put(jdChildOrderId, PurEcInvoiceEnum.INVOICEFAILED.getVal());
                        break;
                    }
                    default: {
                        try {
                            this.autoCreatePurInvoice(dataMap, invoiceMap);
                            invoiceStateMap.put(jdChildOrderId, PurEcInvoiceEnum.HANDLING.getVal());
                            markIdMap.put(jdChildOrderId, (String)invoiceMap.get("markId"));
                            break;
                        }
                        catch (Exception e) {
                            errorsb.append("@@@autoCreatePurInvoice error\uff1a").append(ExceptionUtil.getStackTrace((Throwable)e)).append(System.lineSeparator());
                            failList.add(jdChildOrderId);
                            invoiceStateMap.put(jdChildOrderId, PurEcInvoiceEnum.INVOICEFAILED.getVal());
                            continue block22;
                        }
                    }
                }
                continue;
            }
            failList.add(jdChildOrderId);
            invoiceStateMap.put(jdChildOrderId, PurEcInvoiceEnum.INVOICEFAILED.getVal());
        }
        if (sb.length() > 0) {
            log.info(sb.toString());
        }
        if (errorsb.length() > 0) {
            log.error(errorsb.toString());
        }
        try (TXHandle h = TX.requiresNew();){
            this.updateJdInvoiceState(invoiceStateMap, markIdMap);
        }
        catch (Exception e) {
            log.error("@@@kd.scm.pur.formplugin.util.PurEcInvoiceHelper.invoiceSubmit\u5f00\u7968\u53cd\u5199\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0" + ExceptionUtil.getStackTrace((Throwable)e));
        }
        return failList;
    }

    private void updateJdInvoiceState(Map<String, String> invoiceStateMap, Map<String, String> markIdMap) {
        DynamicObject[] dyos;
        QFilter malOrderFilter = new QFilter("number", "in", invoiceStateMap.keySet());
        for (DynamicObject dyo : dyos = BusinessDataServiceHelper.load((String)"pbd_jdorder", (String)"number,invoicestate,markid", (QFilter[])new QFilter[]{malOrderFilter})) {
            String markIdNum;
            String number = dyo.getString("number");
            String invoiceStateNum = invoiceStateMap.get(number);
            if (invoiceStateNum != null) {
                dyo.set("invoicestate", (Object)invoiceStateNum);
            }
            if ((markIdNum = markIdMap.get(number)) == null) continue;
            dyo.set("markid", (Object)markIdNum);
        }
        SaveServiceHelper.save((DynamicObject[])dyos);
    }

    private String getInvoiceSubmitData(DynamicObject dyo, Map<String, Object> dataMap, Map<String, String> invoiceMap) {
        StringBuilder data = new StringBuilder();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String jdChildOrderId = dyo.getString("jdchildorderid");
        invoiceMap.put("jdchildorderid", jdChildOrderId);
        String invType = dyo.getString("invtype");
        invoiceMap.put("invtype", invType);
        String markId = this.createMarkId(jdChildOrderId);
        invoiceMap.put("markId", markId);
        invoiceMap.put("invdetail", "1");
        String invoiceAmount = String.valueOf(dyo.getBigDecimal("invoiceamount").setScale(2));
        String[] jdAddress = dataMap.get("jdaddressnum") != null ? String.valueOf(dataMap.get("jdaddressnum")).split("_") : new String[]{};
        String token = this.getInvoiceToken();
        invoiceMap.put("invoiceamount", invoiceAmount);
        data.append("token=").append(token);
        data.append("&supplierOrder=").append(jdChildOrderId);
        data.append("&markId=").append(markId);
        data.append("&settlementId=").append(jdChildOrderId);
        String ecInvType = GenericEcInvoiceService.ierpMapEcInvType((String)invType, (String)EcPlatformEnum.ECPLATFORM_JD.getVal());
        data.append("&invoiceType=").append(ecInvType);
        data.append("&enterpriseTaxpayer=").append(dyo.getString("invoiceorg.ftaxregnum").trim());
        data.append("&bizInvoiceContent=").append(1);
        data.append("&title=").append(dyo.getString("invoiceorg.ffirmname.zh_CN").trim());
        if (StringUtils.isNotBlank((Object)dataMap.get("revname")) && StringUtils.isNotBlank((Object)dataMap.get("revphone"))) {
            data.append("&billToer=").append(dataMap.get("revname"));
            data.append("&billToContact=").append(dataMap.get("revphone"));
        }
        int billToProvinceId = 0;
        int billToCityId = 1;
        int billToCountyId = 2;
        if (jdAddress.length == 3) {
            data.append("&billToProvince=").append(jdAddress[billToProvinceId]);
            data.append("&billToCity=").append(jdAddress[billToCityId]);
            data.append("&billToCounty=").append(jdAddress[billToCountyId]);
            data.append("&billToTown=").append('0');
            data.append("&billToAddress=").append(dataMap.get("revaddressdetail"));
        }
        data.append("&invoiceOrg=").append(this.getInvoiceOrgCode());
        data.append("&invoiceDate=").append(format.format(new Date()));
        data.append("&invoiceNum=").append(1);
        data.append("&invoicePrice=").append(invoiceAmount);
        data.append("&currentBatch=").append(1);
        data.append("&totalBatch=").append(1);
        data.append("&totalBatchInvoiceAmount=").append(invoiceAmount);
        return data.toString();
    }

    private String getInvoiceOrgCode() {
        String enterpriseId = RequestContext.getOrCreate().getTenantId();
        String selectFields = "invoiceorgcode";
        QFilter qfiter = new QFilter("tenantid", "=", (Object)enterpriseId);
        qfiter.and(new QFilter("platform", "=", (Object)PlatformEnums.JD.getValue()));
        DynamicObject dyo = QueryServiceHelper.queryOne((String)"pmm_ecadmit", (String)selectFields, (QFilter[])new QFilter[]{qfiter});
        if (null != dyo && StringUtils.isNotBlank((CharSequence)dyo.getString("invoiceorgcode"))) {
            return dyo.getString("invoiceorgcode");
        }
        return "544";
    }

    private String createMarkId(String jdChildOrderId) {
        Calendar calendar = Calendar.getInstance();
        StringBuilder markId = new StringBuilder();
        String d = new SimpleDateFormat("yyyyMMddHHmmSS").format(calendar.getTime());
        markId.append(d).append('-').append(jdChildOrderId);
        return markId.toString();
    }

    private String getInvoiceToken() {
        String enterpriseId = RequestContext.getOrCreate().getTenantId();
        try {
            return JDAccessTokenUtil.getAccessTokenByKD((String)enterpriseId);
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                throw new KDBizException(JDAPIErrorCode.GET_JDTOKEN_FAILED, new Object[0]);
            }
            throw new KDException(JDAPIErrorCode.SYS_ERROR, new Object[]{ExceptionUtil.getStackTrace((Throwable)e)});
        }
    }

    public void autoCreatePurInvoice(Map<String, Object> dataMap, Map<String, String> invoiceMap) {
        DynamicObjectCollection billColl = this.assemblePushBillData(invoiceMap.get("jdchildorderid"), "pur_order");
        if (null == billColl) {
            throw new KDBizException(new ErrorCode("getSourceBill error", ResManager.loadKDString((String)"\u7533\u8bf7\u5f00\u7968\u751f\u6210\u5f00\u7968\u8bb0\u5f55\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PurEcInvoiceHelper_0", (String)"scm-pur-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        if (null != billColl && billColl.size() > 0) {
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber("pur_order");
            pushArgs.setTargetEntityNumber("pur_invoice");
            pushArgs.setBuildConvReport(true);
            ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
            for (DynamicObject billData : billColl) {
                ListSelectedRow row = new ListSelectedRow((Object)billData.getLong("id"));
                row.setEntryEntityKey("materialentry");
                row.setEntryPrimaryKeyValue((Object)billData.getLong("entryentity"));
                selectedRowList.add(row);
            }
            pushArgs.setSelectedRows(selectedRowList);
            ConvertOperationResult result = null;
            try {
                result = ConvertServiceHelper.push((PushArgs)pushArgs);
            }
            catch (Exception e) {
                throw new KDException(new ErrorCode("push error", ResManager.loadKDString((String)"\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u3002", (String)"PurEcInvoiceHelper_1", (String)"scm-pur-formplugin", (Object[])new Object[0])), new Object[]{e.getMessage()});
            }
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"pur_invoice");
            if (result.isSuccess()) {
                List targetData = result.loadTargetDataObjects(new IRefrencedataProvider(){

                    public void fillReferenceData(Object[] objects, IDataEntityType iDataEntityType) {
                        BusinessDataServiceHelper.loadRefence((Object[])objects, (IDataEntityType)iDataEntityType);
                    }
                }, mainType);
                this.handleAfterPushBill((DynamicObject)targetData.get(0), dataMap, invoiceMap);
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("isStrict", String.valueOf(false));
                option.setVariableValue("WF", String.valueOf(false));
                OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"pur_invoice", (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)option);
                if (!saveResult.isSuccess()) {
                    log.error("@@@kd.scm.pur.formplugin.util.PurEcInvoiceHelper.autoCreatePurInvoice:\u4fdd\u5b58\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getErrorInfoDetails((List)saveResult.getAllErrorOrValidateInfo()));
                    throw new KDBizException(new ErrorCode("operation error", ResManager.loadKDString((String)"\u751f\u6210\u5f00\u7968\u8bb0\u5f55\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PurEcInvoiceHelper_2", (String)"scm-pur-formplugin", (Object[])new Object[0])), new Object[]{saveResult.getMessage()});
                }
            } else {
                log.info("@@@kd.scm.pur.formplugin.util.PurEcInvoiceHelper.autoCreatePurInvoice:\u5355\u636e\u4e0b\u63a8\u5931\u8d25\uff1a" + result.getMessage() + result.getReports());
            }
        }
    }

    public void handleAfterPushBill(DynamicObject targetData, Map<String, Object> dataMap, Map<String, String> invoiceMap) {
        targetData.set("revname", dataMap.get("revname"));
        targetData.set("revphone", dataMap.get("revphone"));
        targetData.set("revaddress", (Object)(dataMap.get("wholeaddress") + "&" + dataMap.get("revaddress") + "&" + dataMap.get("jdaddressnum")));
        DynamicObject dyo = this.getJdOrderData(invoiceMap.get("jdchildorderid"));
        log.info("@@dataMap:" + dataMap);
        targetData.set("jdorder_id", (Object)dyo.getString("id"));
        if (StringUtils.isNotBlank((CharSequence)invoiceMap.get("invtype"))) {
            if (StringUtils.equals((CharSequence)"2", (CharSequence)invoiceMap.get("invtype"))) {
                targetData.set("invtype", (Object)"6");
            } else {
                targetData.set("invtype", (Object)"7");
            }
        }
        targetData.set("invdetail", (Object)"2");
        targetData.set("reqperson", (Object)RequestContext.get().getUserId());
        targetData.set("sumtaxamount", (Object)CommonUtil.getBigDecimalPro((Object)invoiceMap.get("invoiceamount")));
        targetData.set("payableamt", (Object)CommonUtil.getBigDecimalPro((Object)invoiceMap.get("invoiceamount")));
    }

    private DynamicObjectCollection assemblePushBillData(String jdChildOrderId, String entityKey) {
        QFilter filter = new QFilter("materialentry.jdorder.number", "=", (Object)jdChildOrderId);
        return QueryServiceHelper.query((String)entityKey, (String)"id,materialentry.id entryentity", (QFilter[])new QFilter[]{filter});
    }

    private DynamicObject getJdOrderData(String jdChildOrderId) {
        QFilter filter = new QFilter("number", "=", (Object)jdChildOrderId);
        return (DynamicObject)QueryServiceHelper.query((String)"pbd_jdorder", (String)"id", (QFilter[])new QFilter[]{filter}).get(0);
    }
}

