/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.expertfilter.expertfilter.ExpertFilterUtils;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.util.SrcBidAssessUtils;
import kd.scm.src.common.util.SrcUsualUserUtils;

public class SrcAssessCfgBatchPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        Map paraMap = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("project", paraMap.get("project"));
        this.getModel().setValue("scoretype", paraMap.get("scoretype"));
        this.getModel().setValue("scoremethod", paraMap.get("scoremethod"));
        this.getModel().setValue("isbyproject", paraMap.get("isbyproject"));
        this.getModel().setValue("ratio_tec", paraMap.get("ratio_tec"));
        this.getModel().setValue("ratio_biz", paraMap.get("ratio_biz"));
        this.getModel().setValue("ratio_oth", paraMap.get("ratio_oth"));
        this.getModel().setValue("ratio_syn", paraMap.get("ratio_syn"));
        this.getModel().setValue("ratio_apt", paraMap.get("ratio_apt"));
        this.getModel().setValue("ratio_apt2", paraMap.get("ratio_apt2"));
        this.setPackageDefaultValue();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int count = this.getModel().getEntryRowCount("entryentity");
        if (count < 2) {
            this.setPackageDefaultValue();
        } else {
            this.getModel().setValue("package", this.getModel().getValue("package", count - 2), count - 1);
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit scorer;
        super.registerListener(e);
        BasedataEdit pkgEdit = (BasedataEdit)this.getControl("package");
        pkgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("indextype");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit scheme = (BasedataEdit)this.getView().getControl("scheme");
        if (scheme != null) {
            scheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((scorer = (BasedataEdit)this.getView().getControl("scorer")) != null) {
            scorer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String opkey;
        super.beforeDoOperation(evt);
        switch (opkey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "save": {
                DynamicObjectCollection bidDocRows = this.getModel().getEntryEntity("entryentity");
                if (bidDocRows == null || bidDocRows.size() == 0) {
                    return;
                }
                this.getView().returnDataToParent((Object)bidDocRows);
                break;
            }
            case "usualuser": {
                long billId = SrcUsualUserUtils.getBillId((String)"src_bidopen_config");
                if (billId > 0L) {
                    OpenFormUtils.openBillPage((IFormView)this.getView(), (String)"src_usualuser", (Object)billId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.Modal, null, null);
                }
                evt.setCancel(true);
                break;
            }
            case "projectscorer": {
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_projectscorer", (ShowType)ShowType.Modal, null, null);
                break;
            }
        }
    }

    private void setPackageDefaultValue() {
        int count = this.getModel().getEntryRowCount("entryentity");
        if (count == 0) {
            return;
        }
        long projectId = this.getModel().getDataEntity().getLong("project.id");
        if (0L == projectId) {
            return;
        }
        QFilter qFilter = new QFilter("project", "=", (Object)projectId);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_packagef7", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"packagename");
        List<Object> packageList = rows.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
        this.getModel().setValue("package", (Object)packageList.toArray(new Object[packageList.size()]), count - 1);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        block5 : switch (key = e.getProperty().getName()) {
            case "indextype": {
                String baseType;
                int index = e.getChangeSet()[0].getRowIndex();
                DynamicObject row = model.getEntryRowEntity("entryentity", index);
                DynamicObject indexTypeObj = row.getDynamicObject("indextype");
                model.setValue("scheme", null, index);
                if (indexTypeObj == null) {
                    model.setValue("weight", null, index);
                    return;
                }
                IFormView parentView = this.getView().getParentView();
                if (Objects.isNull(parentView)) {
                    return;
                }
                if (Objects.equals(parentView.getEntityId(), "src_bidopen_config")) {
                    String baseType2;
                    HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
                    paramMap.put("indextypeid", SrmCommonUtil.getPkValue((DynamicObject)indexTypeObj));
                    paramMap.put("scoretype", model.getDataEntity().getString("scoretype"));
                    paramMap.put("scoremethod", model.getDataEntity().getString("scoremethod"));
                    SchemeFilterUtils.autoSetScheme((IFormView)parentView, (int)index, paramMap, (IDataModel)model);
                    switch (baseType2 = indexTypeObj.getString("basetype")) {
                        case "1": {
                            model.setValue("weight", model.getValue("ratio_tec"), index);
                            break;
                        }
                        case "2": {
                            model.setValue("weight", model.getValue("ratio_biz"), index);
                            break;
                        }
                        case "3": {
                            model.setValue("weight", model.getValue("ratio_oth"), index);
                            break;
                        }
                        case "6": {
                            model.setValue("weight", model.getValue("ratio_syn"), index);
                            break;
                        }
                        case "4": {
                            model.setValue("weight", model.getValue("ratio_apt"), index);
                            break;
                        }
                        case "7": {
                            model.setValue("weight", model.getValue("ratio_apt2"), index);
                            break;
                        }
                    }
                }
                if (!Objects.equals(parentView.getEntityId(), "src_aptitudeconfig") && !Objects.equals(parentView.getEntityId(), "src_aptitudeconfig2")) break;
                SchemeFilterUtils.autoSetScheme((IFormView)parentView, (IDataModel)model, (int)index);
                switch (baseType = indexTypeObj.getString("basetype")) {
                    case "4": 
                    case "7": {
                        this.getModel().setValue("weight", (Object)100, index);
                        break block5;
                    }
                }
                break;
            }
            case "scoretype": {
                String scoreType = PdsCommonUtils.object2String((Object)e.getChangeSet()[0].getNewValue(), (String)"1");
                HashMap<String, Object> paramMap2 = new HashMap<String, Object>(2);
                paramMap2.put("scoretype", scoreType);
                DynamicObjectCollection rows = model.getEntryEntity("entryentity");
                for (int i = 0; i < rows.size(); ++i) {
                    paramMap2.put("indextypeid", SrmCommonUtil.getPkValue((DynamicObject)((DynamicObject)rows.get(i)).getDynamicObject("indextype")));
                    long schemeId2 = SchemeFilterUtils.getFirstSchemeId((DynamicObject)this.getModel().getDataEntity().getDynamicObject("project"), (String)"src_bidopen_config", paramMap2);
                    if (schemeId2 == 0L) {
                        model.setValue("scheme", null, i);
                        continue;
                    }
                    model.setValue("scheme", (Object)schemeId2, i);
                }
                break;
            }
            case "bidattach": {
                AttachmentUtils.setAttachFileName((IFormView)this.getView(), (int)model.getEntryCurrentRowIndex("entryentity"));
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        IDataModel model = this.getModel();
        switch (key = evt.getProperty().getName()) {
            case "indextype": {
                ArrayList<String> indexTypes = new ArrayList<String>(4);
                if (SrcBidAssessUtils.isFinalValue((IDataModel)this.getModel()) || model.getDataEntity().getBigDecimal("ratio_tec").compareTo(BigDecimal.ZERO) > 0) {
                    indexTypes.add("1");
                }
                if (SrcBidAssessUtils.isFinalValue((IDataModel)this.getModel()) || model.getDataEntity().getBigDecimal("ratio_biz").compareTo(BigDecimal.ZERO) > 0) {
                    indexTypes.add("2");
                }
                if (SrcBidAssessUtils.isFinalValue((IDataModel)this.getModel()) || model.getDataEntity().getBigDecimal("ratio_oth").compareTo(BigDecimal.ZERO) > 0) {
                    indexTypes.add("3");
                }
                if (model.getDataEntity().getBigDecimal("ratio_syn").compareTo(BigDecimal.ZERO) > 0) {
                    indexTypes.add("6");
                }
                if (model.getDataEntity().getBigDecimal("ratio_apt").compareTo(BigDecimal.ZERO) > 0) {
                    indexTypes.add("4");
                }
                if (model.getDataEntity().getBigDecimal("ratio_apt2").compareTo(BigDecimal.ZERO) > 0) {
                    indexTypes.add("7");
                }
                ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("basetype", "in", indexTypes));
                break;
            }
            case "package": {
                String objectName = evt.getProperty().getName();
                long projectId = model.getDataEntity().getLong("project.id");
                if (!StringUtils.equals((CharSequence)objectName, (CharSequence)"package")) break;
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                QFilter qFilter = new QFilter("project", "=", (Object)projectId);
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "scheme": {
                IFormView parentView = this.getView().getParentView();
                if (null == parentView) {
                    return;
                }
                DynamicObject row = model.getEntryRowEntity("entryentity", evt.getRow());
                Map paramMap = this.getView().getFormShowParameter().getCustomParams();
                paramMap.put("indextypeid", SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("indextype")));
                paramMap.put("scoretype", model.getDataEntity().getString("scoretype"));
                IFormView pparentView = parentView.getParentView();
                if (null == pparentView) {
                    return;
                }
                DynamicObject billObj = pparentView.getModel().getDataEntity();
                SchemeFilterUtils.setSchemeF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)billObj, (String)parentView.getEntityId(), (Map)paramMap);
                break;
            }
            case "scorer": {
                String expertType = ExpertFilterUtils.inviteExpertType();
                if (null == expertType) break;
                HashMap<String, Boolean> scorerParamMap = new HashMap<String, Boolean>(1);
                scorerParamMap.put("ismustinput", true);
                ExpertFilterUtils.setExpertF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)this.getView().getParentView().getModel().getDataEntity(), (String)("src_expertevaluate_" + expertType + '_' + "filter"), scorerParamMap);
                break;
            }
        }
    }
}

