/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcBiddocBatchPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        Map paraMap = this.getView().getFormShowParameter().getCustomParams();
        Object projectId = paraMap.get("project");
        this.getModel().setValue("parentid", projectId);
        this.setPackageDefaultValue();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int count = this.getModel().getEntryRowCount("entryentity");
        if (count < 2) {
            this.setPackageDefaultValue();
        } else {
            this.getModel().setValue("package", this.getModel().getValue("package", count - 2), count - 1);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit pkgEdit = (BasedataEdit)this.getControl("package");
        pkgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String objectName = evt.getProperty().getName();
        long projectId = this.getModel().getDataEntity().getLong("parentid");
        if (StringUtils.equals((CharSequence)objectName, (CharSequence)"package")) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter qFilter = new QFilter("project.id", "=", (Object)projectId);
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String opkey;
        super.beforeDoOperation(evt);
        switch (opkey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "save": {
                if (!this.checkBidSrcDoc()) {
                    evt.setCancel(true);
                    return;
                }
                this.getView().returnDataToParent((Object)this.getModel().getEntryEntity("entryentity"));
                break;
            }
        }
    }

    private void setPackageDefaultValue() {
        int count = this.getModel().getEntryRowCount("entryentity");
        if (count == 0) {
            return;
        }
        Object projectIdObj = this.getModel().getValue("parentid");
        if (null == projectIdObj || projectIdObj.toString().trim().length() == 0) {
            return;
        }
        long projectId = PdsCommonUtils.object2Long((Object)projectIdObj);
        QFilter qFilter = new QFilter("project.id", "=", (Object)projectId);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_packagef7", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"packagename");
        this.getModel().setValue("package", rows.stream().map(row -> row.getLong("id")).toArray(Object[]::new), count - 1);
    }

    private boolean checkBidSrcDoc() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        if (rows == null || rows.size() == 0) {
            return true;
        }
        Object projectId = this.getModel().getValue("parentid");
        DynamicObject winruleObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_project_rule");
        if (winruleObj == null) {
            return true;
        }
        BigDecimal tecRatio = winruleObj.getBigDecimal("ratio_tec");
        if (tecRatio.compareTo(BigDecimal.ZERO) <= 0) {
            return true;
        }
        for (DynamicObject row2 : rows) {
            String fileType = row2.getString("packfiletype");
            if (fileType != null && !"".equals(fileType.trim())) continue;
            this.getView().showMessage(ResManager.loadKDString((String)"\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrcBiddocBatchPlugin_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return false;
        }
        Boolean noneTecDoc = rows.stream().noneMatch(row -> "1".equals(row.getString("packfiletype")));
        if (noneTecDoc.booleanValue()) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6280\u672f\u6807\u5360\u6bd4(%1$s)\u5927\u4e8e0, \u9700\u4e0a\u4f20\u6280\u672f\u6807\u4e66\u3002", (String)"SrcBiddocBatchPlugin_1", (String)"scm-src-formplugin", (Object[])new Object[0]), tecRatio.setScale(2)));
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String keyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (null == newValue) {
            return;
        }
        switch (keyName) {
            case "bidattach": {
                AttachmentUtils.setAttachFileName((IFormView)this.getView(), (int)index);
                break;
            }
        }
    }
}

