/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.SrcScoreFacade;
import kd.scm.src.common.score.SrcScoreHelper;
import kd.scm.src.common.util.SrcAptitudeUtils;
import org.apache.commons.lang.StringUtils;

public class SrcScoreAssist
extends AbstractFormPlugin {
    private boolean isChanging = false;

    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        String baseType = PdsCommonUtils.object2String(showParameter.getCustomParams().get("basetype"), (String)"");
        if ("4".equals(baseType)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u8d44\u8d28\u9884\u5ba1\u52a9\u624b", (String)"SrcScoreAssist_8", (String)"scm-src-formplugin", (Object[])new Object[0]));
        } else if ("7".equals(baseType)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u8d44\u8d28\u540e\u5ba1\u52a9\u624b", (String)"SrcScoreAssist_9", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        String baseType = PdsCommonUtils.object2String(paramMap.get("basetype"), (String)"");
        if ("4".equals(baseType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"quoteanalyse"});
        } else if ("7".equals(baseType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"quoteanalyse"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"aptitudereply", "aptitudereply_fj"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"aptitudereply", "aptitudereply_fj"});
        }
        long projectId = this.getProjectId();
        Set<Long> scoreTaskIdSet = this.getScoreTaskIdSet();
        if (projectId > 0L || null != scoreTaskIdSet && scoreTaskIdSet.size() > 0) {
            SrcScoreContext context = SrcScoreFacade.createScoreContext((IFormView)this.getView());
            context.setProjectId(projectId);
            context.setProjectSet(scoreTaskIdSet);
            paramMap.put("project", projectId);
            context.setParamMap(paramMap);
            this.getModel().setValue("projectid", (Object)projectId);
            this.refreshData(context);
        } else {
            String entityName = "src_evaluateassist".equals(this.getView().getEntityId()) ? "src_evaluatequery" : "src_scorequery";
            OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)entityName, (ShowType)ShowType.NonModal, (Map)paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "query"));
        }
        if (this.isScoreBySupplier(projectId) || PdsCommonUtils.object2Boolean((Object)PdsCommonUtils.getCustomParamValue((IFormView)this.getView(), (String)"scorebysup"))) {
            this.scoreBySup();
        }
    }

    protected void refreshData(SrcScoreContext context) {
        if (context.getParamMap() == null || context.getParamMap().size() == 0) {
            context.setParamMap(this.getView().getFormShowParameter().getCustomParams());
        }
        SrcScoreFacade.getSelectFields((SrcScoreContext)context);
        SrcScoreFacade.getQFilter((SrcScoreContext)context);
        SrcScoreFacade.queryScoreData((SrcScoreContext)context);
        SrcScoreFacade.loadScoreData((SrcScoreContext)context);
        DynamicObject projectObj = null;
        if (this.getModel().getEntryRowCount("score_entry") > 0) {
            projectObj = ((DynamicObject)this.getModel().getEntryEntity("score_entry").get(0)).getDynamicObject("project");
        }
        SrcBidOpenFacade.setPurlistFieldVisible((IFormView)this.getView(), (String)"score_entry", (String)"purlistname", projectObj);
        SrcAptitudeUtils.showOrHideSupplierReply((IFormView)this.getView(), (DynamicObject)projectObj);
        this.getView().getPageCache().put("qfilter", context.getScoreQFilter().toSerializedString());
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        String propertyName = evt.getProperty().getName();
        Object newValue = evt.getChangeSet()[0].getNewValue();
        int rowIndex = evt.getChangeSet()[0].getRowIndex();
        switch (propertyName) {
            case "isfitted": {
                this.setVualeByIsFitted(newValue, rowIndex);
                this.inputControl(rowIndex);
                break;
            }
            case "value": {
                if (StringUtils.isEmpty((String)String.valueOf(newValue))) break;
                if (!SrcScoreHelper.isNumberValue((String)String.valueOf(newValue))) {
                    this.getModel().setValue("value", null, rowIndex);
                    break;
                }
            }
            case "note": {
                if (this.isChanging) {
                    return;
                }
                this.inputControl(rowIndex);
                break;
            }
        }
    }

    private void setVualeByIsFitted(Object newValue, int rowIndex) {
        this.isChanging = true;
        if (newValue == null) {
            this.getModel().setValue("note", null, rowIndex);
            this.getModel().setValue("value", null, rowIndex);
            this.getModel().setValue("scorerscored", (Object)"0", rowIndex);
            return;
        }
        DynamicObjectCollection cols = this.getModel().getEntryEntity("score_entry");
        this.setIsFittedValue(cols);
        DynamicObject index = ((DynamicObject)cols.get(rowIndex)).getDynamicObject("index");
        if (Objects.isNull(index)) {
            return;
        }
        if (!index.getBoolean("isfitted")) {
            return;
        }
        if (((Boolean)newValue).booleanValue()) {
            this.getModel().setValue("note", (Object)ResManager.loadKDString((String)"\u5408\u683c", (String)"SrcScoreAssist_5", (String)"scm-src-formplugin", (Object[])new Object[0]), rowIndex);
            if ("1".equals(index.getString("scoremethod"))) {
                this.getModel().setValue("value", (Object)"100", rowIndex);
            } else {
                BigDecimal value = index.getBigDecimal("score").setScale(2, 5);
                this.getModel().setValue("value", (Object)value, rowIndex);
            }
        } else {
            this.getModel().setValue("note", (Object)ResManager.loadKDString((String)"\u4e0d\u5408\u683c", (String)"SrcScoreAssist_6", (String)"scm-src-formplugin", (Object[])new Object[0]), rowIndex);
            this.getModel().setValue("value", (Object)"0", rowIndex);
        }
        this.getModel().setValue("scorerscored", (Object)"1", rowIndex);
        this.isChanging = false;
    }

    private void setIsFittedValue(DynamicObjectCollection cols) {
        int i = 0;
        for (DynamicObject col : cols) {
            DynamicObject index = col.getDynamicObject("index");
            if (Objects.isNull(index)) {
                return;
            }
            if (!index.getBoolean("isfitted")) {
                this.getModel().beginInit();
                this.getModel().setValue("isfitted", (Object)false, i);
                this.getModel().endInit();
            }
            ++i;
        }
    }

    protected void inputControl(int rowIndex) {
        if (this.isChanging) {
            return;
        }
        this.isChanging = true;
        SrcScoreFacade.inputControl((IFormView)this.getView(), (int)rowIndex);
        this.isChanging = false;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opKey = ((AbstractOperate)args.getSource()).getOperateKey();
        args.setCancel(true);
        switch (opKey) {
            case "query": {
                this.scoreQuery();
                break;
            }
            case "autoscore": {
                this.autoScore();
                break;
            }
            case "save": {
                this.saveScoreData();
                break;
            }
            case "submit": {
                this.submitScoreData("scoresubmit");
                break;
            }
            case "suggestion": {
                this.submitSuggestion();
                break;
            }
            case "analyse": {
                this.openAnalyse();
                break;
            }
            case "quoteanalyse": {
                this.openQuoteAnalyse();
                break;
            }
            case "purlist": {
                this.openSupplierList();
                break;
            }
            case "answer": {
                this.openAnswer();
                break;
            }
            case "biddoc": {
                this.openBiddoc("src_bidassess_doc");
                break;
            }
            case "biddoctpl": {
                this.openBiddoc("src_biddoc_src");
                break;
            }
            case "scorebysup": {
                this.scoreBySup();
                break;
            }
            case "logquery": {
                this.openReturnQuery();
                break;
            }
            case "close": {
                PdsCommonUtils.refreshParentView((IFormView)this.getView());
                this.getView().close();
                break;
            }
        }
    }

    private void scoreBySup() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("score_entry");
        boolean isByPurlist = false;
        if (rows.size() > 0) {
            isByPurlist = rows.stream().anyMatch(e -> e.getLong("purlistname.id") > 0L);
        }
        if (isByPurlist) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u9879\u76ee\u662f\u6309\u6807\u7684\u4e0b\u8fbe\u8bc4\u6807\u4efb\u52a1\uff0c\u6682\u4e0d\u652f\u6301\u6309\u4f9b\u5e94\u5546\u8bc4\u5206\u3002", (String)"SrcScoreAssist_12", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return;
        }
        IExtPluginHandler openScoreBySupHandle = (IExtPluginHandler)ExtPluginFactory.getInstance().getExtPluginInstance("ISrcScoreOpenBySup");
        if (null != openScoreBySupHandle) {
            ExtPluginContext context = new ExtPluginContext();
            context.setView(this.getView());
            openScoreBySupHandle.process(context);
        }
    }

    private void scoreQuery() {
        String entityName = "src_evaluateassist".equals(this.getView().getEntityId()) ? "src_evaluatequery" : "src_scorequery";
        OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)entityName, (ShowType)ShowType.NonModal, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "query"));
    }

    private void autoScore() {
        DynamicObjectCollection rows = ((AbstractFormDataModel)this.getModel()).getEntryEntity("score_entry");
        if (rows == null || rows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f85\u8bc4\u6807\u7684\u9879\u76ee\u3002", (String)"SrcScoreAssist_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
        } else {
            String bidName = ((DynamicObject)this.getModel().getValue("project")).getString("bidname");
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%1$s \u5c06\u81ea\u52a8\u8bc4\u5206\uff0c\u8bf7\u5148\u4fdd\u5b58\u5f53\u524d\u8bc4\u5206\u7ed3\u679c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SrcScoreAssist_1", (String)"scm-src-formplugin", (Object[])new Object[0]), bidName), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("autoscore"));
        }
    }

    private void openAnalyse() {
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        DynamicObjectCollection rows = ((AbstractFormDataModel)this.getModel()).getEntryEntity("score_entry");
        Set projectSet = rows.stream().map(e -> e.getLong("project.id")).collect(Collectors.toSet());
        if (projectSet != null && projectSet.size() > 0) {
            QFilter qFilter = new QFilter("project", "in", projectSet);
            String entityName = SrcScoreFacade.isEvaluateScore((String)this.getView().getEntityId()) ? "src_evaluateanalyse" : "src_scoreanalyse";
            OpenFormUtils.openListPage((IFormView)this.getView(), (String)entityName, (ShowType)ShowType.MainNewTabPage, (Map)paramMap, (QFilter)qFilter, null);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bfb\u6e90\u9879\u76ee\u3002", (String)"SrcScoreAssist_7", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
    }

    private void openReturnQuery() {
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        DynamicObjectCollection rows = ((AbstractFormDataModel)this.getModel()).getEntryEntity("score_entry");
        Set projectSet = rows.stream().map(e -> e.getLong("project.id")).collect(Collectors.toSet());
        if (projectSet != null && projectSet.size() > 0) {
            QFilter qFilter = new QFilter("project", "in", projectSet);
            qFilter.and(new QFilter("scorer", "=", (Object)RequestContext.get().getCurrUserId()).or("agent", "=", (Object)RequestContext.get().getCurrUserId()));
            String entityName = SrcScoreFacade.isEvaluateScore((String)this.getView().getEntityId()) ? "src_evaluatereturn" : "src_scorereturn";
            OpenFormUtils.openListPage((IFormView)this.getView(), (String)entityName, (ShowType)ShowType.MainNewTabPage, (Map)paramMap, (QFilter)qFilter, null);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bfb\u6e90\u9879\u76ee\u3002", (String)"SrcScoreAssist_7", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
    }

    private void openQuoteAnalyse() {
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        DynamicObjectCollection rows = ((AbstractFormDataModel)this.getModel()).getEntryEntity("score_entry");
        Set projectSet = rows.stream().map(e -> e.getLong("project.id")).collect(Collectors.toSet());
        if (projectSet != null && projectSet.size() > 0) {
            QFilter qFilter = new QFilter("project", "in", projectSet);
            OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_analysetool", (ShowType)ShowType.MainNewTabPage, (Map)paramMap, (QFilter)qFilter, null);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bfb\u6e90\u9879\u76ee\u3002", (String)"SrcScoreAssist_7", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
    }

    private void openSupplierList() {
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        DynamicObjectCollection rows = ((AbstractFormDataModel)this.getModel()).getEntryEntity("score_entry");
        Set projectSet = rows.stream().map(e -> e.getLong("project.id")).collect(Collectors.toSet());
        if (projectSet != null && projectSet.size() > 0) {
            QFilter qFilter = new QFilter("project", "in", projectSet);
            qFilter.and("supplier", ">", (Object)0);
            qFilter.and("entrystatus", ">", (Object)ProjectStatusEnums.TOQUOTE.getValue());
            OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_supplierpurlist", (ShowType)ShowType.MainNewTabPage, (Map)paramMap, (QFilter)qFilter, null);
        }
    }

    private void openAnswer() {
        int entryIndex = this.getModel().getEntryCurrentRowIndex("score_entry");
        DynamicObject row = this.getModel().getEntryRowEntity("score_entry", entryIndex);
        long projectId = 0L;
        if (row != null) {
            projectId = row.getLong("project.id");
        }
        if (projectId != 0L) {
            HashMap<String, Long> customParams = new HashMap<String, Long>(1);
            customParams.put("project", projectId);
            QFilter qFilter = new QFilter("project", "=", (Object)projectId);
            Object baseTypeObj = PdsCommonUtils.getCustomParamValue((IFormView)this.getView(), (String)"basetype");
            if (null != baseTypeObj && !PdsCommonUtils.isEqualOrContain((Object)baseTypeObj, (String)"2")) {
                qFilter.and("questype", "!=", (Object)"2");
            }
            OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_question", (ShowType)ShowType.MainNewTabPage, customParams, (QFilter)qFilter, null);
        } else {
            OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_question", (ShowType)ShowType.MainNewTabPage, null, null, null);
        }
    }

    private void saveScoreData() {
        SrcScoreContext context = SrcScoreFacade.createScoreContext((IFormView)this.getView());
        context.setShowMessage(true);
        SrcScoreFacade.saveScoreData((SrcScoreContext)context);
    }

    private void submitScoreData(String opKey) {
        if (!this.isValidate()) {
            return;
        }
        DynamicObjectCollection rows = this.getModel().getEntryEntity("score_entry");
        Set scoreTaskIds = rows.stream().map(e -> e.getLong("billid")).collect(Collectors.toSet());
        SrcScoreContext context = SrcScoreFacade.createScoreContext((IFormView)this.getView());
        context.setOpKey(opKey);
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        long projectId = this.getProjectId();
        if (projectId == 0L) {
            projectId = this.getUniqueProjectIdByEntry();
            paramMap.put("project", projectId);
        }
        context.setParamMap(paramMap);
        context.setProjectId(projectId);
        boolean isNeedSuggestion = SrcScoreHelper.isNeedSuggestion((IFormView)this.getView(), (long)projectId);
        if (isNeedSuggestion) {
            context.setShowMessage(false);
        } else {
            context.setShowMessage(true);
        }
        SrcScoreFacade.submitScoreData((SrcScoreContext)context);
        if (!context.isCommitSucced()) {
            this.getView().showMessage(context.getCommitMessage());
            return;
        }
        if (isNeedSuggestion) {
            paramMap.put("scoretask", scoreTaskIds);
            OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_submitsuggestion", (ShowType)ShowType.Modal, (Map)paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "suggestion"));
        } else if (context.isCommitSucced()) {
            // empty if block
        }
    }

    private boolean isValidate() {
        int i = 1;
        boolean isValidate = true;
        StringBuilder msgBuilder = new StringBuilder();
        DynamicObjectCollection cols = this.getModel().getEntryEntity("score_entry");
        for (DynamicObject col : cols) {
            String value;
            boolean scoreed = col.getBoolean("scorerscored");
            if (scoreed && !SrcScoreHelper.isNumberValue((String)String.valueOf(value = col.getString("value")))) {
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8f93\u5165\u7684\u503c\u4e0d\u5408\u6cd5\u3002", (String)"SrcScoreAssist_10", (String)"scm-src-formplugin", (Object[])new Object[0]), i));
                msgBuilder.append("\r\n");
            }
            ++i;
        }
        if (msgBuilder.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25", (String)"SrcScoreAssist_11", (String)"scm-src-formplugin", (Object[])new Object[0]), msgBuilder.toString(), MessageTypes.Commit);
            isValidate = false;
        }
        return isValidate;
    }

    private void submitSuggestion() {
        String entityName = SrcScoreFacade.isEvaluateScore((String)this.getView().getEntityId()) ? "src_submitopinion" : "src_submitsuggestion";
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        long projectId = this.getProjectId();
        if (projectId == 0L) {
            projectId = this.getUniqueProjectIdByEntry();
            paramMap.put("project", projectId);
        }
        DynamicObjectCollection rows = this.getModel().getEntryEntity("score_entry");
        Set scoreTaskIds = rows.stream().map(e -> e.getLong("billid")).collect(Collectors.toSet());
        paramMap.put("scoretask", scoreTaskIds);
        if (SrcScoreFacade.isEvaluateScore((String)this.getView().getEntityId())) {
            paramMap.put("basetype", "8");
        }
        SrcScoreContext context = SrcScoreFacade.createScoreContext((IFormView)this.getView());
        context.setShowMessage(false);
        SrcScoreFacade.saveScoreData((SrcScoreContext)context);
        OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)entityName, (ShowType)ShowType.Modal, (Map)paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "suggestion"));
    }

    private void openBiddoc(String entityName) {
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        long projectId = PdsCommonUtils.object2Long(paramMap.get("project"));
        if (projectId == 0L) {
            int entryIndex = this.getModel().getEntryCurrentRowIndex("score_entry");
            DynamicObject row = this.getModel().getEntryRowEntity("score_entry", entryIndex);
            if (row != null) {
                projectId = row.getLong("project.id");
            }
        }
        if (projectId > 0L) {
            paramMap.put("project", projectId);
            DynamicObjectCollection rows = this.getModel().getEntryEntity("score_entry");
            Set baseTypeSet = rows.stream().map(e -> e.getString("basetype")).collect(Collectors.toSet());
            paramMap.put("basetype", baseTypeSet);
            if ("src_biddoc_src".equals(entityName)) {
                QFilter qfilter = new QFilter("parentid", "=", (Object)String.valueOf(projectId));
                DynamicObject docObj = QueryServiceHelper.queryOne((String)entityName, (String)"id", (QFilter[])qfilter.toArray());
                if (null != docObj) {
                    OpenFormUtils.openBillPage((IFormView)this.getView(), (String)entityName, (Object)docObj.get("id"), (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, (Map)paramMap, null);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5bfb\u6e90\u9879\u76ee\u65e0\u91c7\u8d2d\u65b9\u62db\u6807\u6587\u4ef6\u3002", (String)"SrcScoreAssist_13", (String)"scm-src-formplugin", (Object[])new Object[0]));
                }
            } else {
                OpenFormUtils.openBillPage((IFormView)this.getView(), (String)entityName, (Object)projectId, (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, (Map)paramMap, null);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bfb\u6e90\u9879\u76ee\u3002", (String)"SrcScoreAssist_7", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "query": {
                this.scoreQuery(evt);
                break;
            }
        }
    }

    private void scoreQuery(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (returnData instanceof SrcScoreContext) {
            long projectId = ((SrcScoreContext)returnData).getProjectId();
            if (projectId == 0L) {
                this.getModel().setValue("projectid", null);
            } else {
                this.getModel().setValue("projectid", (Object)projectId);
            }
        } else {
            this.getModel().setValue("projectid", null);
            return;
        }
        this.refreshData((SrcScoreContext)returnData);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getResult() != MessageBoxResult.Yes) {
            return;
        }
        if (evt.getCallBackId().equals("autoscore")) {
            this.autoScoreConfirm();
        }
    }

    private void autoScoreConfirm() {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)((DynamicObject)this.getModel().getValue("project")));
        SrcScoreContext context = SrcScoreFacade.createScoreContext((IFormView)this.getView());
        context.setShowMessage(true);
        context.setProjectId(projectId);
        SrcScoreFacade.autoScoreForProject((SrcScoreContext)context);
        this.refreshData(context);
    }

    private long getProjectId() {
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        if (null == paramMap) {
            return 0L;
        }
        long projectId = PdsCommonUtils.object2Long(paramMap.get("project"));
        if (projectId > 0L) {
            return projectId;
        }
        long pkId = PdsCommonUtils.object2Long(paramMap.get("pkId"));
        return pkId;
    }

    private Set<Long> getScoreTaskIdSet() {
        Object scoreTaskIdSet = PdsCommonUtils.getCustomParamValue((IFormView)this.getView(), (String)"scoretask");
        if (null == scoreTaskIdSet) {
            return null;
        }
        return PdsCommonUtils.object2Set((Object)scoreTaskIdSet);
    }

    private long getUniqueProjectIdByEntry() {
        DynamicObject project;
        long projectId = 0L;
        if (this.getModel().getEntryRowCount("score_entry") == 0) {
            return projectId;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("score_entry");
        int[] selectIndexs = entryGrid.getSelectRows();
        if (selectIndexs.length > 0 && null != (project = this.getModel().getEntryRowEntity("score_entry", selectIndexs[0]).getDynamicObject("project"))) {
            return project.getLong("id");
        }
        DynamicObjectCollection cols = this.getModel().getEntryEntity("score_entry");
        for (DynamicObject col : cols) {
            DynamicObject project2 = col.getDynamicObject("project");
            if (null == project2) continue;
            return project2.getLong("id");
        }
        return projectId;
    }

    public boolean isScoreBySupplier(long projectId) {
        if (projectId == 0L) {
            return false;
        }
        DynamicObject projectObj = QueryServiceHelper.queryOne((String)"src_project", (String)"srctype.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)projectId)});
        if (null == projectObj) {
            return false;
        }
        long sourceFlowId = projectObj.getLong("srctype.id");
        return ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isScoreBySupplier", (Object)false, (long)projectId));
    }
}

