/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsProjectIdUtils;
import kd.scm.pds.common.util.SrcDateUtils;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.SrcScoreFacade;

public class SrcScoreTaskQuery
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("datefrom", null);
        this.getModel().setValue("dateto", (Object)SrcDateUtils.getDateByOffsetDay((Date)TimeServiceHelper.now(), (int)30));
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        if (customParams == null) {
            return;
        }
        if (!customParams.containsKey("project")) {
            return;
        }
        Object projectId = customParams.get("project");
        if (projectId instanceof Long) {
            this.getModel().setValue("project", projectId);
        } else {
            QFilter[] filters = new QFilter[]{new QFilter("billno", "=", (Object)projectId.toString())};
            DynamicObject project = BusinessDataServiceHelper.loadSingle((String)"src_projectf7", (String)"id", (QFilter[])filters);
            this.getModel().setValue("project", (Object)project.getLong("id"));
        }
        if (this.getModel().getDataEntity().getDynamicObject("project") != null) {
            this.confirm();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "confirm": {
                boolean isSucced = true;
                StringBuilder sb = new StringBuilder();
                Date dateFrom = this.getModel().getDataEntity().getDate("datefrom");
                Date dateTo = this.getModel().getDataEntity().getDate("dateto");
                if (dateTo == null) {
                    isSucced = false;
                    sb = sb.append(ResManager.loadKDString((String)"\u201c\u8bc4\u4f30\u65e5\u671f\u81f3\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrcScoreTaskQuery_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
                }
                if (dateFrom != null && dateFrom.after(dateTo)) {
                    isSucced = false;
                    sb = sb.append(ResManager.loadKDString((String)"\u201c\u8bc4\u4f30\u65e5\u671f\u4ece\u201d\u4e0d\u80fd\u665a\u4e8e\u201c\u8bc4\u4f30\u65e5\u671f\u81f3\u201d\u3002", (String)"SrcScoreTaskQuery_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
                }
                if (!isSucced) {
                    this.getView().showTipNotification(sb.toString());
                    args.setCancel(true);
                    return;
                }
                this.confirm();
            }
        }
    }

    private void confirm() {
        SrcScoreContext context = SrcScoreFacade.createScoreContext((IFormView)this.getView().getParentView());
        DataEntityPropertyCollection propertiesentity = this.getModel().getDataEntity().getDataEntityType().getProperties();
        for (IDataEntityProperty iDataEntityProperty : propertiesentity) {
            String nameKey = iDataEntityProperty.getName();
            Object object = this.getModel().getValue(nameKey);
            switch (nameKey) {
                case "datefrom": {
                    context.setDateFrom(object == null ? null : (Date)object);
                    break;
                }
                case "dateto": {
                    context.setDateTo(object == null ? null : (Date)object);
                    break;
                }
                case "project": {
                    context.setProjectId(object == null ? 0L : SrmCommonUtil.getPkValue((DynamicObject)((DynamicObject)object)));
                    break;
                }
                case "package": {
                    context.setPackageId(object == null ? 0L : SrmCommonUtil.getPkValue((DynamicObject)((DynamicObject)object)));
                    break;
                }
                case "supplier": {
                    context.setSupplierId(object == null ? 0L : SrmCommonUtil.getPkValue((DynamicObject)((DynamicObject)object)));
                    break;
                }
                case "org": {
                    context.setPurOrgId(object == null ? 0L : SrmCommonUtil.getPkValue((DynamicObject)((DynamicObject)object)));
                    break;
                }
                case "scorestatus": {
                    context.setScoreStatus(object == null ? null : object.toString());
                    break;
                }
                case "billno": {
                    context.setBillNo(object == null ? null : object.toString());
                    break;
                }
                case "monthnum": {
                    context.setMonthnum(Integer.parseInt(object.toString()));
                    break;
                }
            }
        }
        this.getView().returnDataToParent((Object)context);
        this.getView().close();
    }

    public void registerListener(EventObject e) {
        BasedataEdit orgControl;
        BasedataEdit packageControl;
        super.registerListener(e);
        BasedataEdit projectControl = (BasedataEdit)this.getControl("project");
        if (null != projectControl) {
            projectControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (packageControl = (BasedataEdit)this.getControl("package"))) {
            packageControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (orgControl = (BasedataEdit)this.getControl("org"))) {
            orgControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String proName = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        switch (proName) {
            case "project": {
                QFilter projectFilter = this.getProjectFilter();
                showParameter.getListFilterParameter().setFilter(projectFilter);
                break;
            }
            case "package": {
                QFilter pacakgeFilter = new QFilter("project", "=", (Object)this.getModel().getDataEntity().getLong("project.id"));
                showParameter.getListFilterParameter().setFilter(pacakgeFilter);
                break;
            }
            case "org": {
                QFilter purOrgFilter = new QFilter("id", "in", (Object)SrcScoreFacade.getScorerPurOrgIds((IFormView)parentView));
                showParameter.getListFilterParameter().setFilter(purOrgFilter);
                break;
            }
        }
    }

    public QFilter getProjectFilter() {
        Set projectIds = SrcScoreFacade.getScorerProjectIds((IFormView)this.getView().getParentView());
        String scoreStatus = PdsCommonUtils.object2String((Object)this.getModel().getValue("scorestatus"), (String)"0");
        if ("0".equals(scoreStatus)) {
            Set unScoreProjectIds = PdsProjectIdUtils.getAllMyScoreProjectIds((String)"0");
            projectIds.retainAll(unScoreProjectIds);
        } else if ("1".equals(scoreStatus)) {
            Set unScoreProjectIds = PdsProjectIdUtils.getAllMyScoreProjectIds((String)"1");
            projectIds.retainAll(unScoreProjectIds);
        }
        return new QFilter("id", "in", (Object)projectIds);
    }
}

