/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.bidchange;

import java.util.EventObject;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.orm.query.QFilter;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsHyperLinkUtils;
import kd.scm.pds.formplugin.edit.PdsBillCompTplEdit;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcBidChangePlugin
extends PdsBillCompTplEdit
implements BeforeF7SelectListener,
Consumer<BeforeF7ViewDetailEvent> {
    public void registerListener(EventObject e) {
        BasedataEdit currentnodeEdit;
        BasedataEdit projectEdit;
        BasedataEdit demandEdit;
        super.registerListener(e);
        BasedataEdit applyEdit = (BasedataEdit)this.getView().getControl("apply");
        if (applyEdit != null) {
            applyEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            applyEdit.addBeforeF7ViewDetailListener((Consumer)this);
        }
        if ((demandEdit = (BasedataEdit)this.getView().getControl("demand")) != null) {
            demandEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            demandEdit.addBeforeF7ViewDetailListener((Consumer)this);
        }
        if ((projectEdit = (BasedataEdit)this.getView().getControl("project")) != null) {
            projectEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            projectEdit.addBeforeF7ViewDetailListener((Consumer)this);
        }
        if ((currentnodeEdit = (BasedataEdit)this.getView().getControl("currentnode")) != null) {
            currentnodeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            currentnodeEdit.addBeforeF7ViewDetailListener((Consumer)this);
        }
        BasedataEdit templateEdit = (BasedataEdit)this.getControl("template");
        templateEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property;
        switch (property = evt.getProperty().getName()) {
            case "project": {
                this.setProjectFilter(evt);
                break;
            }
            case "template": {
                this.setTemplateFilter(evt);
                break;
            }
        }
    }

    protected void setProjectFilter(BeforeF7SelectEvent evt) {
        Set sourceTypeNumberSet = SrcBidChangeUtil.getSourceTypeNumberSetByShowParams((IFormView)this.getView(), (boolean)false);
        if (sourceTypeNumberSet.size() > 0) {
            evt.addCustomQFilter(new QFilter("sourcetype.number", "in", (Object)sourceTypeNumberSet));
        }
    }

    protected void setTemplateFilter(BeforeF7SelectEvent evt) {
    }

    @Override
    public void accept(BeforeF7ViewDetailEvent args) {
        BasedataEdit basedataEdit = (BasedataEdit)args.getSource();
        switch (basedataEdit.getKey()) {
            case "apply": {
                this.openCurrentBill(args, "src_apply");
                break;
            }
            case "demand": {
                this.openCurrentBill(args, "src_demand");
                break;
            }
            case "project": {
                this.openCurrentBill(args, "src_project");
                break;
            }
            case "currentnode": {
                this.openCurrentNode(args);
                break;
            }
        }
    }

    private void openCurrentBill(BeforeF7ViewDetailEvent args, String entityName) {
        args.setCancel(true);
        long pkId = PdsCommonUtils.object2Long((Object)args.getPkId());
        if (pkId > 0L) {
            PdsHyperLinkUtils.openTargetBill((IFormView)this.getView(), (String)entityName, (long)pkId);
        }
    }

    private void openCurrentNode(BeforeF7ViewDetailEvent args) {
        args.setCancel(true);
        if (null == this.getModel().getDataEntity().get("currentnode")) {
            return;
        }
        String entityName = this.getModel().getDataEntity().getString("currentnode.bizobject.number");
        String changesource = this.getModel().getDataEntity().getString("changesource");
        long pkId = 0L;
        switch (changesource) {
            case "1": {
                pkId = this.getModel().getDataEntity().getLong("apply.id");
                break;
            }
            case "2": {
                pkId = this.getModel().getDataEntity().getLong("demand.id");
                break;
            }
            case "3": {
                pkId = this.getModel().getDataEntity().getLong("project.id");
            }
        }
        if (pkId > 0L && !StringUtils.isBlank((CharSequence)entityName)) {
            PdsHyperLinkUtils.openTargetBill((IFormView)this.getView(), (String)entityName, (long)pkId);
        }
    }
}

