/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.expertfilter.expertfilter.ExpertFilterUtils;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.mytask.SrcMyTaskContext;
import kd.scm.pds.common.mytask.SrcMyTaskFacade;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.bidopen.SrcBidOpenUtils;
import kd.scm.src.common.util.SrcAppCache;
import kd.scm.src.common.util.SrcUsualUserUtils;
import kd.scm.src.formplugin.edit.SrcProjectSchemeHandler;

public class SrcAptitudeConfigEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        SrcAppCache.put((String)this.getView().getEntityId(), (Object)this.getView().getPageId(), (IFormView)parentView);
        this.isAptPush(parentView);
    }

    private void isAptPush(IFormView parentView) {
        if (!PdsCommonUtils.isValidBillType((IFormView)parentView)) {
            return;
        }
        DynamicObject obj = parentView.getModel().getDataEntity();
        DynamicObject srcType = obj.getDynamicObject("srctype");
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)srcType);
        boolean isOpenBySupplier = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isopenbysupplier", (Object)Boolean.FALSE, (long)SrmCommonUtil.getPkValue((DynamicObject)obj)));
        if (!isOpenBySupplier) {
            return;
        }
        String entityId = parentView.getEntityId();
        QFilter qfilter = new QFilter("billid", "=", obj.getPkValue());
        qfilter.and("isdiscard", "=", (Object)"0");
        qfilter.and("isaptitude", "!=", (Object)"2");
        if (Objects.equals("src_aptitudeaudit", entityId)) {
            qfilter.and("isaptpush", "=", (Object)"0");
            this.setEnable(qfilter);
        } else if (Objects.equals("src_aptitudeaudit2", entityId)) {
            qfilter.and("isaptpush2", "=", (Object)"0");
            this.setEnable(qfilter);
        }
    }

    private void setEnable(QFilter qfilter) {
        if (!QueryServiceHelper.exists((String)"src_bidopensupplier", (QFilter[])qfilter.toArray())) {
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"package", "indextype", "weight", "scheme", "scorer", "bidattach", "bidname", "expertcount", "advcontoolbarap1", "note"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap1"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        if (rows.size() == 0 && !this.getModel().getDataEntity().getBoolean("ismultipackage")) {
            this.getModel().getEntryEntity("entryentity").addNew();
            if (this.getView().getEntityId().equals("src_aptitudeconfig")) {
                this.getModel().setValue("indextype", (Object)PdsCommonUtils.getBasedataIdByNumber((String)"src_indexclass", (String)"SYS004"), 0);
            } else {
                this.getModel().setValue("indextype", (Object)PdsCommonUtils.getBasedataIdByNumber((String)"src_indexclass", (String)"SYS007"), 0);
            }
            this.getModel().setValue("entrystatus", (Object)"A", 0);
            this.getView().updateView("entryentity");
            this.getModel().setValue("agent", this.getModel().getValue("agentid"), 0);
            PdsCommonUtils.saveDynamicObjects((DynamicObject)this.getModel().getDataEntity(true));
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs evt) {
        super.beforeDeleteRow(evt);
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)evt.getEntryProp().getName())) {
            for (int index : evt.getRowIndexs()) {
                String entrystatus = PdsCommonUtils.object2String((Object)this.getModel().getValue("entrystatus", index), (String)"");
                if ("A".equals(entrystatus)) continue;
                this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u6709\u672a\u4e0b\u8fbe\u7684\u5206\u5f55\u624d\u80fd\u88ab\u5220\u9664\u3002", (String)"SrcAptitudeConfigEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit agent;
        BasedataEdit scorer;
        BasedataEdit pack;
        BasedataEdit scheme;
        super.registerListener(e);
        BasedataEdit indexType = (BasedataEdit)this.getView().getControl("indextype");
        if (indexType != null) {
            indexType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((scheme = (BasedataEdit)this.getView().getControl("scheme")) != null) {
            scheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((pack = (BasedataEdit)this.getView().getControl("package")) != null) {
            pack.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((scorer = (BasedataEdit)this.getView().getControl("scorer")) != null) {
            scorer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((agent = (BasedataEdit)this.getView().getControl("agent")) != null) {
            agent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        block4 : switch (key = e.getProperty().getName()) {
            case "indextype": {
                String baseType;
                int index = e.getChangeSet()[0].getRowIndex();
                IDataModel model = this.getModel();
                DynamicObject row = model.getEntryRowEntity("entryentity", index);
                DynamicObject indexTypeObj = row.getDynamicObject("indextype");
                model.setValue("scheme", null, index);
                if (null == indexTypeObj) {
                    model.setValue("weight", null, index);
                    return;
                }
                SchemeFilterUtils.autoSetScheme((IFormView)this.getView(), (IDataModel)model, (int)index);
                switch (baseType = indexTypeObj.getString("basetype")) {
                    case "4": 
                    case "7": {
                        this.getModel().setValue("weight", (Object)100, index);
                        break block4;
                    }
                }
                break;
            }
            case "scheme": {
                SrcBidOpenUtils.setProjectSchemeValue((IFormView)this.getView(), (PropertyChangedArgs)e);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "indextype": {
                String sourceMethod = evt.getSourceMethod();
                if (Objects.equals(sourceMethod, "setItemByNumber")) {
                    return;
                }
                ArrayList<String> indexTypes = new ArrayList<String>(3);
                if (this.getView().getEntityId().equals("src_aptitudeconfig")) {
                    indexTypes.add("4");
                } else {
                    indexTypes.add("7");
                }
                ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("basetype", "in", indexTypes));
                break;
            }
            case "package": {
                DynamicObject data = this.getModel().getDataEntity(true);
                QFilter filter = new QFilter("project", "=", data.getPkValue());
                ListShowParameter packageShowParameter = (ListShowParameter)evt.getFormShowParameter();
                packageShowParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
            case "scorer": 
            case "agent": {
                String expertType = ExpertFilterUtils.inviteExpertType();
                if (null == expertType) break;
                HashMap<String, Boolean> paramMap = new HashMap<String, Boolean>(2);
                paramMap.put("ismustinput", true);
                ExpertFilterUtils.setExpertF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)this.getView().getParentView().getModel().getDataEntity(), (String)("src_aptitudeaudit_" + expertType + '_' + "filter"), paramMap);
                break;
            }
            case "scheme": {
                DynamicObject row = this.getModel().getEntryRowEntity("entryentity", evt.getRow());
                HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
                paramMap.put("schemetype", "2");
                paramMap.put("ismustinput", true);
                paramMap.put("indextypeid", SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("indextype")));
                SchemeFilterUtils.setSchemeF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)this.getView().getParentView().getModel().getDataEntity(), (String)this.getView().getEntityId(), paramMap);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        super.beforeDoOperation(evt);
        IFormView parentView = this.getView().getParentView();
        switch (operateKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                this.deleteInvalidRows(this.getModel().getDataEntity(true));
                this.setPackageVal();
                break;
            }
            case "batch": {
                if (null == parentView) {
                    return;
                }
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                DynamicObject billObj = parentView.getModel().getDataEntity();
                if (billObj != null) {
                    paramMap.put("project", billObj.getPkValue());
                    paramMap.put("scoretype", parentView.getModel().getDataEntity().getString("aptitudetype"));
                    if (this.getView().getEntityId().equals("src_aptitudeconfig")) {
                        paramMap.put("ratio_apt", 100);
                    } else {
                        paramMap.put("ratio_apt2", 100);
                    }
                    paramMap.put("schemetype", "2");
                    paramMap.put("entityname", this.getView().getEntityId());
                }
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "batch");
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_assesscfg_batch", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)closeCallBack);
                break;
            }
            case "usualuser": {
                long billId = SrcUsualUserUtils.getBillId((String)this.getView().getEntityId());
                if (billId > 0L) {
                    OpenFormUtils.openBillPage((IFormView)this.getView(), (String)"src_usualuser", (Object)billId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.Modal, null, null);
                }
                evt.setCancel(true);
                break;
            }
            case "projectscorer": {
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_projectscorer", (ShowType)ShowType.Modal, null, null);
                break;
            }
        }
    }

    private void setPackageVal() {
        IDataModel model = this.getModel();
        DynamicObjectCollection cols = model.getEntryEntity("entryentity");
        if (null == cols || cols.size() == 0) {
            return;
        }
        boolean isMultiPackage = model.getDataEntity().getBoolean("ismultipackage");
        if (isMultiPackage) {
            return;
        }
        ArrayList<Integer> noPackageIndexList = new ArrayList<Integer>();
        for (int i = 0; i < cols.size(); ++i) {
            DynamicObject packageObj = ((DynamicObject)cols.get(i)).getDynamicObject("package");
            if (null != packageObj && packageObj.getLong("id") != 0L) continue;
            noPackageIndexList.add(i);
        }
        if (noPackageIndexList.size() > 0) {
            DynamicObject packageObj = this.getPackageObj();
            this.setEntryPackageVal(noPackageIndexList, packageObj);
        }
    }

    private DynamicObject getPackageObj() {
        IFormView parentView = this.getView().getParentView();
        if (!PdsCommonUtils.isValidBillType((IFormView)parentView)) {
            return null;
        }
        QFilter packageFilter = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)parentView.getModel().getDataEntity()));
        packageFilter.and("packagename", "=", (Object)"ByItem");
        DynamicObject packageObj = QueryServiceHelper.queryOne((String)"src_packagef7", (String)"package", (QFilter[])new QFilter[]{packageFilter});
        return packageObj;
    }

    private void setEntryPackageVal(List<Integer> noPackageIndexList, DynamicObject packageObj) {
        if (null == packageObj) {
            return;
        }
        Object packObj = packageObj.get("package");
        for (int index : noPackageIndexList) {
            this.getModel().setValue("package", packObj, index);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String key;
        super.afterDoOperation(evt);
        switch (key = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "save": {
                this.createMyTaskByScorer();
                SrcUsualUserUtils.addToUsualScorer((IFormView)this.getView());
                break;
            }
            case "openscheme": {
                this.setProjectScheme();
                break;
            }
        }
    }

    private void createMyTaskByScorer() {
        SrcMyTaskContext context = new SrcMyTaskContext();
        context.setCurrView(this.getView());
        context.setProjectId(PdsCommonUtils.object2Long((Object)this.getView().getParentView().getModel().getDataEntity().getPkValue()));
        context.setCompkey("src_project_reference");
        SrcMyTaskFacade.createMyTaskByScorer((SrcMyTaskContext)context);
    }

    private void setProjectScheme() {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(this.getView());
        ExtPluginFactory.executeExtplugin((String)SrcProjectSchemeHandler.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
    }

    private void deleteInvalidRows(DynamicObject billObj) {
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            return;
        }
        Iterator ite = rows.iterator();
        while (ite.hasNext()) {
            DynamicObject obj = (DynamicObject)ite.next();
            if (obj.getDynamicObject("indextype") != null && obj.getLong("indextype.id") != 0L) continue;
            ite.remove();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"batch")) {
            DynamicObjectCollection configRows = (DynamicObjectCollection)evt.getReturnData();
            if (configRows == null || configRows.size() == 0) {
                return;
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            int index = model.getEntryRowCount("entryentity");
            for (DynamicObject configRow : configRows) {
                List configList = configRow.getDynamicObjectCollection("package").stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toList());
                for (int i = 0; i < configList.size(); ++i) {
                    model.createNewEntryRow("entryentity");
                    model.setValue("package", configList.get(i), index);
                    model.setValue("indextype", (Object)configRow.getLong("indextype.id"), index);
                    model.setValue("weight", (Object)configRow.getBigDecimal("weight"), index);
                    model.setValue("scheme", (Object)configRow.getLong("scheme.id"), index);
                    model.setValue("bidattach", (Object)configRow.getDynamicObjectCollection("bidattach"), index);
                    model.setValue("bidname", (Object)configRow.getString("packfilename"), index);
                    model.setValue("scorer", (Object)configRow.getDynamicObjectCollection("scorer"), index);
                    model.setValue("note", (Object)configRow.getString("note"), index);
                    ++index;
                }
            }
        }
    }
}

