/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.scm.pds.common.enums.EvaluatePeriodEnums;
import kd.scm.pds.common.expertfilter.expertfilter.ExpertFilterUtils;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.util.SrcAppCache;

public class SrcEvaluateExpertEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        SrcAppCache.put((String)this.getView().getEntityId(), (Object)this.getView().getPageId(), (IFormView)parentView);
        this.setDefaultScheme();
    }

    public void setDefaultScheme() {
        if (null == this.getModel().getValue("scheme")) {
            DynamicObject billObj = this.getView().getParentView().getModel().getDataEntity();
            SchemeFilterUtils.setSchemeDefaultValue((IFormView)this.getView(), (DynamicObject)billObj, (String)"src_expert_scheme", (String)"scheme", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String objectName;
        if (!PdsCommonUtils.isValidBillType((IFormView)this.getView().getParentView())) {
            return;
        }
        switch (objectName = evt.getProperty().getName()) {
            case "scheme": {
                DynamicObject billObj = this.getView().getParentView().getModel().getDataEntity();
                SchemeFilterUtils.setSchemeF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)billObj, (String)"src_expert_scheme", null);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "selectexpert": {
                this.createExpertEntry();
                break;
            }
        }
    }

    public boolean verifyData() {
        DynamicObject schemeObj;
        DynamicObject billObj = this.getView().getParentView().getModel().getDataEntity();
        if (EvaluatePeriodEnums.PROJECT.getId() == billObj.getLong("period.id")) {
            if (null == billObj.get("project")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfb\u6e90\u9879\u76ee \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrcEvaluateExpertEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else {
            if (null == billObj.get("datefrom")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8003\u8bc4\u671f\u95f4\u4ece \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrcEvaluateExpertEdit_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (null == billObj.get("dateto")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8003\u8bc4\u671f\u95f4\u81f3 \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrcEvaluateExpertEdit_2", (String)"scm-src-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (null == (schemeObj = this.getModel().getDataEntity().getDynamicObject("scheme"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f85\u8003\u8bc4\u4e13\u5bb6\u8fc7\u6ee4\u65b9\u6848 \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrcEvaluateExpertEdit_3", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void createExpertEntry() {
        if (!this.verifyData()) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        HashMap<String, String> paramMap = new HashMap<String, String>(1);
        paramMap.put("number", this.getView().getModel().getDataEntity().getString("scheme.number"));
        List expertIds = ExpertFilterUtils.getAllExpertIds((DynamicObject)this.getView().getParentView().getModel().getDataEntity(), (String)this.getModel().getDataEntity().getString("scheme.number"), paramMap);
        if (null == expertIds || expertIds.size() == 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\uff1a%1$s\u3002", (String)"SrcEvaluateExpertEdit_4", (String)"scm-src-formplugin", (Object[])new Object[0]), this.getModel().getDataEntity().getString("scheme.name")));
            return;
        }
        model.deleteEntryData("entryentity");
        model.beginInit();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int index = 0;
        Iterator iterator = expertIds.iterator();
        while (iterator.hasNext()) {
            long expertId = (Long)iterator.next();
            ts.set("supplier", (Object)expertId, index);
            ++index;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit schemeEdit = (BasedataEdit)this.getControl("scheme");
        schemeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs evt) {
        super.beforeDeleteRow(evt);
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)evt.getEntryProp().getName())) {
            for (int index : evt.getRowIndexs()) {
                boolean isEvaluatePush = PdsCommonUtils.object2Boolean((Object)this.getModel().getValue("isevaluatepush", index));
                if (!isEvaluatePush) continue;
                this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u6709\u672a\u4e0b\u8fbe\u7684\u5206\u5f55\u624d\u80fd\u88ab\u5220\u9664\u3002", (String)"SrcEvaluateExpertEdit_5", (String)"scm-src-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }
}

