/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.src.common.util.SrcAppCache;
import kd.scm.src.common.util.SrcBidAssessUtils;
import kd.scm.src.common.util.SrcEvaluateUtils;
import kd.scm.src.formplugin.compext.SrcBidassessTecsumAttachValidator;
import kd.scm.src.formplugin.compext.SrcBidassessTecsumScoreValidator;
import kd.scm.src.formplugin.compext.SrcBidassessTecsumSetDetailValue;

public class SrcEvaluateResultEdit
extends AbstractBillPlugIn {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        SrcAppCache.put((String)this.getView().getEntityId(), (Object)this.getView().getPageId(), (IFormView)parentView);
        String scoreType = parentView.getModel().getDataEntity().getString("scoretype");
        this.getModel().setValue("scoretype", (Object)scoreType);
        if (Objects.equals(scoreType, "2")) {
            TextEdit inputScore = (TextEdit)this.getControl("inputscore");
            inputScore.setMustInput(true);
        }
        SrcBidAssessUtils.setUnFinishScorer((IFormView)this.getView());
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String key;
        super.propertyChanged(evt);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        switch (key = evt.getProperty().getName()) {
            case "inputscore": {
                this.verifyLargeRatio(this.getView(), evt);
                this.updateEvaluateGrade(evt);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "submit": {
                this.verifyAttachmentUpload(this.getView(), args);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "submit": {
                this.setScorerDetailValue(this.getView(), args);
                break;
            }
        }
    }

    private void verifyLargeRatio(IFormView view, PropertyChangedArgs evt) {
        List validators = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcBidassessTecsumScoreValidator.class.getSimpleName(), null);
        for (SrcBidassessTecsumScoreValidator validator : validators) {
            validator.validate(view, evt);
        }
    }

    private void updateEvaluateGrade(PropertyChangedArgs evt) {
        int index = evt.getChangeSet()[0].getRowIndex();
        Object newObj = evt.getChangeSet()[0].getNewValue();
        if (null != newObj) {
            DynamicObject row = this.getModel().getEntryRowEntity("entryentity", index);
            long gradeSchemeId = SrcEvaluateUtils.getScoreGrade(new HashMap(), (long)row.getLong("scoretask.gradescheme.id"), (BigDecimal)row.getBigDecimal("inputscore"));
            this.getModel().setValue("grade", (Object)gradeSchemeId, index);
        } else {
            this.getModel().setValue("grade", null, index);
        }
    }

    private void verifyAttachmentUpload(IFormView view, BeforeDoOperationEventArgs args) {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(view);
        context.setBeforeDoOperationEventArgs(args);
        List validators = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcBidassessTecsumAttachValidator.class.getSimpleName(), null);
        for (IExtPluginHandler validator : validators) {
            validator.process(context);
        }
    }

    private void setScorerDetailValue(IFormView view, AfterDoOperationEventArgs args) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcBidassessTecsumSetDetailValue.class.getSimpleName(), null);
        for (SrcBidassessTecsumSetDetailValue handler : handlers) {
            handler.setScorerDetailValue(view, args);
        }
    }
}

