/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.suplinkman.PdsLinkManFacade;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsPurlistUtils;
import kd.scm.pds.common.util.SupplierUtil;

public class SrcInviteSupplierHelper
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public void beforeBindData(EventObject evt) {
        this.setDefaultScheme();
    }

    public void setDefaultScheme() {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView || !PdsCommonUtils.isValidBillType((IFormView)parentView)) {
            return;
        }
        if (BillStatusEnum.SAVE.getVal().equals(PdsCommonUtils.object2String((Object)parentView.getModel().getValue("billstatus"), (String)BillStatusEnum.SAVE.getVal())) && null == this.getModel().getValue("pickscheme")) {
            SchemeFilterUtils.setSchemeDefaultValue((IFormView)this.getView(), (DynamicObject)parentView.getModel().getDataEntity(), (String)"src_supplierpick_filter", (String)"pickscheme", this.getSchemeFilterMap());
        }
        if (null == this.getModel().getValue("pickscheme")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"pickscheme", "expertcount"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String objectName;
        IFormView parentView = this.getView().getParentView();
        if (null == parentView || !PdsCommonUtils.isValidBillType((IFormView)parentView)) {
            return;
        }
        switch (objectName = evt.getProperty().getName()) {
            case "pickscheme": {
                SchemeFilterUtils.setSchemeF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)parentView.getModel().getDataEntity(), (String)"src_supplierpick_filter", this.getSchemeFilterMap());
                break;
            }
        }
    }

    public Map<String, Object> getSchemeFilterMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("compkey", this.getView().getEntityId());
        paramMap.put("billid", this.getModel().getDataEntity().getPkValue());
        if ("src_addsupplier".equals(this.getView().getEntityId())) {
            paramMap.put("addsupplier", this.getModel().getValue("addsupplier"));
        }
        return paramMap;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String key;
        switch (key = args.getProperty().getName()) {
            case "pickscheme": {
                if (null == args.getChangeSet()[0].getNewValue()) break;
                break;
            }
            case "addsupplier": {
                this.getModel().setValue("pickscheme", null);
                this.getModel().setValue("expertcount", (Object)0);
                this.setDefaultScheme();
                break;
            }
        }
    }

    public void deleteEntryEntity() {
        String compKey;
        IDataModel model = this.getModel();
        switch (compKey = this.getView().getEntityId()) {
            case "src_supplier_invite": 
            case "src_invitesupplier_chg": {
                model.deleteEntryData("entrysupplier");
                break;
            }
            case "src_itemsupplier": 
            case "src_itemsupplier_chg": 
            case "src_addsupplier": {
                model.beginInit();
                for (int i = 0; i < model.getEntryRowCount("entryentity"); ++i) {
                    model.setValue("supplier", null, i);
                }
                model.endInit();
                this.getView().updateView("entryentity");
                break;
            }
            case "src_supplier_select": {
                model.deleteEntryData("entryenroll");
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit schemeEdit = (BasedataEdit)this.getControl("pickscheme");
        schemeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        if ("src_supplier_invite".equals(this.getView().getEntityId())) {
            EntryGrid entrysupplier = (EntryGrid)this.getControl("entrysupplier");
            entrysupplier.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        switch (operateKey = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "invitesupplier": {
                this.selectSupplier();
                break;
            }
            case "logquery": {
                QFilter qfilters = new QFilter("project", "=", (Object)this.getModel().getDataEntity().getLong("projectf7.id"));
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"pds_supselectlog", (ShowType)ShowType.MainNewTabPage, null, (QFilter)qfilters, null);
                break;
            }
        }
    }

    private void selectSupplier() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        DynamicObject projectObj = null;
        projectObj = "src_bidchange".equals(parentView.getEntityId()) ? parentView.getModel().getDataEntity().getDynamicObject("project") : ("src_addsupplier".equals(this.getView().getEntityId()) ? this.getModel().getDataEntity().getDynamicObject("project") : parentView.getModel().getDataEntity());
        if (projectObj == null) {
            return;
        }
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)projectObj);
        String manageType = projectObj.getString("managetype");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("managetype", manageType);
        paramMap.put("project", projectId);
        paramMap.put("packageid", null);
        paramMap.put("packagename", null);
        paramMap.put("purlistid", null);
        paramMap.put("purlistname", null);
        DynamicObject pickSchemeObj = this.getModel().getDataEntity().getDynamicObject("pickscheme");
        paramMap.put("pickscheme", SrmCommonUtil.getPkValue((DynamicObject)pickSchemeObj));
        paramMap.put("compkey", this.getView().getEntityId());
        paramMap.put("billid", this.getView().getModel().getDataEntity().getPkValue());
        paramMap.put("expertcount", this.getView().getModel().getValue("expertcount"));
        if ("src_addsupplier".equals(this.getView().getEntityId())) {
            paramMap.put("addsupplier", this.getModel().getDataEntity().getString("addsupplier"));
        } else {
            PdsCommonUtils.saveDynamicObjects((DynamicObject)this.getModel().getDataEntity(true));
        }
        if (null != pickSchemeObj) {
            if (!QueryServiceHelper.exists((String)"src_purlistf7", (QFilter[])new QFilter[]{new QFilter("project", "=", (Object)projectId)})) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6807\u7684\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u540e\uff0c\u518d\u62bd\u53d6\u4f9b\u5e94\u5546\u3002", (String)"SrcInviteSupplierHelper_6", (String)"scm-src-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("src_bidchange".equals(parentView.getEntityId()) && SrmCommonUtil.getPkValue((DynamicObject)parentView.getModel().getDataEntity()) == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u53d8\u66f4\u5355\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u540e\uff0c\u518d\u62bd\u53d6\u4f9b\u5e94\u5546\u3002", (String)"SrcInviteSupplierHelper_7", (String)"scm-src-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("src_itemsupplier_chg".equals(this.getView().getEntityId()) || "src_addsupplier".equals(this.getView().getEntityId())) {
                Set purlistIds;
                Set packageIds;
                DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
                if (rows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9 \u6807\u6bb5/\u6807\u7684\uff0c\u518d\u62bd\u53d6\u4f9b\u5e94\u5546\u3002", (String)"SrcInviteSupplierHelper_3", (String)"scm-src-formplugin", (Object[])new Object[0]));
                    return;
                }
                if ("src_addsupplier".equals(this.getView().getEntityId()) && (packageIds = rows.stream().filter(e -> e.getLong("package.id") > 0L).map(e -> e.getLong("package.id")).collect(Collectors.toSet())).size() > 0) {
                    paramMap.put("package_id", packageIds);
                }
                if ((purlistIds = rows.stream().filter(e -> e.getLong("purlist.id") > 0L).map(e -> e.getLong("purlist.id")).collect(Collectors.toSet())).size() > 0) {
                    paramMap.put("purlist_id", purlistIds);
                }
            }
            if (pickSchemeObj.getBoolean("isopenmodel")) {
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"pds_invitehelper", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "pickscheme"));
            } else {
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"pds_invitehelper", (ShowType)ShowType.MainNewTabPage, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "pickscheme"));
            }
            return;
        }
        switch (manageType) {
            case "1": {
                this.selectSupplierByProject(paramMap);
                break;
            }
            case "2": {
                this.selectPackage(paramMap);
                break;
            }
            case "3": {
                int rowIndex = this.getPurlistInfo(paramMap);
                if (rowIndex == 1) {
                    this.selectSupplierByPurlist(paramMap);
                    break;
                }
                if (rowIndex != 0) break;
                this.selectPurlist(paramMap);
                break;
            }
        }
    }

    private void selectPackage(Map<String, Object> paramMap) {
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"src_packagehelper", paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "package"), (ShowType)ShowType.Modal));
    }

    private void selectPurlist(Map<String, Object> paramMap) {
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"src_packagehelper", paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "purlist"), (ShowType)ShowType.Modal));
    }

    private void selectSupplierByProject(Map<String, Object> paramMap) {
        OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"pds_invitehelper", (ShowType)ShowType.MainNewTabPage, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "1"));
    }

    private void selectSupplierByPackage(Map<String, Object> paramMap) {
        OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"pds_invitehelper", (ShowType)ShowType.MainNewTabPage, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "2"));
    }

    private void selectSupplierByPurlist(Map<String, Object> paramMap) {
        OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"pds_invitehelper", (ShowType)ShowType.MainNewTabPage, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "3"));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("pickscheme".equals(actionId) && !"src_addsupplier".equals(this.getView().getEntityId())) {
            this.getView().invokeOperation("refresh");
            return;
        }
        Object returnData = closedCallBackEvent.getReturnData();
        if ("purlists".equals(actionId) && null != returnData && BillStatusEnum.SAVE.getVal().equals(this.getView().getParentView().getModel().getDataEntity().getString("billstatus"))) {
            List rows = (List)returnData;
            Object[] purlistIds = new Object[rows.size()];
            int index = 0;
            for (ListSelectedRow row : rows) {
                purlistIds[index++] = row.getPrimaryKeyValue();
            }
            this.getModel().setValue("purlists", (Object)purlistIds, this.getModel().getEntryCurrentRowIndex("entrysupplier"));
            String puristNote = String.format(ResManager.loadKDString((String)"\u67e5\u770b(%1$s)", (String)"SrcInviteSupplierHelper_5", (String)"scm-src-formplugin", (Object[])new Object[0]), purlistIds.length);
            this.getModel().setValue("purlistnote", (Object)puristNote);
            return;
        }
        if (!(returnData instanceof Map)) {
            return;
        }
        Map paramMap = (Map)returnData;
        if (paramMap == null || paramMap.size() == 0) {
            return;
        }
        switch (actionId) {
            case "package": {
                this.selectSupplierByPackage(paramMap);
                break;
            }
            case "purlist": {
                this.selectSupplierByPurlist(paramMap);
                break;
            }
            case "1": {
                this.setQueryCondition(paramMap);
                this.setProjectSupplier(paramMap);
                break;
            }
            case "2": {
                this.setQueryCondition(paramMap);
                this.setPackageSupplier(paramMap);
                break;
            }
            case "3": {
                this.setQueryCondition(paramMap);
                this.setPurlistSupplier(paramMap);
                break;
            }
        }
    }

    private void setProjectSupplier(Map<String, Object> paramMap) {
        this.getModel().deleteEntryData("entrysupplier");
        this.createSupplierEntry(paramMap);
    }

    private void setPackageSupplier(Map<String, Object> paramMap) {
        Object packageObj = paramMap.get("packageid");
        if (StringUtils.isBlank((Object)packageObj)) {
            return;
        }
        long packageId = (Long)packageObj;
        int index = this.getModel().getEntryRowCount("entrysupplier");
        int i = 0;
        while (i < index) {
            DynamicObject row = this.getModel().getEntryRowEntity("entrysupplier", i);
            long oldPackageId = row.getLong("package.id");
            if (packageId == oldPackageId) {
                this.getModel().deleteEntryRow("entrysupplier", i);
                --index;
                continue;
            }
            ++i;
        }
        this.createSupplierEntry(paramMap);
    }

    private void setPurlistSupplier(Map<String, Object> paramMap) {
        Object purlistObj = paramMap.get("purlistid");
        if (StringUtils.isBlank((Object)purlistObj)) {
            return;
        }
        long purlistId = (Long)purlistObj;
        int index = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < index; ++i) {
            DynamicObject row = this.getModel().getEntryRowEntity("entryentity", i);
            long oldPurlistId = row.getLong("purlist.id");
            if (purlistId != oldPurlistId && oldPurlistId != 0L) continue;
            this.setItemSupplier(paramMap, i);
            break;
        }
    }

    private void setItemSupplier(Map<String, Object> paramMap, int i) {
        List supplierIds = (List)paramMap.get("supplier");
        if (supplierIds == null || supplierIds.size() == 0) {
            return;
        }
        IDataModel model = this.getModel();
        model.setValue("supplier", (Object)supplierIds.toArray(new Object[0]), i);
    }

    private void createSupplierEntry(Map<String, Object> paramMap) {
        List supplierIds = (List)paramMap.get("supplier");
        if (supplierIds == null || supplierIds.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String suppliertype = SupplierUtil.getSupType(null);
        Iterator iterator = supplierIds.iterator();
        while (iterator.hasNext()) {
            long supplierId = (Long)iterator.next();
            int row = model.createNewEntryRow("entrysupplier");
            model.setValue("suppliertype", (Object)suppliertype, row);
            model.setValue("supplier", (Object)supplierId, row);
            model.setValue("source", (Object)"2", row);
            if ("2".equals(paramMap.get("managetype"))) {
                model.setValue("package", paramMap.get("packageid"), row);
            }
            if (!"bd_supplier".equals(suppliertype)) continue;
            HashMap linkerMap = PdsLinkManFacade.getSupplierLinkMan((Object)supplierId);
            model.setValue("linkman", linkerMap.get("linkman"), row);
            model.setValue("phone", linkerMap.get("phone"), row);
        }
    }

    private void setQueryCondition(Map<String, Object> paramMap) {
        Object condition = paramMap.get("condition");
        String oldCondition = this.getModel().getDataEntity().getString("condition");
        String manageType = (String)paramMap.get("managetype");
        StringBuilder name = new StringBuilder();
        if ("2".equals(manageType)) {
            name = name.append(paramMap.get("packagename")).append(':');
        } else if ("3".equals(manageType)) {
            name = name.append(paramMap.get("purlistname")).append(':');
        }
        condition = this.rebuildCondition(oldCondition, condition, name.toString());
        this.getModel().setValue("condition", condition);
    }

    private String rebuildCondition(String oldCondition, Object condition, String title) {
        int i;
        if (StringUtils.isBlank((Object)condition)) {
            return oldCondition;
        }
        if (StringUtils.isBlank((CharSequence)oldCondition) || null == title) {
            return '\n' + condition.toString() + ';';
        }
        StringBuilder newCondition = new StringBuilder();
        String[] conditions = oldCondition.split(";");
        boolean isChanged = false;
        for (i = 0; i < conditions.length; ++i) {
            if (!conditions[i].startsWith("\n" + title)) continue;
            conditions[i] = "\n" + condition;
            isChanged = true;
        }
        if (isChanged) {
            for (i = 0; i < conditions.length; ++i) {
                newCondition.append(conditions[i]).append(';');
            }
        } else {
            newCondition.append(oldCondition).append('\n').append(condition).append(';');
        }
        return newCondition.toString();
    }

    private int getPurlistInfo(Map<String, Object> paramMap) {
        if (this.getModel().getEntryRowCount("entryentity") == 0) {
            if (this.getModel().getDataEntity().getDataEntityType().getName().equals("src_itemsupplier_chg")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6807\u7684\u4f9b\u5e94\u5546\u53d8\u66f4\u5206\u5f55\u3002", (String)"SrcInviteSupplierHelper_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5230\u201c\u91c7\u8d2d\u6e05\u5355\u201d\u4e2d\u7ef4\u62a4\u6807\u7684\u4fe1\u606f\u5e76\u5ba1\u6838\uff0c\u8fd9\u91cc\u624d\u80fd\u9009\u62e9\u5230\u6807\u7684\u3002", (String)"SrcInviteSupplierHelper_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
            }
            return -1;
        }
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (currentRowIndex < 0) {
            return 0;
        }
        DynamicObject row = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(currentRowIndex);
        if (row == null) {
            return 0;
        }
        if (row.getLong("purlist.id") == 0L) {
            return 0;
        }
        paramMap.put("purlistid", row.getLong("purlist.id"));
        paramMap.put("purlistname", row.getString("purlist.materialnane"));
        return 1;
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        switch (args.getFieldName()) {
            case "purlistnote": 
            case "purlists": {
                QFilter purlistFilter = PdsPurlistUtils.getOriginalPurlistQFilter((long)this.getView().getParentView().getModel().getDataEntity().getLong("id"));
                Set purlistIds = MultiBasedataUtils.getBasedataIdSet((DynamicObject)this.getModel().getEntryRowEntity("entrysupplier", args.getRowIndex()), (String)"purlistscope");
                if (null != purlistIds && purlistIds.size() > 0) {
                    purlistFilter = purlistFilter.and("id", "in", (Object)purlistIds);
                }
                Set selectIds = MultiBasedataUtils.getBasedataIdSet((DynamicObject)this.getModel().getEntryRowEntity("entrysupplier", args.getRowIndex()), (String)"purlists");
                HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
                paramMap.put("select_ids", selectIds.toArray(new Object[0]));
                paramMap.put("mustinput", true);
                OpenFormUtils.openBaseF7Page((IFormView)this.getView(), (String)"src_purlistf7", (ShowType)ShowType.Modal, paramMap, (QFilter)purlistFilter, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "purlists"), (boolean)true);
                break;
            }
        }
    }
}

