/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsPurlistUtils;

public class SrcMaterialEndEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setDefaultScheme();
    }

    public void setDefaultScheme() {
        if (null == this.getModel().getValue("scheme")) {
            DynamicObject projectObj = this.getModel().getDataEntity().getDynamicObject("projectf7");
            SchemeFilterUtils.setSchemeDefaultValue((IFormView)this.getView(), (DynamicObject)projectObj, (String)"src_materialend_scheme", (String)"scheme", null);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        int index = args.getChangeSet()[0].getRowIndex();
        DynamicObject projectObj = this.getModel().getDataEntity().getDynamicObject("projectf7");
        String key = args.getProperty().getName();
        Object newValue = args.getChangeSet()[0].getNewValue();
        switch (key) {
            case "purlist": {
                if (null != newValue) {
                    this.getModel().setValue("srctype", (Object)projectObj.getLong("srctype.id"), index);
                    this.getModel().setValue("bidname", (Object)projectObj.getString("bidname"), index);
                    break;
                }
                this.setValue2Null(index);
                break;
            }
            case "issource": {
                if (((Boolean)newValue).booleanValue()) break;
                this.setValue2Null(index);
            }
        }
    }

    private void setValue2Null(int index) {
        this.getModel().setValue("srctype", null, index);
        this.getModel().setValue("bidname", null, index);
        this.getModel().setValue("qty", null, index);
    }

    public void registerListener(EventObject e) {
        BasedataEdit purlistControl;
        BasedataEdit supplierControl;
        super.registerListener(e);
        BasedataEdit schemeControl = (BasedataEdit)this.getView().getControl("scheme");
        if (null != schemeControl) {
            schemeControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (supplierControl = (BasedataEdit)this.getView().getControl("supplier"))) {
            supplierControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (purlistControl = (BasedataEdit)this.getView().getControl("purlist"))) {
            purlistControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        String propertyName = evt.getProperty().getName();
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)this.getView().getParentView().getModel().getDataEntity().getDynamicObject("project"));
        if (projectId == 0L) {
            return;
        }
        switch (propertyName) {
            case "scheme": {
                DynamicObject billObj = this.getView().getModel().getDataEntity().getDynamicObject("projectf7");
                HashMap<String, Boolean> paramMap = new HashMap<String, Boolean>(1);
                paramMap.put("ismustinput", true);
                SchemeFilterUtils.setSchemeF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)billObj, (String)"src_materialend_scheme", paramMap);
                break;
            }
            case "supplier": {
                showParameter.setCustomParam("setSupStatusShowAll", (Object)"true");
                evt.getCustomQFilters().add(this.getSupplierQFilter(evt));
                break;
            }
            case "purlist": {
                evt.getCustomQFilters().add(this.getPurlistQFilter(evt));
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "getpurlist": {
                this.createPurlistEntry();
                break;
            }
        }
    }

    public void createPurlistEntry() {
        boolean isValid;
        if (!this.verifyData()) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        model.deleteEntryData("entryentity");
        HashMap<String, String> paramMap = new HashMap<String, String>(1);
        DynamicObject projectObj = this.getModel().getDataEntity().getDynamicObject("projectf7");
        String number = this.getView().getModel().getDataEntity().getString("scheme.number");
        paramMap.put("number", number);
        List purlistIds = SchemeFilterUtils.getAllSchemeIds((DynamicObject)projectObj, (String)number, paramMap);
        boolean isResource = PdsCommonUtils.object2Boolean((Object)ExtParameterUtils.getExtParameterValueByNumber((String)"pds_extfilter", (String)number, (String)"isResourceAfterPurlistEnd", (Object)false));
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)this.getView().getParentView().getModel().getDataEntity().getDynamicObject("project"));
        Set endPurlisIds = PdsPurlistUtils.getPurilstEndIds((long)projectId);
        purlistIds.removeAll(endPurlisIds);
        Set validPurlisIds = PdsPurlistUtils.getValidPurilstIds((long)projectId, (Set)PdsCommonUtils.buildSet((String[])new String[]{ProjectStatusEnums.TOQUOTE.getValue(), ProjectStatusEnums.QUOTED.getValue(), ProjectStatusEnums.OPENED.getValue(), ProjectStatusEnums.CLOSED.getValue(), ProjectStatusEnums.DECIDED.getValue(), ProjectStatusEnums.SIGNED.getValue()}));
        boolean bl = isValid = PdsCommonUtils.getIntersectSet(new HashSet(purlistIds), (Set)validPurlisIds).size() > 0;
        if (null == purlistIds || purlistIds.size() == 0 || !isValid) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\uff1a%1$s\u3002", (String)"SrcMaterialEndEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]), this.getModel().getDataEntity().getString("scheme.name")));
            return;
        }
        Map countMap = PdsPurlistUtils.getValidPurilstCount((long)projectId, (Set)PdsCommonUtils.buildSet((String[])new String[]{ProjectStatusEnums.QUOTED.getValue(), ProjectStatusEnums.OPENED.getValue(), ProjectStatusEnums.CLOSED.getValue(), ProjectStatusEnums.DECIDED.getValue(), ProjectStatusEnums.SIGNED.getValue()}));
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int index = 0;
        Iterator iterator = purlistIds.iterator();
        while (iterator.hasNext()) {
            long purlistId = (Long)iterator.next();
            if (!validPurlisIds.contains(purlistId)) continue;
            ts.set("purlist", (Object)purlistId, index);
            ts.set("count", countMap.get(purlistId), index);
            if (isResource) {
                ts.set("issource", (Object)"1", index);
                ts.set("srctype", (Object)projectObj.getLong("srctype.id"), index);
                ts.set("bidname", (Object)projectObj.getString("bidname"), index);
            } else {
                ts.set("issource", (Object)"0", index);
            }
            ++index;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    public boolean verifyData() {
        DynamicObject schemeObj = this.getModel().getDataEntity().getDynamicObject("scheme");
        if (null == schemeObj) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6807\u7684\u6d41\u6807\u8fc7\u6ee4\u65b9\u6848 \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrcMaterialEndEdit_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private QFilter getSupplierQFilter(BeforeF7SelectEvent evt) {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)this.getView().getParentView().getModel().getDataEntity().getDynamicObject("project"));
        QFilter qfilters = new QFilter("project", "=", (Object)projectId);
        qfilters.and("supplier", ">", (Object)0);
        qfilters.and("entrystatus", "in", (Object)PdsCommonUtils.buildSet((String[])new String[]{"A", "B", "C", "D"}));
        qfilters.and("isbizitem", "=", (Object)"0");
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"supplier.id", (QFilter[])qfilters.toArray());
        Set supplierIds = rows.stream().map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
        QFilter supFilters = new QFilter("id", "in", supplierIds);
        return supFilters;
    }

    private QFilter getPurlistQFilter(BeforeF7SelectEvent evt) {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)this.getView().getParentView().getModel().getDataEntity().getDynamicObject("project"));
        DynamicObject row = this.getModel().getEntryRowEntity("entryentity", evt.getRow());
        long supplierId = row.getLong("supplier.id");
        QFilter qfilters = new QFilter("project", "=", (Object)projectId);
        qfilters.and("supplier", "=", (Object)supplierId);
        qfilters.and("entrystatus", "in", (Object)PdsCommonUtils.buildSet((String[])new String[]{"A", "B", "C", "D"}));
        qfilters.and("isbizitem", "=", (Object)"0");
        qfilters.and("id", "not in", (Object)PdsPurlistUtils.getPurilstEndIds((long)projectId));
        return qfilters;
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        if (args.getFieldName().equals("project")) {
            DynamicObject entryObj = this.getModel().getEntryRowEntity("entryentity", args.getRowIndex());
            long billId = SrmCommonUtil.getPkValue((DynamicObject)entryObj.getDynamicObject("project"));
            OpenFormUtils.openBillPage((IFormView)this.getView(), (String)"src_project", (Object)billId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, null);
        }
    }
}

