/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.util.PdsPurlistUtils;

public class SrcPackageHelper
extends AbstractListPlugin
implements HyperLinkClickListener {
    public void afterCreateNewData(EventObject e) {
        String manageType;
        long projectId;
        super.afterCreateNewData(e);
        FormShowParameter formShowParam = this.getView().getFormShowParameter();
        Map paramMap = formShowParam.getCustomParams();
        long l = projectId = paramMap.get("project") == null ? 0L : (Long)paramMap.get("project");
        if (projectId == 0L) {
            return;
        }
        String string = manageType = paramMap.get("managetype") == null ? "2" : (String)paramMap.get("managetype");
        if ("2".equals(manageType)) {
            ArrayList<Long> packageIds = new ArrayList(8);
            packageIds = this.queryPackage(projectId);
            this.showPackage(projectId, packageIds);
        } else {
            ArrayList<Long> purlistIds = new ArrayList(8);
            purlistIds = this.queryPurlist(projectId);
            this.showPurlist(projectId, purlistIds);
        }
        this.getModel().setValue("managetype", (Object)manageType);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if ("package".equals(fieldName) || "purlist".equals(fieldName)) {
            DynamicObject row = this.getModel().getEntryRowEntity("entryentity", evt.getRowIndex());
            this.returnData(row);
        }
    }

    private List<Long> queryPackage(long projectId) {
        ArrayList<Long> packageIds = new ArrayList();
        QFilter qFilter = new QFilter("project.id", "=", (Object)projectId);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_packagef7", (String)"packagename,id", (QFilter[])new QFilter[]{qFilter});
        packageIds = rows.stream().sorted((s1, s2) -> s1.getString("packagename").compareTo(s2.getString("packagename"))).map(row -> row.getLong("id")).distinct().collect(Collectors.toList());
        return packageIds;
    }

    private List<Long> queryPurlist(long projectId) {
        ArrayList<Long> purlistIds = new ArrayList(16);
        Set purListEndIds = PdsPurlistUtils.getPurilstEndIds((long)projectId);
        QFilter qFilter = new QFilter("project.id", "=", (Object)projectId);
        qFilter.and("purlist.id", "not in", (Object)purListEndIds);
        qFilter.and("billtype", "=", (Object)"1");
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"materialnane,id", (QFilter[])new QFilter[]{qFilter});
        purlistIds = rows.stream().sorted((s1, s2) -> s1.getString("materialnane").compareTo(s2.getString("materialnane"))).map(row -> row.getLong("id")).distinct().collect(Collectors.toList());
        return purlistIds;
    }

    private void showPackage(long projectId, List<Long> packageIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        for (Long packageId : packageIds) {
            ts.set("package", (Object)packageId, i);
            ts.set("project", (Object)projectId, i++);
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    private void showPurlist(long projectId, List<Long> purlistIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        for (Long purlistId : purlistIds) {
            ts.set("purlist", (Object)purlistId, i);
            ts.set("project", (Object)projectId, i++);
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "confirm": {
                this.invite();
                break;
            }
        }
    }

    private void invite() {
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectedIds = grid.getSelectRows();
        if (selectedIds == null || selectedIds.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u7b14\u8bb0\u5f55\u3002", (String)"SrcPackageHelper_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectedIds.length > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u7b14\u8bb0\u5f55\u3002", (String)"SrcPackageHelper_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject row = this.getModel().getEntryRowEntity("entryentity", selectedIds[0]);
        this.returnData(row);
    }

    private void returnData(DynamicObject row) {
        FormShowParameter formShowParam = this.getView().getFormShowParameter();
        Map paramMap = formShowParam.getCustomParams();
        paramMap.put("packageid", row.getLong("package.id"));
        paramMap.put("packagename", row.getString("package.packagename"));
        paramMap.put("purlistid", row.getLong("purlist.id"));
        paramMap.put("purlistname", row.getString("purlist.materialnane"));
        this.getView().returnDataToParent((Object)paramMap);
        this.getView().close();
    }
}

