/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;
import kd.scm.src.common.util.SrcWinruleUtils;

public class SrcProjectWinruleRatioTypeEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void afterAddRow(AfterAddRowEventArgs evt) {
        int count = this.getModel().getEntryRowCount("entryentity");
        this.getModel().setValue("project", (Object)SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity()), count - 1);
        this.getModel().setValue("entrywinerqty", (Object)this.getModel().getDataEntity().getInt("winerqty"), count - 1);
        this.setOrderRatioFieldEnable(count - 1, count);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setOrderRatioFieldEnable(0, this.getModel().getEntryRowCount("entryentity"));
        String ratioType = this.getModel().getDataEntity().getString("ratiotype");
        this.setFieldMastInput(ratioType);
    }

    private void setFieldMastInput(String ratioType) {
        PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"package", (boolean)false);
        PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"purlist", (boolean)false);
        if (Objects.equals(ratioType, "3")) {
            PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"package", (boolean)true);
        }
        if (Objects.equals(ratioType, "4")) {
            PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"purlist", (boolean)true);
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String propertyName;
        super.propertyChanged(evt);
        switch (propertyName = evt.getProperty().getName()) {
            case "scheme": {
                this.getModel().setValue("ratiotype", null);
                this.setRatioTypeComboBySumType();
                break;
            }
            case "ratiotype": {
                this.setFieldMastInput(String.valueOf(evt.getChangeSet()[0].getNewValue()));
                this.clearValueByRatioType();
                this.setOrderRatioFieldEnable(0, this.getModel().getEntryRowCount("entryentity"));
                break;
            }
            case "winerqty": 
            case "alterqty": 
            case "trainqty": {
                this.resetEntrySupplierQty(propertyName);
                break;
            }
            case "entrywinerqty": 
            case "entryalterqty": 
            case "entrytrainqty": {
                this.setOrderRatioFieldEnable(evt.getChangeSet()[0].getRowIndex(), evt.getChangeSet()[0].getRowIndex() + 1);
                break;
            }
        }
    }

    private void resetEntrySupplierQty(String fieldName) {
        int count = this.getModel().getEntryRowCount("entryentity");
        for (int index = 0; index < count; ++index) {
            this.getModel().setValue("entry" + fieldName, (Object)this.getModel().getDataEntity().getInt(fieldName), index);
        }
    }

    private void setOrderRatioFieldEnable(int indexFrom, int indexTo) {
        for (int rowIndex = indexFrom; rowIndex < indexTo; ++rowIndex) {
            int i;
            int trainQty;
            int alterQty;
            int winerQty = (Integer)this.getModel().getValue("entrywinerqty", rowIndex);
            int qty = winerQty + (alterQty = ((Integer)this.getModel().getValue("entryalterqty", rowIndex)).intValue()) + (trainQty = ((Integer)this.getModel().getValue("entrytrainqty", rowIndex)).intValue());
            if (qty == 0) {
                qty = 5;
            }
            for (i = 1; i <= qty; ++i) {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"orderratio" + SrcWinruleUtils.formatInt((int)i, (boolean)true)});
            }
            for (i = qty + 1; i <= 10; ++i) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"orderratio" + SrcWinruleUtils.formatInt((int)i, (boolean)true)});
                this.getModel().setValue("orderratio" + SrcWinruleUtils.formatInt((int)i, (boolean)true), null, rowIndex);
            }
        }
    }

    private void clearValueByRatioType() {
        String ratioType = PdsCommonUtils.object2String((Object)this.getModel().getDataEntity().get("ratiotype"), (String)"1");
        if (!ratioType.equals("3")) {
            this.setEntryValueNull("package");
        } else if (!ratioType.equals("4")) {
            this.setEntryValueNull("purlist");
        }
    }

    private void setEntryValueNull(String fieldName) {
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        this.getModel().beginInit();
        for (int i = 0; i < rowCount; ++i) {
            this.getModel().setValue(fieldName, null, i);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void setRatioTypeComboBySumType() {
        String sumType = this.getModel().getDataEntity().getString("scheme.sumtype");
        if (StringUtils.isBlank((CharSequence)sumType)) {
            return;
        }
        HashMap<String, String> comboItemMap = new HashMap<String, String>(8);
        comboItemMap.put("1", ResManager.loadKDString((String)"\u624b\u5de5\u5206\u914d\u4efd\u989d", (String)"SrcProjectWinruleRatioTypeEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
        comboItemMap.put("2", ResManager.loadKDString((String)"\u81ea\u52a8\u5206\u914d\u4efd\u989d(\u6309\u9879\u76ee)", (String)"SrcProjectWinruleRatioTypeEdit_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
        comboItemMap.put("3", ResManager.loadKDString((String)"\u81ea\u52a8\u5206\u914d\u4efd\u989d(\u6309\u6807\u6bb5)", (String)"SrcProjectWinruleRatioTypeEdit_2", (String)"scm-src-formplugin", (Object[])new Object[0]));
        comboItemMap.put("4", ResManager.loadKDString((String)"\u81ea\u52a8\u5206\u914d\u4efd\u989d(\u6309\u6807\u7684)", (String)"SrcProjectWinruleRatioTypeEdit_3", (String)"scm-src-formplugin", (Object[])new Object[0]));
        comboItemMap.put("9", ResManager.loadKDString((String)"\u4e0d\u9700\u8981\u4efd\u989d\u5206\u914d\u4e0e\u63a7\u5236\u3002", (String)"SrcProjectWinruleRatioTypeEdit_4", (String)"scm-src-formplugin", (Object[])new Object[0]));
        if (sumType.equals("1")) {
            comboItemMap.remove("3");
            comboItemMap.remove("4");
        } else if (sumType.equals("2")) {
            comboItemMap.remove("4");
        }
        ComboEdit ratioTypeComboEdit = (ComboEdit)this.getView().getControl("ratiotype");
        ratioTypeComboEdit.setComboItems(PdsMetadataUtil.buildPropComboItems(comboItemMap));
    }

    public void registerListener(EventObject e) {
        BasedataEdit purlistEdit;
        super.registerListener(e);
        BasedataEdit packageEdit = (BasedataEdit)this.getView().getControl("package");
        if (null != packageEdit) {
            packageEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (purlistEdit = (BasedataEdit)this.getView().getControl("purlist"))) {
            purlistEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        switch (key = beforeF7SelectEvent.getProperty().getName()) {
            case "package": {
                QFilter packageQFilter = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity()));
                ListShowParameter packageShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                packageShowParameter.getListFilterParameter().setFilter(packageQFilter);
                break;
            }
            case "purlist": {
                QFilter purlistQFilter = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity()));
                purlistQFilter.and("billtype", "=", (Object)"1");
                ListShowParameter purlistShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                purlistShowParameter.getListFilterParameter().setFilter(purlistQFilter);
                break;
            }
        }
    }
}

