/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.src.common.calc.analy.SrcAnalyFacade;
import kd.scm.src.common.util.SrcNegotiateUtil;
import kd.scm.src.common.util.SrcPurListUtil;

public class SrcPurListQuoteEdit
extends AbstractBillPlugIn {
    private static Log log = LogFactory.getLog(SrcPurListQuoteEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar advToolBar = (Toolbar)this.getControl("advcontoolbarap");
        if (null != advToolBar) {
            advToolBar.addItemClickListener((ItemClickListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initBar();
    }

    private void initBar() {
        IFormView view = this.getView();
        if (this.isAttach()) {
            String userType = RequestContext.get().getUserType();
            if (null != userType && userType.contains("3")) {
                IFormView parentView = this.getView().getParentView();
                if (null != parentView) {
                    String parentEntityKey = parentView.getEntityId();
                    if ("tnd_apply".equals(parentEntityKey)) {
                        view.setVisible(Boolean.FALSE, new String[]{"querynewquote", "queryallquote", "queryanalyse"});
                    } else {
                        view.setVisible(Boolean.TRUE, new String[]{"querynewquote"});
                        view.setVisible(Boolean.FALSE, new String[]{"queryallquote", "queryanalyse"});
                    }
                }
            } else {
                view.setVisible(Boolean.FALSE, new String[]{"querynewquote"});
                view.setVisible(Boolean.TRUE, new String[]{"queryallquote", "queryanalyse"});
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"querynewquote", "queryallquote", "queryanalyse"});
        }
    }

    private boolean isAttach() {
        boolean iaAttach = false;
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return iaAttach;
        }
        DynamicObject templateDy = null;
        try {
            Object template = parentView.getModel().getValue("template");
            if (null == template || !(template instanceof DynamicObject)) {
                return iaAttach;
            }
            templateDy = (DynamicObject)template;
        }
        catch (Exception e) {
            BizLog.log((String)ResManager.loadKDString((String)"\u7236\u9875\u9762\u5355\u636e\u6ca1\u6709\u6a21\u677f\u3002", (String)"SrcPurListQuoteEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return iaAttach;
        }
        return templateDy.getBoolean("isattachpurlist");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        IFormView view = this.getView();
        switch (itemKey) {
            case "querynewquote": {
                view.setVisible(Boolean.FALSE, new String[]{"querynewquote"});
                view.setVisible(Boolean.TRUE, new String[]{"queryallquote"});
                this.showSupResult(true);
                this.queryQuote(false);
                break;
            }
            case "queryallquote": {
                view.setVisible(Boolean.TRUE, new String[]{"querynewquote"});
                view.setVisible(Boolean.FALSE, new String[]{"queryallquote"});
                this.showSupResult(false);
                this.queryQuote(true);
                break;
            }
            case "queryanalyse": {
                long projectId = this.getModel().getDataEntity().getLong("projectf7.id");
                QFilter projectFilter = new QFilter("project", "=", (Object)projectId);
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_analysetool", (ShowType)ShowType.MainNewTabPage, (Map)SrcAnalyFacade.getFormShowPara((long)projectId), (QFilter)projectFilter, null);
                break;
            }
            case "quotetendency": {
                long projectId = this.getModel().getDataEntity().getLong("projectf7.id");
                QFilter projectFilter = new QFilter("project", "=", (Object)projectId);
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_quotetendency", (ShowType)ShowType.MainNewTabPage, (Map)SrcAnalyFacade.getFormShowPara((long)projectId), (QFilter)projectFilter, null);
                break;
            }
            case "changeanalyse": {
                long projectId = this.getModel().getDataEntity().getLong("projectf7.id");
                QFilter projectFilter = new QFilter("project", "=", (Object)projectId);
                projectFilter.and("isnew", "=", (Object)true);
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_decisionchgf7", (ShowType)ShowType.MainNewTabPage, (Map)SrcAnalyFacade.getFormShowPara((long)projectId), (QFilter)projectFilter, null);
                break;
            }
        }
    }

    private void showSupResult(boolean flag) {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        String entityId = parentView.getEntityId();
        if (!"tnd_project".equals(entityId)) {
            return;
        }
        QFilter projectFilter = new QFilter("id", "=", (Object)Long.parseLong(parentView.getModel().getDataEntity().getPkValue().toString()));
        DynamicObject projectObj = QueryServiceHelper.queryOne((String)"src_decision", (String)"billstatus", (QFilter[])new QFilter[]{projectFilter});
        if (!"C".equals(projectObj.getString("billstatus"))) {
            return;
        }
        if (flag) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"result"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"result"});
        }
    }

    private void queryQuote(boolean isQueryAll) {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        Object[] projectIds = SrcNegotiateUtil.getProjectIds((IFormView)parentView);
        String compKey = this.getView().getEntityId();
        this.setCompData(compKey, projectIds, isQueryAll);
        this.getModel().setDataChanged(false);
    }

    private void setCompData(String compKey, Object[] parentIds, boolean isQueryAll) {
        log.info("SrcPurListComptpEdit projectIds:" + Arrays.toString(parentIds));
        Map entryId_entryMap = SrcNegotiateUtil.getComponetDataMap((String)compKey, (Object[])parentIds, (IFormView)this.getView(), (boolean)isQueryAll);
        int rowSize = entryId_entryMap.size();
        log.info("entryId_entryMap size:" + rowSize);
        if (rowSize == 0) {
            return;
        }
        IFormView view = this.getView();
        if (null == view) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        model.deleteEntryData("entryentity");
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        if (null == entryGrid) {
            return;
        }
        List properties = DynamicObjectUtil.getContainerProperties((Container)entryGrid);
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        for (Map.Entry entryMap : entryId_entryMap.entrySet()) {
            SrcPurListUtil.setCompData((TableValueSetter)ts, entryMap, (List)properties, (int)i);
            ++i;
        }
        log.info("loadDataSize:" + ts.getCount());
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", ts);
        model.endInit();
        view.updateView("entryentity");
        this.setSubEntryGridData(entryId_entryMap, entryGrid, ts.getCount());
    }

    public void setSubEntryGridData(Map<String, DynamicObject> entryId_entryMap, EntryGrid entryGrid, int rowCount) {
        List subEntryKeyList = entryGrid.getSubEntryGrids();
        StringBuilder logMsg = new StringBuilder();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            Object srcEntryId = this.getModel().getValue("srcentryid", rowIndex);
            DynamicObject rowObj = entryId_entryMap.get(String.valueOf(srcEntryId));
            entryGrid.selectRows(rowIndex);
            if (null == rowObj) continue;
            for (String subEntryKey : subEntryKeyList) {
                DynamicObjectCollection subEntryCols = rowObj.getDynamicObjectCollection(subEntryKey);
                if (subEntryCols.size() == 0) continue;
                this.setSubVal(subEntryKey, subEntryCols, logMsg);
            }
        }
        log.info(logMsg.length() == 0 ? "###set setSubEntryGridData" : logMsg.toString());
    }

    private void setSubVal(String subEntryKey, DynamicObjectCollection subEntryCols, StringBuilder logMsg) {
        SubEntryGrid subEntryGrid = (SubEntryGrid)this.getControl(subEntryKey);
        List subProperties = DynamicObjectUtil.getContainerProperties((Container)subEntryGrid);
        TableValueSetter ts = new TableValueSetter(new String[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(subEntryKey);
        for (int index = 0; index < subEntryCols.size(); ++index) {
            DynamicObject subCol = (DynamicObject)subEntryCols.get(index);
            for (String pro : subProperties) {
                DynamicProperty property = subCol.getDynamicObjectType().getProperty(pro);
                if (null == property) continue;
                try {
                    Object proVal = subCol.get(pro);
                    if (proVal instanceof DynamicObject) {
                        ts.set(pro, ((DynamicObject)proVal).getPkValue(), index);
                        continue;
                    }
                    ts.set(pro, proVal, index);
                }
                catch (Exception e) {
                    logMsg.append("###set property exception\uff1a").append(e.getMessage()).append('\uff1b');
                }
            }
        }
        model.beginInit();
        model.batchCreateNewEntryRow(subEntryKey, ts);
        model.endInit();
        this.getView().updateView(subEntryKey);
    }
}

