/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class SrcQuoteBillQueryEdit
extends AbstractFormPlugin
implements RowClickEventListener {
    public static final String TABPAGEAP = "tabpageap";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return;
        }
        DynamicObject billObj = parentView.getModel().getDataEntity(true);
        if (BidOpenStatusEnums.NOOPEN.getValue().equals(billObj.getString("openstatus")) || BidOpenStatusEnums.NEGOTIATE.getValue().equals(billObj.getString("openstatus"))) {
            return;
        }
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)billObj);
        QFilter qFilter = new QFilter("project", "=", (Object)projectId);
        qFilter.and("billstatus", "=", (Object)"C");
        HashSet<String> excFields = new HashSet<String>();
        excFields.add("id");
        excFields.add("seq");
        String orderBy = "turns,supplier,billdate";
        TemplateUtil.loadCompEntryData((IFormView)this.getView(), (String)"tnd_tenderbill", (QFilter)qFilter, excFields, (String)"entryentity", (String)orderBy, (boolean)true);
        TemplateUtil.loadCompEntryData((IFormView)this.getView(), (String)"tnd_quotebill", (QFilter)qFilter, excFields, (String)"entryentity", (String)orderBy, (boolean)true);
        this.hideContainer(TABPAGEAP);
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        if (rowCount > 0) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            entryGrid.selectRows(0);
            long billId = (Long)this.getModel().getValue("srcbillid", 0);
            String entityKey = (String)this.getModel().getValue("srcentitykey", 0);
            this.openPurlistComp(billId, entityKey);
        }
        this.getModel().setDataChanged(false);
    }

    public void hideContainer(String tarKey) {
        IFormView view = this.getView();
        for (int i = 0; i < this.getMaxSize(); ++i) {
            String targetPage = tarKey + i;
            view.setVisible(Boolean.FALSE, new String[]{targetPage});
        }
    }

    private void openPurlistComp(long billId, String entityKey) {
        if (billId == 0L) {
            return;
        }
        Set compKeySet = TemplateUtil.getPurListCompKeySet();
        DynamicObject quoteObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)entityKey);
        int index = 0;
        for (String compKey : compKeySet) {
            DynamicObject compObj = TemplateUtil.getCompData((DynamicObject)quoteObj, (String)compKey);
            if (null == compObj) continue;
            this.showComponent(entityKey, compObj, TABPAGEAP + index);
            if (++index < this.getMaxSize()) continue;
            return;
        }
    }

    private void showComponent(String entityKey, DynamicObject compObj, String targetPage) {
        String compKey = compObj.getDynamicObjectType().getName();
        BillShowParameter bs = new BillShowParameter();
        bs.setFormId(compKey);
        bs.getOpenStyle().setShowType(ShowType.InContainer);
        bs.getOpenStyle().setTargetKey(targetPage);
        bs.setBillStatus(BillOperationStatus.VIEW);
        DynamicObject compRegObj = PdsCommonUtils.getCompRegData((String)entityKey, (String)compKey);
        String showTitile = PdsCommonUtils.getShowCompTitle((String)entityKey, (String)compKey, (DynamicObject)compRegObj);
        TabPage tabpage = (TabPage)this.getView().getControl(targetPage);
        if (tabpage != null) {
            tabpage.setText(new LocaleString(showTitile));
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{targetPage});
        bs.setPkId(compObj.getPkValue());
        this.getView().showForm((FormShowParameter)bs);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        long billId = (Long)this.getModel().getValue("srcbillid", evt.getRow());
        String entityKey = (String)this.getModel().getValue("srcentitykey", evt.getRow());
        this.openPurlistComp(billId, entityKey);
    }

    private int getMaxSize() {
        return 5;
    }
}

