/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsOrderByUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.util.SrcBidAssessUtils;

public class SrcScoreSuggestionEdit
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        if (null == parentView) {
            return;
        }
        this.loadEntryData(this.getQFilter(parentView));
        this.setBillAttachment();
        this.getModel().setDataChanged(false);
        SrcBidOpenFacade.hideSupplierName((IFormView)this.getView(), (long)PdsCommonUtils.object2Long((Object)this.getModel().getValue("parentid")));
        SrcBidOpenFacade.setPurlistFieldVisible((IFormView)this.getView(), (String)"entryentity", (String)"purlist", (DynamicObject)this.getView().getParentView().getModel().getDataEntity());
    }

    private QFilter getQFilter(IFormView parentView) {
        QFilter qfilters = new QFilter("billid.project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)parentView.getModel().getDataEntity()));
        if (parentView.getEntityId().equals("src_aptitudeaudit2")) {
            qfilters.and("billid.isaptitude2", "=", (Object)"1");
        } else if (parentView.getEntityId().equals("src_aptitudeaudit")) {
            qfilters.and("billid.isaptitude", "=", (Object)"1");
            qfilters.and("billid.isaptitude2", "=", (Object)"0");
        } else {
            qfilters.and("billid.isaptitude", "=", (Object)"0");
            qfilters.and("billid.isaptitude2", "=", (Object)"0");
        }
        DynamicObject billObj = parentView.getModel().getDataEntity();
        if (SrcBidAssessUtils.isParallelOpenTec((DynamicObject)billObj)) {
            qfilters.and("billid.indextype.basetype", "!=", (Object)"2");
        } else if (SrcBidAssessUtils.isParallelOpenBiz((DynamicObject)billObj)) {
            qfilters.and("billid.indextype.basetype", "=", (Object)"2");
        } else if (SrcBidAssessUtils.isNeedIndexTypeControl((DynamicObject)billObj)) {
            if ("src_bidassess".equals(billObj.getDataEntityType().getName())) {
                qfilters.and("billid.indextype.basetype", "!=", (Object)"2");
            } else if ("src_compare".equals(billObj.getDataEntityType().getName())) {
                qfilters.and("billid.indextype.basetype", "=", (Object)"2");
            }
        }
        return qfilters;
    }

    private void loadEntryData(QFilter qfilters) {
        HashSet<String> excFields = new HashSet<String>();
        excFields.add("id");
        excFields.add("seq");
        excFields.add("project");
        excFields.add("package");
        excFields.add("supplier");
        excFields.add("basetype");
        excFields.add("minvalue");
        String orderBy = PdsOrderByUtils.getOrderByString((String)this.getOrderBy());
        TemplateUtil.loadCompEntryData((IFormView)this.getView(), (String)"src_scoresuggestionf7", (QFilter)qfilters, excFields, (String)"entryentity", (String)orderBy, (boolean)false);
    }

    private void setBillAttachment() {
        List attachments = AttachmentServiceHelper.getAttachments((String)"src_scoresuggestion", (Object)this.getBillId(), (String)"attachmentpanel", (boolean)false);
        if (null == attachments || attachments.size() == 0) {
            return;
        }
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        attachmentPanel.bindData(attachments);
    }

    private String getBillId() {
        long billId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
        String basetype = "1";
        if (this.getView().getParentView().getEntityId().equals("src_aptitudeaudit")) {
            basetype = "4";
        } else if (this.getView().getParentView().getEntityId().equals("src_aptitudeaudit2")) {
            basetype = "7";
        }
        return String.valueOf(billId) + '_' + basetype;
    }

    private String getOrderBy() {
        IFormView parentView = this.getView().getParentView();
        if (parentView.getEntityId().equals("src_aptitudeaudit")) {
            return "orderby008";
        }
        if (parentView.getEntityId().equals("src_aptitudeaudit2")) {
            return "orderby009";
        }
        return "orderby010";
    }
}

