/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.util.SrcAppCache;

public class SrcSupplierOpenEdit
extends AbstractBillPlugIn {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            SrcAppCache.put((String)"src_supplier_open", (Object)this.getView().getPageId(), (IFormView)parentView);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        this.loadCompEntryData(parentView);
        this.setEnableFalse(parentView);
        SrcBidOpenFacade.hideSupplierName((IFormView)this.getView(), (long)PdsCommonUtils.object2Long((Object)this.getModel().getValue("parentid")));
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "save": 
            case "submit": {
                SrcBidOpenFacade.saveSupOpenData((IFormView)this.getView().getParentView());
                break;
            }
        }
    }

    private void loadCompEntryData(IFormView parentView) {
        DynamicObject projectObj = parentView.getModel().getDataEntity(true);
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)projectObj);
        QFilter qfilter = new QFilter("billid", "=", (Object)projectId);
        SrcBidOpenFacade.addSupplierOpenFilter((QFilter)qfilter, (!"src_aptitudeaudit".equals(parentView.getEntityId()) ? 1 : 0) != 0);
        HashSet<String> excFields = new HashSet<String>();
        excFields.add("id");
        excFields.add("seq");
        TemplateUtil.loadCompEntryData((IFormView)this.getView(), (String)"src_bidopensupplier", (QFilter)qfilter, excFields, (String)"rank");
    }

    private void setEnableFalse(IFormView parentView) {
        if (parentView.getModel().getValue("billstatus").equals(BillStatusEnum.SAVE.getVal())) {
            QFilter filters = new QFilter("billid", "=", parentView.getModel().getDataEntity().getPkValue());
            QFilter openFilter = new QFilter("isaptopen", "=", (Object)"1");
            openFilter.or("istecopen", "=", (Object)"1");
            openFilter.or("isbizopen", "=", (Object)"1");
            filters.and(openFilter);
            if (QueryServiceHelper.exists((String)"src_supplieropen", (QFilter[])filters.toArray())) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"supopentype"});
                this.getView().setEnable(Boolean.valueOf(false), -1, new String[]{"rank"});
            }
        }
    }
}

