/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.compext;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.src.common.util.SrcAptitudeUtils;

public class SrcAptitudeReplyBillyAttachHandler
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        if (SrcAptitudeUtils.isSupplierReplyAptitude((DynamicObject)context.getProjectObj())) {
            this.loadAptitudeReplyBillAttach(context);
        }
    }

    private void loadAptitudeReplyBillAttach(ExtPluginContext context) {
        QFilter qfilter = this.getQFilter(context);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_scoretask", (boolean)false);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_scoretask", (String)selectFields, (QFilter[])qfilter.toArray(), (String)"supplier");
        if (rows == null || rows.length == 0) {
            return;
        }
        DynamicObject billObj = rows[0];
        Map<String, List<DynamicObject>> supplierMap = Arrays.asList(rows).stream().collect(Collectors.groupingBy(e -> e.getString("supplier.id") + '_' + e.getString("package.id") + '_' + e.getString("purlist.id")));
        AbstractFormDataModel model = (AbstractFormDataModel)context.getView().getModel();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        for (Map.Entry<String, List<DynamicObject>> entry : supplierMap.entrySet()) {
            DynamicObjectCollection attachRows = new DynamicObjectCollection();
            HashSet<Long> basedataidSet = new HashSet<Long>();
            for (DynamicObject row : entry.getValue()) {
                DynamicObjectCollection fjRows = row.getDynamicObjectCollection("supaptattach");
                for (DynamicObject fjRow : fjRows) {
                    if (!basedataidSet.add(fjRow.getLong("fbasedataid.id"))) continue;
                    attachRows.add((Object)fjRow);
                }
            }
            ts.set("suppliertype", (Object)"bd_supplier", i);
            ts.set("supplier", (Object)billObj.getLong("supplier.id"), i);
            ts.set("package", (Object)billObj.getLong("package.id"), i);
            ts.set("purlist", (Object)billObj.getLong("purlist.id"), i);
            ts.set("packfiletype", (Object)"5", i);
            ts.set("bidattach", (Object)attachRows, i);
            String fileName = AttachmentUtils.getAttachFileName((DynamicObjectCollection)attachRows);
            ts.set("packfilename", (Object)fileName, i);
            ts.set("billdate", billObj.get("auditdate"), i);
            ts.set("supplierip", billObj.get("supplierip"), i);
            ++i;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    private QFilter getQFilter(ExtPluginContext context) {
        long projectId = context.getView().getModel().getDataEntity().getLong("projectf7.id");
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("supplier", ">", (Object)0L);
        qfilter.and("cfmstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        qfilter.and("supaptattach.fbasedataid", ">", (Object)0L);
        return qfilter;
    }
}

