/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.compext;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.src.common.util.SrcAptitudeUtils;

public class SrcAptitudeReplyEntryAttachHandler
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        if (SrcAptitudeUtils.isSupplierReplyAptitude((DynamicObject)context.getProjectObj())) {
            this.loadAptitudeReplyEntryAttach(context);
        }
    }

    private void loadAptitudeReplyEntryAttach(ExtPluginContext context) {
        QFilter qfilter = this.getQFilter(context);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_scoretask_indexf7", (String)"billid,aptitudereply_fj", (QFilter[])qfilter.toArray(), (String)"billid.supplier");
        if (rows == null || rows.length == 0) {
            return;
        }
        Map<String, List<DynamicObject>> supplierMap = Arrays.asList(rows).stream().collect(Collectors.groupingBy(e -> e.getString("billid.supplier.id") + '_' + e.getString("billid.package.id") + '_' + e.getString("billid.purlist.id")));
        AbstractFormDataModel model = (AbstractFormDataModel)context.getView().getModel();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        for (Map.Entry<String, List<DynamicObject>> entry : supplierMap.entrySet()) {
            DynamicObjectCollection attachRows = new DynamicObjectCollection();
            HashSet<Long> basedataidSet = new HashSet<Long>();
            for (DynamicObject row : entry.getValue()) {
                DynamicObjectCollection fjRows = row.getDynamicObjectCollection("aptitudereply_fj");
                for (DynamicObject fjRow : fjRows) {
                    if (!basedataidSet.add(fjRow.getLong("fbasedataid.id"))) continue;
                    attachRows.add((Object)fjRow);
                }
            }
            DynamicObject billObj = entry.getValue().get(0).getDynamicObject("billid");
            ts.set("suppliertype", (Object)"bd_supplier", i);
            ts.set("supplier", (Object)billObj.getLong("supplier.id"), i);
            ts.set("package", (Object)billObj.getLong("package.id"), i);
            ts.set("purlist", (Object)billObj.getLong("purlist.id"), i);
            ts.set("packfiletype", (Object)"5", i);
            ts.set("bidattach", (Object)attachRows, i);
            String fileName = AttachmentUtils.getAttachFileName((DynamicObjectCollection)attachRows);
            ts.set("packfilename", (Object)fileName, i);
            ts.set("billdate", billObj.get("auditdate"), i);
            ts.set("supplierip", billObj.get("supplierip"), i);
            ++i;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    private QFilter getQFilter(ExtPluginContext context) {
        long projectId = context.getView().getModel().getDataEntity().getLong("projectf7.id");
        QFilter qfilter = new QFilter("billid.project", "=", (Object)projectId);
        qfilter.and("billid.supplier", ">", (Object)0L);
        qfilter.and("billid.cfmstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        qfilter.and("aptitudereply_fj.fbasedataid", ">", (Object)0L);
        return qfilter;
    }
}

