/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.compext;

import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.IExtendPlugin;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcBidassessTecsumSaveEntryData
implements IExtendPlugin {
    private static final long serialVersionUID = 1L;

    public void saveEntryData(IFormView view, AfterDoOperationEventArgs args) {
        DynamicObject[] rows;
        String scoreType = PdsCommonUtils.object2String((Object)view.getModel().getValue("scoretype"), (String)"1");
        if ("1".equals(scoreType)) {
            // empty if block
        }
        if ((rows = this.getBidAssessRows(view)).length == 0) {
            return;
        }
        Map<Long, DynamicObject> entryMap = this.getEntryMap(view);
        if (entryMap.size() == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            long billId = row.getLong("scoretask.id");
            DynamicObject billObj = entryMap.get(billId);
            if (null == billObj) continue;
            row.set("inputscore", (Object)billObj.getBigDecimal("inputscore"));
            row.set("note", (Object)billObj.getString("note"));
            row.set("isaptitude", (Object)billObj.getString("isaptitude"));
            row.set("aptitudenote", (Object)billObj.getString("aptitudenote"));
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }

    private Map<Long, DynamicObject> getEntryMap(IFormView view) {
        DynamicObjectCollection rows = view.getModel().getEntryEntity("entryentity");
        return rows.stream().collect(Collectors.groupingBy(e -> e.getLong("scoretask.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
    }

    private DynamicObject[] getBidAssessRows(IFormView view) {
        QFilter qfilters = this.getProjectFilter(view);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_bidassess_tec", (boolean)false);
        return BusinessDataServiceHelper.load((String)"src_bidassess_tec", (String)selectFields, (QFilter[])qfilters.toArray());
    }

    private QFilter getProjectFilter(IFormView view) {
        return new QFilter("billid", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)view.getParentView().getModel().getDataEntity()));
    }
}

