/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.src.common.util.SrcAppCache;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcBidPurEntryEdit
extends AbstractBillPlugIn {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = SrcBidChangeUtil.getParentView((IFormView)this.getView());
        if (parentView == null) {
            return;
        }
        DynamicObjectCollection purCollection = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        SrcAppCache.put((String)"src_categorychg", (Object)this.getView().getPageId(), (IFormView)parentView);
        DynamicObject dataEntity = parentView.getModel().getDataEntity();
        String project = dataEntity.getString("project.billno");
        if (purCollection.size() == 0) {
            QFilter filter = new QFilter("project.billno", "=", (Object)project);
            filter.and("billtype", "=", (Object)"1");
            filter.and("material", "=", (Object)0L);
            filter.and("isbizitem", "=", (Object)"0");
            DynamicObjectCollection purlistCols = QueryServiceHelper.query((String)"src_purlistf7", (String)"id,purlist,billtype,entrystatus,packagename,material,materialnane,category", (QFilter[])filter.toArray());
            this.createPurlistEntryData("entryentity", purlistCols);
        }
        if (!dataEntity.getBoolean("project.ismultipackage")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"packagename"});
        }
    }

    private void createPurlistEntryData(String entryKey, DynamicObjectCollection objs) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(entryKey);
        int i = 0;
        TableValueSetter ts = new TableValueSetter(new String[0]);
        if (objs.size() > 0) {
            for (DynamicObject obj : objs) {
                ts.set("packagename", (Object)obj.getString("packagename"), i);
                ts.set("material", obj.get("material"), i);
                ts.set("materialnane", (Object)obj.getString("materialnane"), i);
                ts.set("category", obj.get("category"), i);
                ts.set("billtype", obj.get("billtype"), i);
                ts.set("purlist", obj.get("purlist"), i);
                ++i;
            }
        }
        model.batchCreateNewEntryRow(entryKey, ts);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "submit": {
                DynamicObjectCollection cols = this.getModel().getEntryEntity("entryentity");
                boolean flag = cols.stream().filter(col -> Objects.isNull(col.getDynamicObject("material"))).map(col -> col.getDynamicObject("category1")).allMatch(Objects::isNull);
                if (!flag) break;
                args.setCancelMessage(ResManager.loadKDString((String)"\u53d8\u66f4\u540e\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u5168\u90e8\u4e3a\u7a7a\u3002", (String)"SrcBidPurEntryEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }
}

