/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.PdsLettersTypeEnum;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.question.PdsQuestionFacade;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.formplugin.edit.PdsBillCompTplEdit;
import kd.scm.src.common.calc.analy.SrcAnalyFacade;
import kd.scm.src.common.util.SrcBidAssessUtils;
import kd.scm.src.common.util.SrcNegotiateUtil;
import kd.scm.src.common.util.SrcNoticeSupUtil;

public class SrcDecisionEdit
extends PdsBillCompTplEdit {
    private static final String OPPARAM_RETURNBOND = "returnbond";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject dataentity = this.getModel().getDataEntity();
        String billstatus = dataentity.getString("billstatus");
        long billId = dataentity.getLong("id");
        QFilter filter = new QFilter("id", "=", (Object)billId).and("feeway.number", "!=", (Object)"C020701");
        boolean isExists = QueryServiceHelper.exists((String)"src_paymanage_cfg", (QFilter[])filter.toArray());
        if (isExists && StringUtils.equals((CharSequence)"C", (CharSequence)billstatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{OPPARAM_RETURNBOND});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{OPPARAM_RETURNBOND});
        }
        long sourceFlowId = this.getModel().getDataEntity().getLong("srctype.id");
        Object isEnableObj = ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isEnableCostDetail", (Object)Boolean.FALSE, (long)this.getModel().getDataEntity().getLong("id"));
        boolean isEnableCostDetail = ExtParameterUtils.convertToBoolen((Object)isEnableObj);
        if (!isEnableCostDetail) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"costdetail"});
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        super.beforeItemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_submit": {
                break;
            }
            case "viewnegbill": {
                DynamicObject negBill = SrcNegotiateUtil.getNegBillObj((DynamicObject)this.getModel().getDataEntity(), (boolean)false);
                if (null != negBill) {
                    OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"src_negotiatebill", (Object)negBill.getPkValue(), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, null);
                    break;
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u8bae\u4ef7\u5355\u3002", (String)"SrcDecisionEdit_10", (String)"scm-src-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String opKey;
        super.beforeDoOperation(evt);
        switch (opKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "op_negotiatesum": {
                long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
                if (projectId <= 0L) break;
                QFilter filter = new QFilter("project", "=", (Object)projectId);
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_negotiatebill", (ShowType)ShowType.MainNewTabPage, null, (QFilter)filter, null);
                break;
            }
            case "prenoticesup": 
            case "noticesup": {
                if (!this.verifyIsDecisionResult()) {
                    evt.setCancel(true);
                    return;
                }
                if ("prenoticesup".equals(opKey)) {
                    SrcNoticeSupUtil.showNoticeSup((DynamicObject)this.getModel().getDataEntity(), (IFormView)this.getView(), (PdsLettersTypeEnum)PdsLettersTypeEnum.PREWIN);
                    break;
                }
                SrcNoticeSupUtil.showNoticeSup((DynamicObject)this.getModel().getDataEntity(), (IFormView)this.getView(), (PdsLettersTypeEnum)PdsLettersTypeEnum.WIN);
                break;
            }
            case "bidresult": {
                SrcBidAssessUtils.openBidAssessResult((IFormView)this.getView());
                break;
            }
            case "addsupplier": {
                this.addsupplier();
                break;
            }
            case "gather": {
                OpenFormUtils.openBillPage((IFormView)this.getView(), (String)"src_placeonfile", (Object)this.getModel().getDataEntity().getPkValue(), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, null);
                break;
            }
        }
    }

    private void addsupplier() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        paramMap.put("entityname", this.getView().getEntityId());
        paramMap.put("project", SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity()));
        paramMap.put("billid", SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity()));
        paramMap.put("turns", "1");
        OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_addsupplier", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "addsupplier"));
    }

    private boolean verifyIsDecisionResult() {
        boolean isdecisionresult = this.getModel().getDataEntity().getBoolean("isdecisionresult");
        if (!isdecisionresult) {
            return true;
        }
        QFilter qfilters = new QFilter("id", "=", this.getModel().getDataEntity().getPkValue());
        DynamicObject resultObj = QueryServiceHelper.queryOne((String)"src_decision_result", (String)"resultstatus,istemppush,tempreason", (QFilter[])qfilters.toArray());
        if ("B".equals(resultObj.getString("resultstatus")) || "D".equals(resultObj.getString("resultstatus"))) {
            return true;
        }
        if (resultObj.getBoolean("istemppush") && !StringUtils.isEmpty((CharSequence)resultObj.getString("tempreason"))) {
            return true;
        }
        if ("C".equals(resultObj.getString("resultstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u7684\u51b3\u8bae\u72b6\u6001\u4e3a\u4e0d\u901a\u8fc7, \u4e0d\u5141\u8bb8\u901a\u77e5\u4f9b\u5e94\u5546\u3002", (String)"SrcDecisionEdit_12", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u7684\u51b3\u8bae\u72b6\u6001\u4e3a\u5f85\u8bc4\u5ba1,\u987b\u8bbe\u7f6e\u4e3a\u4e34\u65f6\u4e0b\u63a8\u5e76\u586b\u5199\u4e34\u65f6\u4e0b\u63a8\u539f\u56e0, \u5426\u5219\u4e0d\u5141\u8bb8\u901a\u77e5\u4f9b\u5e94\u5546\u3002", (String)"SrcDecisionEdit_13", (String)"scm-src-formplugin", (Object[])new Object[0]));
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        OperationResult result = args.getOperationResult();
        long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
        switch (opKey) {
            case "calculate": 
            case "recalculate": 
            case "ratiocalculate": {
                if (!this.isAllowRatioCalculate(this.getModel().getDataEntity())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u6807\u6216\u586b\u5199\u4efd\u989d\u540e\uff0c\u518d\u8fdb\u884c\u7efc\u5408\u8ba1\u7b97\u3002", (String)"SrcDecisionEdit_14", (String)"scm-src-formplugin", (Object[])new Object[0]));
                } else {
                    result = args.getOperationResult();
                    if (result.isSuccess()) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7efc\u5408\u8ba1\u7b97\u6210\u529f\u3002", (String)"SrcDecisionEdit_15", (String)"scm-src-formplugin", (Object[])new Object[0]));
                    }
                }
                this.getView().invokeOperation("refresh");
                break;
            }
            case "returnbond": {
                DynamicObject dataentity = this.getModel().getDataEntity();
                OpenFormUtils.openBillPage((IFormView)this.getView(), (String)"src_paymanage", (Object)dataentity.getLong("id"), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, null);
                break;
            }
            case "compare": {
                QFilter proFilter = new QFilter("project", "=", (Object)projectId);
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_analysetool", (ShowType)ShowType.MainNewTabPage, (Map)SrcAnalyFacade.getFormShowPara((long)projectId), (QFilter)proFilter, null);
                break;
            }
            case "aptitude": {
                OpenFormUtils.openBillPage((IFormView)this.getView(), (String)"src_aptitudeaudit", (Object)this.getModel().getDataEntity().getPkValue(), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, null);
                break;
            }
            case "querynotice": {
                QFilter projectFilter = new QFilter("srcbillid", "=", (Object)projectId);
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"sou_notice", (ShowType)ShowType.MainNewTabPage, null, (QFilter)projectFilter, null);
                break;
            }
            case "answer": {
                PdsQuestionFacade.openQuestionList((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"src_question", (boolean)true);
                break;
            }
            case "costdetail": {
                QFilter proFilter = new QFilter("project", "=", (Object)projectId);
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_costdetailentryanaly", (ShowType)ShowType.MainNewTabPage, (Map)SrcAnalyFacade.getFormShowPara((long)projectId), (QFilter)proFilter, null);
                break;
            }
            case "submit": {
                if (null == result || !result.isSuccess() || "2".equals(this.getModel().getDataEntity().getString("isneedinvite2"))) break;
                String message = ResManager.loadKDString((String)"\u5b9a\u6807\u63d0\u4ea4\u6210\u529f\uff0c\u8bf7\u53ca\u65f6\u53d1\u9001\u9884\u4e2d\u6807\u901a\u77e5\u7ed9\u4f9b\u5e94\u5546\u3002", (String)"SrcDecisionEdit_16", (String)"scm-src-formplugin", (Object[])new Object[0]);
                SrcNoticeSupUtil.notifySupplier((IFormView)this.getView(), (DynamicObject)this.getModel().getDataEntity(), (String)opKey, (PdsLettersTypeEnum)PdsLettersTypeEnum.PREWIN, (String)message);
                break;
            }
            case "audit": {
                result = args.getOperationResult();
                if (null == result || !result.isSuccess() || "2".equals(this.getModel().getDataEntity().getString("isneedinvite"))) break;
                String message = ResManager.loadKDString((String)"\u5b9a\u6807\u5ba1\u6838\u6210\u529f\uff0c\u8bf7\u53ca\u65f6\u53d1\u9001\u4e2d\u6807\u901a\u77e5\u7ed9\u4f9b\u5e94\u5546\u3002", (String)"SrcDecisionEdit_17", (String)"scm-src-formplugin", (Object[])new Object[0]);
                SrcNoticeSupUtil.notifySupplier((IFormView)this.getView(), (DynamicObject)this.getModel().getDataEntity(), (String)opKey, (PdsLettersTypeEnum)PdsLettersTypeEnum.WIN, (String)message);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"callbackid", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("submit");
        }
    }

    private boolean isAllowRatioCalculate(DynamicObject billObj) {
        if (this.isSchemeAward(billObj)) {
            return true;
        }
        QFilter qfilters = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)billObj));
        qfilters.and("entrystatus", "=", (Object)ProjectStatusEnums.OPENED.getValue());
        qfilters.and("orderratio", ">", (Object)0);
        return QueryServiceHelper.exists((String)"src_purlistf7", (QFilter[])qfilters.toArray());
    }

    private boolean isSchemeAward(DynamicObject billObj) {
        String sourceType = billObj.getString("sourcetype.number");
        Set sourceTypeSet = PdsCommonUtils.buildSet((String[])new String[]{SourceTypeEnums.SCHEME_AWARD.getValue(), SourceTypeEnums.SCHEME_AWARD2.getValue()});
        return sourceTypeSet.contains(sourceType);
    }
}

