/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.excel.ExcelDataEntity;
import kd.scm.pds.common.edit.AbstractBillImportEdit;
import kd.scm.pds.common.util.SrcCalImpl;

public class SrcDemandImportEdit
extends AbstractBillImportEdit {
    String entryentity = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar advToolBar2 = (Toolbar)this.getControl("advcontoolbarap11");
        if (null != advToolBar2) {
            advToolBar2.addUploadListener((UploadListener)this);
            advToolBar2.addItemClickListener((ItemClickListener)this);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "exportdatanotyear": {
                this.entryentity = "entryentity";
                this.exportData();
                break;
            }
        }
    }

    protected String getUniqueColumnName() {
        return "material1";
    }

    protected void setColumn(ExcelDataEntity excelDataEntity) {
        super.setColumn(excelDataEntity);
        ArrayList columnKeyList = new ArrayList(excelDataEntity.getColumnKeyList());
        columnKeyList.remove("purlistentry_fj");
        columnKeyList.remove("taxrate");
        excelDataEntity.setColumnKeyList(columnKeyList);
    }

    public Object getRowVal(DynamicObject col, String column, int i) {
        Object val = "";
        Object columnVal = col.get(column);
        if (columnVal == null) {
            val = "";
        } else if (columnVal instanceof DynamicObject) {
            if ("material1".equals(column)) {
                val = ((DynamicObject)columnVal).get("number");
            } else if (column.equals("taxitem")) {
                val = ((DynamicObject)columnVal).getBigDecimal("taxrate");
                val = ((BigDecimal)val).stripTrailingZeros().toPlainString();
            } else {
                val = super.getRowVal(col, column, i);
            }
        } else {
            val = super.getRowVal(col, column, i);
        }
        return val;
    }

    protected String getBdPro(String column) {
        String bdPro = "name";
        if ("material1".equals(column) || "purchasers".equals(column) || "purchaser".equals(column)) {
            bdPro = "number";
        }
        return bdPro;
    }

    protected Object getBdVal(String column, String bdKey, Object val) {
        if (column.equals("taxitem")) {
            return this.getTaxItem(val, bdKey);
        }
        return super.getBdVal(column, bdKey, val);
    }

    private Object getTaxItem(Object val, String bdKey) {
        Object taxItemId = 0L;
        try {
            val = new BigDecimal(String.valueOf(val));
        }
        catch (NumberFormatException e) {
            return taxItemId;
        }
        QFilter filter = new QFilter("taxrate", "=", val);
        DynamicObject obj = QueryServiceHelper.queryOne((String)bdKey, (String)"id", (QFilter[])new QFilter[]{filter});
        if (null != obj) {
            taxItemId = obj.get("id");
        }
        return taxItemId;
    }

    protected String getEntryKey() {
        return this.entryentity;
    }

    public int getScale(DynamicObject col, String column, int rowIndex) {
        Object unit;
        IDataModel model = this.getModel();
        if ("qty".equals(column) && (unit = model.getValue("unit2", rowIndex)) instanceof DynamicObject) {
            int scale = ((DynamicObject)unit).getInt("precision");
            return scale;
        }
        return super.getScale(col, column, rowIndex);
    }

    protected Map<String, String> getMustInputProMap() {
        Map mustInputProMap = super.getMustInputProMap();
        mustInputProMap.put(this.getEntryKey() + "." + "materialname", ResManager.loadKDString((String)"\u6807\u7684\u540d\u79f0", (String)"SrcDemandImportEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
        mustInputProMap.put(this.getEntryKey() + "." + "qty", ResManager.loadKDString((String)"\u5bfb\u6e90\u6570\u91cf", (String)"SrcDemandImportEdit_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
        mustInputProMap.put(this.getEntryKey() + "." + "unit2", ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"SrcDemandImportEdit_2", (String)"scm-src-formplugin", (Object[])new Object[0]));
        return mustInputProMap;
    }

    protected void beforeImport() {
        super.beforeImport();
        this.getModel().deleteEntryData(this.getEntryKey());
    }

    protected void afterImportOneRow(TableValueSetter ts, int rowIndex, boolean isUpdate) {
        super.afterImportOneRow(ts, rowIndex, isUpdate);
        ts.set("reqqty2", ts.get("qty", rowIndex), rowIndex);
    }

    protected void afterImport() {
        super.afterImport();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entry");
        for (int i = 0; i < rows.size(); ++i) {
            this.getModel().setValue("decisionitem", null, i);
        }
        SrcCalImpl cal = new SrcCalImpl();
        EntryGrid grid = (EntryGrid)this.getControl(this.getEntryKey());
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity(this.getEntryKey());
        for (int i = 0; i < entryRows.size(); ++i) {
            grid.selectRows(i, true);
            cal.proChanged(this.getModel(), this.getEntryKey(), "qty");
        }
        this.saveAndRemoveCache();
    }

    private void saveAndRemoveCache() {
        BusinessDataServiceHelper.removeCache((DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"src_demandf7two").getDynamicObjectType());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
    }
}

